/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlyph;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiHTMLConverter;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiHtmlState;
import com.stimulsoft.base.drawing.StiHtmlTagsState;
import com.stimulsoft.base.drawing.StiLineInfo;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.StiTextOptions;
import com.stimulsoft.base.drawing.StiTextRendererParseHtml;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiRectangleCorners;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.drawing.path.StiPathArc;
import com.stimulsoft.base.drawing.path.StiPathCommand;
import com.stimulsoft.base.drawing.path.StiPathCommandEnum;
import com.stimulsoft.base.drawing.path.StiPathCubicBezier;
import com.stimulsoft.base.drawing.path.StiPathCurve;
import com.stimulsoft.base.drawing.path.StiPathCurveTo;
import com.stimulsoft.base.drawing.path.StiPathLine;
import com.stimulsoft.base.drawing.path.StiPathPie;
import com.stimulsoft.base.drawing.path.StiPathRectangle;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiBidirectionalConvert;
import com.stimulsoft.base.utils.StiMath;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JTextPane;

public class StiGraphics {
    private static final String HTML_BEGIN_PATTERN = "<html><table BORDER=0 CELLSPACING=0 CELLPADDING=0><tr BORDER=0 CELLSPACING=0 CELLPADDING=0><td BORDER=0 CELLSPACING=0 CELLPADDING=0 width='%s' height='%s' align='%s' valign='%s' style=\"font-family: '%s'; font-size: %s;  color: %s\" >";
    private static final String HTML_END_STING = "</td></tr></table></html>";
    public static final Float HTML_SCALE = Float.valueOf(1.3f);
    private static final Float RTF_SCALE = Float.valueOf(1.161f);
    private static final int MAX_RANGE = 15000;
    private final int CURVE_STEPS = 300;
    private JTextPane htmlPane;
    private JTextPane rtfPane;
    private Graphics2D g;
    private Integer digits = 0;
    private Double offsetX = 0.0;
    private Double offsetY = 0.0;
    private final Stack<Double> offsetStack = new Stack();
    private final Stack<Rectangle> clipStack = new Stack();
    private Double rotateAngle = 0.0;
    private final Stack<Double> rotateStack = new Stack();
    private final Stack<Double> centerStack = new Stack();
    private Double centerX = 0.0;
    private Double centerY = 0.0;
    private StiBidirectionalConvert bidi = new StiBidirectionalConvert(StiBidirectionalConvert.Mode.Xps);

    public StiGraphics(Graphics g) {
        this.g = (Graphics2D)g;
    }

    public static StiGraphics fromImage(BufferedImage image) {
        return new StiGraphics(image.createGraphics());
    }

    public Boolean getIntegerCoords() {
        return this.digits == 0;
    }

    public void setIntegerCoords(Boolean value) {
        this.digits = this.getIntegerCoords() != false ? Integer.valueOf(2) : Integer.valueOf(0);
    }

    public void setOffset(double x, double y) {
        this.offsetStack.push(x);
        this.offsetStack.push(y);
        this.offsetX = this.offsetX + x;
        this.offsetY = this.offsetY + y;
    }

    public void clearOffset() {
        if (this.offsetStack.size() > 0) {
            this.offsetY = this.offsetY - this.offsetStack.pop();
            this.offsetX = this.offsetX - this.offsetStack.pop();
        }
    }

    public void setTransformedClip(StiRectangle rect) {
        this.setClip(this.transformRect(rect.clone(), this.offsetX, this.offsetY));
    }

    public Rectangle restoreClip() {
        if (this.clipStack.size() > 0) {
            Rectangle rect = this.clipStack.pop();
            this.g.setClip(rect);
            return rect;
        }
        return null;
    }

    public void setFixedClip(StiRectangle rect) {
        if (this.g != null) {
            Rectangle oldClip = this.g.getClipBounds();
            this.clipStack.push(oldClip);
            this.g.setClip(rect.clone().round(0.0).toRectangle());
        }
    }

    public void setClip(StiRectangle rect) {
        if (this.g != null) {
            Rectangle oldClip = this.g.getClipBounds();
            StiRectangle newClip = rect.clone();
            this.clipStack.push(oldClip);
            if (oldClip != null) {
                double x1 = StiMath.inscribe(newClip.getLeft(), oldClip.x, oldClip.x + oldClip.width);
                double y1 = StiMath.inscribe(newClip.getTop(), oldClip.y, oldClip.y + oldClip.height);
                double x2 = StiMath.inscribe(newClip.getRight(), oldClip.x, oldClip.x + oldClip.width);
                double y2 = StiMath.inscribe(newClip.getBottom(), oldClip.y, oldClip.y + oldClip.height);
                newClip = new StiRectangle(x1, y1, x2 - x1, y2 - y1);
            }
            this.g.setClip(newClip.round(0.0).toRectangle());
        }
    }

    private Boolean isNeedTransform() {
        return this.rotateAngle != 0.0;
    }

    private Double getRadianAngle() {
        return Math.PI / 180 * this.rotateAngle;
    }

    public void setRotate(double angle, double centerX, double centerY) {
        this.rotateStack.push(angle);
        this.rotateAngle = this.rotateAngle + angle;
        StiGraphics stiGraphics = this;
        stiGraphics.centerX = stiGraphics.centerX + centerX;
        stiGraphics = this;
        stiGraphics.centerY = stiGraphics.centerY + centerY;
        this.centerStack.push(centerX);
        this.centerStack.push(centerY);
    }

    public void clearRotate() {
        if (this.rotateStack.size() > 0) {
            this.rotateAngle = this.rotateAngle - this.rotateStack.pop();
            this.centerY = this.centerY - this.centerStack.pop();
            this.centerX = this.centerX - this.centerStack.pop();
        }
    }

    public StiPoint transformCoords(Double x, Double y, Double ox, Double oy) {
        if (!this.isNeedTransform().booleanValue()) {
            return new StiPoint(x + ox, y + oy);
        }
        AffineTransform at = new AffineTransform();
        at.rotate(this.getRadianAngle());
        at.translate(ox + this.centerX, oy + this.centerY);
        Point2D.Double ptSrc = new Point2D.Double(x, y);
        Point2D ptDst = null;
        at.transform(ptSrc, ptDst);
        return new StiPoint(x + ox, y + oy);
    }

    public StiPoint transformPointRound(StiPoint point, Double ox, Double oy) {
        return this.transformPoint(point, ox, oy).round(this.digits.intValue());
    }

    public StiPoint transformPoint(StiPoint point, Double ox, Double oy) {
        if (this.isNeedTransform().booleanValue()) {
            return this.transformCoords(point.x, point.y, ox, oy);
        }
        return new StiPoint(point.x + ox, point.y + oy);
    }

    public StiRectangle transformRectRound(StiRectangle rect, Double ox, Double oy, Integer digits) {
        return this.transformRect(rect, ox, oy).round(digits.doubleValue(), true);
    }

    public StiRectangle transformRectRound(StiRectangle rect) {
        return this.transformRectRound(rect, this.offsetX, this.offsetY, this.digits);
    }

    public StiRectangle transformRect(StiRectangle rect) {
        return this.transformRect(rect, 0.0, 0.0);
    }

    public StiRectangle transformRect(StiRectangle rect, Double ox, Double oy) {
        if (this.isNeedTransform().booleanValue()) {
            StiPoint transPointStart = this.transformCoords(rect.getLeft(), rect.getTop(), ox, oy);
            StiPoint transPointEnd = this.transformCoords(rect.getRight(), rect.getBottom(), ox, oy);
            StiRectangle transRect = new StiRectangle(transPointStart.x, transPointStart.y, 0.0, 0.0);
            transRect.setRight(transPointEnd.x);
            transRect.setBottom(transPointEnd.y);
            return transRect;
        }
        return new StiRectangle(rect.getX() + this.offsetX, rect.getY() + this.offsetY, rect.getWidth(), rect.getHeight());
    }

    private void recalcBounds(StiRectangle rect, double x, double y) {
        if (rect.getLeft() > x) {
            rect.setLeft(x);
        }
        if (rect.getRight() < x) {
            rect.setRight(x);
        }
        if (rect.getTop() > y) {
            rect.setTop(y);
        }
        if (rect.getBottom() < y) {
            rect.setBottom(y);
        }
    }

    public Stroke setLineStyle(StiPen pen, StiRectangle rect, double zoom) {
        if (pen == null) {
            pen = StiPen.TRANSPARENT;
        }
        Stroke oldStroke = this.g.getStroke();
        StiColor color = pen.getColor();
        if (pen.getBrush() instanceof StiEmptyBrush) {
            color = StiColor.Transparent;
        }
        if (pen.getBrush() instanceof StiSolidBrush) {
            color = ((StiSolidBrush)pen.getBrush()).getColor();
        }
        this.g.setColor(color.getAwtColor());
        if (!(pen.getDashStyle() == null || pen.getDashStyle().equals((Object)StiPenStyle.None) || pen.getDashStyle().equals((Object)StiPenStyle.Solid) || pen.getDashStyle().equals((Object)StiPenStyle.Double))) {
            this.graphicsSetDashStyle(pen, zoom);
        } else if (pen.getBrush() == null || pen.getBrush() instanceof StiEmptyBrush || pen.getBrush() instanceof StiSolidBrush) {
            this.g.setStroke(new BasicStroke((int)Math.round(pen.getWidth() * zoom), pen.getCaps(), pen.getJoints()));
        } else {
            StiGradientBrush brush = (StiGradientBrush)pen.getBrush();
            if (brush.getRectangle().isEmpty().booleanValue() && rect != null) {
                brush.setRectangle(this.transformRect(rect, this.offsetX, this.offsetY));
            }
            this.g.setStroke(new BasicStroke((int)Math.round(pen.getWidth() * zoom), pen.getCaps(), pen.getJoints()));
        }
        return oldStroke;
    }

    public Stroke beginFill(StiBrush brush, StiPen pen, StiRectangle rect, Double zoom) {
        if (brush == null && pen != null) {
            return this.setLineStyle(pen, rect, zoom);
        }
        if (brush instanceof StiEmptyBrush) {
            this.g.setColor(StiBrush.ToColor(StiSolidBrush.TRANSPARENT).getAwtColor());
        }
        if (brush instanceof StiSolidBrush) {
            this.g.setColor(StiBrush.ToColor(brush).getAwtColor());
        }
        if (brush instanceof StiGradientBrush) {
            this.beginGradientFill((StiGradientBrush)brush, rect);
        }
        if (brush instanceof StiHatchBrush) {
            this.g.setPaint(((StiHatchBrush)brush).getPaint());
        }
        if (brush instanceof StiGlareBrush) {
            this.beginGlareFill((StiGlareBrush)brush, rect);
        }
        return null;
    }

    private void beginGradientFill(StiGradientBrush brush, StiRectangle rect) {
        if (brush.getRectangle().isEmpty().booleanValue()) {
            brush.setRectangle(this.transformRect(rect, this.offsetX, this.offsetY));
        } else {
            brush.setRectangle(this.transformRect(brush.getRectangle(), this.offsetX, this.offsetY));
        }
        this.g.setPaint(brush.getPaint());
        brush.setRectangle(new StiRectangle(0L, 0L, 0L, 0L));
    }

    private void beginGlareFill(StiGlareBrush brush, StiRectangle rect) {
        if (brush.getRectangle().isEmpty().booleanValue()) {
            brush.setRectangle(this.transformRect(rect, this.offsetX, this.offsetY));
        } else {
            brush.setRectangle(this.transformRect(brush.getRectangle(), this.offsetX, this.offsetY));
        }
        this.g.setPaint(brush.getPaint());
        brush.setRectangle(new StiRectangle(0L, 0L, 0L, 0L));
    }

    public void drawPath(List<StiPathCommand> path, StiPen pen, StiBrush brush, double zoom, double pageZoom) {
        this.drawPath(path, pen, brush, true, zoom, pageZoom);
    }

    public StiRectangle drawPath(List<StiPathCommand> path, StiPen pen, StiBrush brush, Boolean transformCoord, double zoom, double pageZoom) {
        return this.drawPath(path, pen, brush, transformCoord, zoom, pageZoom, true);
    }

    public StiRectangle drawPath(List<StiPathCommand> path, StiPen pen, StiBrush brush, Boolean transformCoord, double zoom, double pageZoom, boolean draw) {
        GeneralPath generalPath = new GeneralPath(0);
        StiRectangle rect = null;
        for (StiPathCommand command : path) {
            StiPoint cubicPoint2;
            StiPoint cubicPoint1;
            Object gp;
            StiPoint transPoint = transformCoord != false ? this.transformCoords(command.getX(), command.getY(), this.offsetX, this.offsetY) : new StiPoint(command.getX(), command.getY());
            transPoint.round(this.digits.intValue());
            if (rect == null) {
                rect = new StiRectangle(command.getX(), command.getY(), 0.0, 0.0);
            }
            if (command.getCommand().equals((Object)StiPathCommandEnum.Line)) {
                StiPathLine lineCommand = (StiPathLine)command;
                StiPoint point2 = this.transformPointRound(new StiPoint(lineCommand.getX2(), lineCommand.getY2()), this.offsetX, this.offsetY);
                generalPath.append(new Line2D.Double(transPoint.getX(), transPoint.getY(), point2.getX(), point2.getY()), true);
                this.recalcBounds(rect, lineCommand.getX2(), lineCommand.getY2());
            } else if (command.getCommand().equals((Object)StiPathCommandEnum.LineTo)) {
                generalPath.lineTo(transPoint.getX().floatValue(), transPoint.getY().floatValue());
            } else if (command.getCommand().equals((Object)StiPathCommandEnum.MoveTo)) {
                generalPath.moveTo(transPoint.getX().floatValue(), transPoint.getY().floatValue());
            } else if (command.getCommand() == StiPathCommandEnum.Rectangle) {
                StiPathRectangle rectCommand = (StiPathRectangle)command;
                generalPath.append(new Rectangle(transPoint.getX().intValue(), transPoint.getY().intValue(), (int)rectCommand.getWidth(), (int)rectCommand.getHeight()), false);
                this.recalcBounds(rect, rectCommand.getX() + rectCommand.getWidth(), rectCommand.getY() + rectCommand.getHeight());
            } else if (command.getCommand() == StiPathCommandEnum.Pie) {
                StiPathPie pie = (StiPathPie)command;
                Arc2D.Double arc = new Arc2D.Double(transPoint.getX(), transPoint.getY(), pie.getWidth(), pie.getHeight(), pie.getStart(), pie.getExtent(), 2);
                generalPath.append(arc, false);
                gp = new GeneralPath();
                ((Path2D)gp).append(new Arc2D.Double(pie.getX(), pie.getY(), pie.getWidth(), pie.getHeight(), pie.getStart(), pie.getExtent(), 2), false);
                this.recalcBounds(rect, ((Path2D)gp).getBounds().x, ((Path2D)gp).getBounds().y);
                this.recalcBounds(rect, ((Path2D)gp).getBounds().x + ((Path2D)gp).getBounds().width, ((Path2D)gp).getBounds().y + ((Path2D)gp).getBounds().height);
            } else if (command.getCommand() == StiPathCommandEnum.Arc) {
                StiPathArc pathAcr = (StiPathArc)command;
                Arc2D.Double arc = new Arc2D.Double(transPoint.getX(), transPoint.getY(), pathAcr.getWidth(), pathAcr.getHeight(), pathAcr.getStart(), pathAcr.getExtent(), 0);
                generalPath.append(arc, true);
                gp = new GeneralPath();
                ((Path2D)gp).append(new Arc2D.Double(pathAcr.getX(), pathAcr.getY(), pathAcr.getWidth(), pathAcr.getHeight(), pathAcr.getStart(), pathAcr.getExtent(), 2), true);
                this.recalcBounds(rect, ((Path2D)gp).getBounds().x, ((Path2D)gp).getBounds().y);
                this.recalcBounds(rect, ((Path2D)gp).getBounds().x + ((Path2D)gp).getBounds().width, ((Path2D)gp).getBounds().y + ((Path2D)gp).getBounds().height);
            } else if (command.getCommand() == StiPathCommandEnum.Curve) {
                StiPathCurve pathCurve = (StiPathCurve)command;
                Polygon polygon = new Polygon();
                for (StiPoint point : pathCurve.getPoints()) {
                    if (transformCoord.booleanValue()) {
                        point = this.transformPointRound(point, this.offsetX, this.offsetY);
                    }
                    polygon.addPoint((int)point.x, (int)point.y);
                }
                generalPath.append(this.createCurvePolyline(polygon), true);
            } else if (command.getCommand() == StiPathCommandEnum.CubicBezier) {
                StiPathCubicBezier pathCurve = (StiPathCubicBezier)command;
                generalPath.append(new CubicCurve2D.Double(pathCurve.x1 + this.offsetX, pathCurve.y1 + this.offsetY, pathCurve.ctrlx1 + this.offsetX, pathCurve.ctrly1 + this.offsetY, pathCurve.ctrlx2 + this.offsetX, pathCurve.ctrly2 + this.offsetY, pathCurve.x2 + this.offsetX, pathCurve.y2 + this.offsetY), true);
            } else if (command.getCommand() == StiPathCommandEnum.ClosePath) {
                generalPath.closePath();
            }
            if (command.getCommand() != StiPathCommandEnum.Curve && command.getCommand() != StiPathCommandEnum.ClosePath) {
                this.recalcBounds(rect, command.getX(), command.getY());
            }
            if (!command.getCommand().equals((Object)StiPathCommandEnum.CurveTo)) continue;
            this.recalcBounds(rect, ((StiPathCurveTo)command).getAx(), ((StiPathCurveTo)command).getAy());
            float x1 = transPoint.getX().floatValue();
            float y1 = transPoint.getY().floatValue();
            StiPathCurveTo curveCommand = (StiPathCurveTo)command;
            if (transformCoord.booleanValue()) {
                transPoint = this.transformCoords(curveCommand.getAx(), curveCommand.getAy(), this.offsetX, this.offsetY);
                cubicPoint1 = this.transformCoords(curveCommand.getBx(), curveCommand.getBy(), this.offsetX, this.offsetY);
                cubicPoint2 = this.transformCoords(curveCommand.getX(), curveCommand.getY(), this.offsetX, this.offsetY);
            } else {
                transPoint = new StiPoint(curveCommand.getAx(), curveCommand.getAy());
                cubicPoint1 = new StiPoint(curveCommand.getBx(), curveCommand.getBy());
                cubicPoint2 = new StiPoint(curveCommand.getX(), curveCommand.getY());
            }
            transPoint.round(this.digits.intValue());
            cubicPoint1.round(this.digits.intValue());
            cubicPoint2.round(this.digits.intValue());
            if (curveCommand.getCubic().booleanValue()) {
                generalPath.curveTo(cubicPoint2.getX().floatValue(), cubicPoint2.getY().floatValue(), transPoint.getX().floatValue(), transPoint.getY().floatValue(), cubicPoint1.getX().floatValue(), cubicPoint1.getY().floatValue());
                continue;
            }
            generalPath.quadTo(x1, y1, transPoint.getX().floatValue(), transPoint.getY().floatValue());
        }
        if (!draw) {
            return rect;
        }
        Stroke oldStroke = this.g.getStroke();
        this.g.rotate(Math.toRadians(this.rotateAngle), this.centerX, this.centerY);
        this.beginFill(brush, pen, rect, zoom);
        if (brush instanceof StiHatchBrush) {
            Double hatchZoom = pageZoom * zoom;
            this.g.scale(1.0 / hatchZoom, 1.0 / hatchZoom);
            AffineTransform af = new AffineTransform();
            af.scale(hatchZoom, hatchZoom);
            generalPath.transform(af);
            this.g.fill(generalPath);
            af = new AffineTransform();
            af.scale(1.0 / hatchZoom, 1.0 / hatchZoom);
            generalPath.transform(af);
            this.g.scale(hatchZoom, hatchZoom);
        } else if (brush != null) {
            this.g.fill(generalPath);
        }
        this.setLineStyle(pen, rect, zoom);
        this.g.draw(generalPath);
        this.g.setPaint(null);
        this.g.setStroke(oldStroke);
        this.g.rotate(Math.toRadians(-this.rotateAngle.doubleValue()), this.centerX, this.centerY);
        return rect;
    }

    private void drawRect(StiRectangle rect, Double cornerRadius, Integer corners, Double zoom, Double pageZoom) {
        StiRectangle transformRect = this.transformRectRound(rect, this.offsetX, this.offsetY, this.digits);
        ArrayList<StiPathCommand> path = new ArrayList<StiPathCommand>();
        if ((corners & StiRectangleCorners.LeftTop.getValue()) != 0) {
            path.add(StiPathCommand.moveTo(transformRect.getX(), transformRect.getY() + cornerRadius));
            path.add(StiPathCommand.curveTo(transformRect.getX(), transformRect.getY(), transformRect.getX() + cornerRadius, transformRect.getY()));
        } else {
            path.add(StiPathCommand.moveTo(transformRect.getX(), transformRect.getY()));
        }
        if ((corners & StiRectangleCorners.RightTop.getValue()) != 0) {
            path.add(StiPathCommand.lineTo(transformRect.getX() + transformRect.getWidth() - cornerRadius, transformRect.getY()));
            path.add(StiPathCommand.curveTo(transformRect.getX() + transformRect.getWidth(), transformRect.getY(), transformRect.getX() + transformRect.getWidth(), transformRect.getY() + cornerRadius));
        } else {
            path.add(StiPathCommand.lineTo(transformRect.getX() + transformRect.getWidth(), transformRect.getY()));
        }
        if ((corners & StiRectangleCorners.RightBottom.getValue()) != 0) {
            path.add(StiPathCommand.lineTo(transformRect.getX() + transformRect.getWidth(), transformRect.getY() + transformRect.getHeight() - cornerRadius));
            path.add(StiPathCommand.curveTo(transformRect.getX() + transformRect.getWidth(), transformRect.getY() + transformRect.getHeight(), transformRect.getX() + transformRect.getWidth() - cornerRadius, transformRect.getY() + transformRect.getHeight()));
        } else {
            path.add(StiPathCommand.lineTo(transformRect.getX() + transformRect.getWidth(), transformRect.getY() + transformRect.getHeight()));
        }
        if ((corners & StiRectangleCorners.LeftBottom.getValue()) != 0) {
            path.add(StiPathCommand.lineTo(transformRect.getX() + cornerRadius, transformRect.getY() + transformRect.getHeight()));
            path.add(StiPathCommand.curveTo(transformRect.getX(), transformRect.getY() + transformRect.getHeight(), transformRect.getX(), transformRect.getY() + transformRect.getHeight() - cornerRadius));
        } else {
            path.add(StiPathCommand.lineTo(transformRect.getX(), transformRect.getY() + transformRect.getHeight()));
        }
        if ((corners & StiRectangleCorners.LeftTop.getValue()) != 0) {
            path.add(StiPathCommand.lineTo(transformRect.getX(), transformRect.getY() + cornerRadius));
        } else {
            path.add(StiPathCommand.lineTo(transformRect.getX(), transformRect.getY()));
        }
        this.drawPath(path, null, null, false, zoom, pageZoom);
    }

    public void drawRectangle(StiRectangle rect, StiPen pen, StiBrush brush, Double zoom, Double pageZoom) {
        this.drawRectangle(rect, pen, brush, 0.0, zoom, pageZoom);
    }

    public void drawRectangle(StiRectangle rect, StiPen pen, StiBrush brush, Double cornerRadius, Double zoom, Double pageZoom) {
        if (rect.getWidth() <= 0.0 || rect.getHeight() <= 0.0) {
            return;
        }
        if (pen == null) {
            // empty if block
        }
        this.g.rotate(Math.toRadians(this.rotateAngle), this.centerX, this.centerY);
        this.beginFill(brush, null, rect, zoom);
        StiRectangle transformRect = this.transformRectRound(rect);
        if (brush != null) {
            if (brush instanceof StiHatchBrush) {
                Double hatchZoom = pageZoom * zoom;
                this.g.scale(1.0 / hatchZoom, 1.0 / hatchZoom);
                this.graphicsFillRect(transformRect.clone().zoom(hatchZoom), (int)(cornerRadius * hatchZoom));
                this.g.scale(hatchZoom, hatchZoom);
            } else {
                this.graphicsFillRect(transformRect, cornerRadius.intValue());
            }
        }
        if (pen != null) {
            Stroke oldStroke = this.setLineStyle(pen, transformRect, zoom);
            this.graphicsDrawRect(transformRect, cornerRadius.intValue());
            this.g.setStroke(oldStroke);
        }
        this.g.setPaint(null);
        this.g.rotate(Math.toRadians(-this.rotateAngle.doubleValue()), this.centerX, this.centerY);
    }

    private void graphicsDrawLine(StiPoint start, StiPoint end) {
        this.g.draw(new Line2D.Double(start.getX(), start.getY(), end.getX(), end.getY()));
    }

    private void graphicsDrawRect(StiRectangle rect, Integer cornerRadius) {
        StiRectangle fillRect = rect.clone().round(0.0, true);
        if (cornerRadius == 0) {
            this.g.drawRect(fillRect.getXi(), fillRect.getYi(), fillRect.getWi(), fillRect.getHi());
        } else {
            this.g.drawRoundRect(fillRect.getXi(), fillRect.getYi(), fillRect.getWi(), fillRect.getHi(), cornerRadius, cornerRadius);
        }
    }

    private void graphicsFillOval(StiRectangle rect) {
        StiRectangle fillRect = rect.clone().round(this.digits.doubleValue(), true);
        this.g.fillOval(fillRect.getXi(), fillRect.getYi(), fillRect.getWi(), fillRect.getHi());
    }

    private void graphicsDrawOval(StiRectangle rect) {
        StiRectangle fillRect = rect.clone().round(this.digits.doubleValue(), true);
        this.g.drawOval(fillRect.getXi(), fillRect.getYi(), fillRect.getWi(), fillRect.getHi());
    }

    private void graphicsFillRect(StiRectangle rect, Integer cornerRadius) {
        StiRectangle fillRect = rect.clone().round(0.0, true);
        Object antialiasing = this.g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g.fillRoundRect(fillRect.getXi(), fillRect.getYi(), fillRect.getWi(), fillRect.getHi(), cornerRadius, cornerRadius);
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
    }

    private void graphicsSetDashStyle(StiPen pen, double zoom) {
        pen.setJoints(2);
        BasicStroke stroke = new BasicStroke((int)Math.round(Math.max(pen.getWidth() * zoom, 1.0)), pen.getCaps(), pen.getJoints(), 1.0f, pen.getDashStyle().getDash((int)Math.max(pen.getWidth() * zoom, 1.0)), 1.0f);
        this.g.setColor(pen.getColor().getAwtColor());
        this.g.setStroke(stroke);
    }

    public void drawEllise(StiRectangle rect, StiPen pen, StiBrush brush, Double zoom, Double pageZoom) {
        if (rect.getWidth() <= 0.0 || rect.getHeight() <= 0.0) {
            return;
        }
        if (pen == null) {
            pen = new StiPen(0.0, StiColorEnum.Transparent.color(), StiPenStyle.Solid);
        }
        this.beginFill(brush, pen, rect, zoom);
        StiRectangle transformRect = this.transformRectRound(rect, this.offsetX, this.offsetY, this.digits);
        if (brush != null) {
            if (brush instanceof StiHatchBrush) {
                Double hatchZoom = pageZoom * zoom;
                this.g.scale(1.0 / hatchZoom, 1.0 / hatchZoom);
                this.graphicsFillOval(transformRect.clone().zoom(hatchZoom));
                this.g.scale(hatchZoom, hatchZoom);
            } else {
                this.graphicsFillOval(transformRect);
            }
        }
        Stroke oldStroke = this.setLineStyle(pen, transformRect, zoom);
        this.graphicsDrawOval(transformRect);
        this.g.setStroke(oldStroke);
        this.g.setPaint(null);
    }

    public void drawElliseBegin(StiRectangle rect, StiPen pen, StiBrush brush, Double zoom) {
        rect = this.transformRect(rect, this.offsetX, this.offsetY);
        this.beginFill(brush, pen, rect, zoom);
        rect.round(this.digits.doubleValue(), true);
        this.g.drawOval(rect.getXi(), rect.getYi(), rect.getWi(), rect.getHi());
    }

    public void drawElliseEnd(StiRectangle rect) {
        rect = this.transformRect(rect, this.offsetX, this.offsetY);
        rect.round(this.digits.doubleValue(), true);
        this.g.drawOval(rect.getXi(), rect.getYi(), rect.getWi(), rect.getHi());
        this.g.setPaint(null);
    }

    public void drawLineXY(Double x1, Double y1, Double x2, Double y2, StiPen pen, Double zoom, Boolean transformRect) {
        this.drawLine(new StiPoint(x1, y1), new StiPoint(x2, y2), pen, zoom, transformRect);
    }

    public void drawLineXY(Double x1, Double y1, Double x2, Double y2, StiPen pen, Double zoom) {
        this.drawLine(new StiPoint(x1, y1), new StiPoint(x2, y2), pen, zoom);
    }

    public void drawLine(StiPoint start, StiPoint end, StiPen pen, Double zoom) {
        this.drawLine(start, end, pen, zoom, true);
    }

    public void drawLine(StiPoint start, StiPoint end, StiPen pen, Double zoom, Boolean transformRect) {
        Stroke stroke = this.g.getStroke();
        if (pen.getDashStyle().equals((Object)StiPenStyle.None)) {
            return;
        }
        if (pen.getDashStyle().equals((Object)StiPenStyle.Solid)) {
            StiRectangle rect = new StiRectangle(Math.min(start.x, end.x), Math.min(start.y, end.y), Math.abs(end.x - start.x), Math.abs(end.y - start.y));
            this.setLineStyle(pen, rect, zoom);
            if (transformRect.booleanValue()) {
                start = this.transformPointRound(start, this.offsetX, this.offsetY);
                end = this.transformPointRound(end, this.offsetX, this.offsetY);
            }
            this.graphicsDrawLine(start, end);
        } else if (pen.getDashStyle().equals((Object)StiPenStyle.Double)) {
            this.drawDoubleLine(start, end, pen, zoom, transformRect);
        } else {
            this.drawDashLine(start, end, pen, zoom, transformRect);
        }
        this.g.setStroke(stroke);
    }

    private void drawDashLine(StiPoint start, StiPoint end, StiPen pen, double zoom, Boolean transformRect) {
        if (transformRect.booleanValue()) {
            start = this.transformPointRound(start, this.offsetX, this.offsetY);
            end = this.transformPointRound(end, this.offsetX, this.offsetY);
        }
        this.graphicsSetDashStyle(pen, zoom);
        this.graphicsDrawLine(start, end);
    }

    private void drawDoubleLine(StiPoint start, StiPoint end, StiPen pen, Double zoom, Boolean tranformRect) {
        StiRectangle rect = new StiRectangle(Math.min(start.x, end.x), Math.min(start.y, end.y), Math.abs(end.x - start.x), Math.abs(end.y - start.y));
        StiPen doublePen = pen.clone();
        doublePen.setWidth(1.0);
        this.setLineStyle(doublePen, rect, zoom);
        if (tranformRect.booleanValue()) {
            start = this.transformPointRound(start, this.offsetX, this.offsetY);
            end = this.transformPointRound(end, this.offsetX, this.offsetY);
        }
        this.graphicsDrawLine(start, end);
    }

    public void drawCurve(StiPoint[] points, StiPen pen, Double zoom, Boolean transformRect) {
        Stroke stroke = this.g.getStroke();
        if (pen.getDashStyle().equals((Object)StiPenStyle.None)) {
            return;
        }
        Polygon polygon = new Polygon();
        for (StiPoint point : points) {
            if (transformRect.booleanValue()) {
                point = this.transformPointRound(point, this.offsetX, this.offsetY);
            }
            polygon.addPoint((int)point.x, (int)point.y);
        }
        if (pen.getDashStyle().equals((Object)StiPenStyle.Solid) || pen.getDashStyle().equals((Object)StiPenStyle.Double)) {
            this.setLineStyle(pen, null, zoom);
        } else {
            this.graphicsSetDashStyle(pen, zoom);
        }
        this.g.draw(this.createCurvePolyline(polygon));
        this.g.setStroke(stroke);
    }

    private GeneralPath createCurvePolyline(Polygon polygon) {
        GeneralPath path = new GeneralPath();
        if (polygon.npoints >= 2) {
            Cubic[] X = this.calcNaturalCubic(polygon.npoints - 1, polygon.xpoints);
            Cubic[] Y = this.calcNaturalCubic(polygon.npoints - 1, polygon.ypoints);
            path.moveTo(Math.round(X[0].eval(0.0f)), Math.round(Y[0].eval(0.0f)));
            for (int i = 0; i < X.length; ++i) {
                for (int j = 1; j <= 300; ++j) {
                    float u = (float)j / 300.0f;
                    path.lineTo(Math.round(X[i].eval(u)), Math.round(Y[i].eval(u)));
                }
            }
        }
        return path;
    }

    private Cubic[] calcNaturalCubic(int n, int[] x) {
        int i;
        float[] gamma = new float[n + 1];
        float[] delta = new float[n + 1];
        float[] D = new float[n + 1];
        gamma[0] = 0.5f;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0f / (4.0f - gamma[i - 1]);
        }
        gamma[n] = 1.0f / (2.0f - gamma[n - 1]);
        delta[0] = (float)(3 * (x[1] - x[0])) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = ((float)(3 * (x[i + 1] - x[i - 1])) - delta[i - 1]) * gamma[i];
        }
        delta[n] = ((float)(3 * (x[n] - x[n - 1])) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], (float)(3 * (x[i + 1] - x[i])) - 2.0f * D[i] - D[i + 1], (float)(2 * (x[i] - x[i + 1])) + D[i] + D[i + 1]);
        }
        return C;
    }

    public void drawImage(BufferedImage image, StiRectangle rect, Boolean stretch, Boolean smooth, double zoom) {
        this.drawImage(image, rect, stretch, smooth, true, 1.0f, zoom);
    }

    public void drawImage(BufferedImage image, StiRectangle rect, Boolean stretch, Boolean smooth, Boolean scaleBitmap, Double zoom) {
        this.drawImage(image, rect, stretch, smooth, scaleBitmap, 1.0f, zoom);
    }

    public void drawImage(BufferedImage image, StiRectangle rect, Boolean stretch, Boolean smooth, Boolean scaleBitmap, float alpha, Double zoom) {
        StiRectangle transformRect = this.transformRect(rect, this.offsetX, this.offsetY);
        StiRectangle transformRectBitmap = this.transformRect(new StiRectangle(0L, 0L, image.getWidth(), image.getHeight()));
        Double sx = 1.0;
        Double sy = 1.0;
        if (stretch.booleanValue()) {
            sx = transformRect.getWidth() / (double)image.getWidth();
            sy = transformRect.getHeight() / (double)image.getHeight();
        } else {
            sx = transformRectBitmap.getWidth() / (double)image.getWidth();
            sy = transformRectBitmap.getHeight() / (double)image.getHeight();
        }
        if (!scaleBitmap.booleanValue()) {
            sx = 1.0;
            sy = 1.0;
            transformRect.setWidth(image.getWidth());
            transformRect.setHeight(image.getHeight());
        }
        transformRect = transformRect.round(this.digits.doubleValue());
        AffineTransform at = new AffineTransform();
        at.translate(transformRect.getLeft(), transformRect.getTop());
        at.scale(sx, sy);
        Composite oldComposite = this.g.getComposite();
        this.g.setComposite(AlphaComposite.getInstance(3, alpha));
        this.g.drawImage(image, at, null);
        this.g.setComposite(oldComposite);
    }

    private StiRectangle swapSize(StiRectangle rectangle, Double rotationAngle) {
        if (rotationAngle != 0.0 && rotationAngle % 360.0 != 0.0 && rotationAngle % 360.0 != 360.0 && ((rotationAngle + 90.0) % 180.0 == 0.0 || (rotationAngle + 90.0) % 180.0 == 180.0)) {
            double temp = rectangle.getWidth();
            rectangle.setWidth(rectangle.getHeight());
            rectangle.setHeight(temp);
            rectangle.setX(rectangle.getX() + rectangle.getHeight() / 2.0 - rectangle.getWidth() / 2.0);
            rectangle.setY(rectangle.getY() + rectangle.getWidth() / 2.0 - rectangle.getHeight() / 2.0);
        }
        return rectangle;
    }

    private JTextPane getHtmlPane() {
        if (this.htmlPane == null) {
            this.htmlPane = new JTextPane();
            this.htmlPane.setContentType("text/html");
            this.htmlPane.setEditable(false);
            this.htmlPane.setOpaque(false);
            this.htmlPane.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.htmlPane;
    }

    private JTextPane getRTFPane() {
        if (this.rtfPane == null) {
            this.rtfPane = new JTextPane();
            this.rtfPane.setContentType("text/rtf");
            this.rtfPane.setEditable(false);
            this.rtfPane.setOpaque(false);
            this.rtfPane.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.rtfPane;
    }

    public void drawRTFText(String text, StiRectangle rect, Double zoom) {
        if (text == null && !"".equals(text) || rect.getWidth() <= 0.0 || rect.getHeight() <= 0.0) {
            return;
        }
        StiRectangle textRectangle = this.transformRectRound(rect, this.offsetX, this.offsetY, 0);
        Integer paneWidth = (int)Math.round(textRectangle.getWidth() / (double)RTF_SCALE.floatValue() / zoom);
        Integer paneHeight = (int)Math.round(textRectangle.getHeight() / (double)RTF_SCALE.floatValue() / zoom);
        JTextPane pane = this.getRTFPane();
        pane.setText(text);
        pane.setBounds(0, 0, paneWidth, paneHeight);
        this.g.translate(textRectangle.getX(), textRectangle.getY());
        this.g.scale((double)RTF_SCALE.floatValue() * zoom, (double)RTF_SCALE.floatValue() * zoom);
        pane.paint(this.g);
        this.g.scale((double)(1.0f / RTF_SCALE.floatValue()) / zoom, (double)(1.0f / RTF_SCALE.floatValue()) / zoom);
        this.g.translate(-textRectangle.getX(), -textRectangle.getY());
    }

    public void drawHTMLText(String text, StiRectangle rect, StiFont font, StiColor color, StiTextHorAlignment horAlignment, StiVertAlignment vertAlignment, Boolean wordWrap, StiPenStyle linesOfUnderline, StiBorder border, StiTextOptions textOptions, float lineSpacing, Double zoom) {
        StiTextRendererParseHtml.StiRenderLine line;
        if (text == null && !"".equals(text) || rect.getWidth() <= 0.0 || rect.getHeight() <= 0.0) {
            return;
        }
        double rotationAngle = textOptions != null ? (double)textOptions.getAngle() : 0.0;
        String htmlText = StiHTMLConverter.replaceHtmlSymbols(text, true, false);
        StiRectangle textRectangle = this.transformRectRound(rect, this.offsetX, this.offsetY, 3);
        StiRectangle displaytextRectangleangle = textRectangle.clone();
        this.swapSize(textRectangle, rotationAngle);
        double paneWidth = wordWrap != false || horAlignment.equals((Object)StiTextHorAlignment.Width) ? textRectangle.width : 15000.0;
        this.setClip(displaytextRectangleangle);
        if (rotationAngle != 0.0 && rotationAngle % 360.0 != 0.0 && rotationAngle % 360.0 != 360.0) {
            this.g.rotate(-Math.toRadians(rotationAngle), textRectangle.getLeft() + textRectangle.getWidth() / 2.0, textRectangle.getTop() + textRectangle.getHeight() / 2.0);
        }
        this.g.translate(textRectangle.x, textRectangle.y);
        this.g.scale(zoom, zoom);
        StiHtmlTagsState baseTagsState = new StiHtmlTagsState(font.bold(), font.italic(), font.underline(), font.strikeout(), (float)font.size, font.getName(), color, StiColorEnum.Transparent.color(), false, false, 0.0, 0.0, lineSpacing, horAlignment);
        StiHtmlState baseState = new StiHtmlState(baseTagsState, 0);
        List<StiHtmlState> htmlStates = StiTextRendererParseHtml.parseHtmlToStates(text, baseState);
        List<StiGlyph> glyphs = StiTextRendererParseHtml.getGlyphs(htmlStates, this.g);
        int pos = 0;
        double yPos = 0.0;
        double paneHeight = 0.0;
        if (vertAlignment != StiVertAlignment.Top) {
            while (pos < glyphs.size()) {
                line = new StiTextRendererParseHtml.StiRenderLine();
                pos = StiTextRendererParseHtml.getNextLine(glyphs, pos, paneWidth / zoom, this.g, line);
                paneHeight += line.height;
            }
            pos = 0;
            if (vertAlignment == StiVertAlignment.Bottom) {
                yPos = rect.height / zoom - paneHeight;
            } else if (vertAlignment == StiVertAlignment.Center) {
                yPos = rect.height / zoom / 2.0 - paneHeight / 2.0;
            }
        }
        while (pos < glyphs.size()) {
            double xPos;
            line = new StiTextRendererParseHtml.StiRenderLine();
            pos = StiTextRendererParseHtml.getNextLine(glyphs, pos, paneWidth / zoom, this.g, line);
            double xPos2 = xPos = line.ts != null && line.ts.textAlign == StiTextHorAlignment.Center ? rect.width / zoom / 2.0 - line.width / 2.0 : (line.ts != null && line.ts.textAlign == StiTextHorAlignment.Right ? rect.width / zoom - line.width : 0.0);
            for (StiGlyph gl : line.glyphs) {
                this.g.setFont(gl.awtFont);
                AttributedString as = new AttributedString(gl.text);
                as.addAttribute(TextAttribute.FONT, gl.awtFont);
                float cy = (float)(gl.ts.superscript ? -gl.height / 2.0 : (gl.ts.subscript ? gl.height / 4.0 : 0.0));
                if (gl.underline) {
                    as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
                if (gl.ts.strikeout) {
                    as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, 0, 1);
                }
                if (gl.ts.superscript) {
                    as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, 0, 1);
                }
                if (gl.ts.superscript) {
                    as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, 0, 1);
                }
                this.g.setColor(gl.backColor);
                this.g.fill(new Rectangle2D.Double(xPos, yPos, gl.width + 1.0, gl.height + line.descent));
                this.g.setColor(gl.color);
                this.g.drawString(as.getIterator(), (float)xPos, (float)yPos - (float)line.descent + cy + (float)(line.height / line.glyphs.get((int)0).ts.lineHeight));
                xPos += gl.width;
            }
            yPos += line.height;
        }
        this.g.scale(1.0 / zoom, 1.0 / zoom);
        this.g.translate(-textRectangle.x, -textRectangle.y);
        if (rotationAngle != 0.0 && rotationAngle % 360.0 != 0.0 && rotationAngle % 360.0 != 360.0) {
            this.g.rotate(Math.toRadians(rotationAngle), textRectangle.getLeft() + textRectangle.getWidth() / 2.0, textRectangle.getTop() + textRectangle.getHeight() / 2.0);
        }
        this.restoreClip();
    }

    public void drawText(String text, StiRectangle rect, StiFont font, StiBrush brush, StiTextHorAlignment horAlignment, StiVertAlignment vertAlignment, Boolean wordWrap, float lineSpacing, Double zoom, StiPenStyle linesOfUnderline, StiBorder border, StiTextOptions textOptions) {
        boolean useRightToLeft;
        double rotationAngle;
        this.g.rotate(Math.toRadians(this.rotateAngle), this.centerX, this.centerY);
        double d = rotationAngle = textOptions != null ? (double)textOptions.getAngle() : 0.0;
        if (rotationAngle == 0.0 || rotationAngle % 360.0 == 0.0 || rotationAngle % 360.0 != 360.0) {
            // empty if block
        }
        if (text == null && !"".equals(text) || rect.getWidth() <= 0.0 || rect.getHeight() <= 0.0) {
            return;
        }
        String htmlText = StiHTMLConverter.replaceHtmlSymbols(text.replaceAll("\r\n", "\n"), true, false);
        StiRectangle textRectangle = this.transformRectRound(rect.clone(), this.offsetX, this.offsetY, 3);
        StiRectangle displayRectangle = textRectangle.clone();
        this.setClip(displayRectangle);
        this.beginFill(brush, null, rect.clone(), zoom);
        Font awtFont = font.getAwtFont(zoom);
        this.swapSize(textRectangle, rotationAngle);
        if (horAlignment == StiTextHorAlignment.Width) {
            wordWrap = true;
        }
        boolean bl = useRightToLeft = textOptions != null && textOptions.getRightToLeft();
        if (!vertAlignment.equals((Object)StiVertAlignment.Top) || !horAlignment.equals((Object)StiTextHorAlignment.Left)) {
            StiRectangle paintRectangle = this.drawAttributedString(htmlText, awtFont, textRectangle, font.underline(), rotationAngle % 90.0 == 90.0 || rotationAngle % 90.0 == 0.0 ? wordWrap : false, horAlignment, lineSpacing, false, new ArrayList<StiLineInfo>(), false);
            switch (vertAlignment) {
                case Center: {
                    textRectangle.setY(textRectangle.getY() + (textRectangle.getHeight() - paintRectangle.getHeight()) / 2.0);
                    break;
                }
                case Bottom: {
                    textRectangle.setY(textRectangle.getY() + textRectangle.getHeight() - paintRectangle.getHeight());
                }
            }
        }
        if (rotationAngle != 0.0 && rotationAngle % 360.0 != 0.0 && rotationAngle % 360.0 != 360.0) {
            this.g.rotate(-Math.toRadians(rotationAngle), displayRectangle.getLeft() + displayRectangle.getWidth() / 2.0, displayRectangle.getTop() + displayRectangle.getHeight() / 2.0);
        }
        this.drawAttributedString(htmlText, awtFont, textRectangle, font.underline(), rotationAngle % 90.0 == 90.0 || rotationAngle % 90.0 == 0.0 ? wordWrap : false, horAlignment, lineSpacing, true, new ArrayList<StiLineInfo>(), useRightToLeft);
        if (rotationAngle != 0.0 && rotationAngle % 360.0 != 0.0 && rotationAngle % 360.0 != 360.0) {
            this.g.rotate(Math.toRadians(rotationAngle), displayRectangle.getLeft() + displayRectangle.getWidth() / 2.0, displayRectangle.getTop() + displayRectangle.getHeight() / 2.0);
        }
        this.drawLinesOfUnderline(text, font, linesOfUnderline, rect, border, vertAlignment, zoom);
        this.g.setPaint(null);
        this.restoreClip();
        this.g.rotate(Math.toRadians(-this.rotateAngle.doubleValue()), this.centerX, this.centerY);
    }

    private void drawLinesOfUnderline(String text, StiFont font, StiPenStyle linesOfUnderline, StiRectangle rect, StiBorder border, StiVertAlignment align, Double zoom) {
        if (linesOfUnderline != null && !StiPenStyle.None.equals((Object)linesOfUnderline) && border != null) {
            float textHeight;
            LineMetrics textLineMetrics = font.getAwtFont(zoom).getLineMetrics(text, this.g.getFontRenderContext());
            float yStart = textHeight = textLineMetrics.getAscent() + textLineMetrics.getDescent() + textLineMetrics.getLeading();
            switch (align) {
                case Bottom: {
                    yStart = (float)(rect.getHeight() - (Math.ceil(rect.getHeight() / (double)textHeight) + 1.0) * (double)textHeight);
                    break;
                }
                case Center: {
                    double yHeight = rect.getHeight() / 2.0 - (double)(textHeight / 2.0f);
                    yStart = (float)(yHeight - (Math.ceil(yHeight / (double)textHeight) + 1.0) * (double)textHeight);
                }
            }
            StiPen pen = new StiPen(border.getSize(), border.getColor(), linesOfUnderline);
            float i = yStart;
            while ((double)i < rect.getHeight()) {
                this.drawLineXY(rect.getLeft(), rect.getTop() + (double)i, rect.getRight(), rect.getTop() + (double)i, pen, zoom);
                i += textHeight;
            }
        }
    }

    public StiRectangle drawAttributedString(String allText, Font awtFont, StiRectangle rect, Boolean underline, Boolean wordWrap, StiTextHorAlignment horAlignment, float lineSpacing, Boolean draw, List<StiLineInfo> lines, Boolean useRightToLeft) {
        if (useRightToLeft.booleanValue()) {
            switch (horAlignment) {
                case Left: {
                    horAlignment = StiTextHorAlignment.Right;
                    break;
                }
                case Right: {
                    horAlignment = StiTextHorAlignment.Left;
                }
            }
        }
        StiRectangle textMeasure = new StiRectangle(0L, 0L, 0L, 0L);
        StringTokenizer paragraphTokenizer = new StringTokenizer(allText, "\n", true);
        double x = rect.getX();
        double y = rect.getY();
        String lastText = null;
        while (paragraphTokenizer.hasMoreElements()) {
            String text = paragraphTokenizer.nextToken();
            if ("\n".equals(text) && !"\n".equals(lastText) && lastText != null) {
                lastText = text;
                continue;
            }
            lastText = text;
            AttributedString attributedString = new AttributedString(text);
            attributedString.addAttribute(TextAttribute.FONT, awtFont);
            if (underline.booleanValue()) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            if (wordWrap.booleanValue()) {
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, this.g.getFontRenderContext());
                int charPos = 0;
                while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout((float)rect.getWidth());
                    textMeasure.setWidth(Math.max((double)textLayout.getAdvance(), textMeasure.getWidth()));
                    double yStart = y;
                    String lineText = text.substring(charPos, lineBreakMeasurer.getPosition());
                    if (useRightToLeft.booleanValue()) {
                        lineText = this.bidi.convert(new StringBuilder(lineText), useRightToLeft).toString();
                    }
                    float lineHeight = textLayout.getAscent();
                    charPos = lineBreakMeasurer.getPosition();
                    if (draw.booleanValue()) {
                        switch (horAlignment) {
                            case Center: {
                                x = rect.getX() + (rect.getWidth() - (double)textLayout.getAdvance()) / 2.0;
                                break;
                            }
                            case Right: {
                                x = rect.getX() + rect.getWidth() - (double)textLayout.getAdvance();
                            }
                        }
                        if (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex() && horAlignment == StiTextHorAlignment.Width) {
                            textLayout = textLayout.getJustifiedLayout((float)rect.getWidth());
                        }
                        textLayout.draw(this.g, (float)x, (float)y + lineHeight);
                    }
                    lineHeight += textLayout.getDescent() + textLayout.getLeading();
                    lines.add(new StiLineInfo(lineText, textMeasure.getWidth(), (y += (double)(lineHeight *= lineSpacing)) - yStart));
                }
                continue;
            }
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.g.getFontRenderContext());
            textMeasure.setWidth(Math.max((double)textLayout.getAdvance(), textMeasure.getWidth()));
            double yStart = y;
            float lineHeight = textLayout.getAscent();
            if (draw.booleanValue()) {
                switch (horAlignment) {
                    case Center: {
                        x = rect.getX() + (rect.getWidth() - (double)textLayout.getAdvance()) / 2.0;
                        break;
                    }
                    case Right: {
                        x = rect.getX() + rect.getWidth() - (double)textLayout.getAdvance();
                    }
                }
                textLayout.draw(this.g, (float)x, (float)y + lineHeight);
            }
            lineHeight += textLayout.getDescent() + textLayout.getLeading();
            y += (double)(lineHeight *= lineSpacing);
            if (useRightToLeft.booleanValue()) {
                text = this.bidi.convert(new StringBuilder(text), useRightToLeft).toString();
            }
            lines.add(new StiLineInfo(text, textMeasure.getWidth(), y - yStart));
        }
        textMeasure.setHeight(y - rect.getY());
        return textMeasure;
    }

    public Graphics2D getG() {
        return this.g;
    }

    public Double getOffsetX() {
        return this.offsetX;
    }

    public Double getOffsetY() {
        return this.offsetY;
    }

    public void setG(Graphics2D g) {
        this.g = g;
    }

    public class Cubic {
        float a;
        float b;
        float c;
        float d;

        public Cubic(float a, float b, float c, float d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public float eval(float u) {
            return ((this.d * u + this.c) * u + this.b) * u + this.a;
        }
    }
}

