/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.HashMap;

public class StiColor
implements IStiSerializable,
IStiSerializableToString {
    public static final StiColor DarkGray = new StiColor(StiColorEnum.DarkGray);
    public static final StiColor Red = new StiColor(StiColorEnum.Red);
    public static final StiColor Blue = new StiColor(StiColorEnum.Blue);
    public static final StiColor Firebrick = new StiColor(StiColorEnum.Firebrick);
    public static final StiColor Gainsboro = new StiColor(StiColorEnum.Gainsboro);
    public static final StiColor Gray = new StiColor(StiColorEnum.Gray);
    public static final StiColor Black = new StiColor(StiColorEnum.Black);
    public static final StiColor Silver = new StiColor(StiColorEnum.Silver);
    public static final StiColor Transparent = new StiColor(StiColorEnum.Transparent);
    public static final StiColor Empty = new StiColor(StiColorEnum.Black);
    public static final StiColor White = new StiColor(StiColorEnum.White);
    private static final int A_DEFAULT = 255;
    private String name;
    public int a = 255;
    public int r;
    public int g;
    public int b;
    private int gradient;
    private static HashMap<String, StiColor> colorTable = new HashMap();

    public String toString() {
        return "r=" + this.r + " g=" + this.g + " b=" + this.b + " a=" + this.a;
    }

    public String toHTML() {
        return "#" + String.format("%1$6s", Integer.toHexString(this.getAwtColor().getRGB() & 0xFFFFFF).toUpperCase()).replaceAll(" ", "0");
    }

    public String toArgbHTML() {
        return "#" + String.format("%1$8s", Integer.toHexString(this.getAwtColor().getRGB() & 0xFFFFFFFF).toUpperCase()).replaceAll(" ", "0");
    }

    public String toRGBAhtml() {
        return String.format("rgba(%s, %s, %s, %s)", this.r, this.g, this.b, (double)this.a / 255.0);
    }

    public static StiColor parseIntARGB(int color) {
        int r = color & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 16 & 0xFF;
        int a = color >> 24 & 0xFF;
        return new StiColor(a, r, g, b);
    }

    public static StiColor parseIntRGB(int color) {
        int b = color & 0xFF;
        int g = color >> 8 & 0xFF;
        int r = color >> 16 & 0xFF;
        return new StiColor(r, g, b);
    }

    public StiColor() {
    }

    public Color getAwtColor() {
        return new Color(this.r, this.g, this.b, this.a);
    }

    public StiColor(String r, String g, String b) {
        this(255, Integer.valueOf(r), Integer.valueOf(g), Integer.valueOf(b), null);
    }

    public StiColor(int r, int g, int b) {
        this(255, r, g, b, null);
    }

    public StiColor(String a, String r, String g, String b) {
        this(Integer.valueOf(a), Integer.valueOf(r), Integer.valueOf(g), Integer.valueOf(b), null);
    }

    public StiColor(int a, int r, int g, int b) {
        this(a, r, g, b, null);
    }

    public StiColor(StiColorEnum color) {
        this(color.a, color.r, color.g, color.b, color.name());
    }

    public StiColor(int a, int r, int g, int b, String name) {
        this.a = Math.min(Math.max(a, 0), 255);
        this.r = Math.min(Math.max(r, 0), 255);
        this.g = Math.min(Math.max(g, 0), 255);
        this.b = Math.min(Math.max(b, 0), 255);
        this.name = name;
    }

    public StiColor light(int value) {
        StiColor color = this.clone();
        color.r = Math.min(255, this.r + value);
        color.g = Math.min(255, this.g + value);
        color.b = Math.min(255, this.b + value);
        return color;
    }

    public StiColor dark(int value) {
        StiColor color = this.clone();
        color.r = Math.max(0, this.r - value);
        color.g = Math.max(0, this.g - value);
        color.b = Math.max(0, this.b - value);
        return color;
    }

    public StiColor clone() {
        StiColor object = new StiColor(this.a, this.r, this.g, this.b, this.name);
        object.setGradient(this.gradient);
        return object;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setA(int a) {
        this.a = a;
    }

    public int getA() {
        return this.a;
    }

    public void setR(int r) {
        this.r = r;
    }

    public int getR() {
        return this.r;
    }

    public void setG(int g) {
        this.g = g;
    }

    public int getG() {
        return this.g;
    }

    public void setB(int b) {
        this.b = b;
    }

    public int getB() {
        return this.b;
    }

    public boolean is(StiColorEnum color) {
        return this.a == color.a && this.r == color.r && this.g == color.g && this.b == color.b;
    }

    public String serializeString() {
        String result = StiValidationUtil.isEmpty((String)this.name) && this.a == 255 ? MessageFormat.format("[{0}:{1}:{2}]", this.r, this.g, this.b) : (StiValidationUtil.isNotEmpty((String)this.name) && !"Custom".equals(this.name) ? MessageFormat.format("{0}", "Empty".equals(this.name) ? "Transparent" : this.name) : MessageFormat.format("[{0}:{1}:{2}:{3}]", this.a, this.r, this.g, this.b));
        return result;
    }

    public static String serializeStringArray(StiColor[] colors) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < colors.length; ++i) {
            sb.append(colors[i].serializeString());
            if (i == colors.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static StiColor fromAColor(int alpha, StiColor color) {
        return new StiColor(alpha, color.r, color.g, color.b);
    }

    public static StiColor fromArgb(int a, int r, int g, int b) {
        return new StiColor(a, r, g, b);
    }

    public static StiColor deserializeString(String value) {
        String colorName;
        String[] values = (value = value.replaceAll("\\[|\\]", "")).split(":");
        StiColor result = values.length == 1 ? ((colorName = values[0].trim()).equals("Empty") ? new StiColor(StiColorEnum.Transparent) : new StiColor(StiColorEnum.valueOf(colorName))) : (values.length == 4 ? new StiColor(values[0].trim(), values[1].trim(), values[2].trim(), values[3].trim()) : new StiColor(values[0].trim(), values[1].trim(), values[2].trim()));
        return result;
    }

    public static StiColor[] deserializeStringArray(String value) {
        String[] strColors = value.split(",");
        StiColor[] colors = new StiColor[strColors.length];
        for (int i = 0; i < strColors.length; ++i) {
            colors[i] = StiColor.deserializeString(strColors[i]);
        }
        return colors;
    }

    public static StiColor create(StiColorEnum color) {
        return new StiColor(color);
    }

    public static StiColor Light(StiColorEnum color, int i) {
        return new StiColor(color).light(i);
    }

    public static StiColor Dark(StiColorEnum color, int i) {
        return new StiColor(color).dark(i);
    }

    @Override
    public String serialize() {
        if (StiValidationUtil.isEmpty((String)this.name) || "Custom".equals(this.name)) {
            if (this.gradient != 0) {
                return MessageFormat.format("{0}, {1}, {2}, {3}, {4}", this.a, this.r, this.g, this.b, this.gradient);
            }
            if (this.a == 255) {
                return MessageFormat.format("{0}, {1}, {2}", this.r, this.g, this.b);
            }
            return MessageFormat.format("{0}, {1}, {2}, {3}", this.a, this.r, this.g, this.b);
        }
        return this.name;
    }

    @Override
    public void deserialize(String textContent) {
        if (textContent.indexOf(", ") >= 0) {
            String[] colorPar = textContent.split(", ");
            this.name = "Custom";
            if (colorPar.length >= 4) {
                this.a = StiSerializTypeConverter.stringToInt(colorPar[0]);
                this.r = StiSerializTypeConverter.stringToInt(colorPar[1]);
                this.g = StiSerializTypeConverter.stringToInt(colorPar[2]);
                this.b = StiSerializTypeConverter.stringToInt(colorPar[3]);
                this.gradient = colorPar.length > 4 ? StiSerializTypeConverter.stringToInt(colorPar[4]) : 0;
            } else {
                this.r = StiSerializTypeConverter.stringToInt(colorPar[0]);
                this.g = StiSerializTypeConverter.stringToInt(colorPar[1]);
                this.b = StiSerializTypeConverter.stringToInt(colorPar[2]);
                this.a = 255;
                this.gradient = 0;
            }
        } else {
            StiColor tempColor = StiColorEnum.valueOf(textContent).color();
            this.a = tempColor.a;
            this.r = tempColor.r;
            this.g = tempColor.g;
            this.b = tempColor.b;
            this.gradient = 0;
            this.name = tempColor.name;
        }
    }

    public boolean equals(StiColorEnum color) {
        return StiValidationUtil.isNotBlank((String)this.name) && this.name.equals(color.name());
    }

    public boolean equals(StiColor color) {
        return this.a == color.a && this.r == color.r && this.g == color.g && this.b == color.b;
    }

    public static StiColor fromArgb(int r, int g, int b) {
        return new StiColor(r, g, b);
    }

    public static StiColor by(StiColorEnum color) {
        return new StiColor(color);
    }

    public static StiColor fromArgb(int alpha, StiColor color) {
        return new StiColor(alpha, color.getR(), color.getG(), color.getB());
    }

    public void setGradient(int gradient) {
        this.gradient = gradient;
        this.name = "Custom";
    }

    public int getGradient() {
        return this.gradient;
    }

    public static Object ConvertColorToString(StiColor color) {
        return null;
    }

    public static StiColor ConvertStringToColor(String string) {
        return null;
    }

    public static StiColor FromArgb(int alpha, StiColor color) {
        return StiColor.fromArgb(alpha, color);
    }

    public static StiColor FromArgb(int intColor) {
        StiColor color = new StiColor();
        color.a = 255;
        color.r = intColor / 65536;
        color.g = (intColor - color.r * 65536) / 256;
        color.b = (intColor - color.r * 65536 - color.g * 256) / 1;
        return color;
    }

    public static StiColor fromHtml(String colorStr) {
        if (colorStr.startsWith("#")) {
            colorStr = colorStr.substring(1);
        }
        if (colorStr.length() == 6) {
            return new StiColor(Integer.valueOf(colorStr.substring(0, 2), 16), Integer.valueOf(colorStr.substring(2, 4), 16), Integer.valueOf(colorStr.substring(4, 6), 16));
        }
        return new StiColor(Integer.valueOf(colorStr.substring(0, 2), 16), Integer.valueOf(colorStr.substring(2, 4), 16), Integer.valueOf(colorStr.substring(4, 6), 16), Integer.valueOf(colorStr.substring(6, 8), 16));
    }

    public static StiColor get(String color) {
        if (StiValidationUtil.isNullOrWhiteSpace((String)color)) {
            return StiColorEnum.Transparent.color();
        }
        StiColor value = StiColor.getColor(color = color.trim());
        if (value != null) {
            return value;
        }
        if (color.indexOf(",") != -1) {
            String[] strs = color.split(",");
            if (strs.length == 4) {
                return StiColor.fromArgb(Integer.parseInt(strs[0].trim()), Integer.parseInt(strs[1].trim()), Integer.parseInt(strs[2].trim()), Integer.parseInt(strs[3].trim()));
            }
            return StiColor.fromArgb(Integer.parseInt(strs[0].trim()), Integer.parseInt(strs[1].trim()), Integer.parseInt(strs[2].trim()));
        }
        if (!color.startsWith("#")) {
            color = "#" + color;
        }
        return StiColor.fromHtml(color);
    }

    public static StiColor getColor(String colorName) {
        if (colorTable.size() == 0) {
            colorTable.put("grey93", new StiColor(237, 237, 237));
            colorTable.put("grey92", new StiColor(235, 235, 235));
            colorTable.put("grey95", new StiColor(242, 242, 242));
            colorTable.put("grey94", new StiColor(240, 240, 240));
            colorTable.put("grey97", new StiColor(247, 247, 247));
            colorTable.put("grey96", new StiColor(245, 245, 245));
            colorTable.put("grey99", new StiColor(252, 252, 252));
            colorTable.put("grey98", new StiColor(250, 250, 250));
            colorTable.put("brown3", new StiColor(205, 51, 51));
            colorTable.put("brown2", new StiColor(238, 59, 59));
            colorTable.put("brown4", new StiColor(139, 35, 35));
            colorTable.put("cornsilk3", new StiColor(205, 200, 177));
            colorTable.put("darkslateblue", new StiColor(72, 61, 139));
            colorTable.put("cornsilk4", new StiColor(139, 136, 120));
            colorTable.put("grey91", new StiColor(232, 232, 232));
            colorTable.put("brown1", new StiColor(255, 64, 64));
            colorTable.put("grey90", new StiColor(229, 229, 229));
            colorTable.put("cornsilk2", new StiColor(238, 232, 205));
            colorTable.put("honeydew3", new StiColor(193, 205, 193));
            colorTable.put("gray100", new StiColor(255, 255, 255));
            colorTable.put("honeydew4", new StiColor(131, 139, 131));
            colorTable.put("honeydew1", new StiColor(240, 255, 240));
            colorTable.put("honeydew2", new StiColor(224, 238, 224));
            colorTable.put("grey89", new StiColor(227, 227, 227));
            colorTable.put("saddlebrown", new StiColor(139, 69, 19));
            colorTable.put("grey82", new StiColor(209, 209, 209));
            colorTable.put("orange4", new StiColor(139, 90, 0));
            colorTable.put("grey81", new StiColor(207, 207, 207));
            colorTable.put("skyblue", new StiColor(135, 206, 235));
            colorTable.put("grey84", new StiColor(214, 214, 214));
            colorTable.put("orange2", new StiColor(238, 154, 0));
            colorTable.put("grey83", new StiColor(212, 212, 212));
            colorTable.put("orange3", new StiColor(205, 133, 0));
            colorTable.put("grey86", new StiColor(219, 219, 219));
            colorTable.put("mediumpurple", new StiColor(147, 112, 219));
            colorTable.put("grey85", new StiColor(217, 217, 217));
            colorTable.put("orange1", new StiColor(255, 165, 0));
            colorTable.put("grey88", new StiColor(224, 224, 224));
            colorTable.put("grey87", new StiColor(222, 222, 222));
            colorTable.put("dimgrey", new StiColor(105, 105, 105));
            colorTable.put("grey80", new StiColor(204, 204, 204));
            colorTable.put("darkseagreen", new StiColor(143, 188, 143));
            colorTable.put("limegreen", new StiColor(50, 205, 50));
            colorTable.put("grey79", new StiColor(201, 201, 201));
            colorTable.put("grey78", new StiColor(199, 199, 199));
            colorTable.put("yellow", new StiColor(255, 255, 0));
            colorTable.put("tomato", new StiColor(255, 99, 71));
            colorTable.put("transparent", new StiColor(255, 255, 254));
            colorTable.put("gold", new StiColor(255, 215, 0));
            colorTable.put("springgreen", new StiColor(0, 255, 127));
            colorTable.put("wheat", new StiColor(245, 222, 179));
            colorTable.put("lightgoldenrod", new StiColor(238, 221, 130));
            colorTable.put("blue", new StiColor(0, 0, 255));
            colorTable.put("seagreen", new StiColor(46, 139, 87));
            colorTable.put("lightblue1", new StiColor(191, 239, 255));
            colorTable.put("lightblue2", new StiColor(178, 223, 238));
            colorTable.put("lightblue3", new StiColor(154, 192, 205));
            colorTable.put("lightblue4", new StiColor(104, 131, 139));
            colorTable.put("slategray4", new StiColor(108, 123, 139));
            colorTable.put("tan3", new StiColor(205, 133, 63));
            colorTable.put("tan4", new StiColor(139, 90, 43));
            colorTable.put("tan1", new StiColor(255, 165, 79));
            colorTable.put("tan2", new StiColor(238, 154, 73));
            colorTable.put("slategray3", new StiColor(159, 182, 205));
            colorTable.put("slategray2", new StiColor(185, 211, 238));
            colorTable.put("slategray1", new StiColor(198, 226, 255));
            colorTable.put("red", new StiColor(255, 0, 0));
            colorTable.put("darkolivegreen4", new StiColor(110, 139, 61));
            colorTable.put("salmon4", new StiColor(139, 76, 57));
            colorTable.put("darkolivegreen3", new StiColor(162, 205, 90));
            colorTable.put("salmon3", new StiColor(205, 112, 84));
            colorTable.put("darkolivegreen2", new StiColor(188, 238, 104));
            colorTable.put("salmon2", new StiColor(238, 130, 98));
            colorTable.put("salmon1", new StiColor(255, 140, 105));
            colorTable.put("peachpuff", new StiColor(255, 218, 185));
            colorTable.put("darkturquoise", new StiColor(0, 206, 209));
            colorTable.put("navajowhite1", new StiColor(255, 222, 173));
            colorTable.put("royalblue3", new StiColor(58, 95, 205));
            colorTable.put("royalblue4", new StiColor(39, 64, 139));
            colorTable.put("navajowhite3", new StiColor(205, 179, 139));
            colorTable.put("lightgray", new StiColor(211, 211, 211));
            colorTable.put("royalblue1", new StiColor(72, 118, 255));
            colorTable.put("navajowhite4", new StiColor(139, 121, 94));
            colorTable.put("royalblue2", new StiColor(67, 110, 238));
            colorTable.put("steelblue4", new StiColor(54, 100, 139));
            colorTable.put("steelblue3", new StiColor(79, 148, 205));
            colorTable.put("lightsalmon", new StiColor(255, 160, 122));
            colorTable.put("lightgoldenrod1", new StiColor(255, 236, 139));
            colorTable.put("lightgoldenrod2", new StiColor(238, 220, 130));
            colorTable.put("lightgoldenrod3", new StiColor(205, 190, 112));
            colorTable.put("lightgoldenrod4", new StiColor(139, 129, 76));
            colorTable.put("aquamarine1", new StiColor(127, 255, 212));
            colorTable.put("aquamarine2", new StiColor(118, 238, 198));
            colorTable.put("cyan2", new StiColor(0, 238, 238));
            colorTable.put("aquamarine3", new StiColor(102, 205, 170));
            colorTable.put("cyan1", new StiColor(0, 255, 255));
            colorTable.put("aquamarine4", new StiColor(69, 139, 116));
            colorTable.put("grey0", new StiColor(0, 0, 0));
            colorTable.put("firebrick", new StiColor(178, 34, 34));
            colorTable.put("grey1", new StiColor(3, 3, 3));
            colorTable.put("aliceblue", new StiColor(240, 248, 255));
            colorTable.put("darkgoldenrod", new StiColor(184, 134, 11));
            colorTable.put("grey2", new StiColor(5, 5, 5));
            colorTable.put("grey3", new StiColor(8, 8, 8));
            colorTable.put("grey4", new StiColor(10, 10, 10));
            colorTable.put("grey5", new StiColor(13, 13, 13));
            colorTable.put("grey6", new StiColor(15, 15, 15));
            colorTable.put("mediumspringgreen", new StiColor(0, 250, 154));
            colorTable.put("grey8", new StiColor(20, 20, 20));
            colorTable.put("grey9", new StiColor(23, 23, 23));
            colorTable.put("cyan4", new StiColor(0, 139, 139));
            colorTable.put("cyan3", new StiColor(0, 205, 205));
            colorTable.put("skyblue1", new StiColor(135, 206, 255));
            colorTable.put("skyblue2", new StiColor(126, 192, 238));
            colorTable.put("skyblue3", new StiColor(108, 166, 205));
            colorTable.put("skyblue4", new StiColor(74, 112, 139));
            colorTable.put("khaki3", new StiColor(205, 198, 115));
            colorTable.put("khaki2", new StiColor(238, 230, 133));
            colorTable.put("khaki4", new StiColor(139, 134, 78));
            colorTable.put("goldenrod1", new StiColor(255, 193, 37));
            colorTable.put("yellow4", new StiColor(139, 139, 0));
            colorTable.put("khaki1", new StiColor(255, 246, 143));
            colorTable.put("goldenrod4", new StiColor(139, 105, 20));
            colorTable.put("khaki", new StiColor(240, 230, 140));
            colorTable.put("goldenrod3", new StiColor(205, 155, 29));
            colorTable.put("goldenrod2", new StiColor(238, 180, 34));
            colorTable.put("invis", new StiColor(255, 255, 254));
            colorTable.put("purple4", new StiColor(85, 26, 139));
            colorTable.put("darkorange3", new StiColor(205, 102, 0));
            colorTable.put("darkorange2", new StiColor(238, 118, 0));
            colorTable.put("darkorange1", new StiColor(255, 127, 0));
            colorTable.put("purple3", new StiColor(125, 38, 205));
            colorTable.put("purple2", new StiColor(145, 44, 238));
            colorTable.put("purple1", new StiColor(155, 48, 255));
            colorTable.put("burlywood", new StiColor(222, 184, 135));
            colorTable.put("mediumorchid", new StiColor(186, 85, 211));
            colorTable.put("darkorange4", new StiColor(139, 69, 0));
            colorTable.put("pink", new StiColor(255, 192, 203));
            colorTable.put("bisque2", new StiColor(238, 213, 183));
            colorTable.put("bisque1", new StiColor(255, 228, 196));
            colorTable.put("sienna", new StiColor(160, 82, 45));
            colorTable.put("bisque4", new StiColor(139, 125, 107));
            colorTable.put("bisque3", new StiColor(205, 183, 158));
            colorTable.put("cornsilk", new StiColor(255, 248, 220));
            colorTable.put("slateblue3", new StiColor(105, 89, 205));
            colorTable.put("slateblue4", new StiColor(71, 60, 139));
            colorTable.put("coral1", new StiColor(255, 114, 86));
            colorTable.put("coral4", new StiColor(139, 62, 47));
            colorTable.put("coral3", new StiColor(205, 91, 69));
            colorTable.put("slateblue1", new StiColor(131, 111, 255));
            colorTable.put("yellow1", new StiColor(255, 255, 0));
            colorTable.put("slateblue2", new StiColor(122, 103, 238));
            colorTable.put("yellow2", new StiColor(238, 238, 0));
            colorTable.put("yellow3", new StiColor(205, 205, 0));
            colorTable.put("darkorchid1", new StiColor(191, 62, 255));
            colorTable.put("darkorchid3", new StiColor(154, 50, 205));
            colorTable.put("darkorchid4", new StiColor(104, 34, 139));
            colorTable.put("forestgreen", new StiColor(34, 139, 34));
            colorTable.put("snow1", new StiColor(255, 250, 250));
            colorTable.put("snow2", new StiColor(238, 233, 233));
            colorTable.put("coral", new StiColor(255, 127, 80));
            colorTable.put("snow3", new StiColor(205, 201, 201));
            colorTable.put("snow4", new StiColor(139, 137, 137));
            colorTable.put("antiquewhite4", new StiColor(139, 131, 120));
            colorTable.put("plum", new StiColor(221, 160, 221));
            colorTable.put("antiquewhite2", new StiColor(238, 223, 204));
            colorTable.put("antiquewhite3", new StiColor(205, 192, 176));
            colorTable.put("midnightblue", new StiColor(25, 25, 112));
            colorTable.put("dimgray", new StiColor(105, 105, 105));
            colorTable.put("antiquewhite1", new StiColor(255, 239, 219));
            colorTable.put("snow", new StiColor(255, 250, 250));
            colorTable.put("mediumpurple1", new StiColor(171, 130, 255));
            colorTable.put("mediumpurple2", new StiColor(159, 121, 238));
            colorTable.put("mediumpurple3", new StiColor(137, 104, 205));
            colorTable.put("mediumpurple4", new StiColor(93, 71, 139));
            colorTable.put("lightslateblue", new StiColor(132, 112, 255));
            colorTable.put("floralwhite", new StiColor(255, 250, 240));
            colorTable.put("thistle1", new StiColor(255, 225, 255));
            colorTable.put("thistle2", new StiColor(238, 210, 238));
            colorTable.put("turquoise", new StiColor(64, 224, 208));
            colorTable.put("thistle3", new StiColor(205, 181, 205));
            colorTable.put("thistle4", new StiColor(139, 123, 139));
            colorTable.put("gray26", new StiColor(66, 66, 66));
            colorTable.put("gray25", new StiColor(64, 64, 64));
            colorTable.put("gray23", new StiColor(59, 59, 59));
            colorTable.put("navajowhite", new StiColor(255, 222, 173));
            colorTable.put("lightcyan1", new StiColor(224, 255, 255));
            colorTable.put("lightcyan2", new StiColor(209, 238, 238));
            colorTable.put("lightcyan3", new StiColor(180, 205, 205));
            colorTable.put("lightcyan4", new StiColor(122, 139, 139));
            colorTable.put("darkorange", new StiColor(255, 140, 0));
            colorTable.put("slateblue", new StiColor(106, 90, 205));
            colorTable.put("lightcyan", new StiColor(224, 255, 255));
            colorTable.put("gray29", new StiColor(74, 74, 74));
            colorTable.put("gray28", new StiColor(71, 71, 71));
            colorTable.put("gray27", new StiColor(69, 69, 69));
            colorTable.put("mistyrose2", new StiColor(238, 213, 210));
            colorTable.put("indianred1", new StiColor(255, 106, 106));
            colorTable.put("firebrick1", new StiColor(255, 48, 48));
            colorTable.put("firebrick2", new StiColor(238, 44, 44));
            colorTable.put("firebrick3", new StiColor(205, 38, 38));
            colorTable.put("cadetblue2", new StiColor(142, 229, 238));
            colorTable.put("mediumaquamarine", new StiColor(102, 205, 170));
            colorTable.put("firebrick4", new StiColor(139, 26, 26));
            colorTable.put("cadetblue1", new StiColor(152, 245, 255));
            colorTable.put("indianred2", new StiColor(238, 99, 99));
            colorTable.put("cadetblue4", new StiColor(83, 134, 139));
            colorTable.put("mistyrose4", new StiColor(139, 125, 123));
            colorTable.put("indianred3", new StiColor(205, 85, 85));
            colorTable.put("cadetblue3", new StiColor(122, 197, 205));
            colorTable.put("mistyrose3", new StiColor(205, 183, 181));
            colorTable.put("indianred4", new StiColor(139, 58, 58));
            colorTable.put("gray15", new StiColor(38, 38, 38));
            colorTable.put("gray14", new StiColor(36, 36, 36));
            colorTable.put("gray13", new StiColor(33, 33, 33));
            colorTable.put("gray12", new StiColor(31, 31, 31));
            colorTable.put("gray11", new StiColor(28, 28, 28));
            colorTable.put("red2", new StiColor(238, 0, 0));
            colorTable.put("darkseagreen1", new StiColor(193, 255, 193));
            colorTable.put("gray10", new StiColor(26, 26, 26));
            colorTable.put("red1", new StiColor(255, 0, 0));
            colorTable.put("red4", new StiColor(139, 0, 0));
            colorTable.put("red3", new StiColor(205, 0, 0));
            colorTable.put("darkseagreen4", new StiColor(105, 139, 105));
            colorTable.put("darkseagreen2", new StiColor(180, 238, 180));
            colorTable.put("darkseagreen3", new StiColor(155, 205, 155));
            colorTable.put("gray19", new StiColor(48, 48, 48));
            colorTable.put("gray17", new StiColor(43, 43, 43));
            colorTable.put("gray16", new StiColor(41, 41, 41));
            colorTable.put("dodgerblue4", new StiColor(16, 78, 139));
            colorTable.put("gray50", new StiColor(127, 127, 127));
            colorTable.put("dodgerblue3", new StiColor(24, 116, 205));
            colorTable.put("dodgerblue2", new StiColor(28, 134, 238));
            colorTable.put("gold4", new StiColor(139, 117, 0));
            colorTable.put("dodgerblue1", new StiColor(30, 144, 255));
            colorTable.put("gold3", new StiColor(205, 173, 0));
            colorTable.put("gold2", new StiColor(238, 201, 0));
            colorTable.put("gold1", new StiColor(255, 215, 0));
            colorTable.put("gray48", new StiColor(122, 122, 122));
            colorTable.put("chocolate4", new StiColor(139, 69, 19));
            colorTable.put("gray47", new StiColor(120, 120, 120));
            colorTable.put("gray46", new StiColor(117, 117, 117));
            colorTable.put("gray45", new StiColor(115, 115, 115));
            colorTable.put("gray44", new StiColor(112, 112, 112));
            colorTable.put("gray43", new StiColor(110, 110, 110));
            colorTable.put("gray42", new StiColor(107, 107, 107));
            colorTable.put("gray41", new StiColor(105, 105, 105));
            colorTable.put("chocolate1", new StiColor(255, 127, 36));
            colorTable.put("violetred1", new StiColor(255, 62, 150));
            colorTable.put("gray49", new StiColor(125, 125, 125));
            colorTable.put("chocolate3", new StiColor(205, 102, 29));
            colorTable.put("deepskyblue", new StiColor(0, 191, 255));
            colorTable.put("gray40", new StiColor(102, 102, 102));
            colorTable.put("palevioletred", new StiColor(219, 112, 147));
            colorTable.put("gray37", new StiColor(94, 94, 94));
            colorTable.put("honeydew", new StiColor(240, 255, 240));
            colorTable.put("gray36", new StiColor(92, 92, 92));
            colorTable.put("gray35", new StiColor(89, 89, 89));
            colorTable.put("gray39", new StiColor(99, 99, 99));
            colorTable.put("gray38", new StiColor(97, 97, 97));
            colorTable.put("lightsteelblue", new StiColor(176, 196, 222));
            colorTable.put("grey100", new StiColor(255, 255, 255));
            colorTable.put("seashell", new StiColor(255, 245, 238));
            colorTable.put("thistle", new StiColor(216, 191, 216));
            colorTable.put("gray73", new StiColor(186, 186, 186));
            colorTable.put("sandybrown", new StiColor(244, 164, 96));
            colorTable.put("gray69", new StiColor(176, 176, 176));
            colorTable.put("gray68", new StiColor(173, 173, 173));
            colorTable.put("gray", new StiColor(192, 192, 192));
            colorTable.put("gray67", new StiColor(171, 171, 171));
            colorTable.put("gray66", new StiColor(168, 168, 168));
            colorTable.put("lightpink4", new StiColor(139, 95, 101));
            colorTable.put("gray65", new StiColor(166, 166, 166));
            colorTable.put("gray64", new StiColor(163, 163, 163));
            colorTable.put("gray63", new StiColor(161, 161, 161));
            colorTable.put("lightsteelblue2", new StiColor(188, 210, 238));
            colorTable.put("lightpink1", new StiColor(255, 174, 185));
            colorTable.put("lightpink2", new StiColor(238, 162, 173));
            colorTable.put("lightpink3", new StiColor(205, 140, 149));
            colorTable.put("lightsteelblue3", new StiColor(162, 181, 205));
            colorTable.put("violetred2", new StiColor(238, 58, 140));
            colorTable.put("violetred3", new StiColor(205, 50, 120));
            colorTable.put("violetred4", new StiColor(139, 34, 82));
            colorTable.put("indianred", new StiColor(205, 92, 92));
            colorTable.put("whitesmoke", new StiColor(245, 245, 245));
            colorTable.put("gray62", new StiColor(158, 158, 158));
            colorTable.put("black", new StiColor(0, 0, 0));
            colorTable.put("gray61", new StiColor(156, 156, 156));
            colorTable.put("gray60", new StiColor(153, 153, 153));
            colorTable.put("beige", new StiColor(245, 245, 220));
            colorTable.put("darkgoldenrod4", new StiColor(139, 101, 8));
            colorTable.put("darkgoldenrod2", new StiColor(238, 173, 14));
            colorTable.put("darkgoldenrod3", new StiColor(205, 149, 12));
            colorTable.put("darkslategray", new StiColor(47, 79, 79));
            colorTable.put("royalblue", new StiColor(65, 105, 225));
            colorTable.put("darkgoldenrod1", new StiColor(255, 185, 15));
            colorTable.put("blue1", new StiColor(0, 0, 255));
            colorTable.put("tomato4", new StiColor(139, 54, 38));
            colorTable.put("chartreuse2", new StiColor(118, 238, 0));
            colorTable.put("chartreuse3", new StiColor(102, 205, 0));
            colorTable.put("tomato2", new StiColor(238, 92, 66));
            colorTable.put("chartreuse4", new StiColor(69, 139, 0));
            colorTable.put("tomato3", new StiColor(205, 79, 57));
            colorTable.put("lightsalmon4", new StiColor(139, 87, 66));
            colorTable.put("gray94", new StiColor(240, 240, 240));
            colorTable.put("gray93", new StiColor(237, 237, 237));
            colorTable.put("gray92", new StiColor(235, 235, 235));
            colorTable.put("gray91", new StiColor(232, 232, 232));
            colorTable.put("blue4", new StiColor(0, 0, 139));
            colorTable.put("gray90", new StiColor(229, 229, 229));
            colorTable.put("tomato1", new StiColor(255, 99, 71));
            colorTable.put("blue3", new StiColor(0, 0, 205));
            colorTable.put("blue2", new StiColor(0, 0, 238));
            colorTable.put("gray89", new StiColor(227, 227, 227));
            colorTable.put("gray88", new StiColor(224, 224, 224));
            colorTable.put("lightblue", new StiColor(173, 216, 230));
            colorTable.put("white", new StiColor(255, 255, 255));
            colorTable.put("gray87", new StiColor(222, 222, 222));
            colorTable.put("seagreen3", new StiColor(67, 205, 128));
            colorTable.put("lightsalmon1", new StiColor(255, 160, 122));
            colorTable.put("gray86", new StiColor(219, 219, 219));
            colorTable.put("lightsalmon2", new StiColor(238, 149, 114));
            colorTable.put("seagreen1", new StiColor(84, 255, 159));
            colorTable.put("lightsalmon3", new StiColor(205, 129, 98));
            colorTable.put("darkolivegreen", new StiColor(85, 107, 47));
            colorTable.put("gainsboro", new StiColor(220, 220, 220));
            colorTable.put("sienna1", new StiColor(255, 130, 71));
            colorTable.put("mediumorchid1", new StiColor(224, 102, 255));
            colorTable.put("powderblue", new StiColor(176, 224, 230));
            colorTable.put("mediumorchid2", new StiColor(209, 95, 238));
            colorTable.put("gray84", new StiColor(214, 214, 214));
            colorTable.put("gray83", new StiColor(212, 212, 212));
            colorTable.put("gray82", new StiColor(209, 209, 209));
            colorTable.put("seagreen4", new StiColor(46, 139, 87));
            colorTable.put("gray81", new StiColor(207, 207, 207));
            colorTable.put("steelblue", new StiColor(70, 130, 180));
            colorTable.put("gray76", new StiColor(194, 194, 194));
            colorTable.put("gray75", new StiColor(191, 191, 191));
            colorTable.put("yellowgreen", new StiColor(154, 205, 50));
            colorTable.put("lawngreen", new StiColor(124, 252, 0));
            colorTable.put("peru", new StiColor(205, 133, 63));
            colorTable.put("wheat2", new StiColor(238, 216, 174));
            colorTable.put("wheat1", new StiColor(255, 231, 186));
            colorTable.put("wheat4", new StiColor(139, 126, 102));
            colorTable.put("wheat3", new StiColor(205, 186, 150));
            colorTable.put("hotpink1", new StiColor(255, 110, 180));
            colorTable.put("mistyrose", new StiColor(255, 228, 225));
            colorTable.put("springgreen3", new StiColor(0, 205, 102));
            colorTable.put("springgreen2", new StiColor(0, 238, 118));
            colorTable.put("ghostwhite", new StiColor(248, 248, 255));
            colorTable.put("springgreen4", new StiColor(0, 139, 69));
            colorTable.put("green", new StiColor(0, 255, 0));
            colorTable.put("lavenderblush3", new StiColor(205, 193, 197));
            colorTable.put("seashell4", new StiColor(139, 134, 130));
            colorTable.put("lavenderblush4", new StiColor(139, 131, 134));
            colorTable.put("seashell3", new StiColor(205, 197, 191));
            colorTable.put("springgreen1", new StiColor(0, 255, 127));
            colorTable.put("lavenderblush1", new StiColor(255, 240, 245));
            colorTable.put("seashell2", new StiColor(238, 229, 222));
            colorTable.put("lavenderblush2", new StiColor(238, 224, 229));
            colorTable.put("seashell1", new StiColor(255, 245, 238));
            colorTable.put("oldlace", new StiColor(253, 245, 230));
            colorTable.put("grey", new StiColor(192, 192, 192));
            colorTable.put("deeppink3", new StiColor(205, 16, 118));
            colorTable.put("deeppink2", new StiColor(238, 18, 137));
            colorTable.put("deeppink4", new StiColor(139, 10, 80));
            colorTable.put("darkviolet", new StiColor(148, 0, 211));
            colorTable.put("magenta3", new StiColor(205, 0, 205));
            colorTable.put("magenta1", new StiColor(255, 0, 255));
            colorTable.put("magenta2", new StiColor(238, 0, 238));
            colorTable.put("none", new StiColor(255, 255, 254));
            colorTable.put("bisque", new StiColor(255, 228, 196));
            colorTable.put("palevioletred1", new StiColor(255, 130, 171));
            colorTable.put("lightyellow1", new StiColor(255, 255, 224));
            colorTable.put("lightyellow3", new StiColor(205, 205, 180));
            colorTable.put("lightyellow2", new StiColor(238, 238, 209));
            colorTable.put("blanchedalmond", new StiColor(255, 235, 205));
            colorTable.put("lightyellow4", new StiColor(139, 139, 122));
            colorTable.put("lightcoral", new StiColor(240, 128, 128));
            colorTable.put("orangered", new StiColor(255, 69, 0));
            colorTable.put("azure", new StiColor(240, 255, 255));
            colorTable.put("navyblue", new StiColor(0, 0, 128));
            colorTable.put("palegreen1", new StiColor(154, 255, 154));
            colorTable.put("palegreen2", new StiColor(144, 238, 144));
            colorTable.put("pink4", new StiColor(139, 99, 108));
            colorTable.put("palegreen3", new StiColor(124, 205, 124));
            colorTable.put("lightyellow", new StiColor(255, 255, 224));
            colorTable.put("pink3", new StiColor(205, 145, 158));
            colorTable.put("palegreen4", new StiColor(84, 139, 84));
            colorTable.put("pink2", new StiColor(238, 169, 184));
            colorTable.put("peachpuff3", new StiColor(205, 175, 149));
            colorTable.put("violet", new StiColor(238, 130, 238));
            colorTable.put("peachpuff4", new StiColor(139, 119, 101));
            colorTable.put("peachpuff1", new StiColor(255, 218, 185));
            colorTable.put("mediumblue", new StiColor(0, 0, 205));
            colorTable.put("paleturquoise", new StiColor(175, 238, 238));
            colorTable.put("papayawhip", new StiColor(255, 239, 213));
            colorTable.put("chocolate", new StiColor(210, 105, 30));
            colorTable.put("plum1", new StiColor(255, 187, 255));
            colorTable.put("plum3", new StiColor(205, 150, 205));
            colorTable.put("plum2", new StiColor(238, 174, 238));
            colorTable.put("grey31", new StiColor(79, 79, 79));
            colorTable.put("grey30", new StiColor(77, 77, 77));
            colorTable.put("darkgreen", new StiColor(0, 100, 0));
            colorTable.put("grey32", new StiColor(82, 82, 82));
            colorTable.put("lightseagreen", new StiColor(32, 178, 170));
            colorTable.put("cornflowerblue", new StiColor(100, 149, 237));
            colorTable.put("crimson", new StiColor(220, 20, 60));
            colorTable.put("slategrey", new StiColor(112, 128, 144));
            colorTable.put("ivory", new StiColor(255, 255, 240));
            colorTable.put("grey24", new StiColor(61, 61, 61));
            colorTable.put("turquoise1", new StiColor(0, 245, 255));
            colorTable.put("grey23", new StiColor(59, 59, 59));
            colorTable.put("turquoise2", new StiColor(0, 229, 238));
            colorTable.put("turquoise3", new StiColor(0, 197, 205));
            colorTable.put("grey25", new StiColor(64, 64, 64));
            colorTable.put("turquoise4", new StiColor(0, 134, 139));
            colorTable.put("sienna2", new StiColor(238, 121, 66));
            colorTable.put("sienna3", new StiColor(205, 104, 57));
            colorTable.put("sienna4", new StiColor(139, 71, 38));
            colorTable.put("grey20", new StiColor(51, 51, 51));
            colorTable.put("darkorchid", new StiColor(153, 50, 204));
            colorTable.put("grey22", new StiColor(56, 56, 56));
            colorTable.put("grey21", new StiColor(54, 54, 54));
            colorTable.put("lightpink", new StiColor(255, 182, 193));
            colorTable.put("cadetblue", new StiColor(95, 158, 160));
            colorTable.put("darkkhaki", new StiColor(189, 183, 107));
            colorTable.put("ivory4", new StiColor(139, 139, 131));
            colorTable.put("ivory3", new StiColor(205, 205, 193));
            colorTable.put("deepskyblue4", new StiColor(0, 104, 139));
            colorTable.put("deepskyblue3", new StiColor(0, 154, 205));
            colorTable.put("violetred", new StiColor(208, 32, 144));
            colorTable.put("grey15", new StiColor(38, 38, 38));
            colorTable.put("grey14", new StiColor(36, 36, 36));
            colorTable.put("grey17", new StiColor(43, 43, 43));
            colorTable.put("grey16", new StiColor(41, 41, 41));
            colorTable.put("orchid", new StiColor(218, 112, 214));
            colorTable.put("plum4", new StiColor(139, 102, 139));
            colorTable.put("grey19", new StiColor(48, 48, 48));
            colorTable.put("deepskyblue2", new StiColor(0, 178, 238));
            colorTable.put("grey18", new StiColor(46, 46, 46));
            colorTable.put("deepskyblue1", new StiColor(0, 191, 255));
            colorTable.put("darksalmon", new StiColor(233, 150, 122));
            colorTable.put("grey51", new StiColor(130, 130, 130));
            colorTable.put("grey50", new StiColor(127, 127, 127));
            colorTable.put("grey53", new StiColor(135, 135, 135));
            colorTable.put("navy", new StiColor(0, 0, 128));
            colorTable.put("grey52", new StiColor(133, 133, 133));
            colorTable.put("lightslategray", new StiColor(119, 136, 153));
            colorTable.put("grey55", new StiColor(140, 140, 140));
            colorTable.put("grey54", new StiColor(138, 138, 138));
            colorTable.put("greenyellow", new StiColor(173, 255, 47));
            colorTable.put("dodgerblue", new StiColor(30, 144, 255));
            colorTable.put("grey46", new StiColor(117, 117, 117));
            colorTable.put("paleturquoise1", new StiColor(187, 255, 255));
            colorTable.put("darkslategray4", new StiColor(82, 139, 139));
            colorTable.put("paleturquoise2", new StiColor(174, 238, 238));
            colorTable.put("grey48", new StiColor(122, 122, 122));
            colorTable.put("darkslategray2", new StiColor(141, 238, 238));
            colorTable.put("grey47", new StiColor(120, 120, 120));
            colorTable.put("darkslategray3", new StiColor(121, 205, 205));
            colorTable.put("grey49", new StiColor(125, 125, 125));
            colorTable.put("darkslategray1", new StiColor(151, 255, 255));
            colorTable.put("paleturquoise3", new StiColor(150, 205, 205));
            colorTable.put("paleturquoise4", new StiColor(102, 139, 139));
            colorTable.put("tan", new StiColor(210, 180, 140));
            colorTable.put("grey41", new StiColor(105, 105, 105));
            colorTable.put("olivedrab1", new StiColor(192, 255, 62));
            colorTable.put("lemonchiffon", new StiColor(255, 250, 205));
            colorTable.put("olivedrab3", new StiColor(154, 205, 50));
            colorTable.put("salmon", new StiColor(250, 128, 114));
            colorTable.put("olivedrab2", new StiColor(179, 238, 58));
            colorTable.put("olivedrab4", new StiColor(105, 139, 34));
            colorTable.put("grey35", new StiColor(89, 89, 89));
            colorTable.put("grey34", new StiColor(87, 87, 87));
            colorTable.put("olivedrab", new StiColor(107, 142, 35));
            colorTable.put("grey71", new StiColor(181, 181, 181));
            colorTable.put("grey70", new StiColor(179, 179, 179));
            colorTable.put("grey73", new StiColor(186, 186, 186));
            colorTable.put("grey72", new StiColor(184, 184, 184));
            colorTable.put("maroon4", new StiColor(139, 28, 98));
            colorTable.put("grey75", new StiColor(191, 191, 191));
            colorTable.put("maroon3", new StiColor(205, 41, 144));
            colorTable.put("grey74", new StiColor(189, 189, 189));
            colorTable.put("maroon2", new StiColor(238, 48, 167));
            colorTable.put("grey77", new StiColor(196, 196, 196));
            colorTable.put("maroon1", new StiColor(255, 52, 179));
            colorTable.put("grey76", new StiColor(194, 194, 194));
            colorTable.put("gray0", new StiColor(0, 0, 0));
            colorTable.put("gray1", new StiColor(3, 3, 3));
            colorTable.put("gray2", new StiColor(5, 5, 5));
            colorTable.put("rosybrown2", new StiColor(238, 180, 180));
            colorTable.put("gray3", new StiColor(8, 8, 8));
            colorTable.put("rosybrown1", new StiColor(255, 193, 193));
            colorTable.put("gray4", new StiColor(10, 10, 10));
            colorTable.put("gray5", new StiColor(13, 13, 13));
            colorTable.put("gray6", new StiColor(15, 15, 15));
            colorTable.put("lavenderblush", new StiColor(255, 240, 245));
            colorTable.put("gray7", new StiColor(18, 18, 18));
            colorTable.put("gray8", new StiColor(20, 20, 20));
            colorTable.put("gray9", new StiColor(23, 23, 23));
            colorTable.put("slategray", new StiColor(112, 128, 144));
            colorTable.put("grey68", new StiColor(173, 173, 173));
            colorTable.put("grey67", new StiColor(171, 171, 171));
            colorTable.put("grey69", new StiColor(176, 176, 176));
            colorTable.put("lightskyblue4", new StiColor(96, 123, 139));
            colorTable.put("lightskyblue3", new StiColor(141, 182, 205));
            colorTable.put("lightskyblue1", new StiColor(176, 226, 255));
            colorTable.put("grey60", new StiColor(153, 153, 153));
            colorTable.put("mediumturquoise", new StiColor(72, 209, 204));
            colorTable.put("grey62", new StiColor(158, 158, 158));
            colorTable.put("grey61", new StiColor(156, 156, 156));
            colorTable.put("grey64", new StiColor(163, 163, 163));
            colorTable.put("grey63", new StiColor(161, 161, 161));
            colorTable.put("grey66", new StiColor(168, 168, 168));
            colorTable.put("grey65", new StiColor(166, 166, 166));
            colorTable.put("orangered3", new StiColor(205, 55, 0));
            colorTable.put("orangered4", new StiColor(139, 37, 0));
            colorTable.put("orchid1", new StiColor(255, 131, 250));
            colorTable.put("rosybrown4", new StiColor(139, 105, 105));
            colorTable.put("orchid2", new StiColor(238, 122, 233));
            colorTable.put("rosybrown3", new StiColor(205, 155, 155));
            colorTable.put("orchid3", new StiColor(205, 105, 201));
            colorTable.put("azure3", new StiColor(193, 205, 205));
            colorTable.put("orchid4", new StiColor(139, 71, 137));
            colorTable.put("darkslategrey", new StiColor(47, 79, 79));
            colorTable.put("azure4", new StiColor(131, 139, 139));
            colorTable.put("mediumslateblue", new StiColor(123, 104, 238));
            colorTable.put("orangered1", new StiColor(255, 69, 0));
            colorTable.put("azure1", new StiColor(240, 255, 255));
            colorTable.put("orangered2", new StiColor(238, 64, 0));
            colorTable.put("azure2", new StiColor(224, 238, 238));
            colorTable.put("grey57", new StiColor(145, 145, 145));
            colorTable.put("grey56", new StiColor(143, 143, 143));
            colorTable.put("grey59", new StiColor(150, 150, 150));
            colorTable.put("maroon", new StiColor(176, 48, 96));
        }
        return colorTable.containsKey(colorName.toLowerCase()) ? colorTable.get(colorName.toLowerCase()) : null;
    }
}

