/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.IStiInvalidator;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.system.geometry.StiRectangle;

public abstract class StiBrush
implements Cloneable,
IStiInvalidator,
IStiSerializable,
IStiSerializableToString {
    private IStiInvalidator invalidator = null;

    public Object clone() {
        if (this instanceof StiEmptyBrush) {
            return new StiEmptyBrush();
        }
        if (this instanceof StiSolidBrush) {
            return new StiSolidBrush(((StiSolidBrush)this).getColor());
        }
        if (this instanceof StiGradientBrush) {
            StiGradientBrush gradientBrush = (StiGradientBrush)this;
            StiGradientBrush result = new StiGradientBrush(gradientBrush.getStartColor().clone(), gradientBrush.getEndColor().clone(), (float)gradientBrush.getAngle());
            result.setRectangle(gradientBrush.getRectangle().clone());
            return result;
        }
        if (this instanceof StiHatchBrush) {
            StiHatchBrush hatchBrush = (StiHatchBrush)this;
            return new StiHatchBrush(hatchBrush.getStyle(), hatchBrush.getForeColor().clone(), hatchBrush.getBackColor().clone());
        }
        if (this instanceof StiGlareBrush) {
            StiGlareBrush glareBrush = (StiGlareBrush)this;
            StiGlareBrush br = new StiGlareBrush(glareBrush.getStartColor().clone(), glareBrush.getEndColor().clone(), (float)glareBrush.getAngle(), glareBrush.getFocus(), glareBrush.getScale());
            br.setRectangle(glareBrush.getRectangle().clone());
            return br;
        }
        if (this instanceof StiGlassBrush) {
            StiGlassBrush glassBrush = new StiGlassBrush();
            glassBrush.deserialize(((StiGlassBrush)this).serialize());
            return glassBrush;
        }
        return null;
    }

    public final IStiInvalidator getInvalidator() {
        return this.invalidator;
    }

    public final void setInvalidator(IStiInvalidator value) {
        this.invalidator = value;
    }

    @Override
    public final void invalidate() {
        if (this.getInvalidator() != null) {
            this.getInvalidator().invalidate();
        }
    }

    public static StiBrush getBrush(StiBrush brush, StiRectangle rect1) {
        StiRectangle rect = rect1.clone();
        if (brush instanceof StiEmptyBrush) {
            return new StiSolidBrush(StiColorEnum.Transparent.color());
        }
        if (brush instanceof StiSolidBrush) {
            return new StiSolidBrush(((StiSolidBrush)brush).getColor());
        }
        if (brush instanceof StiGradientBrush) {
            StiRectangle rectF = rect;
            if (rectF.width < 1.0) {
                rectF.width = 1.0;
            }
            if (rectF.height < 1.0) {
                rectF.height = 1.0;
            }
            StiGradientBrush gradientBrush = (StiGradientBrush)brush;
            return new StiGradientBrush(gradientBrush.getStartColor(), gradientBrush.getEndColor(), (float)gradientBrush.getAngle());
        }
        if (brush instanceof StiHatchBrush) {
            StiHatchBrush hatchBrush = (StiHatchBrush)brush;
            return new StiHatchBrush(hatchBrush.getStyle(), hatchBrush.getForeColor(), hatchBrush.getBackColor());
        }
        if (brush instanceof StiGlareBrush) {
            StiRectangle rectF = rect;
            if (rectF.width < 1.0) {
                rectF.width = 1.0;
            }
            if (rectF.height < 1.0) {
                rectF.height = 1.0;
            }
            StiGlareBrush glareBrush = (StiGlareBrush)brush;
            StiGradientBrush br = new StiGradientBrush(glareBrush.getStartColor(), glareBrush.getEndColor(), (float)glareBrush.getAngle());
            return br;
        }
        if (brush instanceof StiGlassBrush) {
            return (StiBrush)brush.clone();
        }
        return null;
    }

    public static StiColor ToColor(StiBrush brush) {
        if (brush instanceof StiEmptyBrush) {
            return StiColor.Transparent;
        }
        if (brush instanceof StiSolidBrush) {
            return ((StiSolidBrush)brush).getColor();
        }
        if (brush instanceof StiGradientBrush) {
            return ((StiGradientBrush)brush).getStartColor();
        }
        if (brush instanceof StiGlareBrush) {
            return ((StiGlareBrush)brush).getStartColor();
        }
        if (brush instanceof StiGlassBrush) {
            return ((StiGlassBrush)brush).getColor();
        }
        if (brush instanceof StiHatchBrush) {
            return ((StiHatchBrush)brush).getForeColor();
        }
        return StiColor.Empty;
    }

    public void setReference(int reference) {
        throw new RuntimeException("method setReference() can not be used");
    }

    public int getReference() {
        throw new RuntimeException("method getReference() can not be used");
    }

    public void dispose() {
    }

    public static StiBrush LoadFromJson(JSONObject jObject) throws JSONException {
        JProperty ident = jObject.Properties().FirstOrDefault("Ident");
        String value = ident.Value.toString();
        if (value.equals("StiEmptyBrush")) {
            return new StiEmptyBrush();
        }
        if (value.equals("StiSolidBrush")) {
            StiSolidBrush solid = new StiSolidBrush();
            solid.LoadValuesFromJson(jObject);
            return solid;
        }
        if (value.equals("StiGradientBrush")) {
            StiGradientBrush gradient = new StiGradientBrush();
            gradient.LoadValuesFromJson(jObject);
            return gradient;
        }
        if (value.equals("StiGlareBrush")) {
            StiGlareBrush glare = new StiGlareBrush();
            glare.LoadValuesFromJson(jObject);
            return glare;
        }
        if (value.equals("StiGlassBrush")) {
            StiGlassBrush glass = new StiGlassBrush();
            glass.LoadValuesFromJson(jObject);
            return glass;
        }
        if (value.equals("StiHatchBrush")) {
            StiHatchBrush hatch = new StiHatchBrush();
            hatch.LoadValuesFromJson(jObject);
            return hatch;
        }
        throw new RuntimeException("Type is not supported!");
    }
}

