/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiGlyph;
import com.stimulsoft.base.drawing.StiLineInfo;
import com.stimulsoft.base.drawing.StiTextRendererParseHtml;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class StiBreakText {
    public static final StiBreakText EMPTY = new StiBreakText();
    private String placedString;
    private String notPlacedString;

    private StiBreakText() {
        this.placedString = "";
        this.notPlacedString = "";
    }

    public StiBreakText(String placedString, String notPlacedString) {
        this.placedString = placedString;
        this.notPlacedString = notPlacedString;
    }

    public StiBreakText(StringBuilder placedString, StringBuilder notPlacedString) {
        this.placedString = placedString.toString();
        this.notPlacedString = notPlacedString.toString();
    }

    public StiBreakText(List<StiGlyph> glyphs, int maxHeight, double width, Graphics2D g, String text) {
        ArrayList<StiGlyph> placedGlyphs = new ArrayList<StiGlyph>();
        ArrayList<StiGlyph> notPlacedGlyphs = new ArrayList<StiGlyph>();
        double height = 0.0;
        int pos = 0;
        while (pos < glyphs.size()) {
            StiTextRendererParseHtml.StiRenderLine line = new StiTextRendererParseHtml.StiRenderLine();
            pos = StiTextRendererParseHtml.getNextLine(glyphs, pos, width, g, line);
            double lastLineHeight = line.height / line.glyphs.get((int)0).ts.lineHeight;
            if (height + lastLineHeight <= (double)maxHeight) {
                placedGlyphs.addAll(line.glyphs);
                height += line.height;
                continue;
            }
            notPlacedGlyphs.addAll(line.glyphs);
            height += lastLineHeight;
        }
        this.placedString = StiGlyph.toHTML(placedGlyphs);
        this.notPlacedString = StiGlyph.toHTML(notPlacedGlyphs);
    }

    public StiBreakText(List<StiLineInfo> lines, int maxHeight, int factor) {
        Double height;
        int placedCounLines;
        if (lines.size() == 0) {
            this.placedString = "";
            this.notPlacedString = "";
        }
        placedCounLines = (placedCounLines = (int)((double)maxHeight / (height = Double.valueOf(lines.get(0).getHeight() / (double)factor)))) > lines.size() ? lines.size() : placedCounLines;
        StringBuilder placedSB = new StringBuilder();
        for (int i = 0; i < placedCounLines; ++i) {
            placedSB.append(lines.get(i).getText());
        }
        StringBuilder notPlacedSB = new StringBuilder();
        for (int i = placedCounLines; i < lines.size(); ++i) {
            notPlacedSB.append(lines.get(i).getText());
        }
        this.placedString = placedSB.toString();
        this.notPlacedString = notPlacedSB.toString();
    }

    public String getPlacedString() {
        return this.placedString;
    }

    public String getNotPlacedString() {
        return this.notPlacedString;
    }
}

