/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.data;

import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class StiDataLoaderHelper {
    public static List<Data> loadMultiple(String path, String filter) throws IOException {
        if (StiValidationUtil.isNullOrEmpty((String)path)) {
            return null;
        }
        File pathFile = new File(path);
        ArrayList<Data> result = new ArrayList<Data>();
        if (pathFile.isDirectory() && pathFile.exists()) {
            for (File file : pathFile.listFiles()) {
                if (!file.isFile()) continue;
                result.add(new Data(StiDataLoaderHelper.getFileNameWithoutExtension(file.getName()), StiDataLoaderHelper.getFileData(file)));
            }
            return result;
        }
        Data data = StiDataLoaderHelper.loadSingle(path);
        return data != null ? data.toList() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Data loadSingle(String path) throws IOException {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            return new Data(StiDataLoaderHelper.getFileNameWithoutExtension(file.getName()), StiDataLoaderHelper.getFileData(file));
        }
        URL url = new URL(path);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream is = url.openStream();){
            StiIOUtil.copy((InputStream)is, (OutputStream)baos);
        }
        return new Data(StiDataLoaderHelper.getFileNameWithoutExtension(url.getFile()), baos.toByteArray());
    }

    private static byte[] getFileData(File file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FileInputStream fis = new FileInputStream(file);){
            StiIOUtil.copy((InputStream)fis, (OutputStream)baos);
        }
        return baos.toByteArray();
    }

    private static String getFileNameWithoutExtension(String fileName) {
        return fileName.substring(0, fileName.indexOf(".") >= 0 ? fileName.lastIndexOf(".") : fileName.length());
    }

    public static class Data {
        public String name;
        public byte[] array;

        public List<Data> toList() {
            ArrayList<Data> result = new ArrayList<Data>();
            result.add(this);
            return result;
        }

        public Data(String name, byte[] array) {
            this.name = name;
            this.array = array;
        }
    }
}

