/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base;

import com.stimulsoft.base.drawing.StiBytesFromURL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.concurrent.ConcurrentHashMap;

public class StiDownloadCache {
    private static ConcurrentHashMap<String, FileInfo> cache = new ConcurrentHashMap();
    public static boolean enabled = true;
    public static int ticksToExpired = 120000;
    public static int ticksToFailedAttempt = 2000;
    public static int ticksDelayInProcess = 50;

    public static void clear() {
        cache.clear();
    }

    public static byte[] get(String url) throws IOException {
        if (!enabled) {
            return StiBytesFromURL.load(url);
        }
        boolean needLoad = false;
        boolean inProcess = false;
        if (cache.containsKey(url)) {
            FileInfo res = cache.get(url);
            if (!res.finished) {
                inProcess = true;
            } else {
                res.ticks = Calendar.getInstance().getTimeInMillis();
            }
        } else {
            needLoad = true;
            cache.put(url, new FileInfo(url, null, 0L, false));
        }
        if (inProcess) {
            int counter;
            for (counter = 20000 / ticksDelayInProcess; cache.containsKey(url) && !StiDownloadCache.cache.get((Object)url).finished && counter > 0; --counter) {
                try {
                    Thread.sleep(ticksDelayInProcess);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (counter == 0) {
                needLoad = true;
            }
        }
        if (needLoad) {
            byte[] data = null;
            try {
                data = StiBytesFromURL.load(url);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (data == null || data.length == 0) {
                FileInfo fileInfo2 = new FileInfo(url, null, Calendar.getInstance().getTimeInMillis() - (long)ticksToExpired + (long)ticksToFailedAttempt, true);
                cache.put(url, fileInfo2);
            } else {
                FileInfo fileInfo = new FileInfo(url, data, Calendar.getInstance().getTimeInMillis(), true);
                cache.put(url, fileInfo);
            }
        }
        FileInfo info = cache.get(url);
        info.ticks = Calendar.getInstance().getTimeInMillis();
        return info.data;
    }

    public static void checkExpiredUrls() {
        long currentTicks = Calendar.getInstance().getTimeInMillis();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (FileInfo info : cache.values()) {
            if (currentTicks - info.ticks <= (long)ticksToExpired) continue;
            keysToRemove.add(info.url);
        }
        for (String st : keysToRemove) {
            cache.remove(st);
        }
    }

    static {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(120000L);
                    StiDownloadCache.checkExpiredUrls();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    private static class FileInfo {
        public String url;
        public byte[] data;
        public long ticks;
        public boolean finished;

        public FileInfo(String url, byte[] data, long ticks, boolean finished) {
            this.url = url;
            this.data = data;
            this.ticks = ticks;
            this.finished = finished;
        }
    }
}

