/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.demo.panels;

import com.stimulsoft.base.drawing.StiGraphicsHelper;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.demo.Demo;
import com.stimulsoft.demo.button.StiDemoButton;
import com.stimulsoft.viewer.utils.StiURLHelper;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StiWelcomePanel
extends JPanel {
    private static final long serialVersionUID = -2022941276453688552L;
    private static final int PAGE_WIDTH = 900;
    private static final int PAGE_HEIGHT = 550;
    private Demo parentComponent;
    private Dimension welcomeSize = new Dimension(900, 550);
    private JTextPane htmlPane;

    public StiWelcomePanel(Demo parentComponent) {
        this.parentComponent = parentComponent;
        this.setLayout(new BoxLayout(this, 1));
        this.setMaximumSize(this.welcomeSize);
        this.setPreferredSize(this.welcomeSize);
        this.setMinimumSize(this.welcomeSize);
        this.setBackground(Color.WHITE);
        this.htmlPane = new JTextPane();
        this.htmlPane.setContentType("text/html");
        this.htmlPane.setEditable(false);
        this.htmlPane.setOpaque(false);
        this.htmlPane.setMargin(new Insets(0, 0, 0, 0));
        this.buildComponent();
        this.bindEvents();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(900, 700);
    }

    private void buildComponent() {
        JPanel welcomePanel = new JPanel(new FlowLayout(1));
        welcomePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        welcomePanel.setBackground(Color.white);
        JLabel welcomeLabel = new JLabel(StiLocalization.getValue((String)"Localization", (String)"Welcome")){
            private static final long serialVersionUID = -552486635281237529L;

            @Override
            public void paintComponent(Graphics g) {
                StiGraphicsHelper.setRenderingHints((Graphics2D)((Graphics2D)g));
                super.paintComponent(g);
            }
        };
        welcomeLabel.setForeground(new Color(99, 99, 99));
        welcomeLabel.setFont(new Font("Arial", 0, 60));
        welcomePanel.add(welcomeLabel);
        this.add(welcomePanel);
        this.htmlPane.setFont(new Font("Arial", 0, 17));
        this.htmlPane.setText("<html><table><tr><td align='justify' style=\"font-family: 'Arial'; font-size: 17\">" + StiLocalization.getValue((String)"Localization", (String)"WelcomeDesc") + "</html>");
        this.htmlPane.setBounds(2, 0, 900, 100);
        JPanel welcomeDescPanel = new JPanel(){
            private static final long serialVersionUID = 8545051796467744809L;

            @Override
            public void paintComponent(Graphics g) {
                StiWelcomePanel.this.htmlPane.paint(g);
            }
        };
        welcomeDescPanel.setPreferredSize(new Dimension(900, 300));
        this.add(welcomeDescPanel);
        JPanel butPanel = new JPanel();
        butPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        butPanel.setLayout(new GridLayout(3, 2, 10, 25));
        butPanel.setBackground(Color.WHITE);
        StiDemoButton demoButton = new StiDemoButton(StiLocalization.getValue((String)"Localization", (String)"DescDemo"), StiResourceUtil.loadIcon((String)"/buttonDemo.png"));
        butPanel.add(demoButton);
        StiDemoButton supportButton = new StiDemoButton(StiLocalization.getValue((String)"Localization", (String)"DescSupport"), StiResourceUtil.loadIcon((String)"/buttonSupport.png"), 1);
        butPanel.add(supportButton);
        StiDemoButton videoButton = new StiDemoButton(StiLocalization.getValue((String)"Localization", (String)"DescVideo"), StiResourceUtil.loadIcon((String)"/buttonVideo.png"), 1);
        butPanel.add(videoButton);
        StiDemoButton documentationButton = new StiDemoButton(StiLocalization.getValue((String)"Localization", (String)"DescDocumentation"), StiResourceUtil.loadIcon((String)"/buttonDocumentation.png"));
        butPanel.add(documentationButton);
        StiDemoButton forumButton = new StiDemoButton(StiLocalization.getValue((String)"Localization", (String)"DescForum"), StiResourceUtil.loadIcon((String)"/buttonForum.png"));
        butPanel.add(forumButton);
        StiDemoButton sampleProjectButton = new StiDemoButton(StiLocalization.getValue((String)"Localization", (String)"DescSampleProject"), StiResourceUtil.loadIcon((String)"/buttonSampleProject.png"), 1);
        butPanel.add(sampleProjectButton);
        this.add(butPanel);
        JPanel againgPanel = new JPanel(new FlowLayout(2));
        againgPanel.setBackground(Color.white);
        JCheckBox againCheckBox = new JCheckBox(StiLocalization.getValue((String)"Localization", (String)"DisplayWelcomeScreenAgain"));
        againCheckBox.setOpaque(false);
        againCheckBox.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        againCheckBox.setFocusable(false);
        againCheckBox.setForeground(new Color(39, 38, 37));
        againCheckBox.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 5));
        againCheckBox.setSelected(StiSettings.getBoolValue((String)"Demo", (String)"DisplayWelcomeScreenAgain", (Boolean)false));
        againgPanel.add(againCheckBox);
        this.add(againgPanel);
        demoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StiWelcomePanel.this.parentComponent.showDemo();
            }
        });
        supportButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StiURLHelper.openURL((String)"http://www.stimulsoft.com/support.aspx");
            }
        });
        videoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StiURLHelper.openURL((String)"http://www.stimulsoft.com/Videos.aspx");
            }
        });
        documentationButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StiURLHelper.openURL((String)"http://www.stimulsoft.com/Documentation.aspx");
            }
        });
        forumButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StiURLHelper.openURL((String)"http://forum.stimulsoft.com/");
            }
        });
        againCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StiSettings.setBoolValue((String)"Demo", (String)"DisplayWelcomeScreenAgain", (Boolean)((JCheckBox)e.getSource()).isSelected());
            }
        });
        sampleProjectButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StiWelcomePanel.this.parentComponent.showSamples();
            }
        });
    }

    private void bindEvents() {
        this.parentComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                StiWelcomePanel.this.resized();
            }
        });
    }

    public void resized() {
        if (this.getParent() != null) {
            this.setBounds(this.getParent().getWidth() / 2 - 450, this.getParent().getHeight() / 2 - 275 - 20, 900, 550);
        }
    }

    public Dimension getWelcomeSize() {
        return this.welcomeSize;
    }
}

