/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.demo;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.exception.StiExceptionProvider;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiConfig;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.demo.button.StiHelpResourcesButton;
import com.stimulsoft.demo.panels.StiReportsPanel;
import com.stimulsoft.demo.panels.StiTreeReportsPanel;
import com.stimulsoft.demo.panels.StiWelcomePanel;
import com.stimulsoft.samples.panels.StiSamplesPanel;
import com.stimulsoft.samples.welcome.StiWelcomable;
import com.stimulsoft.viewer.FullScreenSupportable;
import com.stimulsoft.viewer.StiViewerFx;
import com.stimulsoft.viewer.controls.visual.StiFlatButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Demo
extends JFrame
implements FullScreenSupportable,
StiWelcomable {
    private static final long serialVersionUID = -6275615603455805262L;
    public static final String LOCALIZATION_CATEGORY = "Localization";
    public static final String LOCALIZATION_FILE_NAME = "/Reports_en.xml";
    public static final String DISPLAY_WELCOME_SCREEN_AGAIN_KEY = "DisplayWelcomeScreenAgain";
    public static final String REPORTS_DIR = "Reports/";
    public static final String SUPPORT_URL = "http://www.stimulsoft.com/support.aspx";
    public static final String VIDEO_URL = "http://www.stimulsoft.com/Videos.aspx";
    public static final String DOCUMENTATION_URL = "http://www.stimulsoft.com/Documentation.aspx";
    public static final String FORUM_URL = "http://forum.stimulsoft.com/";
    public static final String KNOWLEDGEBASE_URL = "http://stimulsoft.helpserve.com/index.php?_m=knowledgebase&_a=view";
    private StiViewerFx stiViewerPanel;
    private StiWelcomePanel welcomePanel;
    private JPanel mainPanel;
    private StiReportsPanel reportsPanel;
    private StiHelpResourcesButton helpResourcesButton;
    private StiFlatButton helpButton;
    private StiSamplesPanel samplesPanel;

    public Demo(String[] args) {
        Locale.setDefault(Locale.US);
        this.initView();
        for (String arg : args) {
            if (!arg.startsWith("-load")) continue;
            this.stiViewerPanel.getStiViewModel().loadDocumentFile(new File(arg.substring(5)), true);
        }
    }

    private void initView() {
        this.setIconImage(StiResourceUtil.loadIcon((String)"/ico/icon.png").getImage());
        try {
            Demo.config();
        }
        catch (Exception e) {
            System.err.println("Unable to load /Reports_en.xml");
            e.printStackTrace();
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        this.setSize(new Dimension(1100, 650));
        this.setExtendedState(this.getExtendedState() | 6);
        this.mainPanel = new JPanel();
        this.stiViewerPanel = new StiViewerFx((JFrame)this);
        this.reportsPanel = new StiReportsPanel(this);
        this.welcomePanel = new StiWelcomePanel(this);
        this.samplesPanel = new StiSamplesPanel((JFrame)this);
        this.mainPanel.setLayout(new FlowLayout(1));
        this.welcomePanel.setAlignmentY(1.0f);
        this.mainPanel.add(this.welcomePanel);
        this.mainPanel.setBackground(Color.WHITE);
        if (StiSettings.getBoolValue((String)"Demo", (String)DISPLAY_WELCOME_SCREEN_AGAIN_KEY, (Boolean)true).booleanValue()) {
            this.showWelcomeScreen();
        } else {
            this.showDemo();
        }
        this.setTitle("Demo");
        this.helpResourcesButton = new StiHelpResourcesButton();
        this.stiViewerPanel.getStiMainToolBar().add((Component)this.helpResourcesButton);
        this.helpButton = new StiFlatButton(null, (Icon)StiResourceUtil.loadIcon((String)"/Help.png"), StiLocalization.getValue((String)LOCALIZATION_CATEGORY, (String)"JumpToWelcomeScreen"), null);
        this.stiViewerPanel.getStiMainToolBar().add((Component)this.helpButton);
        this.helpResourcesButton.setFocusable(false);
        this.helpButton.setFocusable(false);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.bindEvents();
    }

    private static void config() throws IOException, StiException {
        StiConfig config;
        File propertiesDir = new File("Settings/stimulsoft.properties");
        if (propertiesDir.exists()) {
            Properties properties = new Properties();
            FileInputStream fis = new FileInputStream(propertiesDir);
            properties.load(fis);
            fis.close();
            config = new StiConfig(properties);
        } else {
            config = new StiConfig();
        }
        Demo.setLocalization();
        StiConfig.init((StiConfig)config);
        InputStream stream = StiResourceUtil.getStream((String)LOCALIZATION_FILE_NAME);
        StiLocalization.getLocalization().addLanguageCategory(stream);
        stream.close();
    }

    private static void setLocalization() throws IOException, StiException {
        String cultureNameInConfig = StiLocalization.getLocalizationCultureName();
        File localizationDir = new File(LOCALIZATION_CATEGORY, cultureNameInConfig + ".xml");
        if (localizationDir.exists()) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(localizationDir));
            StiLocalization localization = StiLocalization.load((InputStream)is);
            StiLocalization.setLocalization((StiLocalization)localization);
            ((InputStream)is).close();
        }
    }

    public void switchFullScreen(Boolean isFullScreen) {
        this.reportsPanel.setVisible(isFullScreen == false);
        this.samplesPanel.switchFullScreen(isFullScreen);
    }

    private void bindEvents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StiSettings.flush();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.showWelcomeScreen();
            }
        });
        final int initialWidth = (int)this.getSize().getWidth();
        final int initialHeight = (int)this.getSize().getHeight();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Demo.this.setSize(Math.max(initialWidth, Demo.this.getWidth()), Math.max(initialHeight, Demo.this.getHeight()));
            }
        });
    }

    public void reportSelected(StiTreeReportsPanel.Report report) {
        this.helpResourcesButton.reportSelected(report);
    }

    public void updateStatus(String status) {
        this.reportsPanel.updateStatus(status);
    }

    public void showWelcomeScreen() {
        this.remove(this.reportsPanel);
        this.remove((Component)this.stiViewerPanel);
        this.remove((Component)this.samplesPanel);
        this.add(this.mainPanel);
        SwingUtilities.updateComponentTreeUI(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Demo.this.welcomePanel.resized();
            }
        });
    }

    public void showDemo() {
        this.remove(this.mainPanel);
        this.remove((Component)this.samplesPanel);
        this.setLayout(new BoxLayout(this.getContentPane(), 0));
        this.add(this.reportsPanel);
        this.add((Component)this.stiViewerPanel);
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void showSamples() {
        this.remove(this.mainPanel);
        this.remove(this.reportsPanel);
        this.remove((Component)this.stiViewerPanel);
        this.add((Component)this.samplesPanel);
        SwingUtilities.updateComponentTreeUI(this);
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Demo ex = new Demo(args);
                    ex.setVisible(true);
                }
                catch (Throwable e) {
                    StiExceptionProvider.show((Throwable)e, null);
                }
            }
        });
    }

    public StiViewerFx getStiViewerPanel() {
        return this.stiViewerPanel;
    }
}

