/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.context.gauge.geoms;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.painters.context.gauge.StiGaugeGeomType;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathArcGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathCloseFigureGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathLineGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathLinesGaugeGeom;
import java.util.ArrayList;
import java.util.List;

public class StiGraphicsPathGaugeGeom
extends StiGaugeGeom {
    public StiRectangle Rect;
    public StiBrush Background;
    public StiBrush BorderBrush;
    public double BorderWidth;
    public StiPoint StartPoint;
    private List<StiGaugeGeom> geoms = new ArrayList<StiGaugeGeom>();

    @Override
    public StiGaugeGeomType getType() {
        return StiGaugeGeomType.GraphicsPath;
    }

    public List<StiGaugeGeom> getGeoms() {
        return this.geoms;
    }

    public void addGraphicsPathArcGaugeGeom(double x, double y, double width, double height, double startAngle, double sweepAngle) {
        if (width > 0.0 && height > 0.0) {
            this.geoms.add(new StiGraphicsPathArcGaugeGeom(x, y, width, height, startAngle, sweepAngle));
        }
    }

    public void addGraphicsPathCloseFigureGaugeGeom() {
        this.geoms.add(new StiGraphicsPathCloseFigureGaugeGeom());
    }

    public void addGraphicsPathLinesGaugeGeom(StiPoint[] points) {
        this.geoms.add(new StiGraphicsPathLinesGaugeGeom(points));
    }

    public void addGraphicsPathLineGaugeGeom(StiPoint p1, StiPoint p2) {
        this.geoms.add(new StiGraphicsPathLineGaugeGeom(p1, p2));
    }

    public StiGraphicsPathGaugeGeom(StiRectangle rect, StiPoint startPoint, StiBrush background, StiBrush borderBrush, double borderWidth) {
        this.Rect = rect;
        this.StartPoint = startPoint;
        this.Background = background;
        this.BorderBrush = borderBrush;
        this.BorderWidth = borderWidth;
        this.StartPoint = startPoint;
    }
}

