/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiGraphicsHelper;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiImageRotation;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiView;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiViewPainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class StiImagePainter
extends StiViewPainter {
    protected BufferedImage getImageBitmap(StiView view, StiRectangle rect) {
        StiImage image = (StiImage)view;
        if (image.getImageBytesToDraw() != null && !image.getImageRotation().equals((Object)StiImageRotation.None)) {
            return image.rotateImage(image.getBufferedImage(rect));
        }
        return image.getBufferedImage(rect);
    }

    @Override
    public BufferedImage getImage(StiComponent component, Double pageZoom, StiExportFormat format) {
        Graphics2D graphics;
        BufferedImage image;
        Double oldZoom = component.getPage().getZoom();
        component.getReport().getInfo().setZoom(pageZoom);
        component.getReport().getInfo().setPageZoom(pageZoom);
        component.getReport().getInfo().setExporting(true);
        StiRectangle rect = component.getPaintRectangle();
        int iWidth = rect.getWi();
        int iHeight = rect.getHi();
        iHeight = iHeight <= 0 ? 1 : iHeight;
        int n = iWidth = iWidth <= 0 ? 1 : iWidth;
        if (format == StiExportFormat.Pdf || format == StiExportFormat.ImagePng || (format == StiExportFormat.Html || format == StiExportFormat.HtmlTable || format == StiExportFormat.HtmlSpan || format == StiExportFormat.HtmlDiv) && this instanceof StiImagePainter || (format == StiExportFormat.Html || format == StiExportFormat.HtmlTable || format == StiExportFormat.Pdf || format == StiExportFormat.HtmlSpan || format == StiExportFormat.HtmlDiv) && component instanceof StiBarCode) {
            image = new BufferedImage(iWidth, iHeight, 2);
            graphics = image.createGraphics();
        } else {
            image = new BufferedImage(iWidth, iHeight, 1);
            graphics = image.createGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, iWidth, iHeight);
        }
        StiGraphicsHelper.setRenderingHints((Graphics2D)graphics);
        StiPaintArgs args = new StiPaintArgs(new StiGraphics((Graphics)graphics));
        args.setPaintRect(new StiRectangle(0L, 0L, (long)iWidth, (long)iHeight));
        this.paint(component, args);
        component.getReport().getInfo().setZoom(oldZoom);
        component.getReport().getInfo().setExporting(false);
        return image;
    }

    @Override
    public void paint(StiComponent component, StiPaintArgs args) {
        try {
            super.paint(component, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

