/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.path.StiPathCommand;
import com.stimulsoft.base.drawing.path.StiPathLineTo;
import com.stimulsoft.base.drawing.path.StiPathMoveTo;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiCheckStyle;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiComponentPainter;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class StiCheckBoxPainter
extends StiComponentPainter {
    private static void drawRectangle(StiGraphics g, StiRectangle rect, StiPen pen, StiBrush brush, Double zoom, Double pageZoom) {
        ArrayList<Object> path = new ArrayList<Object>();
        Double delta = rect.getWidth() * 0.1;
        path.add(new StiPathMoveTo(Double.valueOf(rect.getLeft()), Double.valueOf(rect.getTop())));
        path.add(new StiPathLineTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getTop())));
        path.add(new StiPathLineTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom())));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft()), Double.valueOf(rect.getBottom())));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft()), Double.valueOf(rect.getTop())));
        path.add(new StiPathMoveTo(Double.valueOf(rect.getLeft() + delta), Double.valueOf(rect.getTop() + delta)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getRight() - delta), Double.valueOf(rect.getTop() + delta)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getRight() - delta), Double.valueOf(rect.getBottom() - delta)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft() + delta), Double.valueOf(rect.getBottom() - delta)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft() + delta), Double.valueOf(rect.getTop() + delta)));
        g.drawPath(path, pen, brush, zoom.doubleValue(), pageZoom.doubleValue());
    }

    private static void drawCircle(StiGraphics g, StiRectangle rect, StiPen pen, StiBrush brush, Double zoom, Double pageZoom) {
        Double delta = rect.getWidth() * 0.1;
        StiRectangle innerRect = new StiRectangle(rect.getX() + delta, rect.getY() + delta, rect.getWidth() - delta * 2.0, rect.getHeight() - delta * 2.0);
        ArrayList path = new ArrayList();
        StiPathCommand.createCircle((StiRectangle)innerRect, path);
        StiPathCommand.createCircle((StiRectangle)rect, path);
        g.drawPath(path, pen, brush, zoom.doubleValue(), pageZoom.doubleValue());
    }

    private static void drawRect(StiGraphics g, StiRectangle rect, StiPen pen, StiBrush brush, Double zoom, Double pageZoom) {
        Double delta = rect.getWidth() * 0.3;
        StiRectangle innerRect = new StiRectangle(rect.getX() + delta, rect.getY() + delta, rect.getWidth() - delta * 2.0, rect.getHeight() - delta * 2.0);
        g.drawRectangle(innerRect, pen, brush, zoom, pageZoom);
    }

    private static void drawDot(StiGraphics g, StiRectangle rect, StiPen pen, StiBrush brush, Double zoom, Double pageZoom) {
        Double delta = rect.getWidth() * 0.3;
        StiRectangle innerRect = new StiRectangle(rect.getX() + delta, rect.getY() + delta, rect.getWidth() - delta * 2.0, rect.getHeight() - delta * 2.0);
        g.drawEllise(innerRect, pen, brush, zoom, pageZoom);
    }

    private static void drawCross(StiGraphics g, StiRectangle rect, StiPen pen, StiBrush brush, Double zoom, Double pageZoom) {
        ArrayList<Object> path = new ArrayList<Object>();
        Double delta = rect.getWidth() * 0.22;
        Double size = rect.getWidth() * 0.33;
        Double center = rect.getWidth() * 0.5;
        Double center2 = rect.getWidth() * 0.5 - delta * 0.5;
        path.add(new StiPathMoveTo(Double.valueOf(rect.getLeft() + delta), Double.valueOf(rect.getTop() + size)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft() + size), Double.valueOf(rect.getTop() + delta)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft() + center), Double.valueOf(rect.getTop() + center2)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getRight() - size), Double.valueOf(rect.getTop() + delta)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getRight() - delta), Double.valueOf(rect.getTop() + size)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getRight() - center2), Double.valueOf(rect.getTop() + center)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getRight() - delta), Double.valueOf(rect.getBottom() - size)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getRight() - size), Double.valueOf(rect.getBottom() - delta)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getRight() - center), Double.valueOf(rect.getBottom() - center2)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft() + size), Double.valueOf(rect.getBottom() - delta)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft() + delta), Double.valueOf(rect.getBottom() - size)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft() + center2), Double.valueOf(rect.getBottom() - center)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft() + delta), Double.valueOf(rect.getTop() + size)));
        g.drawPath(path, pen, brush, zoom.doubleValue(), pageZoom.doubleValue());
    }

    private static void drawCheck(StiGraphics g, StiRectangle rect, StiPen pen, StiBrush brush, Boolean offset, Double zoom, Double pageZoom) {
        ArrayList<Object> path = new ArrayList<Object>();
        Double delta = rect.getWidth() * 0.2;
        Double size = delta * 0.25;
        Double center = rect.getWidth() * 0.5;
        if (offset.booleanValue()) {
            rect = new StiRectangle(rect.getX() - delta * 0.5, rect.getY() + delta * 0.5, rect.getWidth(), rect.getHeight());
        }
        path.add(new StiPathMoveTo(Double.valueOf(rect.getLeft() + delta), Double.valueOf(rect.getTop() + center)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft() + center - size), Double.valueOf(rect.getBottom() - delta)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getRight() + size), Double.valueOf(rect.getTop())));
        path.add(new StiPathLineTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getTop() - size)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft() + center - size), Double.valueOf(rect.getBottom() - delta * 2.0)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft() + delta + size * 2.0), Double.valueOf(rect.getTop() + center - size * 2.0)));
        path.add(new StiPathLineTo(Double.valueOf(rect.getLeft() + delta), Double.valueOf(rect.getTop() + center)));
        g.drawPath(path, pen, brush, zoom.doubleValue(), pageZoom.doubleValue());
    }

    public static void paintCheck(StiCheckBox checkBox, StiGraphics g, StiRectangle rect, Double zoom) {
        Double pageZoom = checkBox.getReport().getInfo().getPageZoom();
        Boolean isCheckedValue = true;
        Boolean isUncheckedValue = false;
        if (!checkBox.getIsDesigning()) {
            isCheckedValue = checkBox.isChecked();
            isUncheckedValue = checkBox.isUnchecked();
        }
        if (isCheckedValue.booleanValue() || isUncheckedValue.booleanValue()) {
            StiCheckStyle checkStyle = isCheckedValue != false ? checkBox.getCheckStyleForTrue() : checkBox.getCheckStyleForFalse();
            StiPen pen = new StiPen(checkBox.getSize(), checkBox.getContourColor());
            StiRectangle bounds = rect.clone();
            bounds.setWidth(bounds.getWidth() * 0.8);
            bounds.setHeight(bounds.getHeight() * 0.8);
            bounds.setX(bounds.getX() + (rect.getWidth() - bounds.getWidth()) / 2.0);
            bounds.setY(bounds.getY() + (rect.getHeight() - bounds.getHeight()) / 2.0);
            if (bounds.getWidth() > bounds.getHeight()) {
                bounds.setX(bounds.getX() + (bounds.getWidth() - bounds.getHeight()) / 2.0);
                bounds.setWidth(bounds.getHeight());
            } else {
                bounds.setY(bounds.getY() + (bounds.getHeight() - bounds.getWidth()) / 2.0);
                bounds.setHeight(bounds.getWidth());
            }
            if (checkStyle == StiCheckStyle.CheckRectangle || checkStyle == StiCheckStyle.CrossRectangle || checkStyle == StiCheckStyle.DotRectangle || checkStyle == StiCheckStyle.NoneRectangle) {
                StiCheckBoxPainter.drawRectangle(g, bounds, pen, checkBox.getTextBrush(), zoom, pageZoom);
            }
            if (checkStyle == StiCheckStyle.CrossCircle || checkStyle == StiCheckStyle.DotCircle || checkStyle == StiCheckStyle.NoneCircle) {
                StiCheckBoxPainter.drawCircle(g, bounds, pen, checkBox.getTextBrush(), zoom, pageZoom);
            }
            if (checkStyle == StiCheckStyle.DotRectangle) {
                StiCheckBoxPainter.drawRect(g, bounds, pen, checkBox.getTextBrush(), zoom, pageZoom);
            }
            if (checkStyle == StiCheckStyle.DotCircle) {
                StiCheckBoxPainter.drawDot(g, bounds, pen, checkBox.getTextBrush(), zoom, pageZoom);
            }
            if (checkStyle == StiCheckStyle.Cross || checkStyle == StiCheckStyle.CrossCircle || checkStyle == StiCheckStyle.CrossRectangle) {
                StiCheckBoxPainter.drawCross(g, bounds, pen, checkBox.getTextBrush(), zoom, pageZoom);
            }
            if (checkStyle == StiCheckStyle.Check) {
                StiCheckBoxPainter.drawCheck(g, bounds, pen, checkBox.getTextBrush(), true, zoom, pageZoom);
            }
            if (checkStyle == StiCheckStyle.CheckRectangle) {
                StiCheckBoxPainter.drawCheck(g, bounds, pen, checkBox.getTextBrush(), false, zoom, pageZoom);
            }
        }
    }

    public BufferedImage getImage(StiComponent component, Double zoom, int format) {
        return null;
    }

    @Override
    public void paint(StiComponent component, StiPaintArgs args) {
        StiCheckBox checkBox = (StiCheckBox)component;
        if (component.getEnabled() || component.getIsDesigning()) {
            StiGraphics g = args.getG();
            StiRectangle rect = checkBox.getPaintRectangle();
            Double zoom = checkBox.getPage().getZoom();
            Double pageZoom = checkBox.getReport().getInfo().getPageZoom();
            Boolean topMost = args.getDrawTopmostBorderSides();
            if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0 && args.intersectsWith(rect).booleanValue()) {
                if (!topMost.booleanValue()) {
                    if (checkBox.getBrush() instanceof StiSolidBrush && StiColorEnum.Transparent.color().equals(((StiSolidBrush)checkBox.getBrush()).getColor()) && checkBox.getReport().getInfo().getFillComponent() && checkBox.getIsDesigning()) {
                        StiColor color = StiColor.fromAColor((int)150, (StiColor)StiColorEnum.White.color());
                        g.drawRectangle(rect, null, (StiBrush)new StiSolidBrush(color), zoom, pageZoom);
                    } else {
                        g.drawRectangle(rect, null, checkBox.getBrush(), zoom, pageZoom);
                    }
                    StiCheckBoxPainter.paintCheck(checkBox, g, rect, zoom);
                    this.paintMarkers(checkBox, g, rect, zoom, pageZoom);
                    this.paintBorder(checkBox, g, rect, topMost, args.isThumbPaint(), zoom, pageZoom);
                    this.paintEvents(checkBox, g, rect);
                    this.paintConditions(checkBox, g, rect);
                } else {
                    this.paintBorder(checkBox, g, rect, topMost, args.isThumbPaint(), zoom, pageZoom);
                }
            }
        }
    }
}

