/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.drawing.path.StiPathCommand;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiComponentPainter;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class StiBarCodePainter
extends StiComponentPainter {
    public void baseTransform(StiGraphics g, Double x, Double y, Double angle, Double dx, Double dy, StiRectangle clip) {
        g.setTransformedClip(clip);
        g.setOffset(x.doubleValue(), y.doubleValue());
        g.setRotate(angle.doubleValue(), g.getOffsetX().doubleValue(), g.getOffsetY().doubleValue());
        g.setOffset(dx.doubleValue(), dy.doubleValue());
    }

    public void baseRollbackTransform(StiGraphics g) {
        g.clearOffset();
        g.clearOffset();
        g.clearRotate();
        g.restoreClip();
    }

    public void baseFillRectangle(StiGraphics g, StiBrush brush, Double x, Double y, Double width, Double height, Double zoom, Double pageZoom) {
        g.setIntegerCoords(Boolean.valueOf(false));
        g.drawRectangle(new StiRectangle(x.doubleValue(), y.doubleValue(), width.doubleValue(), height.doubleValue()), null, brush, zoom, pageZoom);
        g.setIntegerCoords(Boolean.valueOf(true));
    }

    public void baseFillRectangle2D(StiGraphics g, StiBrush brush, Double x, Double y, Double width, Double height, Double zoom, Double pageZoom) {
        g.setIntegerCoords(Boolean.valueOf(false));
        g.drawRectangle(new StiRectangle(x.doubleValue(), y.doubleValue(), width.doubleValue(), height.doubleValue()), null, brush, zoom, pageZoom);
        g.setIntegerCoords(Boolean.valueOf(true));
    }

    public void baseFillPolygon(StiGraphics g, StiBrush brush, StiPoint[] points, double zoom, double pageZoom) {
        ArrayList<Object> path = new ArrayList<Object>();
        if (points.length > 0) {
            path.add(StiPathCommand.moveTo((Double)points[0].x, (Double)points[0].y));
            for (StiPoint point : points) {
                path.add(StiPathCommand.lineTo((Double)point.x, (Double)point.y));
            }
        }
        g.drawPath(path, null, brush, zoom, pageZoom);
    }

    public void baseFillEllipse(StiGraphics g, StiBrush brush, double x, double y, double width, double height, double zoom, double pageZoom) {
        g.drawEllise(new StiRectangle(x, y, width, height), null, brush, Double.valueOf(zoom), Double.valueOf(pageZoom));
    }

    public void baseDrawRectangle(StiGraphics g, StiColor penColor, Double penSize, Double x, Double y, Double width, Double height, Double zoom, Double pageZoom) {
        StiPen pen = new StiPen(penSize.doubleValue(), penColor);
        g.setIntegerCoords(Boolean.valueOf(false));
        g.drawRectangle(new StiRectangle(x.doubleValue(), y.doubleValue(), width.doubleValue(), height.doubleValue()), pen, null, zoom, pageZoom);
        g.setIntegerCoords(Boolean.valueOf(true));
    }

    public void baseDrawString(StiGraphics g, String st, StiFont font, StiBrush brush, StiRectangle rect, StiTextHorAlignment horAlignment, StiVertAlignment vertAlignment, Double zoom) {
        StiRectangle textRect = rect.clone();
        textRect.setWidth(textRect.getWidth() + 1.0);
        g.drawText(st, textRect, font, brush, horAlignment, vertAlignment, Boolean.valueOf(false), 1.0f, zoom, null, null, null);
    }

    public void baseDrawString(StiGraphics g, String st, StiFont font, StiBrush brush, StiRectangle rect, Double zoom) {
        this.baseDrawString(g, st, font, brush, rect, StiTextHorAlignment.Center, StiVertAlignment.Top, zoom);
    }

    public StiSize baseMeasureString(StiGraphics g, String st, StiFont font) {
        return StiSize.getEmpty();
    }

    public BufferedImage getImage(StiComponent component, Double zoom, int format) {
        return null;
    }

    @Override
    public void paint(StiComponent component, StiPaintArgs args) {
        StiBarCode barCode = (StiBarCode)component;
        if (component.getEnabled() || component.getIsDesigning()) {
            StiGraphics g = args.getG();
            Double zoom = barCode.getReport().getInfo().getZoom();
            Double pageZoom = barCode.getReport().getInfo().getPageZoom();
            Boolean topMost = args.getDrawTopmostBorderSides();
            StiRectangle rect = component.getPaintRectangle();
            if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0 && args.intersectsWith(rect).booleanValue()) {
                if (!topMost.booleanValue()) {
                    if (barCode.page != null && (barCode.getIsDesigning() || barCode.getCodeValue() != null && !"".equals(barCode.getCodeValue()))) {
                        StiRectangle barCodeRect = rect.clone();
                        barCodeRect.setX(0.0);
                        barCodeRect.setY(0.0);
                        try {
                            barCode.getBarCodeType().draw(g, barCode, rect, zoom.floatValue());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.paintMarkers(barCode, g, rect, zoom, pageZoom);
                    this.paintBorder(barCode, g, rect, topMost, args.isThumbPaint(), zoom, pageZoom);
                    this.paintEvents(barCode, g, rect);
                    this.paintConditions(barCode, g, rect);
                } else {
                    this.paintBorder(barCode, g, rect, topMost, args.isThumbPaint(), zoom, pageZoom);
                }
            }
        }
    }
}

