/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.cell;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.system.geometry.StiRectangle;
import java.util.ArrayList;

public class StiWinLossSparklinesCellPainter {
    public static void draw(StiContext context, StiRectangle rect, double[] array, StiColor positiveColor, StiColor negativeColor) {
        if (array == null || array.length == 0) {
            return;
        }
        rect.inflate(-2, -2);
        double[] values = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            values[i] = array[i] == 0.0 ? 0.0 : (array[i] > 0.0 ? 1.0 : -1.0);
        }
        double stepWidth = rect.width / (double)values.length;
        double maxPart = rect.height / 2.0;
        double x = rect.x;
        ArrayList<StiRectangle> rects = new ArrayList<StiRectangle>();
        for (double value : values) {
            double valuePart = rect.height * Math.abs(value) / 2.0;
            StiRectangle barRect = new StiRectangle(x, rect.y + (value > 0.0 ? maxPart - valuePart : maxPart), stepWidth, valuePart);
            if (barRect.width > 4.0) {
                barRect.inflate(-1, 0);
            }
            x += stepWidth;
            rects.add(barRect);
        }
        int valueIndex = 0;
        for (StiRectangle r : rects) {
            StiColor color = values[valueIndex] > 0.0 ? positiveColor : negativeColor;
            context.FillRectangle((Object)color, (double)((float)r.x), (double)((float)r.y), (double)((float)r.width), (double)((float)r.height), null);
            ++valueIndex;
        }
    }
}

