/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiGraphicsHelper;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.indicators.StiDataBarIndicator;
import com.stimulsoft.report.components.indicators.StiIconSetIndicator;
import com.stimulsoft.report.components.indicators.StiIndicator;
import com.stimulsoft.report.components.shapeTypes.StiArrowShapeType;
import com.stimulsoft.report.components.shapeTypes.StiBentArrowShapeType;
import com.stimulsoft.report.components.shapeTypes.StiChevronShapeType;
import com.stimulsoft.report.components.shapeTypes.StiComplexArrowShapeType;
import com.stimulsoft.report.components.shapeTypes.StiDiagonalDownLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiDiagonalUpLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiDivisionShapeType;
import com.stimulsoft.report.components.shapeTypes.StiEqualShapeType;
import com.stimulsoft.report.components.shapeTypes.StiFlowchartCardShapeType;
import com.stimulsoft.report.components.shapeTypes.StiFlowchartCollateShapeType;
import com.stimulsoft.report.components.shapeTypes.StiFlowchartDecisionShapeType;
import com.stimulsoft.report.components.shapeTypes.StiFlowchartManualInputShapeType;
import com.stimulsoft.report.components.shapeTypes.StiFlowchartOffPageConnectorShapeType;
import com.stimulsoft.report.components.shapeTypes.StiFlowchartPreparationShapeType;
import com.stimulsoft.report.components.shapeTypes.StiFlowchartSortShapeType;
import com.stimulsoft.report.components.shapeTypes.StiFrameShapeType;
import com.stimulsoft.report.components.shapeTypes.StiHorizontalLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiLeftAndRightLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiMinusShapeType;
import com.stimulsoft.report.components.shapeTypes.StiMultiplyShapeType;
import com.stimulsoft.report.components.shapeTypes.StiOvalShapeType;
import com.stimulsoft.report.components.shapeTypes.StiParallelogramShapeType;
import com.stimulsoft.report.components.shapeTypes.StiPlusShapeType;
import com.stimulsoft.report.components.shapeTypes.StiRectangleShapeType;
import com.stimulsoft.report.components.shapeTypes.StiRegularPentagonShapeType;
import com.stimulsoft.report.components.shapeTypes.StiRoundedRectangleShapeType;
import com.stimulsoft.report.components.shapeTypes.StiShapeTypeService;
import com.stimulsoft.report.components.shapeTypes.StiSnipDiagonalSideCornerRectangleShapeType;
import com.stimulsoft.report.components.shapeTypes.StiSnipSameSideCornerRectangleShapeType;
import com.stimulsoft.report.components.shapeTypes.StiTopAndBottomLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiTrapezoidShapeType;
import com.stimulsoft.report.components.shapeTypes.StiTriangleShapeType;
import com.stimulsoft.report.components.shapeTypes.StiVerticalLineShapeType;
import com.stimulsoft.report.components.signature.StiPdfDigitalSignature;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiEndPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiHorizontalLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiRectanglePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiRoundedRectanglePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiShape;
import com.stimulsoft.report.components.simplecomponents.StiSparkline;
import com.stimulsoft.report.components.simplecomponents.StiStartPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.simplecomponents.StiTextInCells;
import com.stimulsoft.report.components.simplecomponents.StiVerticalLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiZipCode;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiBarCodePainter;
import com.stimulsoft.report.painters.components.StiChartPainter;
import com.stimulsoft.report.painters.components.StiCheckBoxPainter;
import com.stimulsoft.report.painters.components.StiContainerPainter;
import com.stimulsoft.report.painters.components.StiGaugePainter;
import com.stimulsoft.report.painters.components.StiHorizontalLinePrimitivePainter;
import com.stimulsoft.report.painters.components.StiImagePainter;
import com.stimulsoft.report.painters.components.StiMapPainter;
import com.stimulsoft.report.painters.components.StiPagePainter;
import com.stimulsoft.report.painters.components.StiPdfDigitalSignaturePainter;
import com.stimulsoft.report.painters.components.StiPointPrimitivePainter;
import com.stimulsoft.report.painters.components.StiRectanglePrimitivePainter;
import com.stimulsoft.report.painters.components.StiRichTextPainter;
import com.stimulsoft.report.painters.components.StiRoundedRectanglePrimitivePainter;
import com.stimulsoft.report.painters.components.StiShapePainter;
import com.stimulsoft.report.painters.components.StiSparklinePainter;
import com.stimulsoft.report.painters.components.StiTextInCellsPainter;
import com.stimulsoft.report.painters.components.StiTextPainter;
import com.stimulsoft.report.painters.components.StiVerticalLinePrimitivePainter;
import com.stimulsoft.report.painters.components.StiViewPainter;
import com.stimulsoft.report.painters.components.StiZipCodePainter;
import com.stimulsoft.report.painters.indicator.StiDataBarIndicatorTypePainter;
import com.stimulsoft.report.painters.indicator.StiIconSetIndicatorTypePainter;
import com.stimulsoft.report.painters.indicator.StiIndicatorTypePainter;
import com.stimulsoft.report.painters.shapetype.StiArrowShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiBentArrowShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiChevronShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiComplexArrowShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiDiagonalDownLineShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiDiagonalUpLineShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiDivisionShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiEqualShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiFlowchartCardShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiFlowchartCollateShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiFlowchartDecisionShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiFlowchartManualInputShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiFlowchartOffPageConnectorShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiFlowchartPreparationShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiFlowchartSortShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiFrameShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiHorizontalLineShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiLeftAndRightLineShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiMinusShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiMultiplyShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiOvalShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiParallelogramShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiPlusShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiRectangleShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiRegularPentagonShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiRoundedRectangleShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiSnipDiagonalSideCornerRectangleShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiSnipSameSideCornerRectangleShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiTopAndBottomLineShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiTrapezoidShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiTriangleShapeTypePainter;
import com.stimulsoft.report.painters.shapetype.StiVerticalLineShapeTypePainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.ConcurrentHashMap;

public class StiPainter {
    private static ConcurrentHashMap<String, StiPainter> typeToPainter = new ConcurrentHashMap();

    public BufferedImage getImage(StiComponent component, Double pageZoom, StiExportFormat format) {
        Graphics2D graphics;
        BufferedImage image;
        if (format != StiExportFormat.Pdf && !(component instanceof StiPdfDigitalSignature) && !(component instanceof StiImage) && (format != StiExportFormat.Html && format != StiExportFormat.HtmlTable && format != StiExportFormat.HtmlSpan && format != StiExportFormat.HtmlDiv || !(component instanceof StiBarCode) && !(component instanceof StiShape))) {
            pageZoom = pageZoom * 2.0;
        }
        Double zoom = 1.0 / (component instanceof StiImage ? 1.0 : StiAttribute.RENDER_QUALITY);
        Double oldZoom = component.getPage().getZoom();
        component.getReport().getInfo().setZoom(pageZoom);
        component.getReport().getInfo().setPageZoom(pageZoom);
        component.getReport().getInfo().setExporting(true);
        StiRectangle rect = component.getPaintRectangle();
        component.getReport().getInfo().setZoom(1.0 / zoom);
        int iWidth = rect.getWi();
        int iHeight = rect.getHi();
        if (this instanceof StiShapePainter) {
            StiShape shape = (StiShape)component;
            iWidth = (int)(rect.getWidth() + 0.5) + 1 + (int)(shape.getSize() * pageZoom);
            iHeight = (int)(rect.getHeight() + 0.5) + 1 + (int)(shape.getSize() * pageZoom);
        } else if (this instanceof StiCheckBoxPainter || this instanceof StiViewPainter) {
            ++iWidth;
            ++iHeight;
        } else if (this instanceof StiZipCodePainter) {
            iWidth += 2;
            iHeight += 2;
        }
        iHeight = iHeight <= 0 ? 1 : iHeight;
        int n = iWidth = iWidth <= 0 ? 1 : iWidth;
        if (format == StiExportFormat.Pdf || format == StiExportFormat.ImagePng || (format == StiExportFormat.Html || format == StiExportFormat.HtmlTable || format == StiExportFormat.HtmlSpan || format == StiExportFormat.HtmlDiv) && this instanceof StiImagePainter || (format == StiExportFormat.Html || format == StiExportFormat.HtmlTable || format == StiExportFormat.Pdf || format == StiExportFormat.HtmlSpan || format == StiExportFormat.HtmlDiv) && (component instanceof StiBarCode || component instanceof StiShape)) {
            image = new BufferedImage(iWidth, iHeight, 2);
            graphics = image.createGraphics();
        } else {
            image = new BufferedImage(iWidth, iHeight, 1);
            graphics = image.createGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, iWidth, iHeight);
        }
        StiGraphicsHelper.setRenderingHints((Graphics2D)graphics);
        graphics.scale(pageZoom * zoom, pageZoom * zoom);
        StiPaintArgs args = new StiPaintArgs(new StiGraphics((Graphics)graphics));
        this.paint(component, args);
        graphics.scale(1.0 / pageZoom / zoom, 1.0 / pageZoom / zoom);
        component.getReport().getInfo().setZoom(oldZoom);
        component.getReport().getInfo().setExporting(false);
        return image;
    }

    public static StiPainter getPainter(StiComponent stiComponent) {
        StiPainter painter = typeToPainter.get(stiComponent.getClass().getName());
        if (painter == null) {
            if (stiComponent instanceof StiTextInCells) {
                painter = new StiTextInCellsPainter();
            } else if (stiComponent instanceof StiPage) {
                painter = new StiPagePainter();
            } else if (stiComponent instanceof StiText) {
                painter = new StiTextPainter();
            } else if (stiComponent instanceof StiRichText) {
                painter = new StiRichTextPainter();
            } else if (stiComponent instanceof StiContainer) {
                painter = new StiContainerPainter();
            } else if (stiComponent instanceof StiShape) {
                painter = new StiShapePainter();
            } else if (stiComponent instanceof StiImage) {
                painter = new StiImagePainter();
            } else if (stiComponent instanceof StiBarCode) {
                painter = new StiBarCodePainter();
            } else if (stiComponent instanceof StiHorizontalLinePrimitive) {
                painter = new StiHorizontalLinePrimitivePainter();
            } else if (stiComponent instanceof StiVerticalLinePrimitive) {
                painter = new StiVerticalLinePrimitivePainter();
            } else if (stiComponent instanceof StiRoundedRectanglePrimitive) {
                painter = new StiRoundedRectanglePrimitivePainter();
            } else {
                if (stiComponent instanceof StiPointPrimitive || stiComponent instanceof StiEndPointPrimitive || stiComponent instanceof StiStartPointPrimitive) {
                    return new StiPointPrimitivePainter();
                }
                if (stiComponent instanceof StiRectanglePrimitive) {
                    painter = new StiRectanglePrimitivePainter();
                } else if (stiComponent instanceof StiCheckBox) {
                    painter = new StiCheckBoxPainter();
                } else if (stiComponent instanceof StiZipCode) {
                    painter = new StiZipCodePainter();
                } else if (stiComponent instanceof StiChart) {
                    painter = new StiChartPainter();
                } else if (stiComponent instanceof StiGauge) {
                    painter = new StiGaugePainter();
                } else if (stiComponent instanceof StiMap) {
                    painter = new StiMapPainter();
                } else if (stiComponent instanceof StiSparkline) {
                    painter = new StiSparklinePainter();
                } else if (stiComponent instanceof StiPdfDigitalSignature) {
                    painter = new StiPdfDigitalSignaturePainter();
                }
            }
            if (painter != null) {
                typeToPainter.put(stiComponent.getClass().getName(), painter);
            }
        }
        if (painter == null) {
            throw new RuntimeException("Component: " + stiComponent.getClass().toString() + " painter NOT FOUND");
        }
        return painter;
    }

    public void paint(StiComponent stiComponent, StiPaintArgs e) {
    }

    public static StiIndicatorTypePainter getIndicatorPainter(StiIndicator componentType) {
        StiIndicatorTypePainter painter = (StiIndicatorTypePainter)typeToPainter.get(componentType.getClass().getName());
        if (painter == null) {
            if (componentType instanceof StiIconSetIndicator) {
                painter = new StiIconSetIndicatorTypePainter();
            } else if (componentType instanceof StiDataBarIndicator) {
                painter = new StiDataBarIndicatorTypePainter();
            }
            if (painter != null) {
                typeToPainter.put(componentType.getClass().getName(), painter);
            }
        }
        return painter;
    }

    public static StiShapeTypePainter getShapePainter(StiShapeTypeService componentType) {
        StiShapeTypePainter painter = (StiShapeTypePainter)typeToPainter.get(((Object)((Object)componentType)).getClass().getName());
        if (painter == null) {
            if (componentType instanceof StiArrowShapeType) {
                painter = new StiArrowShapeTypePainter();
            }
            if (componentType instanceof StiArrowShapeType) {
                painter = new StiArrowShapeTypePainter();
            } else if (componentType instanceof StiBentArrowShapeType) {
                painter = new StiBentArrowShapeTypePainter();
            } else if (componentType instanceof StiChevronShapeType) {
                painter = new StiChevronShapeTypePainter();
            } else if (componentType instanceof StiComplexArrowShapeType) {
                painter = new StiComplexArrowShapeTypePainter();
            } else if (componentType instanceof StiDiagonalDownLineShapeType) {
                painter = new StiDiagonalDownLineShapeTypePainter();
            } else if (componentType instanceof StiDiagonalUpLineShapeType) {
                painter = new StiDiagonalUpLineShapeTypePainter();
            } else if (componentType instanceof StiDivisionShapeType) {
                painter = new StiDivisionShapeTypePainter();
            } else if (componentType instanceof StiEqualShapeType) {
                painter = new StiEqualShapeTypePainter();
            } else if (componentType instanceof StiFlowchartCardShapeType) {
                painter = new StiFlowchartCardShapeTypePainter();
            } else if (componentType instanceof StiFlowchartCollateShapeType) {
                painter = new StiFlowchartCollateShapeTypePainter();
            } else if (componentType instanceof StiFlowchartDecisionShapeType) {
                painter = new StiFlowchartDecisionShapeTypePainter();
            } else if (componentType instanceof StiFlowchartManualInputShapeType) {
                painter = new StiFlowchartManualInputShapeTypePainter();
            } else if (componentType instanceof StiFlowchartOffPageConnectorShapeType) {
                painter = new StiFlowchartOffPageConnectorShapeTypePainter();
            } else if (componentType instanceof StiFlowchartPreparationShapeType) {
                painter = new StiFlowchartPreparationShapeTypePainter();
            } else if (componentType instanceof StiFlowchartSortShapeType) {
                painter = new StiFlowchartSortShapeTypePainter();
            } else if (componentType instanceof StiFrameShapeType) {
                painter = new StiFrameShapeTypePainter();
            } else if (componentType instanceof StiHorizontalLineShapeType) {
                painter = new StiHorizontalLineShapeTypePainter();
            } else if (componentType instanceof StiLeftAndRightLineShapeType) {
                painter = new StiLeftAndRightLineShapeTypePainter();
            } else if (componentType instanceof StiMinusShapeType) {
                painter = new StiMinusShapeTypePainter();
            } else if (componentType instanceof StiMultiplyShapeType) {
                painter = new StiMultiplyShapeTypePainter();
            } else if (componentType instanceof StiOvalShapeType) {
                painter = new StiOvalShapeTypePainter();
            } else if (componentType instanceof StiParallelogramShapeType) {
                painter = new StiParallelogramShapeTypePainter();
            } else if (componentType instanceof StiPlusShapeType) {
                painter = new StiPlusShapeTypePainter();
            } else if (componentType instanceof StiRectangleShapeType) {
                painter = new StiRectangleShapeTypePainter();
            } else if (componentType instanceof StiRegularPentagonShapeType) {
                painter = new StiRegularPentagonShapeTypePainter();
            } else if (componentType instanceof StiRoundedRectangleShapeType) {
                painter = new StiRoundedRectangleShapeTypePainter();
            } else if (componentType instanceof StiSnipDiagonalSideCornerRectangleShapeType) {
                painter = new StiSnipDiagonalSideCornerRectangleShapeTypePainter();
            } else if (componentType instanceof StiSnipSameSideCornerRectangleShapeType) {
                painter = new StiSnipSameSideCornerRectangleShapeTypePainter();
            } else if (componentType instanceof StiTopAndBottomLineShapeType) {
                painter = new StiTopAndBottomLineShapeTypePainter();
            } else if (componentType instanceof StiTrapezoidShapeType) {
                painter = new StiTrapezoidShapeTypePainter();
            } else if (componentType instanceof StiTriangleShapeType) {
                painter = new StiTriangleShapeTypePainter();
            } else if (componentType instanceof StiVerticalLineShapeType) {
                painter = new StiVerticalLineShapeTypePainter();
            }
            if (painter != null) {
                typeToPainter.put(((Object)((Object)componentType)).getClass().getName(), painter);
            }
        }
        return painter;
    }
}

