/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.context.chart.IStiContextPainter;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiArcSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiBorderGeom;
import com.stimulsoft.base.context.chart.geoms.StiCachedShadowGeom;
import com.stimulsoft.base.context.chart.geoms.StiCloseFigureSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiCurveGeom;
import com.stimulsoft.base.context.chart.geoms.StiCurveSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiEllipseGeom;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLinesGeom;
import com.stimulsoft.base.context.chart.geoms.StiLinesSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiPieSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPopClipGeom;
import com.stimulsoft.base.context.chart.geoms.StiPopSmothingModeGeom;
import com.stimulsoft.base.context.chart.geoms.StiPopTextRenderingHintGeom;
import com.stimulsoft.base.context.chart.geoms.StiPopTransformGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushClipGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushRotateTransformGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushSmothingModeToAntiAliasGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushTextRenderingHintToAntiAliasGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushTranslateTransformGeom;
import com.stimulsoft.base.context.chart.geoms.StiSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiShadowGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.context.chart.geoms.StiTextGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiRotatedTextDrawing;
import com.stimulsoft.base.drawing.StiShadow;
import com.stimulsoft.base.drawing.StiShadowGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.drawing.enums.StiStringTrimming;
import com.stimulsoft.base.drawing.path.StiPathArc;
import com.stimulsoft.base.drawing.path.StiPathClose;
import com.stimulsoft.base.drawing.path.StiPathCommand;
import com.stimulsoft.base.drawing.path.StiPathCurve;
import com.stimulsoft.base.drawing.path.StiPathLine;
import com.stimulsoft.base.drawing.path.StiPathLineTo;
import com.stimulsoft.base.drawing.path.StiPathMoveTo;
import com.stimulsoft.base.drawing.path.StiPathPie;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.StringFormat;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;

public class StiContextPainter
implements IStiContextPainter {
    private StiGraphics graphics;
    private double zoom;
    private Double pageZoom;
    private List<Graphics2D> states = new ArrayList<Graphics2D>();
    private List<Object> smothingModes = new ArrayList<Object>();
    private List<Object> textRenderingHints = new ArrayList<Object>();

    public StiContextPainter(StiGraphics graphics, double zoom, Double pageZoom) {
        this.graphics = graphics;
        this.zoom = zoom;
        this.pageZoom = pageZoom;
    }

    public IStiContextPainter clone() {
        StiContextPainter result = new StiContextPainter(this.graphics, this.zoom, this.pageZoom);
        return result;
    }

    public StiStringFormatGeom getDefaultStringFormat() {
        return new StiStringFormatGeom(StiStringTrimming.Character);
    }

    public StiStringFormatGeom getGenericStringFormat() {
        return this.getDefaultStringFormat();
    }

    public StiContext createShadowGraphics(boolean isPrinting, double zoom) {
        return new StiContext((IStiContextPainter)new StiContextPainter(this.graphics, this.zoom, this.pageZoom), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(isPrinting), zoom);
    }

    public StiRectangle getPathBounds(List<StiSegmentGeom> geoms) {
        List<StiPathCommand> path = this.getPath(geoms);
        return this.graphics.drawPath(path, null, null, Boolean.valueOf(false), this.getLineZoom(), this.pageZoom.doubleValue(), false);
    }

    public StiSize measureString(String text, StiFontGeom font) {
        return StiTextUtil.measureString((StiFont)this.getFont(font), (String)text, (float)1.0f);
    }

    public StiSize measureString(String text, StiFontGeom font, int width, StiStringFormatGeom sf) {
        return StiTextUtil.measureString((double)width, (StiFont)this.getFont(font), (String)text, (float)0.0f, (float)1.0f);
    }

    public StiRectangle measureRotatedString(String text, StiFontGeom font, StiRectangle rect, StiStringFormatGeom sf, double angle) {
        return StiRotatedTextDrawing.measureString((StiGraphics)this.graphics, (String)text, (StiFont)this.getFont(font), (StiRectangle)rect, (StringFormat)this.getStringFormat(sf), (StiRotationMode)StiRotationMode.CenterCenter, (double)angle, (float)1.0f, (double)this.zoom);
    }

    public StiRectangle measureRotatedString(String text, StiFontGeom font, StiRectangle rect, StiStringFormatGeom sf, StiRotationMode mode, double angle) {
        return StiRotatedTextDrawing.measureString((StiGraphics)this.graphics, (String)text, (StiFont)this.getFont(font), (StiRectangle)rect, (StringFormat)this.getStringFormat(sf), (StiRotationMode)mode, (double)angle, (float)1.0f, (double)this.zoom);
    }

    public StiRectangle measureRotatedString(String text, StiFontGeom font, StiPoint point, StiStringFormatGeom sf, StiRotationMode mode, double angle, int maximalWidth, boolean wordWrap) {
        return StiRotatedTextDrawing.measureString((StiGraphics)this.graphics, (String)text, (StiFont)this.getFont(font), (StiPoint)new StiPoint(point.x, point.y), (StringFormat)this.getStringFormat(sf), (StiRotationMode)mode, (double)angle, (float)1.0f, (int)maximalWidth, (double)this.zoom, (boolean)wordWrap);
    }

    public StiRectangle measureRotatedString(String text, StiFontGeom font, StiPoint point, StiStringFormatGeom sf, StiRotationMode mode, double angle) {
        return StiRotatedTextDrawing.measureString((StiGraphics)this.graphics, (String)text, (StiFont)this.getFont(font), (StiPoint)new StiPoint(point.x, point.y), (StringFormat)this.getStringFormat(sf), (StiRotationMode)mode, (double)angle, (float)1.0f, (double)this.zoom);
    }

    public void render(StiRectangle rect, List<StiGeom> geoms) {
        for (StiGeom geom : geoms) {
            switch (geom.getType()) {
                case Border: {
                    this.drawBorderGeom((StiBorderGeom)geom);
                    break;
                }
                case Line: {
                    this.drawLineGeom((StiLineGeom)geom);
                    break;
                }
                case Lines: {
                    this.drawLinesGeom((StiLinesGeom)geom);
                    break;
                }
                case Curve: {
                    this.drawCurveGeom((StiCurveGeom)geom);
                    break;
                }
                case Ellipse: {
                    this.drawEllipseGeom((StiEllipseGeom)geom);
                    break;
                }
                case CachedShadow: {
                    this.drawCachedShadowGeom((StiCachedShadowGeom)geom);
                    break;
                }
                case Shadow: {
                    this.drawShadowGeom((StiShadowGeom)geom);
                    break;
                }
                case Path: {
                    this.drawPathGeom((StiPathGeom)geom);
                    break;
                }
                case Text: {
                    this.drawTextGeom((StiTextGeom)geom);
                    break;
                }
                case PushClip: {
                    this.pushClipGeom((StiPushClipGeom)geom);
                    break;
                }
                case PushTranslateTransform: {
                    this.pushTranslateTransformGeom((StiPushTranslateTransformGeom)geom);
                    break;
                }
                case PushRotateTransform: {
                    this.pushRotateTransformGeom((StiPushRotateTransformGeom)geom);
                    break;
                }
                case PushSmothingModeToAntiAlias: {
                    this.pushSmothingModeToAntiAliasGeom((StiPushSmothingModeToAntiAliasGeom)geom);
                    break;
                }
                case PushTextRenderingHintToAntiAlias: {
                    this.pushTextRenderingHintToAntiAliasGeom((StiPushTextRenderingHintToAntiAliasGeom)geom);
                    break;
                }
                case PopSmothingMode: {
                    this.popSmothingModeGeom((StiPopSmothingModeGeom)geom);
                    break;
                }
                case PopTextRenderingHint: {
                    this.popTextRenderingHintGeom((StiPopTextRenderingHintGeom)geom);
                    break;
                }
                case PopTransform: {
                    this.popTransformGeom((StiPopTransformGeom)geom);
                    break;
                }
                case PopClip: {
                    this.popClipGeom((StiPopClipGeom)geom);
                }
            }
        }
    }

    private void drawBorderGeom(StiBorderGeom borderGeom) {
        Object rect = borderGeom.getRect();
        StiBrush backgroundBrush = this.getBrush(borderGeom.getBackground());
        StiPen borderPen = this.getPen(borderGeom.getBorderPen());
        this.graphics.drawRectangle((StiRectangle)rect, borderPen, backgroundBrush, Double.valueOf(backgroundBrush instanceof StiHatchBrush ? this.zoom : this.getLineZoom()), this.pageZoom);
    }

    private void drawLineGeom(StiLineGeom lineGeom) {
        StiPen linePen = this.getPen(lineGeom.getPen());
        if (linePen == null) {
            return;
        }
        this.graphics.drawLine(new StiPoint((double)lineGeom.getX1(), (double)lineGeom.getY1()), new StiPoint((double)lineGeom.getX2(), (double)lineGeom.getY2()), linePen, Double.valueOf(this.getLineZoom()));
    }

    private void drawLinesGeom(StiLinesGeom linesGeom) {
        StiPen linesPen = this.getPen(linesGeom.getPen());
        if (linesPen == null) {
            return;
        }
        ArrayList<Object> path = new ArrayList<Object>();
        if (linesGeom.getPoints() != null && linesGeom.getPoints().length > 1) {
            StiPoint startP = linesGeom.getPoints()[0];
            path.add(new StiPathMoveTo(startP.getX(), startP.getY()));
            for (int i = 1; i < linesGeom.getPoints().length; ++i) {
                StiPoint point = linesGeom.getPoints()[i];
                path.add(new StiPathLineTo(point.getX(), point.getY()));
            }
        }
        this.graphics.drawPath(path, linesPen, null, linesGeom.isUseZoom() ? this.zoom : this.getLineZoom(), this.pageZoom.doubleValue());
    }

    private void drawCurveGeom(StiCurveGeom curveGeom) {
        StiPen curvePen = this.getPen(curveGeom.getPen());
        if (curvePen == null) {
            return;
        }
        this.graphics.drawCurve(curveGeom.getPoints(), curvePen, Double.valueOf(curveGeom.isUseZoom() ? this.zoom : this.getLineZoom()), Boolean.valueOf(true));
    }

    private void drawEllipseGeom(StiEllipseGeom ellipseGeom) {
        StiRectangle rect = ellipseGeom.getRect();
        StiBrush backgroundBrush = this.getBrush(ellipseGeom.getBackground());
        StiPen borderPen = this.getPen(ellipseGeom.getBorderPen());
        this.graphics.drawEllise(rect, borderPen, backgroundBrush, Double.valueOf(backgroundBrush instanceof StiHatchBrush ? this.zoom : this.getLineZoom()), this.pageZoom);
    }

    private void drawCachedShadowGeom(StiCachedShadowGeom cachedShadowGeom) {
        StiShadow.setShadowSize((int)((int)this.getLineZoom()));
        StiShadow.drawCachedShadow((StiGraphics)this.graphics, (StiRectangle)cachedShadowGeom.getRect(), (StiEnumSet)cachedShadowGeom.getSides(), (boolean)cachedShadowGeom.isPrinting());
    }

    private void drawShadowGeom(StiShadowGeom shadowGeom) {
        StiShadowGraphics shadowGraphics = new StiShadowGraphics(shadowGeom.getRect());
        ((StiContextPainter)shadowGeom.getShadowContext().getContextPainter()).setGraphics(shadowGraphics.getGraphics());
        shadowGeom.getShadowContext().render(shadowGeom.getRect());
        shadowGraphics.drawShadow(this.graphics, shadowGeom.getRect(), shadowGeom.getRadius(), this.getLineZoom());
    }

    private void drawPathGeom(StiPathGeom pathGeom) {
        List<StiPathCommand> path = this.getPath(pathGeom.getGeoms());
        StiBrush backgroundBrush = this.getBrush(pathGeom.getBackground());
        StiPen borderPen = this.getPen(pathGeom.getPen());
        this.graphics.drawPath(path, borderPen, backgroundBrush, backgroundBrush instanceof StiHatchBrush ? this.zoom : this.getLineZoom(), this.pageZoom.doubleValue());
    }

    private void drawTextGeom(StiTextGeom textGeom) {
        RenderingHints textHint = this.graphics.getG().getRenderingHints();
        if (textGeom.isAntialiasing()) {
            this.graphics.getG().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Object rectObj = textGeom.getLocation();
        StiBrush br = this.getBrush(textGeom.getBrush());
        StiFont font = this.getFont(textGeom.getFont());
        StringFormat stringFormat = this.getStringFormat(textGeom.getStringFormat());
        if (!textGeom.isRotatedText()) {
            StiRectangle rect = (StiRectangle)rectObj;
            this.graphics.drawText(textGeom.getText(), rect, font, br, stringFormat.getHorAlignment(), stringFormat.getVertsAlignment(), Boolean.valueOf(stringFormat.isWordWrap()), 1.0f, Double.valueOf(1.0), StiPenStyle.Solid, null, stringFormat.getTextOptions());
        } else if (rectObj instanceof StiRectangle && textGeom.isRounded()) {
            StiRectangle rect = (StiRectangle)rectObj;
            StiRotatedTextDrawing.drawString((StiGraphics)this.graphics, (String)textGeom.getText(), (StiFont)font, (StiBrush)br, (StiRectangle)rect, (StringFormat)stringFormat, (StiRotationMode)textGeom.getRotationMode(), (double)textGeom.getAngle(), (float)1.0f, (boolean)textGeom.isAntialiasing(), (double)this.zoom);
        } else if (rectObj instanceof StiRectangle) {
            StiRectangle rect = (StiRectangle)rectObj;
            if (textGeom.getMaximalWidth() != null) {
                StiRotatedTextDrawing.drawString((StiGraphics)this.graphics, (String)textGeom.getText(), (StiFont)font, (StiBrush)br, (StiRectangle)rect, (StringFormat)stringFormat, (StiRotationMode)textGeom.getRotationMode(), (double)textGeom.getAngle(), (float)1.0f, (boolean)textGeom.isAntialiasing(), (int)textGeom.getMaximalWidth(), (double)this.zoom);
            } else {
                StiRotatedTextDrawing.drawString((StiGraphics)this.graphics, (String)textGeom.getText(), (StiFont)font, (StiBrush)br, (StiRectangle)rect, (StringFormat)stringFormat, (double)textGeom.getAngle(), (float)1.0f, (boolean)textGeom.isAntialiasing(), (double)this.zoom);
            }
        } else if (rectObj instanceof StiPoint) {
            StiPoint point = (StiPoint)textGeom.getLocation();
            if (textGeom.getMaximalWidth() != null) {
                StiRotatedTextDrawing.drawString((StiGraphics)this.graphics, (String)textGeom.getText(), (StiFont)font, (StiBrush)br, (StiPoint)point, (StringFormat)stringFormat, (StiRotationMode)textGeom.getRotationMode(), (double)textGeom.getAngle(), (float)1.0f, (boolean)textGeom.isAntialiasing(), (int)textGeom.getMaximalWidth(), (double)this.zoom);
            } else {
                StiRotatedTextDrawing.drawString((StiGraphics)this.graphics, (String)textGeom.getText(), (StiFont)font, (StiBrush)br, (StiPoint)point, (StringFormat)stringFormat, (StiRotationMode)textGeom.getRotationMode(), (double)textGeom.getAngle(), (float)1.0f, (boolean)textGeom.isAntialiasing(), (double)this.zoom);
            }
        }
        if (textGeom.isAntialiasing()) {
            this.graphics.getG().setRenderingHints(textHint);
        }
    }

    private void pushClipGeom(StiPushClipGeom clip) {
        this.pushState();
        this.graphics.setTransformedClip(clip.getClipRectangle().clone());
    }

    private void popClipGeom(StiPopClipGeom clip) {
        this.graphics.restoreClip();
        this.popState();
    }

    private void pushTranslateTransformGeom(StiPushTranslateTransformGeom translate) {
        this.pushState();
        this.graphics.setOffset((double)translate.getX(), (double)translate.getY());
    }

    private void pushRotateTransformGeom(StiPushRotateTransformGeom rotate) {
        this.pushState();
        this.graphics.getG().rotate(Math.toRadians(rotate.getAngle()), this.graphics.getOffsetX(), this.graphics.getOffsetY());
        this.graphics.setOffset(0.0, 0.0);
    }

    private void popTransformGeom(StiPopTransformGeom translate) {
        this.graphics.clearOffset();
        this.popState();
    }

    private void pushSmothingModeToAntiAliasGeom(StiPushSmothingModeToAntiAliasGeom smothing) {
        this.pushState();
        this.smothingModes.add(this.graphics.getG().getRenderingHint(RenderingHints.KEY_ANTIALIASING));
        this.graphics.getG().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private void popSmothingModeGeom(StiPopSmothingModeGeom smothing) {
        this.graphics.getG().setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.smothingModes.remove(this.smothingModes.size() - 1));
        this.popState();
    }

    private void pushTextRenderingHintToAntiAliasGeom(StiPushTextRenderingHintToAntiAliasGeom text) {
        this.pushState();
        this.textRenderingHints.add(this.graphics.getG().getRenderingHint(RenderingHints.KEY_ANTIALIASING));
        this.graphics.getG().setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    private void popTextRenderingHintGeom(StiPopTextRenderingHintGeom text) {
        this.graphics.getG().setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.textRenderingHints.remove(this.smothingModes.size() - 1));
        this.popState();
    }

    private void pushState() {
        this.states.add(this.graphics.getG());
        this.graphics.setG((Graphics2D)this.graphics.getG().create());
    }

    private void popState() {
        this.graphics.setG(this.states.remove(this.states.size() - 1));
    }

    private List<StiPathCommand> getPath(List<StiSegmentGeom> geoms) {
        ArrayList<StiPathCommand> path = new ArrayList<StiPathCommand>();
        for (StiSegmentGeom geom : geoms) {
            if (geom instanceof StiArcSegmentGeom) {
                StiArcSegmentGeom arcSegment = (StiArcSegmentGeom)geom;
                path.add((StiPathCommand)new StiPathArc(arcSegment.getRect(), (double)(-arcSegment.getStartAngle()), (double)(-arcSegment.getSweepAngle())));
                continue;
            }
            if (geom instanceof StiCloseFigureSegmentGeom) {
                path.add((StiPathCommand)new StiPathClose());
                continue;
            }
            if (geom instanceof StiCurveSegmentGeom) {
                StiCurveSegmentGeom curveSegment = (StiCurveSegmentGeom)geom;
                path.add((StiPathCommand)new StiPathCurve(curveSegment.getPoints()));
                continue;
            }
            if (geom instanceof StiLineSegmentGeom) {
                StiLineSegmentGeom lineSegment = (StiLineSegmentGeom)geom;
                path.add((StiPathCommand)new StiPathLine(lineSegment.getX1(), lineSegment.getY1(), lineSegment.getX2(), lineSegment.getY2()));
                continue;
            }
            if (geom instanceof StiLinesSegmentGeom) {
                StiLinesSegmentGeom linesSegment = (StiLinesSegmentGeom)geom;
                StiPoint[] points = linesSegment.getPoints();
                if (points == null || points.length <= 1) continue;
                if (path.size() == 0) {
                    path.add((StiPathCommand)new StiPathMoveTo(Double.valueOf(points[0].x), Double.valueOf(points[0].y)));
                }
                for (int i = 1; i < points.length; ++i) {
                    path.add((StiPathCommand)new StiPathLineTo(Double.valueOf(points[i].x), Double.valueOf(points[i].y)));
                }
                continue;
            }
            if (!(geom instanceof StiPieSegmentGeom)) continue;
            StiPieSegmentGeom pieSegment = (StiPieSegmentGeom)geom;
            path.add((StiPathCommand)new StiPathPie(pieSegment.getRect(), (double)(-pieSegment.getStartAngle()), (double)(-pieSegment.getSweepAngle())));
        }
        return path;
    }

    private StiBrush getBrush(Object brush) {
        if (brush == null) {
            return null;
        }
        if (brush instanceof StiColor) {
            return new StiSolidBrush((StiColor)brush);
        }
        return (StiBrush)brush;
    }

    private StiPen getPen(StiPenGeom penGeom) {
        if (penGeom != null && penGeom.getBrush() != null && penGeom.getBrush() instanceof StiColor) {
            StiPen pen = new StiPen(penGeom.getThickness(), (StiColor)penGeom.getBrush());
            pen.setDashStyle(penGeom.getPenStyle());
            pen.setCaps(penGeom.getEndCap().getAwtCap());
            return pen;
        }
        return null;
    }

    private StiFont getFont(StiFontGeom fontGeom) {
        return new StiFont(fontGeom.getFontName(), fontGeom.getFontSize(), fontGeom.getFontStyle());
    }

    private StringFormat getStringFormat(StiStringFormatGeom sfGeom) {
        StringFormat sf = new StringFormat();
        sf.Alignment = sfGeom.getAlignment();
        sf.FormatFlags = sfGeom.getFormatFlags();
        sf.HotkeyPrefix = sfGeom.getHotkeyPrefix();
        sf.LineAlignment = sfGeom.getLineAlignment();
        sf.Trimming = sfGeom.getTrimming();
        return sf;
    }

    private double getLineZoom() {
        return this.zoom / this.pageZoom;
    }

    public StiGraphics getGraphics() {
        return this.graphics;
    }

    public void setGraphics(StiGraphics graphics) {
        this.graphics = graphics;
    }
}

