/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.json;

import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.data.DBNull;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.json.datahelp.StiJsonMetaData;
import com.stimulsoft.report.json.datahelp.StiJsonRelationData;
import com.stimulsoft.report.json.datahelp.StiJsonRelationIdData;
import com.stimulsoft.report.utils.data.StiDataColumnsUtil;
import com.stimulsoft.report.utils.data.StiSqlField;
import com.stimulsoft.report.utils.data.StiXmlTable;
import com.stimulsoft.report.utils.data.StiXmlTableFieldsRequest;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class StiJsonToDataSetConverterV2 {
    public static DataSet getDataSet(Object json) throws JSONException {
        ArrayList<StiJsonMetaData> table;
        json = StiJsonToDataSetConverterV2.correctNetJson(json);
        json = StiJsonToDataSetConverterV2.correctJson(json);
        ArrayList<StiJsonMetaData> collections = new ArrayList<StiJsonMetaData>();
        DataSet dataSet = new DataSet();
        Hashtable<Object, StiJsonRelationIdData> tags = new Hashtable<Object, StiJsonRelationIdData>();
        StiJsonToDataSetConverterV2.fillCollection(collections, "", "", "", json, true, tags);
        Hashtable addresses = new Hashtable();
        Hashtable tables = new Hashtable();
        Hashtable<String, StiJsonRelationData> relations = new Hashtable<String, StiJsonRelationData>();
        Hashtable<List, Integer> lastIndexesForAddress = new Hashtable<List, Integer>();
        ArrayList<StiDataColumn> allRelationsColumn = new ArrayList<StiDataColumn>();
        for (StiJsonMetaData collection : collections) {
            if (collection == null) continue;
            table = (ArrayList<StiJsonMetaData>)tables.get(collection.getCast());
            if (table == null) {
                table = new ArrayList<StiJsonMetaData>();
            }
            lastIndexesForAddress.put(table, 0);
            addresses.put(collection.getAddress(), table);
            table.add(collection);
            tables.put(collection.getCast(), table);
            String relationId = tags.containsKey(collection.getObject()) ? tags.get(collection.getObject()).getRelationId() : null;
            if (relationId == null || relationId.equals("-1") || relationId.indexOf("#relation#") != 0) continue;
            String relationParentCast = relationId.replaceAll("#relation#", "");
            if (tables.containsKey(relationParentCast)) {
                tags.get(collection.getObject()).setRelationId(String.valueOf(((List)tables.get(relationParentCast)).size()));
                continue;
            }
            tags.get(collection.getObject()).setRelationId("0");
        }
        for (StiJsonMetaData cast : tables.keySet()) {
            table = (List)tables.get(cast);
            int dataTableRowsCount = 0;
            for (StiJsonMetaData item : table) {
                String tableName = item.getCollectionName();
                DataTable dataTable = dataSet.getTables().get(tableName);
                if (dataTable == null) {
                    dataTable = new DataTable(tableName);
                    dataSet.getTables().add(dataTable);
                }
                if (!(item.getObject() instanceof JSONObject)) continue;
                DataRow dataRow = dataTable.NewRow();
                ++dataTableRowsCount;
                JSONArray names = ((JSONObject)item.getObject()).names();
                for (int i = 0; i < names.length(); ++i) {
                    StiJsonRelationIdData itemDataHelp;
                    Object itemObject = ((JSONObject)item.getObject()).get(names.getString(i));
                    String columnName = names.getString(i);
                    if (columnName == null) continue;
                    StiDataColumn dataColumn = dataTable.getColumns().get(columnName);
                    if (dataColumn == null) {
                        dataColumn = new StiDataColumn(columnName, columnName, StiSystemTypeEnum.SystemString.getSystemType());
                        dataTable.getColumns().add(dataColumn);
                    }
                    StiJsonRelationIdData dataHelp = tags.containsKey(itemObject) && (itemObject instanceof JSONObject || itemObject instanceof JSONArray) ? tags.get(itemObject) : null;
                    Object columnValue = dataHelp != null && dataHelp.getNewValue() != null ? dataHelp.getNewValue() : ((JSONObject)item.getObject()).get(names.getString(i));
                    StiJsonRelationIdData stiJsonRelationIdData = itemDataHelp = tags.containsKey(item.getObject()) ? tags.get(item.getObject()) : null;
                    if ("relationId".equals(columnName) && itemDataHelp != null && itemDataHelp.getRelationId() != null) {
                        StiDataColumn dataColumnRalationId = dataTable.getColumns().get("relationId");
                        if (dataColumnRalationId == null) {
                            dataColumnRalationId = new StiDataColumn("relationId", "relationId", StiSystemTypeEnum.SystemString.getSystemType());
                            dataTable.getColumns().add(dataColumnRalationId);
                            allRelationsColumn.add(dataColumnRalationId);
                        }
                        if (itemDataHelp.getRelationId().equals("-1")) {
                            itemDataHelp.setRelationId("0");
                            List table1 = (List)addresses.get(item.getAddress());
                            Integer index = (Integer)lastIndexesForAddress.get(table1);
                            while (index < table1.size()) {
                                StiJsonMetaData item1 = (StiJsonMetaData)table1.get(index);
                                if (StiValidationUtil.equals((Object)item1.getAddress(), (Object)item.getAddress())) {
                                    itemDataHelp.setRelationId(index.toString());
                                    lastIndexesForAddress.put(table1, index);
                                    break;
                                }
                                Integer n = index;
                                Integer n2 = index = Integer.valueOf(index + 1);
                            }
                        }
                        dataRow.setValue(dataColumnRalationId.getName(), (Object)itemDataHelp.getRelationId());
                        continue;
                    }
                    if (columnValue != null && columnValue.toString().indexOf("#relation#") == 0) {
                        List list;
                        dataRow.setValue(dataColumn.getName(), (Object)String.valueOf(dataTableRowsCount - 1));
                        String address = columnValue.toString().replaceAll("#relation#", "");
                        if (!addresses.containsKey(address) || (list = (List)addresses.get(address)).size() <= 0) continue;
                        StiJsonRelationData dataHelpRelation = new StiJsonRelationData();
                        dataHelpRelation.setChildColumn(dataColumn);
                        dataHelpRelation.setChildTable(dataTable);
                        dataHelpRelation.setParentTableName(((StiJsonMetaData)list.get(0)).getCollectionName());
                        relations.put(dataTable.getTableName() + "." + dataColumn.getName(), dataHelpRelation);
                        continue;
                    }
                    if (columnValue == null || columnValue == JSONObject.NULL) {
                        dataRow.setValue(dataColumn.getName(), (Object)DBNull.Value);
                        continue;
                    }
                    dataRow.setValue(dataColumn.getName(), columnValue);
                }
                dataTable.getRows().add(dataRow);
            }
        }
        for (StiJsonRelationData relation : relations.values()) {
            StiDataColumn childColumn = relation.getChildColumn();
            DataTable parentTable = dataSet.getTables().get(relation.getParentTableName());
            StiDataColumn parentColumn = parentTable.getColumns().get("relationId");
            if (parentColumn != null && childColumn == null) continue;
        }
        for (StiDataColumn stiDataColumn : allRelationsColumn) {
        }
        return dataSet;
    }

    private static Object correctNetJson(Object json) throws JSONException {
        if (json instanceof JSONArray) {
            JSONArray array = (JSONArray)json;
            JSONArray resultArray = new JSONArray();
            for (int i = 0; i < array.length(); ++i) {
                resultArray.put(StiJsonToDataSetConverterV2.correctNetJson(array.get(i)));
            }
            return resultArray;
        }
        if (json instanceof JSONObject) {
            JSONObject object = (JSONObject)json;
            JSONObject resultObject = new JSONObject();
            for (int i = 0; i < object.length(); ++i) {
                String name = object.names().getString(i);
                if (object.get(name) instanceof JSONObject) {
                    JSONArray resultArray = new JSONArray();
                    resultArray.put(StiJsonToDataSetConverterV2.correctNetJson(object.get(name)));
                    resultObject.put(name, (Object)resultArray);
                    continue;
                }
                resultObject.put(name, StiJsonToDataSetConverterV2.correctNetJson(object.get(name)));
            }
            return resultObject;
        }
        return json;
    }

    public static DataSet getDataSetFromXml(byte[] array) {
        if (array != null) {
            try {
                DataSet dataSet = new DataSet();
                StiXmlTableFieldsRequest request = StiDataColumnsUtil.parceXSDSchema(StiIOUtil.toInputStream((String)new String(array, "UTF-8")));
                for (StiXmlTable table : request.getTables()) {
                    DataTable dataTable = dataSet.getTables().get(table.getName());
                    if (dataTable == null) {
                        dataTable = new DataTable(table.getName());
                        dataSet.getTables().add(dataTable);
                    }
                    for (StiSqlField column : table.getColumns()) {
                        StiDataColumn dataColumn = dataTable.getColumns().get(column.getName());
                        if (dataColumn != null) continue;
                        dataColumn = new StiDataColumn(column.getName(), column.getName(), column.getSystemType());
                        dataTable.getColumns().add(dataColumn);
                    }
                }
                return dataSet;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void correctArray(Object jToken) throws JSONException {
        block4: {
            JSONObject jContainer;
            block3: {
                JSONArray jArray;
                jContainer = jToken instanceof JSONObject ? (JSONObject)jToken : null;
                JSONArray jSONArray = jArray = jToken instanceof JSONArray ? (JSONArray)jToken : null;
                if (jArray == null) break block3;
                for (int index = 0; index < jArray.length(); ++index) {
                    Object jTokenArray = jArray.get(index);
                    if (!(jTokenArray instanceof JSONObject) && !(jTokenArray instanceof JSONArray)) {
                        JSONObject value = new JSONObject();
                        value.put("value", jTokenArray);
                        jArray.put(index, (Object)value);
                        continue;
                    }
                    StiJsonToDataSetConverterV2.correctArray(jTokenArray);
                }
                break block4;
            }
            if (jContainer == null) break block4;
            for (int index = 0; index < jContainer.length(); ++index) {
                boolean itemJProperty;
                Object item = jContainer.get(jContainer.names().getString(index));
                boolean bl = itemJProperty = item instanceof JSONArray || item instanceof JSONObject;
                if (!itemJProperty) continue;
                StiJsonToDataSetConverterV2.correctArray(item);
            }
        }
    }

    private static JSONObject correctJson(Object jToken) throws JSONException {
        JSONObject jContainer;
        StiJsonToDataSetConverterV2.correctArray(jToken);
        JSONObject jSONObject = jContainer = jToken instanceof JSONObject ? (JSONObject)jToken : null;
        if (jToken instanceof JSONArray) {
            JSONObject root = new JSONObject();
            root.put("root", jToken);
            return root;
        }
        if (jContainer != null) {
            for (int index = 0; index < jContainer.names().length(); ++index) {
                Object item = jContainer.get(jContainer.names().getString(index));
                if (!(item instanceof String) && !(item instanceof Number)) continue;
                JSONObject root = new JSONObject();
                root.put("root", jToken);
                return root;
            }
        }
        return (JSONObject)jToken;
    }

    private static String correctJsonString(String json) {
        String newJson = json;
        for (int pos = 0; pos < newJson.length(); ++pos) {
            if (newJson.charAt(pos) == '{') {
                return newJson;
            }
            if (newJson.charAt(pos) != '[') continue;
            return "{\"root\": " + newJson + "}";
        }
        return newJson;
    }

    private static void fillCollection(List<StiJsonMetaData> collections, String collectionName, String parentName, String address, Object json, boolean first, Hashtable<Object, StiJsonRelationIdData> tags) throws JSONException {
        Object obj;
        String cast = parentName + "_" + collectionName;
        if (StiValidationUtil.isNullOrEmpty((String)parentName)) {
            cast = collectionName;
        }
        if (json instanceof JSONObject || json instanceof JSONArray) {
            JSONArray array = json instanceof JSONArray ? (JSONArray)json : null;
            JSONObject container = json instanceof JSONObject ? (JSONObject)json : null;
            Integer name = 0;
            for (int i = 0; i < (array != null ? array.length() : container.length()); ++i) {
                JSONArray itemValueJArray;
                Object item = container != null ? container.get(container.names().getString(i)) : array.get(i);
                JSONArray itemJArray = item instanceof JSONArray ? (JSONArray)item : null;
                JSONObject itemJObject = item instanceof JSONObject ? (JSONObject)item : null;
                String itemName = container != null ? container.names().getString(i) : name.toString();
                JSONArray jSONArray = itemValueJArray = item instanceof JSONArray ? (JSONArray)item : null;
                if (item instanceof JSONArray || item instanceof JSONObject || array != null) {
                    boolean isSetRelation = false;
                    if (json instanceof JSONArray) {
                        StiJsonToDataSetConverterV2.fillCollection(collections, collectionName, parentName, address + ".#array#" + name.toString(), item, false, tags);
                    } else {
                        if (!first && itemValueJArray != null) {
                            for (int j = 0; j < itemValueJArray.length(); ++j) {
                                Object itemItem = itemValueJArray.get(j);
                                StiJsonToDataSetConverterV2.setRelationId(itemItem, "#relation#" + cast, tags);
                                if (!(itemItem instanceof JSONObject)) continue;
                                ((JSONObject)itemItem).put("relationId", (Object)("#relation#" + cast));
                            }
                        }
                        StiJsonToDataSetConverterV2.fillCollection(collections, itemName, cast, address + "." + itemName, item, false, tags);
                        if (itemValueJArray == null) {
                            StiJsonToDataSetConverterV2.setRelationId(item, "-1", tags);
                        } else {
                            StiJsonToDataSetConverterV2.setNewValue(item, "#relation#" + address + "." + itemName + ".#array#0", tags);
                            isSetRelation = true;
                        }
                    }
                    if (!isSetRelation && itemValueJArray == null) {
                        StiJsonToDataSetConverterV2.setNewValue(item, "#relation#" + address + "." + itemName, tags);
                    }
                }
                Integer n = name;
                Integer n2 = name = Integer.valueOf(name + 1);
            }
        }
        if (json instanceof JSONArray) {
            if (((JSONArray)json).length() == 0 && parentName.length() == 0) {
                obj = new JSONObject();
                obj.put("value", json);
                if (tags.containsKey(json)) {
                    tags.remove(json);
                }
                collections.add(new StiJsonMetaData(collectionName, address, cast, json));
            }
            return;
        }
        if (!StiValidationUtil.isNullOrEmpty((String)address)) {
            if (!StiValidationUtil.isNullOrEmpty((String)parentName)) {
                collectionName = parentName + "_" + collectionName;
            }
            JSONObject jSONObject = obj = json instanceof JSONObject || json instanceof JSONArray ? json : null;
            if (obj == null) {
                obj = new JSONObject();
                obj.put("value", json);
                if (tags.containsKey(json)) {
                    tags.remove(json);
                }
            }
            collections.add(new StiJsonMetaData(collectionName, address, cast, obj));
        }
    }

    private static StiJsonRelationIdData setRelationId(Object tag, String relationId, Hashtable<Object, StiJsonRelationIdData> tags) {
        StiJsonRelationIdData dataHelp = tags.containsKey(tag) ? tags.get(tag) : new StiJsonRelationIdData();
        dataHelp.setRelationId(relationId);
        tags.put(tag, dataHelp);
        return dataHelp;
    }

    private static StiJsonRelationIdData setNewValue(Object tag, Object value, Hashtable<Object, StiJsonRelationIdData> tags) {
        StiJsonRelationIdData dataHelp = tags.containsKey(tag) ? tags.get(tag) : new StiJsonRelationIdData();
        dataHelp.setNewValue(value);
        tags.put(tag, dataHelp);
        return dataHelp;
    }
}

