/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.tick.linear.mark;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.infographics.gauge.tick.StiCustomValueBase;

public class StiLinearTickMarkCustomValue
extends StiCustomValueBase {
    private Double relativeWidth = null;
    private Double relativeHeight = null;
    private StiGaugeElementSkin skin;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyFloatNullable("RelativeHeight", this.relativeHeight.doubleValue(), null);
        jObject.AddPropertyFloatNullable("RelativeWidth", this.relativeWidth.doubleValue(), null);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("RelativeHeight".equals(property.Name)) {
                this.setRelativeHeight((Double)property.Value);
                continue;
            }
            if (!"RelativeWidth".equals(property.Name)) continue;
            this.setRelativeWidth((Double)property.Value);
        }
    }

    @Override
    public StiComponentId getComponentId() {
        return StiComponentId.StiLinearTickMarkCustomValue;
    }

    @StiSerializable
    public Double getRelativeWidth() {
        return this.relativeWidth;
    }

    public void setRelativeWidth(Double relativeWidth) {
        this.relativeWidth = relativeWidth;
    }

    @StiSerializable
    public Double getRelativeHeight() {
        return this.relativeHeight;
    }

    public void setRelativeHeight(Double relativeHeight) {
        this.relativeHeight = relativeHeight;
    }

    @StiSerializable
    public StiGaugeElementSkin getSkin() {
        return this.skin;
    }

    public void setSkin(StiGaugeElementSkin skin) {
        this.skin = skin;
    }

    @Override
    public String getLocalizedName() {
        return "LinearTickMarkCustom";
    }

    public String toString() {
        return String.format("Value=%s", this.value);
    }

    @Override
    public StiCustomValueBase createNew() {
        return new StiLinearTickMarkCustomValue();
    }

    public StiLinearTickMarkCustomValue() {
    }

    public StiLinearTickMarkCustomValue(double value) {
        this.value = value;
    }

    public StiLinearTickMarkCustomValue(double value, Double offset, Double relativeWidth, Double relativeHeight, StiPlacement placement, StiGaugeElementSkin skin) {
        this.value = value;
        this.offset = offset;
        this.relativeWidth = relativeWidth;
        this.relativeHeight = relativeHeight;
        this.placement = placement;
        this.skin = skin;
    }
}

