/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.scales;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.infographics.gauge.StiGaugeElemenType;
import com.stimulsoft.report.infographics.gauge.StiRadialScaleSkin;
import com.stimulsoft.report.infographics.gauge.StiRadiusMode;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.scalebargeometry.StiRadialBarGeometry;
import com.stimulsoft.report.infographics.gauge.primitives.scales.StiScaleBase;
import com.stimulsoft.report.infographics.gauge.styles.IStiGaugeStyle;

public class StiRadialScale
extends StiScaleBase {
    private double radius = 0.75;
    private StiRadiusMode radiusMode = StiRadiusMode.Auto;
    private StiPoint center = new StiPoint(0.5, 0.5);
    private double startAngle = 45.0;
    private double sweepAngle = 300.0;
    private StiRadialScaleSkin skin = StiRadialScaleSkin.Default;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyFloat("Radius", this.getRadius(), 0.0);
        jObject.AddPropertyEnum("RadiusMode", (Enum)this.getRadiusMode());
        jObject.AddPropertyJObject("Center", StiJsonReportObjectHelper.Serialize.pointF((StiPoint)this.getCenter()));
        jObject.AddPropertyFloat("StartAngle", this.getStartAngle(), 45.0);
        jObject.AddPropertyFloat("SweepAngle", this.getSweepAngle(), 300.0);
        jObject.AddPropertyEnum("Skin", (Enum)this.getSkin());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("Radius".equals(property.Name)) {
                this.setRadius((Double)property.Value);
                continue;
            }
            if ("RadiusMode".equals(property.Name)) {
                this.setRadiusMode(StiRadiusMode.valueOf(property.Value.toString()));
                continue;
            }
            if ("Center".equals(property.Name)) {
                this.setCenter(StiJsonReportObjectHelper.Deserialize.PointF((JSONObject)((JSONObject)property.Value)));
                continue;
            }
            if ("StartAngle".equals(property.Name)) {
                this.setStartAngle((Double)property.Value);
                continue;
            }
            if ("SweepAngle".equals(property.Name)) {
                this.setSweepAngle((Double)property.Value);
                continue;
            }
            if (!"Skin".equals(property.Name)) continue;
            this.setSkin(StiRadialScaleSkin.valueOf(property.Value.toString()));
        }
    }

    @Override
    public StiComponentId getComponentId() {
        return StiComponentId.StiRadialScale;
    }

    @Override
    public Object clone() {
        StiRadialScale scale = (StiRadialScale)super.clone();
        scale.setRadius(this.getRadius());
        scale.setRadiusMode(this.getRadiusMode());
        scale.setCenter(this.getCenter().clone());
        scale.setStartAngle(this.getStartAngle());
        scale.setSweepAngle(this.getSweepAngle());
        scale.setSkin(this.getSkin());
        return scale;
    }

    @Override
    public void applyStyle(IStiGaugeStyle style) {
        for (int index = 0; index < this.getItems().size(); ++index) {
            ((StiGaugeElement)this.getItems().get(index)).applyStyle(style);
        }
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    @StiSerializable
    public double getRadius() {
        return this.radius;
    }

    @StiSerializable
    public StiRadiusMode getRadiusMode() {
        return this.radiusMode;
    }

    public void setRadiusMode(StiRadiusMode radiusMode) {
        this.radiusMode = radiusMode;
    }

    @StiSerializable
    public StiPoint getCenter() {
        return this.center;
    }

    public void setCenter(StiPoint center) {
        this.center = center;
    }

    @StiSerializable
    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double startAngle) {
        this.startAngle = startAngle;
    }

    @StiSerializable
    public double getSweepAngle() {
        return this.sweepAngle;
    }

    public void setSweepAngle(double sweepAngle) {
        this.sweepAngle = sweepAngle;
    }

    @StiSerializable
    public StiRadialScaleSkin getSkin() {
        return this.skin;
    }

    public void setSkin(StiRadialScaleSkin skin) {
        this.skin = skin;
    }

    @Override
    public StiGaugeElemenType getScaleType() {
        return StiGaugeElemenType.RadialElement;
    }

    public double GetRadius() {
        if (this.radius < 0.0) {
            return 0.0;
        }
        return this.radius;
    }

    public double GetStartWidth() {
        double value = this.startWidth;
        if (value < 0.0) {
            value = 0.0;
        } else if (value > 1.0) {
            value = 1.0;
        }
        return value;
    }

    public double GetEndWidth() {
        double value = this.endWidth;
        if (value < 0.0) {
            value = 0.0;
        } else if (value > 1.0) {
            value = 1.0;
        }
        return value;
    }

    public double GetSweepAngle() {
        double value = this.sweepAngle;
        if (value < 0.0) {
            value = 0.0;
        } else if (value > 360.0) {
            value = 360.0;
        }
        return value;
    }

    public double getCurrentAngle(double angle) {
        return this.getPosition(angle) * this.getSweepAngle() + this.getStartAngle();
    }

    @Override
    public StiScaleBase createNew() {
        return new StiRadialScale();
    }

    public StiRadialScale() {
        this.barGeometry = new StiRadialBarGeometry(this);
    }
}

