/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.range;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.helpers.StiMathHelper;
import com.stimulsoft.report.infographics.gauge.primitives.range.StiRangeBase;
import com.stimulsoft.report.infographics.gauge.primitives.scales.StiScaleBase;
import com.stimulsoft.report.infographics.gauge.scales.StiRadialScale;
import com.stimulsoft.report.painters.StiGaugeContextPainter;

public class StiRadialRange
extends StiRangeBase {
    private boolean useValuesFromTheSpecifiedRange = true;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyBool("UseValuesFromTheSpecifiedRange", this.useValuesFromTheSpecifiedRange, true);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (!"UseValuesFromTheSpecifiedRange".equals(property.Name)) continue;
            this.setUseValuesFromTheSpecifiedRange((Boolean)property.Value);
        }
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiRadialRange;
    }

    @StiSerializable
    public boolean isUseValuesFromTheSpecifiedRange() {
        return this.useValuesFromTheSpecifiedRange;
    }

    public void setUseValuesFromTheSpecifiedRange(boolean useValuesFromTheSpecifiedRange) {
        this.useValuesFromTheSpecifiedRange = useValuesFromTheSpecifiedRange;
    }

    @Override
    public String getLocalizeName() {
        return "RadialRange";
    }

    @Override
    public void drawRange(StiGaugeContextPainter context, StiScaleBase scale) {
        double radius4;
        double radius3;
        double radius2;
        double radius1;
        double scaleEndWidth;
        double scaleStartWidth;
        StiRadialScale radialScale;
        StiRadialScale stiRadialScale = radialScale = scale instanceof StiRadialScale ? (StiRadialScale)scale : null;
        if (radialScale == null || this.getStartWidth() == 0.0 || this.getEndWidth() == 0.0) {
            return;
        }
        double startValue = this.getStartValue();
        if (this.useValuesFromTheSpecifiedRange && startValue < scale.getMinimum()) {
            startValue = scale.getMinimum();
        } else if (startValue > scale.getMaximum()) {
            return;
        }
        double endValue = this.getEndValue();
        if (this.useValuesFromTheSpecifiedRange && endValue > scale.getMaximum()) {
            endValue = scale.getMaximum();
        } else if (endValue < scale.getMinimum()) {
            return;
        }
        double diameter = scale.barGeometry.getDiameter();
        if (scale.getIsReversed()) {
            startValue = scale.getMaximum() - startValue;
            endValue = scale.getMaximum() - endValue;
            scaleStartWidth = scale.getEndWidth() * diameter;
            scaleEndWidth = scale.getStartWidth() * diameter;
        } else {
            scaleStartWidth = scale.getStartWidth() * diameter;
            scaleEndWidth = scale.getEndWidth() * diameter;
        }
        StiRectangle rect = scale.barGeometry.getRectGeometry();
        StiPoint centerPoint = scale.barGeometry.getCenter();
        double radius = scale.barGeometry.getRadius();
        double startWidth = this.getStartWidth() >= 0.0 ? this.getStartWidth() * diameter : 0.0;
        double endWidth = this.getEndWidth() >= 0.0 ? this.getEndWidth() * diameter : 0.0;
        double startAngle = radialScale.getStartAngle() + scale.getPosition(startValue) * radialScale.getSweepAngle();
        double endAngle = (scale.getPosition(endValue) - scale.getPosition(startValue)) * radialScale.getSweepAngle();
        double value1 = scale.getPosition(startValue);
        double value2 = scale.getPosition(endValue);
        double scaleRest = StiMathHelper.maxMinusMin(scaleStartWidth, scaleEndWidth);
        if (this.getPlacement() == StiPlacement.Outside) {
            radius1 = radius;
            radius2 = radius;
            radius3 = radius + startWidth;
            radius4 = radius + endWidth;
        } else if (this.getPlacement() == StiPlacement.Overlay) {
            if (scale.isUp()) {
                radius1 = radius - (scaleStartWidth + scaleRest * value1 - startWidth) / 2.0;
                radius2 = radius - (scaleStartWidth + scaleRest * value2 - endWidth) / 2.0;
                radius3 = radius - (scaleStartWidth + scaleRest * value1 + startWidth) / 2.0;
                radius4 = radius - (scaleStartWidth + scaleRest * value2 + endWidth) / 2.0;
            } else {
                radius1 = radius - (scaleStartWidth - scaleRest * value1 - startWidth) / 2.0;
                radius2 = radius - (scaleStartWidth - scaleRest * value2 - endWidth) / 2.0;
                radius3 = radius - (scaleStartWidth - scaleRest * value1 + startWidth) / 2.0;
                radius4 = radius - (scaleStartWidth - scaleRest * value2 + endWidth) / 2.0;
            }
        } else if (scale.isUp()) {
            radius1 = radius - (scaleStartWidth + scaleRest * value1);
            radius2 = radius - (scaleStartWidth + scaleRest * value2);
            radius3 = radius - (scaleStartWidth + scaleRest * value1 + startWidth);
            radius4 = radius - (scaleStartWidth + scaleRest * value2 + endWidth);
        } else {
            radius1 = radius - (scaleStartWidth - scaleRest * value1);
            radius2 = radius - (scaleStartWidth - scaleRest * value2);
            radius3 = radius - (scaleStartWidth - scaleRest * value1 + startWidth);
            radius4 = radius - (scaleStartWidth - scaleRest * value2 + endWidth);
        }
        context.addRadialRangeGaugeGeom(rect, this.getBrush(), this.getBorderBrush(), this.getBorderWidth(), centerPoint, startAngle, endAngle, radius1, radius2, radius3, radius4);
    }

    @Override
    public StiRangeBase createNew() {
        return new StiRadialRange();
    }
}

