/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.tick;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.expressions.StiSkipIndicesExpression;
import com.stimulsoft.report.infographics.gauge.expressions.StiSkipValuesExpression;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeHelper;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import java.util.Arrays;
import java.util.TreeMap;

public abstract class StiTickBase
extends StiGaugeElement {
    private StiSkipValuesExpression skipValues = new StiSkipValuesExpression();
    private StiSkipIndicesExpression skipIndices = new StiSkipIndicesExpression();
    private StiPlacement placement = StiPlacement.Outside;
    private double[] skipValuesObj = null;
    private double[] skipIndicesObj = null;
    private double offset = 0.0;
    private Double minimumValue = null;
    private Double maximumValue = null;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyJObject("SkipValues", this.getSkipValues().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("SkipIndices", this.getSkipIndices().SaveToJsonObject(mode));
        jObject.AddPropertyEnum("Placement", (Enum)this.getPlacement());
        jObject.AddPropertyDouble("Offset", this.getOffset(), 0.0);
        jObject.AddPropertyDouble("MinimumValue", this.minimumValue.doubleValue(), 0.0);
        jObject.AddPropertyDouble("MaximumValue", this.maximumValue.doubleValue(), 0.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("SkipValues".equals(property.Name)) {
                StiSkipValuesExpression skipValuesExspression = new StiSkipValuesExpression();
                skipValuesExspression.LoadFromJsonObject((JSONObject)property.Value);
                this.setSkipValues(skipValuesExspression);
                continue;
            }
            if ("SkipIndices".equals(property.Name)) {
                StiSkipIndicesExpression skipIndices = new StiSkipIndicesExpression();
                skipIndices.LoadFromJsonObject((JSONObject)property.Value);
                this.setSkipIndices(skipIndices);
                continue;
            }
            if ("Placement".equals(property.Name)) {
                this.setPlacement(StiPlacement.valueOf(property.Value.toString()));
                continue;
            }
            if ("Offset".equals(property.Name)) {
                this.setOffset((Double)property.Value);
                continue;
            }
            if ("MinimumValue".equals(property.Name)) {
                this.setMinimumValue((Double)property.Value);
                continue;
            }
            if (!"MaximumValue".equals(property.Name)) continue;
            this.setMaximumValue((Double)property.Value);
        }
    }

    @Override
    public Object clone() {
        StiTickBase tick = (StiTickBase)super.clone();
        tick.skipValues = this.skipValues != null ? (StiSkipValuesExpression)this.skipValues.clone() : null;
        tick.skipIndices = this.skipIndices != null ? (StiSkipIndicesExpression)this.skipIndices.clone() : null;
        tick.placement = this.placement;
        tick.offset = this.offset;
        tick.minimumValue = this.minimumValue;
        tick.maximumValue = this.maximumValue;
        tick.skipIndicesObj = this.skipIndicesObj != null ? Arrays.copyOf(this.skipIndicesObj, this.skipIndicesObj.length) : null;
        tick.skipValuesObj = this.skipValuesObj != null ? Arrays.copyOf(this.skipValuesObj, this.skipValuesObj.length) : null;
        return tick;
    }

    @StiSerializable
    public StiSkipValuesExpression getSkipValues() {
        return this.skipValues;
    }

    public void setSkipValues(StiSkipValuesExpression skipValues) {
        this.skipValues = skipValues;
    }

    @StiSerializable
    public StiSkipIndicesExpression getSkipIndices() {
        return this.skipIndices;
    }

    public void setSkipIndices(StiSkipIndicesExpression skipIndices) {
        this.skipIndices = skipIndices;
    }

    @StiSerializable
    public StiPlacement getPlacement() {
        return this.placement;
    }

    public void setPlacement(StiPlacement placement) {
        this.placement = placement;
    }

    @StiSerializable
    public double[] getSkipValuesObj() {
        return this.skipValuesObj;
    }

    public void setSkipValuesObj(double[] skipValuesObj) {
        this.skipValuesObj = skipValuesObj;
    }

    @StiSerializable
    public double[] getSkipIndicesObj() {
        return this.skipIndicesObj;
    }

    public void setSkipIndicesObj(double[] skipIndicesObj) {
        this.skipIndicesObj = skipIndicesObj;
    }

    @StiSerializable
    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    @StiSerializable
    public Double getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(Double minimumValue) {
        this.minimumValue = minimumValue;
    }

    @StiSerializable
    public Double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(Double maximumValue) {
        this.maximumValue = maximumValue;
    }

    protected boolean isSkipMajorValues() {
        return false;
    }

    protected TreeMap<Double, Double> getPointCollection() {
        return null;
    }

    protected TreeMap<Double, Double> getMinorCollections() {
        TreeMap<Double, Double> minorCollection = new TreeMap<Double, Double>();
        TreeMap<Double, Double> majorCollection = !this.isSkipMajorValues() ? null : this.getMajorCollections();
        double minorInterval = this.scale.getMinorInterval();
        if (minorInterval == 0.0) {
            minorInterval = 1.0;
        }
        double minimum = this.scale.scaleHelper.ActualMinimum;
        double maximum = this.scale.scaleHelper.ActualMaximum;
        double length = this.scale.scaleHelper.getTotalLength();
        double index = minimum;
        double step = minorInterval;
        double offset = 0.0;
        minorCollection.put(index, 0.0);
        double proportion = length / 100.0;
        index += minorInterval;
        while (index <= maximum) {
            minorCollection.put(index, (offset += step) / proportion * 0.01);
            index += minorInterval;
        }
        if (majorCollection != null) {
            for (Double key : majorCollection.keySet()) {
                if (!minorCollection.containsKey(key)) continue;
                minorCollection.remove(key);
            }
        }
        return minorCollection;
    }

    protected TreeMap<Double, Double> getMajorCollections() {
        TreeMap<Double, Double> majorCollection = new TreeMap<Double, Double>();
        double majorInterval = this.scale.getMajorInterval();
        if (majorInterval == 0.0) {
            majorInterval = 1.0;
        }
        double minimum = this.scale.scaleHelper.ActualMinimum;
        double maximum = this.scale.scaleHelper.ActualMaximum;
        double length = this.scale.scaleHelper.getTotalLength();
        double step = majorInterval;
        double index = minimum;
        double offset = 0.0;
        majorCollection.put(index, 0.0);
        double proportion = length / 100.0;
        index += majorInterval;
        while (index <= maximum) {
            majorCollection.put(index, (offset += step) / proportion * 0.01);
            index += majorInterval;
        }
        return majorCollection;
    }

    protected boolean checkTickValue(double[] skipValues, double[] skipIndices, double key, int value) {
        int index;
        if (skipIndices != null) {
            for (index = 0; index < skipIndices.length; ++index) {
                if (skipIndices[index] != (double)value) continue;
                return true;
            }
        }
        if (skipValues != null) {
            for (index = 0; index < skipValues.length; ++index) {
                if (skipValues[index] != key) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void prepareGaugeElement() {
        StiGetValueEventArgs e1 = new StiGetValueEventArgs();
        this.skipValuesObj = StiGaugeHelper.getFloatArrayValueFromString(e1.getValue());
        StiGetValueEventArgs e2 = new StiGetValueEventArgs();
        this.skipIndicesObj = StiGaugeHelper.getFloatArrayValueFromString(e2.getValue());
    }

    protected double getOffset(Double value) {
        return value == null ? this.getOffset() : value.doubleValue();
    }

    protected StiPlacement getPlacement(StiPlacement value) {
        return value == null ? this.getPlacement() : value;
    }
}

