/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.tick;

import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.enums.StiOrientation;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.helpers.StiRectangleHelper;
import com.stimulsoft.report.infographics.gauge.primitives.tick.StiTickMarkBase;
import com.stimulsoft.report.infographics.gauge.scales.StiLinearScale;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import java.util.TreeMap;

public class StiLinearTickMarkBase
extends StiTickMarkBase {
    @Override
    public void drawElement(StiGaugeContextPainter context) {
        double scaleOffset;
        double distance;
        boolean isUp;
        StiLinearScale linearScale;
        StiLinearScale stiLinearScale = linearScale = this.scale instanceof StiLinearScale ? (StiLinearScale)this.scale : null;
        if (linearScale == null) {
            return;
        }
        StiSize size = linearScale.barGeometry.getSize();
        StiRectangle rect = linearScale.barGeometry.getRectGeometry();
        TreeMap<Double, Double> collection = this.getPointCollection();
        if (collection.size() == 0) {
            return;
        }
        double[] skipValues = super.getSkipValuesObj();
        double[] skipIndices = super.getSkipIndicesObj();
        StiGaugeElementSkin skin = this.getActualSkin();
        double startValue = this.scale.scaleHelper.ActualMinimum;
        double endValue = this.scale.scaleHelper.ActualMaximum;
        boolean bl = isUp = linearScale.getStartWidth() < linearScale.getEndWidth();
        if (linearScale.getOrientation() == StiOrientation.Horizontal) {
            distance = rect.getWidth();
            scaleOffset = size.getHeight();
        } else {
            distance = rect.getHeight();
            scaleOffset = size.getWidth();
        }
        double rest = linearScale.barGeometry.getRestToLenght();
        scaleOffset *= super.getOffset();
        double tickWidth = size.getWidth() * this.getRelativeWidth();
        double tickHeight = size.getHeight() * this.getRelativeHeight();
        int index = -1;
        for (double key : collection.keySet()) {
            double restValue;
            double top;
            double left;
            if (key < startValue || key > endValue || this.checkTickValue(skipValues, skipIndices, key, ++index) || this.getMinimumValue() != null && key < this.getMinimumValue() || this.getMaximumValue() != null && key > this.getMaximumValue()) continue;
            double offsetByValue = collection.get(key) * distance;
            if (linearScale.getOrientation() == StiOrientation.Horizontal) {
                double d = left = linearScale.getIsReversed() ? rect.getRight() - offsetByValue - tickWidth : rect.getLeft() + offsetByValue - tickWidth / 2.0;
                if (this.getPlacement() == StiPlacement.Overlay) {
                    top = StiRectangleHelper.centerY(rect) - tickHeight / 2.0 - scaleOffset;
                } else {
                    double d2 = restValue = isUp ? (1.0 - collection.get(key)) * rest : rest * collection.get(key);
                    top = this.getPlacement() == StiPlacement.Outside ? rect.getTop() - tickHeight - scaleOffset + restValue : rect.getBottom() + scaleOffset - restValue;
                }
            } else {
                double d = top = linearScale.getIsReversed() ? rect.getTop() + offsetByValue - tickHeight / 2.0 : rect.getBottom() - offsetByValue - tickHeight / 2.0;
                if (this.getPlacement() == StiPlacement.Overlay) {
                    left = StiRectangleHelper.centerX(rect) - tickWidth / 2.0 - scaleOffset;
                } else {
                    restValue = isUp ? (1.0 - collection.get(key)) * rest : rest * collection.get(key);
                    left = this.getPlacement() == StiPlacement.Outside ? rect.getLeft() - tickWidth - 3.0 - scaleOffset + restValue : rect.getRight() + scaleOffset + 3.0 - restValue;
                }
            }
            skin.draw(context, this, new StiRectangle((double)Math.round(left), (double)Math.round(top), Math.ceil(tickWidth), Math.ceil(tickHeight)));
        }
    }
}

