/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.scalebargeometry;

import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.enums.StiOrientation;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.helpers.StiMathHelper;
import com.stimulsoft.report.infographics.gauge.helpers.StiRectangleHelper;
import com.stimulsoft.report.infographics.gauge.interfaces.IStiScaleBarGeometry;
import com.stimulsoft.report.infographics.gauge.scales.StiLinearScale;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathLinesGaugeGeom;

public class StiLinearBarGeometry
implements IStiScaleBarGeometry {
    private final StiLinearScale scale;
    private StiSize size = new StiSize(0, 0);
    private StiRectangle rectGeometry = StiRectangle.getEmpty();
    private StiPoint center = new StiPoint(0.0, 0.0);

    @Override
    public StiSize getSize() {
        return this.size;
    }

    @Override
    public StiRectangle getRectGeometry() {
        return this.rectGeometry;
    }

    @Override
    public double getRadius() {
        return 0.0;
    }

    @Override
    public double getDiameter() {
        return 0.0;
    }

    @Override
    public StiPoint getCenter() {
        return this.center;
    }

    @Override
    public void checkRectGeometry(StiRectangle rect) {
        this.size = rect.getSize();
        StiRefObject startWidth = new StiRefObject((Object)0.0);
        StiRefObject endWidth = new StiRefObject((Object)0.0);
        this.checkMinMaxWidth((StiRefObject<Double>)startWidth, (StiRefObject<Double>)endWidth);
        this.rectGeometry = this.getRectGeometry(rect, (Double)startWidth.argvalue > (Double)endWidth.argvalue ? (Double)startWidth.argvalue : (Double)endWidth.argvalue);
        this.center = new StiPoint(this.rectGeometry.getLeft() + this.rectGeometry.width / 2.0, this.rectGeometry.getTop() + this.rectGeometry.height / 2.0);
    }

    private StiRectangle getRectGeometry(StiRectangle rect, double value) {
        double height;
        double width;
        if (this.scale.getOrientation() == StiOrientation.Horizontal) {
            width = this.size.width * this.scale.getRelativeHeight();
            height = this.size.height * value;
        } else {
            height = this.size.height * this.scale.getRelativeHeight();
            width = this.size.width * value;
        }
        return new StiRectangle(rect.x + (this.size.width - width) / 2.0, rect.y + (this.size.height - height) / 2.0, width, height);
    }

    @Override
    public double getRestToLenght() {
        double value = Math.abs(this.scale.getStartWidth() - this.scale.getEndWidth());
        if (this.scale.getOrientation() == StiOrientation.Horizontal) {
            return this.size.height * value / 2.0;
        }
        return this.size.width * value / 2.0;
    }

    private void checkMinMaxWidth(StiRefObject<Double> startWidth, StiRefObject<Double> endWidth) {
        if (this.scale.getIsReversed()) {
            startWidth.argvalue = this.scale.getEndWidth();
            endWidth.argvalue = this.scale.getStartWidth();
        } else {
            startWidth.argvalue = this.scale.getStartWidth();
            endWidth.argvalue = this.scale.getEndWidth();
        }
    }

    @Override
    public void drawScaleGeometry(StiGaugeContextPainter context) {
        StiRefObject startValue = new StiRefObject((Object)0.0);
        StiRefObject endValue = new StiRefObject((Object)0.0);
        this.checkMinMaxWidth((StiRefObject<Double>)startValue, (StiRefObject<Double>)endValue);
        StiPoint[] points = new StiPoint[4];
        if (this.scale.getOrientation() == StiOrientation.Horizontal) {
            double offsetY = this.size.height;
            offsetY *= ((Double)startValue.argvalue < (Double)endValue.argvalue ? (Double)startValue.argvalue : (Double)endValue.argvalue).doubleValue();
            offsetY = (this.rectGeometry.height - offsetY) / 2.0;
            if ((Double)startValue.argvalue > (Double)endValue.argvalue) {
                points[0] = new StiPoint(this.rectGeometry.getLeft(), this.rectGeometry.getTop());
                points[1] = new StiPoint(this.rectGeometry.getRight(), this.rectGeometry.getTop() + offsetY);
                points[2] = new StiPoint(this.rectGeometry.getRight(), this.rectGeometry.getBottom() - offsetY);
                points[3] = new StiPoint(this.rectGeometry.getLeft(), this.rectGeometry.getBottom());
            } else {
                points[0] = new StiPoint(this.rectGeometry.getLeft(), this.rectGeometry.getTop() + offsetY);
                points[1] = new StiPoint(this.rectGeometry.getLeft(), this.rectGeometry.getBottom() - offsetY);
                points[2] = new StiPoint(this.rectGeometry.getRight(), this.rectGeometry.getBottom());
                points[3] = new StiPoint(this.rectGeometry.getRight(), this.rectGeometry.getTop());
            }
        } else {
            double offsetX = this.size.width;
            offsetX *= ((Double)startValue.argvalue < (Double)endValue.argvalue ? (Double)startValue.argvalue : (Double)endValue.argvalue).doubleValue();
            offsetX = (this.rectGeometry.width - offsetX) / 2.0;
            if ((Double)startValue.argvalue > (Double)endValue.argvalue) {
                points[0] = new StiPoint(this.rectGeometry.getLeft() + offsetX, this.rectGeometry.getTop());
                points[1] = new StiPoint(this.rectGeometry.getLeft(), this.rectGeometry.getBottom());
                points[2] = new StiPoint(this.rectGeometry.getRight(), this.rectGeometry.getBottom());
                points[3] = new StiPoint(this.rectGeometry.getRight() - offsetX, this.rectGeometry.getTop());
            } else {
                points[0] = new StiPoint(this.rectGeometry.getLeft(), this.rectGeometry.getTop());
                points[1] = new StiPoint(this.rectGeometry.getLeft() + offsetX, this.rectGeometry.getBottom());
                points[2] = new StiPoint(this.rectGeometry.getRight() - offsetX, this.rectGeometry.getBottom());
                points[3] = new StiPoint(this.rectGeometry.getRight(), this.rectGeometry.getTop());
            }
        }
        StiGraphicsPathGaugeGeom pathGeom = new StiGraphicsPathGaugeGeom(this.rectGeometry, points[0], this.scale.getBrush(), this.scale.getBorderBrush(), 1.0);
        pathGeom.addGraphicsPathLinesGaugeGeom(points);
        pathGeom.addGraphicsPathCloseFigureGaugeGeom();
        context.addGraphicsPathGaugeGeom(pathGeom);
    }

    @Override
    public StiGraphicsPathLinesGaugeGeom drawGeometry(StiGaugeContextPainter context, double StartValue, double EndValue, double StartWidth, double EndWidth, double Offset, StiPlacement Placement, StiRefObject<StiRectangle> rect, boolean returnOnlyRect) {
        double actualMinAscent;
        double step;
        double length2;
        double length1;
        StiRectangle rectGeometry = this.rectGeometry.clone();
        rect.argvalue = rectGeometry;
        if (((StiRectangle)rect.argvalue).width == 0.0 || ((StiRectangle)rect.argvalue).height == 0.0) {
            return null;
        }
        double startValue = StartValue;
        double endValue = EndValue;
        if (startValue == endValue) {
            return null;
        }
        double minimum = this.scale.scaleHelper.ActualMinimum;
        double maximum = this.scale.scaleHelper.ActualMaximum;
        double length = this.scale.scaleHelper.getTotalLength();
        if (startValue <= minimum && endValue <= minimum || startValue >= maximum && endValue >= maximum) {
            return null;
        }
        if (startValue < endValue) {
            if (startValue < minimum) {
                startValue = minimum;
            }
            if (endValue > maximum) {
                endValue = maximum;
            }
            length1 = StiMathHelper.length(minimum, startValue);
            length2 = StiMathHelper.length(startValue, endValue);
        } else {
            if (startValue < minimum) {
                startValue = minimum;
            }
            if (endValue > maximum) {
                endValue = maximum;
            }
            length1 = StiMathHelper.length(minimum, endValue);
            length2 = StiMathHelper.length(endValue, startValue);
        }
        if (this.scale.getOrientation() == StiOrientation.Horizontal) {
            step = ((StiRectangle)rect.argvalue).width / length;
            double offset1 = length1 * step;
            double offset2 = length2 * step;
            if (this.scale.getIsReversed()) {
                ((StiRectangle)rect.argvalue).x = ((StiRectangle)rect.argvalue).getRight() - (offset1 + offset2);
                ((StiRectangle)rect.argvalue).width = offset2;
            } else {
                ((StiRectangle)rect.argvalue).x += offset1;
                ((StiRectangle)rect.argvalue).width = offset2;
            }
        } else {
            step = ((StiRectangle)rect.argvalue).height / length;
            double offset1 = length1 * step;
            double offset2 = length2 * step;
            if (this.scale.getIsReversed()) {
                ((StiRectangle)rect.argvalue).y += offset1;
                ((StiRectangle)rect.argvalue).height = offset2;
            } else {
                ((StiRectangle)rect.argvalue).y += ((StiRectangle)rect.argvalue).height - (offset1 + offset2);
                ((StiRectangle)rect.argvalue).height = offset2;
            }
        }
        boolean isStartGreaterEnd = this.scale.getStartWidth() > this.scale.getEndWidth();
        double restToLength = this.scale.barGeometry.getRestToLenght();
        double offsetMax = length1 / length;
        double offsetMin = (length1 + length2) / length;
        if (!isStartGreaterEnd) {
            offsetMax = 1.0 - offsetMax;
            offsetMin = 1.0 - offsetMin;
        }
        double offsetRest = isStartGreaterEnd ? offsetMin - offsetMax : (offsetMax *= restToLength) - (offsetMin *= restToLength);
        double actualMaxAscent = 0.0;
        if (this.scale.getOrientation() == StiOrientation.Horizontal) {
            actualMinAscent = this.size.height * Math.min(StartWidth, EndWidth);
            actualMaxAscent = this.size.height * Math.max(StartWidth, EndWidth);
            double offsetY = this.size.height * Offset;
            if (isStartGreaterEnd) {
                switch (Placement) {
                    case Outside: {
                        ((StiRectangle)rect.argvalue).y -= actualMaxAscent - offsetMin + offsetRest;
                        ((StiRectangle)rect.argvalue).height = actualMaxAscent + offsetRest;
                        ((StiRectangle)rect.argvalue).y -= offsetY;
                        break;
                    }
                    case Overlay: {
                        ((StiRectangle)rect.argvalue).y = StiRectangleHelper.centerY((StiRectangle)rect.argvalue) - actualMaxAscent / 2.0;
                        ((StiRectangle)rect.argvalue).height = actualMaxAscent;
                        ((StiRectangle)rect.argvalue).y += offsetY;
                        break;
                    }
                    case Inside: {
                        ((StiRectangle)rect.argvalue).y += ((StiRectangle)rect.argvalue).height - offsetMin;
                        ((StiRectangle)rect.argvalue).height = actualMaxAscent + offsetRest;
                        ((StiRectangle)rect.argvalue).y += offsetY;
                    }
                }
            } else {
                switch (Placement) {
                    case Outside: {
                        ((StiRectangle)rect.argvalue).y -= actualMaxAscent - offsetMax + offsetRest;
                        ((StiRectangle)rect.argvalue).height = actualMaxAscent + offsetRest;
                        ((StiRectangle)rect.argvalue).y -= offsetY;
                        break;
                    }
                    case Overlay: {
                        ((StiRectangle)rect.argvalue).y = StiRectangleHelper.centerY((StiRectangle)rect.argvalue) - actualMaxAscent / 2.0;
                        ((StiRectangle)rect.argvalue).height = actualMaxAscent;
                        ((StiRectangle)rect.argvalue).y += offsetY;
                        break;
                    }
                    case Inside: {
                        ((StiRectangle)rect.argvalue).y += ((StiRectangle)rect.argvalue).height - offsetMax;
                        ((StiRectangle)rect.argvalue).height = actualMaxAscent + offsetRest;
                        ((StiRectangle)rect.argvalue).y += offsetY;
                    }
                }
            }
        } else {
            actualMinAscent = this.size.width * Math.min(StartWidth, EndWidth);
            actualMaxAscent = this.size.width * Math.max(StartWidth, EndWidth);
            double offsetX = this.size.width * Offset;
            if (isStartGreaterEnd) {
                switch (Placement) {
                    case Outside: {
                        ((StiRectangle)rect.argvalue).x -= actualMaxAscent - offsetMin + offsetRest;
                        ((StiRectangle)rect.argvalue).width = actualMaxAscent + offsetRest;
                        ((StiRectangle)rect.argvalue).x -= offsetX;
                        break;
                    }
                    case Overlay: {
                        ((StiRectangle)rect.argvalue).x = StiRectangleHelper.centerX((StiRectangle)rect.argvalue) - actualMaxAscent / 2.0;
                        ((StiRectangle)rect.argvalue).width = actualMaxAscent;
                        ((StiRectangle)rect.argvalue).x += offsetX;
                        break;
                    }
                    case Inside: {
                        ((StiRectangle)rect.argvalue).x += ((StiRectangle)rect.argvalue).width - offsetMin;
                        ((StiRectangle)rect.argvalue).width = actualMaxAscent + offsetRest;
                        ((StiRectangle)rect.argvalue).x += offsetX;
                    }
                }
            } else {
                switch (Placement) {
                    case Outside: {
                        ((StiRectangle)rect.argvalue).x -= actualMaxAscent - offsetMax + offsetRest;
                        ((StiRectangle)rect.argvalue).width = actualMaxAscent + offsetRest;
                        ((StiRectangle)rect.argvalue).x -= offsetX;
                        break;
                    }
                    case Overlay: {
                        ((StiRectangle)rect.argvalue).x = StiRectangleHelper.centerX((StiRectangle)rect.argvalue) - actualMaxAscent / 2.0;
                        ((StiRectangle)rect.argvalue).width = actualMaxAscent;
                        ((StiRectangle)rect.argvalue).x += offsetX;
                        break;
                    }
                    case Inside: {
                        ((StiRectangle)rect.argvalue).x += ((StiRectangle)rect.argvalue).width - offsetMax;
                        ((StiRectangle)rect.argvalue).width = actualMaxAscent + offsetRest;
                        ((StiRectangle)rect.argvalue).x += offsetX;
                    }
                }
            }
        }
        return returnOnlyRect ? null : this.drawPrimitiveGeometry(context, ((StiRectangle)rect.argvalue).clone(), actualMinAscent, actualMaxAscent, StartWidth, EndWidth, Placement, offsetRest, isStartGreaterEnd);
    }

    public StiGraphicsPathLinesGaugeGeom drawPrimitiveGeometry(StiGaugeContextPainter context, StiRectangle rect, double minAscent, double maxAscent, double StartWidth, double EndWidth, StiPlacement Placement, double restOffset, boolean isStartGreaterEnd) {
        StiRectangle rect1 = rect.clone();
        rect.x = 0.0;
        rect.y = 0.0;
        StiPoint[] points = new StiPoint[4];
        if (this.scale.getStartWidth() == this.scale.getEndWidth() && minAscent == maxAscent) {
            points[0] = new StiPoint(rect.getLeft(), rect.getTop());
            points[1] = new StiPoint(rect.getRight(), rect.getTop());
            points[2] = new StiPoint(rect.getRight(), rect.getBottom());
            points[3] = new StiPoint(rect.getLeft(), rect.getBottom());
        } else {
            boolean isRangeUp;
            boolean isBarUp = this.scale.getStartWidth() < this.scale.getEndWidth();
            boolean bl = isRangeUp = StartWidth <= EndWidth;
            if (this.scale.getIsReversed()) {
                isBarUp = !isBarUp;
                boolean bl2 = isRangeUp = !isRangeUp;
            }
            if (this.scale.getOrientation() == StiOrientation.Horizontal) {
                if (isBarUp) {
                    if (isRangeUp) {
                        switch (Placement) {
                            case Outside: {
                                points[0] = new StiPoint(0.0, rect.height - minAscent);
                                points[1] = new StiPoint(rect.width, rect.height - restOffset - maxAscent);
                                points[2] = new StiPoint(rect.width, rect.height - restOffset);
                                points[3] = new StiPoint(0.0, rect.height);
                                break;
                            }
                            case Overlay: {
                                points[0] = new StiPoint(0.0, StiRectangleHelper.centerY(rect) - minAscent / 2.0);
                                points[1] = new StiPoint(rect.width, StiRectangleHelper.centerY(rect) - maxAscent / 2.0);
                                points[2] = new StiPoint(rect.width, StiRectangleHelper.centerY(rect) + maxAscent / 2.0);
                                points[3] = new StiPoint(0.0, StiRectangleHelper.centerY(rect) + minAscent / 2.0);
                                break;
                            }
                            default: {
                                points[0] = new StiPoint(0.0, 0.0);
                                points[1] = new StiPoint(rect.width, restOffset);
                                points[2] = new StiPoint(rect.width, restOffset + maxAscent);
                                points[3] = new StiPoint(0.0, minAscent);
                                break;
                            }
                        }
                    } else {
                        switch (Placement) {
                            case Outside: {
                                points[0] = new StiPoint(0.0, rect.height - maxAscent);
                                points[1] = new StiPoint(rect.width, rect.height - restOffset - minAscent);
                                points[2] = new StiPoint(rect.width, rect.height - restOffset);
                                points[3] = new StiPoint(0.0, rect.height);
                                break;
                            }
                            case Overlay: {
                                points[0] = new StiPoint(0.0, StiRectangleHelper.centerY(rect) - maxAscent / 2.0);
                                points[1] = new StiPoint(rect.width, StiRectangleHelper.centerY(rect) - minAscent / 2.0);
                                points[2] = new StiPoint(rect.width, StiRectangleHelper.centerY(rect) + minAscent / 2.0);
                                points[3] = new StiPoint(0.0, StiRectangleHelper.centerY(rect) + maxAscent / 2.0);
                                break;
                            }
                            default: {
                                points[0] = new StiPoint(0.0, 0.0);
                                points[1] = new StiPoint(rect.width, restOffset);
                                points[2] = new StiPoint(rect.width, restOffset + minAscent);
                                points[3] = new StiPoint(0.0, maxAscent);
                                break;
                            }
                        }
                    }
                } else if (isRangeUp) {
                    switch (Placement) {
                        case Outside: {
                            points[0] = new StiPoint(0.0, rect.height - restOffset - minAscent);
                            points[1] = new StiPoint(rect.width, rect.height - maxAscent);
                            points[2] = new StiPoint(rect.width, rect.height);
                            points[3] = new StiPoint(0.0, rect.height - restOffset);
                            break;
                        }
                        case Overlay: {
                            points[0] = new StiPoint(0.0, StiRectangleHelper.centerY(rect) - minAscent / 2.0);
                            points[1] = new StiPoint(rect.getRight(), StiRectangleHelper.centerY(rect) - maxAscent / 2.0);
                            points[2] = new StiPoint(rect.getRight(), StiRectangleHelper.centerY(rect) + maxAscent / 2.0);
                            points[3] = new StiPoint(0.0, StiRectangleHelper.centerY(rect) + minAscent / 2.0);
                            break;
                        }
                        default: {
                            points[0] = new StiPoint(0.0, restOffset);
                            points[1] = new StiPoint(rect.getRight(), 0.0);
                            points[2] = new StiPoint(rect.getRight(), maxAscent);
                            points[3] = new StiPoint(0.0, restOffset + minAscent);
                            break;
                        }
                    }
                } else {
                    switch (Placement) {
                        case Outside: {
                            points[0] = new StiPoint(0.0, rect.height - restOffset - maxAscent);
                            points[1] = new StiPoint(rect.getRight(), rect.height - minAscent);
                            points[2] = new StiPoint(rect.getRight(), rect.height);
                            points[3] = new StiPoint(0.0, rect.height - restOffset);
                            break;
                        }
                        case Overlay: {
                            points[0] = new StiPoint(0.0, StiRectangleHelper.centerY(rect) - maxAscent / 2.0);
                            points[1] = new StiPoint(rect.getRight(), StiRectangleHelper.centerY(rect) - minAscent / 2.0);
                            points[2] = new StiPoint(rect.getRight(), StiRectangleHelper.centerY(rect) + minAscent / 2.0);
                            points[3] = new StiPoint(0.0, StiRectangleHelper.centerY(rect) + maxAscent / 2.0);
                            break;
                        }
                        default: {
                            points[0] = new StiPoint(0.0, restOffset);
                            points[1] = new StiPoint(rect.getRight(), 0.0);
                            points[2] = new StiPoint(rect.getRight(), minAscent);
                            points[3] = new StiPoint(0.0, restOffset + maxAscent);
                            break;
                        }
                    }
                }
            } else if (isBarUp) {
                if (isRangeUp) {
                    switch (Placement) {
                        case Outside: {
                            points[0] = new StiPoint(rect.width - restOffset - maxAscent, 0.0);
                            points[1] = new StiPoint(rect.width - restOffset, 0.0);
                            points[2] = new StiPoint(rect.width, rect.height);
                            points[3] = new StiPoint(rect.width - minAscent, rect.height);
                            break;
                        }
                        case Overlay: {
                            points[0] = new StiPoint(StiRectangleHelper.centerX(rect) - maxAscent / 2.0, 0.0);
                            points[1] = new StiPoint(StiRectangleHelper.centerX(rect) + maxAscent / 2.0, 0.0);
                            points[2] = new StiPoint(StiRectangleHelper.centerX(rect) + minAscent / 2.0, rect.height);
                            points[3] = new StiPoint(StiRectangleHelper.centerX(rect) - minAscent / 2.0, rect.height);
                            break;
                        }
                        default: {
                            points[0] = new StiPoint(restOffset, 0.0);
                            points[1] = new StiPoint(restOffset + maxAscent, 0.0);
                            points[2] = new StiPoint(minAscent, rect.height);
                            points[3] = new StiPoint(0.0, rect.height);
                            break;
                        }
                    }
                } else {
                    switch (Placement) {
                        case Outside: {
                            points[0] = new StiPoint(rect.width - restOffset - minAscent, 0.0);
                            points[1] = new StiPoint(rect.width - restOffset, 0.0);
                            points[2] = new StiPoint(rect.width, rect.height);
                            points[3] = new StiPoint(rect.width - maxAscent, rect.height);
                            break;
                        }
                        case Overlay: {
                            points[0] = new StiPoint(StiRectangleHelper.centerX(rect) - minAscent / 2.0, 0.0);
                            points[1] = new StiPoint(StiRectangleHelper.centerX(rect) + minAscent / 2.0, 0.0);
                            points[2] = new StiPoint(StiRectangleHelper.centerX(rect) + maxAscent / 2.0, rect.height);
                            points[3] = new StiPoint(StiRectangleHelper.centerX(rect) - maxAscent / 2.0, rect.height);
                            break;
                        }
                        default: {
                            points[0] = new StiPoint(restOffset, 0.0);
                            points[1] = new StiPoint(restOffset + minAscent, 0.0);
                            points[2] = new StiPoint(maxAscent, rect.height);
                            points[3] = new StiPoint(0.0, rect.height);
                            break;
                        }
                    }
                }
            } else if (isRangeUp) {
                switch (Placement) {
                    case Outside: {
                        points[0] = new StiPoint(rect.width - maxAscent, 0.0);
                        points[1] = new StiPoint(rect.width, 0.0);
                        points[2] = new StiPoint(rect.width - restOffset, rect.height);
                        points[3] = new StiPoint(rect.width - restOffset - minAscent, rect.height);
                        break;
                    }
                    case Overlay: {
                        points[0] = new StiPoint(StiRectangleHelper.centerX(rect) - maxAscent / 2.0, 0.0);
                        points[1] = new StiPoint(StiRectangleHelper.centerX(rect) + maxAscent / 2.0, 0.0);
                        points[2] = new StiPoint(StiRectangleHelper.centerX(rect) + minAscent / 2.0, rect.height);
                        points[3] = new StiPoint(StiRectangleHelper.centerX(rect) - minAscent / 2.0, rect.height);
                        break;
                    }
                    default: {
                        points[0] = new StiPoint(rect.getLeft(), 0.0);
                        points[1] = new StiPoint(maxAscent, 0.0);
                        points[2] = new StiPoint(restOffset + minAscent, rect.height);
                        points[3] = new StiPoint(restOffset, rect.height);
                        break;
                    }
                }
            } else {
                switch (Placement) {
                    case Outside: {
                        points[0] = new StiPoint(rect.width - minAscent, 0.0);
                        points[1] = new StiPoint(rect.width, 0.0);
                        points[2] = new StiPoint(rect.width - restOffset, rect.height);
                        points[3] = new StiPoint(rect.width - restOffset - maxAscent, rect.height);
                        break;
                    }
                    case Overlay: {
                        points[0] = new StiPoint(StiRectangleHelper.centerX(rect) - minAscent / 2.0, 0.0);
                        points[1] = new StiPoint(StiRectangleHelper.centerX(rect) + minAscent / 2.0, 0.0);
                        points[2] = new StiPoint(StiRectangleHelper.centerX(rect) + maxAscent / 2.0, rect.height);
                        points[3] = new StiPoint(StiRectangleHelper.centerX(rect) - maxAscent / 2.0, rect.height);
                        break;
                    }
                    default: {
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(minAscent, 0.0);
                        points[2] = new StiPoint(restOffset + maxAscent, rect.height);
                        points[3] = new StiPoint(restOffset, rect.height);
                    }
                }
            }
        }
        points[0].x += rect1.getLeft();
        points[0].y += rect1.getTop();
        points[1].x += rect1.getLeft();
        points[1].y += rect1.getTop();
        points[2].x += rect1.getLeft();
        points[2].y += rect1.getTop();
        points[3].x += rect1.getLeft();
        points[3].y += rect1.getTop();
        return new StiGraphicsPathLinesGaugeGeom(points);
    }

    public StiLinearBarGeometry(StiLinearScale scale) {
        this.scale = scale;
    }
}

