/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.indicators;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiRotationAnimation;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.infographics.gauge.StiGaugeElemenType;
import com.stimulsoft.report.infographics.gauge.StiNeedleSkin;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeHelper;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeSkinHelper;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.indicators.StiIndicatorBase;
import com.stimulsoft.report.infographics.gauge.scales.StiRadialScale;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.infographics.gauge.styles.IStiGaugeStyle;
import com.stimulsoft.report.painters.StiGaugeContextPainter;

public class StiNeedle
extends StiIndicatorBase {
    private String format = "{0:F0}";
    private boolean showValue = false;
    private StiBrush textBrush = new StiSolidBrush(StiColorEnum.DimGray.color());
    private StiFont font = new StiFont("Arial", 7.0);
    private StiBrush capBrush = new StiSolidBrush(StiColor.fromArgb((int)158, (int)158, (int)158));
    private StiBrush capBorderBrush = new StiEmptyBrush();
    private double capBorderWidth = 0.0;
    private double offsetNeedle = 0.0;
    private double startWidth = 0.1f;
    private double endWidth = 1.0;
    private boolean autoCalculateCenterPoint = true;
    private StiPoint centerPoint = new StiPoint();
    private double relativeHeight = 0.04f;
    private double relativeWidth = 0.4f;
    private StiNeedleSkin skin = StiNeedleSkin.SimpleNeedle;
    private StiGaugeElementSkin customSkin;

    public StiNeedle() {
        this.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)158, (int)158, (int)158)));
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyStringNullOfEmpty("Format", this.format);
        jObject.AddPropertyBool("ShowValue", this.showValue, false);
        jObject.AddPropertyStringNullOfEmpty("TextBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.textBrush));
        jObject.AddPropertyStringNullOfEmpty("Font", StiJsonReportObjectHelper.Serialize.font((StiFont)this.font, (String)"Arial", (float)8.0f, (int)StiFontStyle.Bold.intValue));
        jObject.AddPropertyStringNullOfEmpty("CapBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.capBrush));
        jObject.AddPropertyStringNullOfEmpty("CapBorderBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.capBorderBrush));
        jObject.AddPropertyFloat("CapBorderWidth", this.capBorderWidth, 0.0);
        jObject.AddPropertyFloat("OffsetNeedle", this.offsetNeedle, 0.0);
        jObject.AddPropertyFloat("StartWidth", this.startWidth, (double)0.1f);
        jObject.AddPropertyFloat("EndWidth", this.endWidth, 1.0);
        jObject.AddPropertyBool("AutoCalculateCenterPoint", this.autoCalculateCenterPoint, true);
        jObject.AddPropertyJObject("CenterPoint", StiJsonReportObjectHelper.Serialize.pointF((StiPoint)this.centerPoint));
        jObject.AddPropertyFloat("RelativeHeight", this.relativeHeight, (double)0.04f);
        jObject.AddPropertyFloat("RelativeWidth", this.relativeWidth, (double)0.4f);
        jObject.AddPropertyEnum("Skin", (Enum)this.skin);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("Format".equals(property.Name)) {
                this.setFormat(property.Value.toString());
                continue;
            }
            if ("ShowValue".equals(property.Name)) {
                this.setShowValue((Boolean)property.Value);
                continue;
            }
            if ("TextBrush".equals(property.Name)) {
                this.setTextBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if ("Font".equals(property.Name)) {
                this.setFont(StiJsonReportObjectHelper.Deserialize.Font((JProperty)property, (StiFont)this.font));
                continue;
            }
            if ("CapBrush".equals(property.Name)) {
                this.setCapBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if ("CapBorderBrush".equals(property.Name)) {
                this.setCapBorderBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if ("CapBorderWidth".equals(property.Name)) {
                this.setCapBorderWidth((Double)property.Value);
                continue;
            }
            if ("OffsetNeedle".equals(property.Name)) {
                this.setOffsetNeedle((Double)property.Value);
                continue;
            }
            if ("StartWidth".equals(property.Name)) {
                this.setStartWidth((Double)property.Value);
                continue;
            }
            if ("EndWidth".equals(property.Name)) {
                this.setEndWidth((Double)property.Value);
                continue;
            }
            if ("AutoCalculateCenterPoint".equals(property.Name)) {
                this.setAutoCalculateCenterPoint((Boolean)property.Value);
                continue;
            }
            if ("Center".equals(property.Name)) {
                this.setCenterPoint(StiJsonReportObjectHelper.Deserialize.PointF((JSONObject)((JSONObject)property.Value)));
                continue;
            }
            if ("RelativeHeight".equals(property.Name)) {
                this.setRelativeHeight((Double)property.Value);
                continue;
            }
            if ("RelativeWidth".equals(property.Name)) {
                this.setRelativeWidth((Double)property.Value);
                continue;
            }
            if (!"Skin".equals(property.Name)) continue;
            this.setSkin(StiNeedleSkin.valueOf(property.Value.toString()));
        }
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiNeedle;
    }

    @Override
    public void applyStyle(IStiGaugeStyle style) {
        if (this.isAllowApplyStyle()) {
            this.setBrush(style.getCore().getNeedleBrush());
            this.setBorderBrush(style.getCore().getNeedleBorderBrush());
            this.setCapBrush(style.getCore().getNeedleCapBrush());
            this.setCapBorderBrush(style.getCore().getNeedleCapBorderBrush());
            this.setBorderWidth(style.getCore().getNeedleBorderWidth());
            this.setCapBorderWidth(style.getCore().getNeedleCapBorderWidth());
            this.setStartWidth(style.getCore().getNeedleStartWidth());
            this.setEndWidth(style.getCore().getNeedleEndWidth());
            this.setRelativeHeight(style.getCore().getNeedleRelativeHeight());
            this.setRelativeWidth(style.getCore().getNeedleRelativeWith());
        }
    }

    @StiSerializable
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @StiSerializable
    public boolean isShowValue() {
        return this.showValue;
    }

    public void setShowValue(boolean showValue) {
        this.showValue = showValue;
    }

    @StiSerializable
    public StiBrush getTextBrush() {
        return this.textBrush;
    }

    public void setTextBrush(StiBrush textBrush) {
        this.textBrush = textBrush;
    }

    @StiSerializable
    public StiFont getFont() {
        return this.font;
    }

    public void setFont(StiFont font) {
        this.font = font;
    }

    @StiSerializable
    public StiBrush getCapBrush() {
        return this.capBrush;
    }

    public void setCapBrush(StiBrush capBrush) {
        this.capBrush = capBrush;
    }

    @StiSerializable
    public StiBrush getCapBorderBrush() {
        return this.capBorderBrush;
    }

    public void setCapBorderBrush(StiBrush capBorderBrush) {
        this.capBorderBrush = capBorderBrush;
    }

    @StiSerializable
    public double getCapBorderWidth() {
        return this.capBorderWidth;
    }

    public void setCapBorderWidth(double capBorderWidth) {
        this.capBorderWidth = capBorderWidth;
    }

    @StiSerializable
    public double getOffsetNeedle() {
        return this.offsetNeedle;
    }

    public void setOffsetNeedle(double offsetNeedle) {
        this.offsetNeedle = offsetNeedle;
    }

    @StiSerializable
    public double getStartWidth() {
        return this.startWidth;
    }

    public void setStartWidth(double startWidth) {
        this.startWidth = startWidth;
    }

    @StiSerializable
    public double getEndWidth() {
        return this.endWidth;
    }

    public void setEndWidth(double endWidth) {
        this.endWidth = endWidth;
    }

    @StiSerializable
    public boolean isAutoCalculateCenterPoint() {
        return this.autoCalculateCenterPoint;
    }

    public void setAutoCalculateCenterPoint(boolean autoCalculateCenterPoint) {
        this.autoCalculateCenterPoint = autoCalculateCenterPoint;
    }

    @StiSerializable
    public StiPoint getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(StiPoint centerPoint) {
        this.centerPoint = centerPoint;
    }

    @StiSerializable
    public double getRelativeHeight() {
        return this.relativeHeight;
    }

    public void setRelativeHeight(double relativeHeight) {
        this.relativeHeight = relativeHeight;
    }

    @StiSerializable
    public double getRelativeWidth() {
        return this.relativeWidth;
    }

    public void setRelativeWidth(double relativeWidth) {
        this.relativeWidth = relativeWidth;
    }

    @StiSerializable
    public StiNeedleSkin getSkin() {
        return this.skin;
    }

    public void setSkin(StiNeedleSkin skin) {
        this.skin = skin;
    }

    @StiSerializable
    public StiGaugeElementSkin getCustomSkin() {
        return this.customSkin;
    }

    public void setCustomSkin(StiGaugeElementSkin customSkin) {
        this.customSkin = customSkin;
    }

    @Override
    public StiBrush getBrush() {
        return super.getBrush();
    }

    @Override
    public void setBrush(StiBrush brush) {
        super.setBrush(brush);
    }

    @Override
    public StiGaugeElemenType getElementType() {
        return StiGaugeElemenType.RadialElement;
    }

    @Override
    public String getLocalizeName() {
        return "Needle";
    }

    @Override
    public StiGaugeElement createNew() {
        return new StiNeedle();
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        StiRadialScale radialScale;
        StiRadialScale stiRadialScale = radialScale = this.scale instanceof StiRadialScale ? (StiRadialScale)this.scale : null;
        if (radialScale == null) {
            return;
        }
        StiPoint center = this.scale.barGeometry.getCenter();
        StiSize actualSize = new StiSize(this.scale.barGeometry.getDiameter() * this.relativeWidth, this.scale.barGeometry.getDiameter() * this.relativeHeight);
        Double offsetX = 0.0;
        Double offsetY = 0.0;
        if (actualSize.width > actualSize.height) {
            offsetX = actualSize.height / 2.0;
            offsetY = actualSize.height / 2.0;
        } else {
            offsetX = actualSize.width / 2.0;
            offsetY = actualSize.height / 2.0;
        }
        double x = center.x - offsetX;
        double y = center.y - offsetY;
        StiRectangle rect = new StiRectangle(new StiPoint(x, y), actualSize);
        double angle = 0.0;
        double value = 0.0;
        try {
            value = context.gauge.isDesigning() ? Func.Convert.toSingle(StiParser.ParseTextValue("{" + this.getValue().getValue() + "}", context.gauge)) : this.getValueObj();
        }
        catch (Exception e) {
            value = 0.0;
        }
        angle = this.scale.getIsReversed() ? radialScale.getSweepAngle() - radialScale.getCurrentAngle(value) : radialScale.getCurrentAngle(value);
        double rotationAngle = -radialScale.getPosition(value) * radialScale.getSweepAngle();
        if (this.scale.getIsReversed()) {
            rotationAngle = -rotationAngle;
        }
        this.setAnimation((StiAnimation)new StiRotationAnimation(rotationAngle, 0.0, center, Integer.valueOf(StiGaugeHelper.GlobalDurationElement), Integer.valueOf(0)));
        StiGaugeElementSkin skin = this.getActualSkin();
        skin.draw(context, this, rect, angle, center);
    }

    @Override
    public void interactiveClick(StiRectangle rect, StiPoint p) {
        throw new RuntimeException("NotImplemented");
    }

    private StiPoint GetActualCenterPoint() {
        if (this.scale != null && this.scale.gauge != null) {
            if (this.autoCalculateCenterPoint) {
                StiRectangle rect1 = this.scale.gauge.getReport().getUnit().ConvertToHInches(this.scale.gauge.getClientRectangle());
                StiRectangle rect = this.scale.gauge.getClientRectangle();
                double xPos = 0.0;
                if (rect.width != 0.0) {
                    xPos = rect.height * this.relativeHeight / 2.0;
                }
                return new StiPoint(xPos, 0.5);
            }
            return this.centerPoint;
        }
        return new StiPoint();
    }

    private StiGaugeElementSkin getActualSkin() {
        return this.customSkin != null ? this.customSkin : StiGaugeSkinHelper.getNeedleIndicatorSkin(this.skin);
    }
}

