/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.helpers;

import com.stimulsoft.report.Func;
import com.stimulsoft.report.dictionary.data.DBNull;

public class StiValueHelper {
    public static Double tryToNullableDecimal(Object value) {
        if (value == null || value == DBNull.Value) {
            return null;
        }
        try {
            String str;
            String string = str = value instanceof String ? (String)value : null;
            if (str != null) {
                str = StiValueHelper.normalizeFloatingPointValue(value);
                try {
                    return Double.parseDouble(str.trim());
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (!(value instanceof Number)) {
                return null;
            }
            return Func.Convert.toDecimal(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean tryToBool(Object value) {
        try {
            if (value == null || value == DBNull.Value) {
                return false;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            Double decimalValue = StiValueHelper.tryToNullableDecimal(value);
            if (decimalValue != null) {
                return decimalValue == 1.0;
            }
            String str = value.toString();
            if (str != null) {
                return (str = str.toLowerCase()).equals("true") || str.equals("on") || str.equals("yes");
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static double tryToDecimal(Object value) {
        Double result = StiValueHelper.tryToNullableDecimal(value);
        return result == null ? 0.0 : result;
    }

    private static String normalizeFloatingPointValue(Object value) {
        return value.toString().trim().replace(",", ".");
    }
}

