/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.helpers;

import com.stimulsoft.report.dictionary.enums.StiResourceType;
import com.stimulsoft.report.helpers.StiFileDialogHelper;

public class StiResourceTypeHelper {
    public static StiResourceType getTypeFromExtension(String extension) {
        if (StiResourceTypeHelper.isImageType(extension = extension.toLowerCase())) {
            return StiResourceType.Image;
        }
        if (extension.equals(".csv")) {
            return StiResourceType.Csv;
        }
        if (extension.equals(".dbf")) {
            return StiResourceType.Dbf;
        }
        if (extension.equals(".xls") || extension.equals(".xlsx")) {
            return StiResourceType.Excel;
        }
        if (extension.equals(".json")) {
            return StiResourceType.Json;
        }
        if (extension.equals(".xml")) {
            return StiResourceType.Xml;
        }
        if (extension.equals(".xsd")) {
            return StiResourceType.Xsd;
        }
        if (extension.equals(".ttf")) {
            return StiResourceType.FontTtf;
        }
        if (extension.equals(".otf")) {
            return StiResourceType.FontOtf;
        }
        if (extension.equals(".woff")) {
            return StiResourceType.FontWoff;
        }
        if (extension.equals(".ttc")) {
            return StiResourceType.FontTtc;
        }
        if (extension.equals(".eot")) {
            return StiResourceType.FontEot;
        }
        if (extension.equals(".rtf")) {
            return StiResourceType.Rtf;
        }
        if (extension.equals(".txt")) {
            return StiResourceType.Txt;
        }
        if (extension.equals(".mrt") || extension.equals(".mrz")) {
            return StiResourceType.Report;
        }
        if (extension.equals(".mdc") || extension.equals(".mdz")) {
            return StiResourceType.ReportSnapshot;
        }
        if (extension.equals(".pdf")) {
            return StiResourceType.Pdf;
        }
        if (extension.equals(".doc") || extension.equals(".docx")) {
            return StiResourceType.Word;
        }
        return null;
    }

    public static boolean isImageType(String ext) {
        return StiResourceTypeHelper.isExtensionType(StiFileDialogHelper.ImageExts, ext);
    }

    private static boolean isExtensionType(String[] exts, String ext) {
        ext = ext.startsWith(".") ? ext.substring(1) : ext;
        ext = ext.toLowerCase();
        for (String e : exts) {
            if (!e.equals(ext)) continue;
            return true;
        }
        return false;
    }
}

