/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.helpers;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.settings.StiConfig;
import com.stimulsoft.report.helpers.StiFontIconSet;
import com.stimulsoft.report.helpers.StiFontIcons;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class StiFontIconsHelper {
    private static String fontFamilyIcons;

    public static String getContent(StiFontIcons fontIcons) {
        switch (fontIcons) {
            case ArrowDown: {
                return "\ue900";
            }
            case ArrowRight: {
                return "\ue901";
            }
            case ArrowRightDown: {
                return "\ue902";
            }
            case ArrowRightUp: {
                return "\ue903";
            }
            case ArrowUp: {
                return "\ue904";
            }
            case Check: {
                return "\ue905";
            }
            case Circle: {
                return "\ue906";
            }
            case CircleCheck: {
                return "\ue907";
            }
            case CircleCross: {
                return "\ue908";
            }
            case CircleExclamation: {
                return "\ue909";
            }
            case Cross: {
                return "\ue90a";
            }
            case Exclamation: {
                return "\ue90b";
            }
            case Flag: {
                return "\ue90c";
            }
            case Latin1: {
                return "\ue90d";
            }
            case Latin2: {
                return "\ue90e";
            }
            case Latin3: {
                return "\ue90f";
            }
            case Latin4: {
                return "\ue910";
            }
            case Latin5: {
                return "\ue92b";
            }
            case Minus: {
                return "\ue911";
            }
            case QuarterFull: {
                return "\ue912";
            }
            case QuarterHalf: {
                return "\ue913";
            }
            case QuarterNone: {
                return "\ue914";
            }
            case QuarterQuarter: {
                return "\ue915";
            }
            case QuarterThreeFourth: {
                return "\ue916";
            }
            case Rating0: {
                return "\ue917";
            }
            case Rating1: {
                return "\ue918";
            }
            case Rating2: {
                return "\ue919";
            }
            case Rating3: {
                return "\ue91a";
            }
            case Rating4: {
                return "\ue91b";
            }
            case Rhomb: {
                return "\ue91c";
            }
            case Square0: {
                return "\ue91d";
            }
            case Square1: {
                return "\ue91e";
            }
            case Square2: {
                return "\ue91f";
            }
            case Square3: {
                return "\ue920";
            }
            case Square4: {
                return "\ue921";
            }
            case StarFull: {
                return "\ue922";
            }
            case StarHalf: {
                return "\ue923";
            }
            case StarNone: {
                return "\ue924";
            }
            case StarQuarter: {
                return "\ue925";
            }
            case StarThreeFourth: {
                return "\ue926";
            }
            case Triangle: {
                return "\ue927";
            }
            case TriangleDown: {
                return "\ue928";
            }
            case TriangleUp: {
                return "\ue929";
            }
            case Home: {
                return "\ue92a";
            }
            case Cart: {
                return "\ue93a";
            }
            case Phone: {
                return "\ue942";
            }
            case UserTie: {
                return "\ue976";
            }
            case Mobile: {
                return "\ue958";
            }
            case Mug: {
                return "\ue9a2";
            }
            case Airplane: {
                return "\ue9af";
            }
            case Truck: {
                return "\ue9b0";
            }
            case Earth: {
                return "\ue9ca";
            }
            case Man: {
                return "\ue9dc";
            }
            case Woman: {
                return "\ue9dd";
            }
            case ManWoman: {
                return "\ue9de";
            }
            case Appleinc: {
                return "\ueabe";
            }
            case Windows8: {
                return "\ueac2";
            }
            case Glass: {
                return "\uf000";
            }
            case Music: {
                return "\uf001";
            }
            case Search: {
                return "\uf002";
            }
            case EnvelopeO: {
                return "\uf003";
            }
            case Heart: {
                return "\uf004";
            }
            case Star: {
                return "\uf005";
            }
            case StarO: {
                return "\uf006";
            }
            case User: {
                return "\uf007";
            }
            case Film: {
                return "\uf008";
            }
            case ThLarge: {
                return "\uf009";
            }
            case Th: {
                return "\uf00a";
            }
            case ThList: {
                return "\uf00b";
            }
            case Times: {
                return "\uf00d";
            }
            case SearchPlus: {
                return "\uf00e";
            }
            case SearchMinus: {
                return "\uf010";
            }
            case PowerOff: {
                return "\uf011";
            }
            case Signal: {
                return "\uf012";
            }
            case Cog: {
                return "\uf013";
            }
            case TrashO: {
                return "\uf014";
            }
            case FileO: {
                return "\uf016";
            }
            case ClockO: {
                return "\uf017";
            }
            case Road: {
                return "\uf018";
            }
            case Download: {
                return "\uf019";
            }
            case ArrowCircleODown: {
                return "\uf01a";
            }
            case ArrowCircleOUp: {
                return "\uf01b";
            }
            case Inbox: {
                return "\uf01c";
            }
            case PlayCircleO: {
                return "\uf01d";
            }
            case Repeat: {
                return "\uf01e";
            }
            case Refresh: {
                return "\uf021";
            }
            case ListAlt: {
                return "\uf022";
            }
            case Lock: {
                return "\uf023";
            }
            case FAFlag: {
                return "\uf024";
            }
            case Headphones: {
                return "\uf025";
            }
            case VolumeOff: {
                return "\uf026";
            }
            case VolumeDown: {
                return "\uf027";
            }
            case VolumeUp: {
                return "\uf028";
            }
            case Qrcode: {
                return "\uf029";
            }
            case Barcode: {
                return "\uf02a";
            }
            case Tag: {
                return "\uf02b";
            }
            case Tags: {
                return "\uf02c";
            }
            case Book: {
                return "\uf02d";
            }
            case Bookmark: {
                return "\uf02e";
            }
            case Print: {
                return "\uf02f";
            }
            case Camera: {
                return "\uf030";
            }
            case Font: {
                return "\uf031";
            }
            case Bold: {
                return "\uf032";
            }
            case Italic: {
                return "\uf033";
            }
            case TextHeight: {
                return "\uf034";
            }
            case TextWidth: {
                return "\uf035";
            }
            case AlignLeft: {
                return "\uf036";
            }
            case AlignCenter: {
                return "\uf037";
            }
            case AlignRight: {
                return "\uf038";
            }
            case AlignJustify: {
                return "\uf039";
            }
            case List: {
                return "\uf03a";
            }
            case Outdent: {
                return "\uf03b";
            }
            case Indent: {
                return "\uf03c";
            }
            case VideoCamera: {
                return "\uf03d";
            }
            case PictureO: {
                return "\uf03e";
            }
            case Pencil: {
                return "\uf040";
            }
            case MapMarker: {
                return "\uf041";
            }
            case Adjust: {
                return "\uf042";
            }
            case Tint: {
                return "\uf043";
            }
            case PencilSquareO: {
                return "\uf044";
            }
            case ShareSquareO: {
                return "\uf045";
            }
            case CheckSquareO: {
                return "\uf046";
            }
            case Arrows: {
                return "\uf047";
            }
            case StepBackward: {
                return "\uf048";
            }
            case FastBackward: {
                return "\uf049";
            }
            case Backward: {
                return "\uf04a";
            }
            case Play: {
                return "\uf04b";
            }
            case Pause: {
                return "\uf04c";
            }
            case Stop: {
                return "\uf04d";
            }
            case Forward: {
                return "\uf04e";
            }
            case FastForward: {
                return "\uf050";
            }
            case StepForward: {
                return "\uf051";
            }
            case Eject: {
                return "\uf052";
            }
            case ChevronLeft: {
                return "\uf053";
            }
            case ChevronRight: {
                return "\uf054";
            }
            case PlusCircle: {
                return "\uf055";
            }
            case MinusCircle: {
                return "\uf056";
            }
            case TimesCircle: {
                return "\uf057";
            }
            case CheckCircle: {
                return "\uf058";
            }
            case QuestionCircle: {
                return "\uf059";
            }
            case InfoCircle: {
                return "\uf05a";
            }
            case Crosshairs: {
                return "\uf05b";
            }
            case TimesCircleO: {
                return "\uf05c";
            }
            case CheckCircleO: {
                return "\uf05d";
            }
            case Ban: {
                return "\uf05e";
            }
            case FAArrowLeft: {
                return "\uf060";
            }
            case FAArrowRight: {
                return "\uf061";
            }
            case FAArrowUp: {
                return "\uf062";
            }
            case FAArrowDown: {
                return "\uf063";
            }
            case Share: {
                return "\uf064";
            }
            case Expand: {
                return "\uf065";
            }
            case Compress: {
                return "\uf066";
            }
            case FAPlus: {
                return "\uf067";
            }
            case FAMinus: {
                return "\uf068";
            }
            case Asterisk: {
                return "\uf069";
            }
            case ExclamationCircle: {
                return "\uf06a";
            }
            case Gift: {
                return "\uf06b";
            }
            case Leaf: {
                return "\uf06c";
            }
            case Fire: {
                return "\uf06d";
            }
            case Eye: {
                return "\uf06e";
            }
            case EyeSlash: {
                return "\uf070";
            }
            case ExclamationTriangle: {
                return "\uf071";
            }
            case Plane: {
                return "\uf072";
            }
            case Calendar: {
                return "\uf073";
            }
            case Random: {
                return "\uf074";
            }
            case Comment: {
                return "\uf075";
            }
            case Magnet: {
                return "\uf076";
            }
            case ChevronUp: {
                return "\uf077";
            }
            case ChevronDown: {
                return "\uf078";
            }
            case Retweet: {
                return "\uf079";
            }
            case ShoppingCart: {
                return "\uf07a";
            }
            case Folder: {
                return "\uf07b";
            }
            case FolderOpen: {
                return "\uf07c";
            }
            case ArrowsV: {
                return "\uf07d";
            }
            case ArrowsH: {
                return "\uf07e";
            }
            case BarChart: {
                return "\uf080";
            }
            case TwitterSquare: {
                return "\uf081";
            }
            case FacebookSquare: {
                return "\uf082";
            }
            case CameraRetro: {
                return "\uf083";
            }
            case Key: {
                return "\uf084";
            }
            case Cogs: {
                return "\uf085";
            }
            case Comments: {
                return "\uf086";
            }
            case ThumbsOUp: {
                return "\uf087";
            }
            case ThumbsODown: {
                return "\uf088";
            }
            case HeartO: {
                return "\uf08a";
            }
            case SignOut: {
                return "\uf08b";
            }
            case LinkedinSquare: {
                return "\uf08c";
            }
            case ThumbTack: {
                return "\uf08d";
            }
            case ExternalLink: {
                return "\uf08e";
            }
            case SignIn: {
                return "\uf090";
            }
            case Trophy: {
                return "\uf091";
            }
            case GithubSquare: {
                return "\uf092";
            }
            case Upload: {
                return "\uf093";
            }
            case LemonO: {
                return "\uf094";
            }
            case SquareO: {
                return "\uf096";
            }
            case BookmarkO: {
                return "\uf097";
            }
            case PhoneSquare: {
                return "\uf098";
            }
            case Twitter: {
                return "\uf099";
            }
            case Facebook: {
                return "\uf09a";
            }
            case Github: {
                return "\uf09b";
            }
            case Unlock: {
                return "\uf09c";
            }
            case CreditCard: {
                return "\uf09d";
            }
            case Rss: {
                return "\uf09e";
            }
            case HddO: {
                return "\uf0a0";
            }
            case Bullhorn: {
                return "\uf0a1";
            }
            case Bell: {
                return "\uf0f3";
            }
            case Certificate: {
                return "\uf0a3";
            }
            case HandORight: {
                return "\uf0a4";
            }
            case HandOLeft: {
                return "\uf0a5";
            }
            case HandOUp: {
                return "\uf0a6";
            }
            case HandODown: {
                return "\uf0a7";
            }
            case ArrowCircleLeft: {
                return "\uf0a8";
            }
            case ArrowCircleRight: {
                return "\uf0a9";
            }
            case ArrowCircleUp: {
                return "\uf0aa";
            }
            case ArrowCircleDown: {
                return "\uf0ab";
            }
            case Globe: {
                return "\uf0ac";
            }
            case Wrench: {
                return "\uf0ad";
            }
            case Tasks: {
                return "\uf0ae";
            }
            case Filter: {
                return "\uf0b0";
            }
            case Briefcase: {
                return "\uf0b1";
            }
            case ArrowsAlt: {
                return "\uf0b2";
            }
            case Users: {
                return "\uf0c0";
            }
            case Link: {
                return "\uf0c1";
            }
            case Cloud: {
                return "\uf0c2";
            }
            case Flask: {
                return "\uf0c3";
            }
            case Scissors: {
                return "\uf0c4";
            }
            case FilesO: {
                return "\uf0c5";
            }
            case Paperclip: {
                return "\uf0c6";
            }
            case FloppyO: {
                return "\uf0c7";
            }
            case Square: {
                return "\uf0c8";
            }
            case Bars: {
                return "\uf0c9";
            }
            case ListUl: {
                return "\uf0ca";
            }
            case ListOl: {
                return "\uf0cb";
            }
            case Strikethrough: {
                return "\uf0cc";
            }
            case Underline: {
                return "\uf0cd";
            }
            case Table: {
                return "\uf0ce";
            }
            case Magic: {
                return "\uf0d0";
            }
            case Pinterest: {
                return "\uf0d2";
            }
            case PinterestSquare: {
                return "\uf0d3";
            }
            case GooglePlusSquare: {
                return "\uf0d4";
            }
            case GooglePlus: {
                return "\uf0d5";
            }
            case Money: {
                return "\uf0d6";
            }
            case CaretDown: {
                return "\uf0d7";
            }
            case CaretUp: {
                return "\uf0d8";
            }
            case CaretLeft: {
                return "\uf0d9";
            }
            case CaretRight: {
                return "\uf0da";
            }
            case Columns: {
                return "\uf0db";
            }
            case Sort: {
                return "\uf0dc";
            }
            case SortDesc: {
                return "\uf0dd";
            }
            case SortAsc: {
                return "\uf0de";
            }
            case Envelope: {
                return "\uf0e0";
            }
            case Linkedin: {
                return "\uf0e1";
            }
            case Undo: {
                return "\uf0e2";
            }
            case Gavel: {
                return "\uf0e3";
            }
            case Tachometer: {
                return "\uf0e4";
            }
            case CommentO: {
                return "\uf0e5";
            }
            case CommentsO: {
                return "\uf0e6";
            }
            case Bolt: {
                return "\uf0e7";
            }
            case Sitemap: {
                return "\uf0e8";
            }
            case Umbrella: {
                return "\uf0e9";
            }
            case Clipboard: {
                return "\uf0ea";
            }
            case LightbulbO: {
                return "\uf0eb";
            }
            case Exchange: {
                return "\uf0ec";
            }
            case CloudDownload: {
                return "\uf0ed";
            }
            case CloudUpload: {
                return "\uf0ee";
            }
            case UserMd: {
                return "\uf0f0";
            }
            case Stethoscope: {
                return "\uf0f1";
            }
            case Suitcase: {
                return "\uf0f2";
            }
            case BellO: {
                return "\uf0a2";
            }
            case Coffee: {
                return "\uf0f4";
            }
            case Cutlery: {
                return "\uf0f5";
            }
            case FileTextO: {
                return "\uf0f6";
            }
            case BuildingO: {
                return "\uf0f7";
            }
            case HospitalO: {
                return "\uf0f8";
            }
            case Ambulance: {
                return "\uf0f9";
            }
            case Medkit: {
                return "\uf0fa";
            }
            case FighterJet: {
                return "\uf0fb";
            }
            case Beer: {
                return "\uf0fc";
            }
            case HSquare: {
                return "\uf0fd";
            }
            case PlusSquare: {
                return "\uf0fe";
            }
            case AngleDoubleLeft: {
                return "\uf100";
            }
            case AngleDoubleRight: {
                return "\uf101";
            }
            case AngleDoubleUp: {
                return "\uf102";
            }
            case AngleDoubleDown: {
                return "\uf103";
            }
            case AngleLeft: {
                return "\uf104";
            }
            case AngleRight: {
                return "\uf105";
            }
            case AngleUp: {
                return "\uf106";
            }
            case AngleDown: {
                return "\uf107";
            }
            case Desktop: {
                return "\uf108";
            }
            case Laptop: {
                return "\uf109";
            }
            case Tablet: {
                return "\uf10a";
            }
            case CircleO: {
                return "\uf10c";
            }
            case QuoteLeft: {
                return "\uf10d";
            }
            case QuoteRight: {
                return "\uf10e";
            }
            case Spinner: {
                return "\uf110";
            }
            case Reply: {
                return "\uf112";
            }
            case GithubAlt: {
                return "\uf113";
            }
            case FolderO: {
                return "\uf114";
            }
            case FolderOpenO: {
                return "\uf115";
            }
            case SmileO: {
                return "\uf118";
            }
            case FrownO: {
                return "\uf119";
            }
            case MehO: {
                return "\uf11a";
            }
            case Gamepad: {
                return "\uf11b";
            }
            case KeyboardO: {
                return "\uf11c";
            }
            case FlagO: {
                return "\uf11d";
            }
            case FlagCheckered: {
                return "\uf11e";
            }
            case Terminal: {
                return "\uf120";
            }
            case Code: {
                return "\uf121";
            }
            case ReplyAll: {
                return "\uf122";
            }
            case StarHalfO: {
                return "\uf123";
            }
            case LocationArrow: {
                return "\uf124";
            }
            case Crop: {
                return "\uf125";
            }
            case CodeFork: {
                return "\uf126";
            }
            case ChainBroken: {
                return "\uf127";
            }
            case Question: {
                return "\uf128";
            }
            case Info: {
                return "\uf129";
            }
            case Superscript: {
                return "\uf12b";
            }
            case Subscript: {
                return "\uf12c";
            }
            case Eraser: {
                return "\uf12d";
            }
            case PuzzlePiece: {
                return "\uf12e";
            }
            case Microphone: {
                return "\uf130";
            }
            case MicrophoneSlash: {
                return "\uf131";
            }
            case Shield: {
                return "\uf132";
            }
            case CalendarO: {
                return "\uf133";
            }
            case FireExtinguisher: {
                return "\uf134";
            }
            case Rocket: {
                return "\uf135";
            }
            case Maxcdn: {
                return "\uf136";
            }
            case ChevronCircleLeft: {
                return "\uf137";
            }
            case ChevronCircleRight: {
                return "\uf138";
            }
            case ChevronCircleUp: {
                return "\uf139";
            }
            case ChevronCircleDown: {
                return "\uf13a";
            }
            case Html5: {
                return "\uf13b";
            }
            case Css3: {
                return "\uf13c";
            }
            case Anchor: {
                return "\uf13d";
            }
            case UnlockAlt: {
                return "\uf13e";
            }
            case Bullseye: {
                return "\uf140";
            }
            case EllipsisH: {
                return "\uf141";
            }
            case EllipsisV: {
                return "\uf142";
            }
            case RssSquare: {
                return "\uf143";
            }
            case PlayCircle: {
                return "\uf144";
            }
            case Ticket: {
                return "\uf145";
            }
            case MinusSquare: {
                return "\uf146";
            }
            case InusSquareO: {
                return "\uf147";
            }
            case LevelUp: {
                return "\uf148";
            }
            case LevelDown: {
                return "\uf149";
            }
            case CheckSquare: {
                return "\uf14a";
            }
            case PencilSquare: {
                return "\uf14b";
            }
            case ExternalLinkSquare: {
                return "\uf14c";
            }
            case ShareSquare: {
                return "\uf14d";
            }
            case Compass: {
                return "\uf14e";
            }
            case CaretSquareODown: {
                return "\uf150";
            }
            case CaretSquareOUp: {
                return "\uf151";
            }
            case CaretSquareORight: {
                return "\uf152";
            }
            case Eur: {
                return "\uf153";
            }
            case Gbp: {
                return "\uf154";
            }
            case Usd: {
                return "\uf155";
            }
            case Inr: {
                return "\uf156";
            }
            case Jpy: {
                return "\uf157";
            }
            case Rub: {
                return "\uf158";
            }
            case Krw: {
                return "\uf159";
            }
            case Btc: {
                return "\uf15a";
            }
            case File: {
                return "\uf15b";
            }
            case FileText: {
                return "\uf15c";
            }
            case SortAlphaAsc: {
                return "\uf15d";
            }
            case SortAlphaDesc: {
                return "\uf15e";
            }
            case SortAmountAsc: {
                return "\uf160";
            }
            case SortAmountDesc: {
                return "\uf161";
            }
            case SortNumericAsc: {
                return "\uf162";
            }
            case SortNumericDesc: {
                return "\uf163";
            }
            case ThumbsUp: {
                return "\uf164";
            }
            case ThumbsDown: {
                return "\uf165";
            }
            case YoutubeSquare: {
                return "\uf166";
            }
            case Youtube: {
                return "\uf167";
            }
            case Xing: {
                return "\uf168";
            }
            case XingSquare: {
                return "\uf169";
            }
            case YoutubePlay: {
                return "\uf16a";
            }
            case Dropbox: {
                return "\uf16b";
            }
            case StackOverflow: {
                return "\uf16c";
            }
            case Instagram: {
                return "\uf16d";
            }
            case Flickr: {
                return "\uf16e";
            }
            case Adn: {
                return "\uf170";
            }
            case Bitbucket: {
                return "\uf171";
            }
            case BitbucketSquare: {
                return "\uf172";
            }
            case Tumblr: {
                return "\uf173";
            }
            case TumblrSquare: {
                return "\uf174";
            }
            case LongArrowDown: {
                return "\uf175";
            }
            case LongArrowUp: {
                return "\uf176";
            }
            case LongArrowLeft: {
                return "\uf177";
            }
            case LongArrowRight: {
                return "\uf178";
            }
            case Apple: {
                return "\uf179";
            }
            case Windows: {
                return "\uf17a";
            }
            case Android: {
                return "\uf17b";
            }
            case Linux: {
                return "\uf17c";
            }
            case Dribbble: {
                return "\uf17d";
            }
            case Skype: {
                return "\uf17e";
            }
            case Foursquare: {
                return "\uf180";
            }
            case Trello: {
                return "\uf181";
            }
            case Female: {
                return "\uf182";
            }
            case Male: {
                return "\uf183";
            }
            case Gratipay: {
                return "\uf184";
            }
            case SunO: {
                return "\uf185";
            }
            case MoonO: {
                return "\uf186";
            }
            case Archive: {
                return "\uf187";
            }
            case Bug: {
                return "\uf188";
            }
            case Vk: {
                return "\uf189";
            }
            case Weibo: {
                return "\uf18a";
            }
            case Renren: {
                return "\uf18b";
            }
            case Pagelines: {
                return "\uf18c";
            }
            case StackExchange: {
                return "\uf18d";
            }
            case ArrowCircleORight: {
                return "\uf18e";
            }
            case ArrowCircleOLeft: {
                return "\uf190";
            }
            case CaretSquareOLeft: {
                return "\uf191";
            }
            case DotCircleO: {
                return "\uf192";
            }
            case Wheelchair: {
                return "\uf193";
            }
            case VimeoSquare: {
                return "\uf194";
            }
            case Try: {
                return "\uf195";
            }
            case PlusSquareO: {
                return "\uf196";
            }
            case SpaceShuttle: {
                return "\uf197";
            }
            case Slack: {
                return "\uf198";
            }
            case EnvelopeSquare: {
                return "\uf199";
            }
            case Wordpress: {
                return "\uf19a";
            }
            case Openid: {
                return "\uf19b";
            }
            case University: {
                return "\uf19c";
            }
            case GraduationCap: {
                return "\uf19d";
            }
            case Yahoo: {
                return "\uf19e";
            }
            case Google: {
                return "\uf1a0";
            }
            case Reddit: {
                return "\uf1a1";
            }
            case RedditSquare: {
                return "\uf1a2";
            }
            case StumbleuponCircle: {
                return "\uf1a3";
            }
            case Stumbleupon: {
                return "\uf1a4";
            }
            case Delicious: {
                return "\uf1a5";
            }
            case Digg: {
                return "\uf1a6";
            }
            case PiedPiper: {
                return "\uf1a7";
            }
            case PiedPiperAlt: {
                return "\uf1a8";
            }
            case Drupal: {
                return "\uf1a9";
            }
            case Joomla: {
                return "\uf1aa";
            }
            case Language: {
                return "\uf1ab";
            }
            case Fax: {
                return "\uf1ac";
            }
            case Building: {
                return "\uf1ad";
            }
            case Child: {
                return "\uf1ae";
            }
            case Paw: {
                return "\uf1b0";
            }
            case Spoon: {
                return "\uf1b1";
            }
            case Cube: {
                return "\uf1b2";
            }
            case Cubes: {
                return "\uf1b3";
            }
            case Behance: {
                return "\uf1b4";
            }
            case BehanceSquare: {
                return "\uf1b5";
            }
            case Steam: {
                return "\uf1b6";
            }
            case SteamSquare: {
                return "\uf1b7";
            }
            case Recycle: {
                return "\uf1b8";
            }
            case Car: {
                return "\uf1b9";
            }
            case Taxi: {
                return "\uf1ba";
            }
            case Tree: {
                return "\uf1bb";
            }
            case Spotify: {
                return "\uf1bc";
            }
            case Deviantart: {
                return "\uf1bd";
            }
            case Soundcloud: {
                return "\uf1be";
            }
            case Database: {
                return "\uf1c0";
            }
            case FilePdfO: {
                return "\uf1c1";
            }
            case FileWordO: {
                return "\uf1c2";
            }
            case FileExcelO: {
                return "\uf1c3";
            }
            case FilePowerpointO: {
                return "\uf1c4";
            }
            case FileImageO: {
                return "\uf1c5";
            }
            case FileArchiveO: {
                return "\uf1c6";
            }
            case FileAudioO: {
                return "\uf1c7";
            }
            case FileVideoO: {
                return "\uf1c8";
            }
            case FileCodeO: {
                return "\uf1c9";
            }
            case Vine: {
                return "\uf1ca";
            }
            case Codepen: {
                return "\uf1cb";
            }
            case Jsfiddle: {
                return "\uf1cc";
            }
            case LifeRing: {
                return "\uf1cd";
            }
            case CircleONotch: {
                return "\uf1ce";
            }
            case Rebel: {
                return "\uf1d0";
            }
            case Empire: {
                return "\uf1d1";
            }
            case GitSquare: {
                return "\uf1d2";
            }
            case Git: {
                return "\uf1d3";
            }
            case HackerNews: {
                return "\uf1d4";
            }
            case TencentWeibo: {
                return "\uf1d5";
            }
            case Qq: {
                return "\uf1d6";
            }
            case Weixin: {
                return "\uf1d7";
            }
            case PaperPlane: {
                return "\uf1d8";
            }
            case PaperPlaneO: {
                return "\uf1d9";
            }
            case History: {
                return "\uf1da";
            }
            case CircleThin: {
                return "\uf1db";
            }
            case Header: {
                return "\uf1dc";
            }
            case Paragraph: {
                return "\uf1dd";
            }
            case Sliders: {
                return "\uf1de";
            }
            case ShareAlt: {
                return "\uf1e0";
            }
            case ShareAltSquare: {
                return "\uf1e1";
            }
            case Bomb: {
                return "\uf1e2";
            }
            case FutbolO: {
                return "\uf1e3";
            }
            case Tty: {
                return "\uf1e4";
            }
            case Binoculars: {
                return "\uf1e5";
            }
            case Plug: {
                return "\uf1e6";
            }
            case Slideshare: {
                return "\uf1e7";
            }
            case Twitch: {
                return "\uf1e8";
            }
            case Yelp: {
                return "\uf1e9";
            }
            case NewspaperO: {
                return "\uf1ea";
            }
            case Wifi: {
                return "\uf1eb";
            }
            case Calculator: {
                return "\uf1ec";
            }
            case Paypal: {
                return "\uf1ed";
            }
            case GoogleWallet: {
                return "\uf1ee";
            }
            case CcVisa: {
                return "\uf1f0";
            }
            case CcMastercard: {
                return "\uf1f1";
            }
            case CcDiscover: {
                return "\uf1f2";
            }
            case CcAmex: {
                return "\uf1f3";
            }
            case CcPaypal: {
                return "\uf1f4";
            }
            case CcStripe: {
                return "\uf1f5";
            }
            case BellSlash: {
                return "\uf1f6";
            }
            case BellSlashO: {
                return "\uf1f7";
            }
            case Trash: {
                return "\uf1f8";
            }
            case Copyright: {
                return "\uf1f9";
            }
            case At: {
                return "\uf1fa";
            }
            case Eyedropper: {
                return "\uf1fb";
            }
            case PaintBrush: {
                return "\uf1fc";
            }
            case BirthdayCake: {
                return "\uf1fd";
            }
            case AreaChart: {
                return "\uf1fe";
            }
            case PieChart: {
                return "\uf200";
            }
            case LineChart: {
                return "\uf201";
            }
            case Lastfm: {
                return "\uf202";
            }
            case LastfmSquare: {
                return "\uf203";
            }
            case ToggleOff: {
                return "\uf204";
            }
            case ToggleOn: {
                return "\uf205";
            }
            case Bicycle: {
                return "\uf206";
            }
            case Bus: {
                return "\uf207";
            }
            case Ioxhost: {
                return "\uf208";
            }
            case Angellist: {
                return "\uf209";
            }
            case Cc: {
                return "\uf20a";
            }
            case Ils: {
                return "\uf20b";
            }
            case Meanpath: {
                return "\uf20c";
            }
            case Buysellads: {
                return "\uf20d";
            }
            case Connectdevelop: {
                return "\uf20e";
            }
            case Dashcube: {
                return "\uf210";
            }
            case Forumbee: {
                return "\uf211";
            }
            case Leanpub: {
                return "\uf212";
            }
            case Sellsy: {
                return "\uf213";
            }
            case Shirtsinbulk: {
                return "\uf214";
            }
            case Simplybuilt: {
                return "\uf215";
            }
            case Skyatlas: {
                return "\uf216";
            }
            case CartPlus: {
                return "\uf217";
            }
            case CartArrowDown: {
                return "\uf218";
            }
            case Diamond: {
                return "\uf219";
            }
            case Ship: {
                return "\uf21a";
            }
            case UserSecret: {
                return "\uf21b";
            }
            case Motorcycle: {
                return "\uf21c";
            }
            case StreetView: {
                return "\uf21d";
            }
            case Heartbeat: {
                return "\uf21e";
            }
            case Venus: {
                return "\uf221";
            }
            case Mars: {
                return "\uf222";
            }
            case Mercury: {
                return "\uf223";
            }
            case Transgender: {
                return "\uf224";
            }
            case TransgenderAlt: {
                return "\uf225";
            }
            case VenusDouble: {
                return "\uf226";
            }
            case MarsDouble: {
                return "\uf227";
            }
            case VenusMars: {
                return "\uf228";
            }
            case MarsStroke: {
                return "\uf229";
            }
            case MarsStrokeV: {
                return "\uf22a";
            }
            case MarsStrokeH: {
                return "\uf22b";
            }
            case Neuter: {
                return "\uf22c";
            }
            case Genderless: {
                return "\uf22d";
            }
            case FacebookOfficial: {
                return "\uf230";
            }
            case PinterestP: {
                return "\uf231";
            }
            case Whatsapp: {
                return "\uf232";
            }
            case Server: {
                return "\uf233";
            }
            case UserPlus: {
                return "\uf234";
            }
            case UserTimes: {
                return "\uf235";
            }
            case Bed: {
                return "\uf236";
            }
            case Viacoin: {
                return "\uf237";
            }
            case Train: {
                return "\uf238";
            }
            case Subway: {
                return "\uf239";
            }
            case Medium: {
                return "\uf23a";
            }
            case YCombinator: {
                return "\uf23b";
            }
            case OptinMonster: {
                return "\uf23c";
            }
            case Opencart: {
                return "\uf23d";
            }
            case Expeditedssl: {
                return "\uf23e";
            }
            case BatteryFull: {
                return "\uf240";
            }
            case BatteryThreeQuarters: {
                return "\uf241";
            }
            case BatteryHalf: {
                return "\uf242";
            }
            case BatteryQuarter: {
                return "\uf243";
            }
            case BatteryEmpty: {
                return "\uf244";
            }
            case MousePointer: {
                return "\uf245";
            }
            case ICursor: {
                return "\uf246";
            }
            case ObjectGroup: {
                return "\uf247";
            }
            case ObjectUngroup: {
                return "\uf248";
            }
            case StickyNote: {
                return "\uf249";
            }
            case StickyNoteO: {
                return "\uf24a";
            }
            case CcJcb: {
                return "\uf24b";
            }
            case CcDinersClub: {
                return "\uf24c";
            }
            case Clone: {
                return "\uf24d";
            }
            case BalanceScale: {
                return "\uf24e";
            }
            case HourglassO: {
                return "\uf250";
            }
            case HourglassStart: {
                return "\uf251";
            }
            case HourglassHalf: {
                return "\uf252";
            }
            case HourglassEnd: {
                return "\uf253";
            }
            case Hourglass: {
                return "\uf254";
            }
            case HandRockO: {
                return "\uf255";
            }
            case HandPaperO: {
                return "\uf256";
            }
            case HandScissorsO: {
                return "\uf257";
            }
            case HandLizardO: {
                return "\uf258";
            }
            case HandSpockO: {
                return "\uf259";
            }
            case HandPointerO: {
                return "\uf25a";
            }
            case HandPeaceO: {
                return "\uf25b";
            }
            case Trademark: {
                return "\uf25c";
            }
            case Registered: {
                return "\uf25d";
            }
            case CreativeCommons: {
                return "\uf25e";
            }
            case Gg: {
                return "\uf260";
            }
            case GgCircle: {
                return "\uf261";
            }
            case Tripadvisor: {
                return "\uf262";
            }
            case Odnoklassniki: {
                return "\uf263";
            }
            case OdnoklassnikiSquare: {
                return "\uf264";
            }
            case GetPocket: {
                return "\uf265";
            }
            case WikipediaW: {
                return "\uf266";
            }
            case Safari: {
                return "\uf267";
            }
            case Chrome: {
                return "\uf268";
            }
            case Firefox: {
                return "\uf269";
            }
            case Opera: {
                return "\uf26a";
            }
            case InternetExplorer: {
                return "\uf26b";
            }
            case Television: {
                return "\uf26c";
            }
            case Contao: {
                return "\uf26d";
            }
            case Px500: {
                return "\uf26e";
            }
            case Amazon: {
                return "\uf270";
            }
            case CalendarPlusO: {
                return "\uf271";
            }
            case CalendarMinusO: {
                return "\uf272";
            }
            case CalendarTimesO: {
                return "\uf273";
            }
            case CalendarCheckO: {
                return "\uf274";
            }
            case Industry: {
                return "\uf275";
            }
            case MapPin: {
                return "\uf276";
            }
            case MapSigns: {
                return "\uf277";
            }
            case MapO: {
                return "\uf278";
            }
            case Map: {
                return "\uf279";
            }
            case Commenting: {
                return "\uf27a";
            }
            case CommentingO: {
                return "\uf27b";
            }
            case Houzz: {
                return "\uf27c";
            }
            case Vimeo: {
                return "\uf27d";
            }
            case BlackTie: {
                return "\uf27e";
            }
            case Fonticons: {
                return "\uf280";
            }
        }
        return null;
    }

    public static String getFontFamilyIcons() throws FontFormatException, IOException {
        if (fontFamilyIcons == null) {
            InputStream stream = StiConfig.class.getResourceAsStream("/com/stimulsoft/Stimulsoft.ttf");
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font font = Font.createFont(0, stream);
            ge.registerFont(font);
            fontFamilyIcons = font.getFontName();
        }
        return fontFamilyIcons;
    }

    public static BufferedImage convertFontIconToImage(StiFontIcons icon, StiColor color, int width, int height) throws FontFormatException, IOException {
        String fontFamilyIcons = StiFontIconsHelper.getFontFamilyIcons();
        int minSize = Math.min(width, height);
        BufferedImage image = new BufferedImage(minSize, minSize, 6);
        Graphics2D g = image.createGraphics();
        String iconContent = StiFontIconsHelper.getContent(icon);
        Font font = new Font(fontFamilyIcons, 0, 100);
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        double iconWidth = font.getStringBounds(iconContent, frc).getWidth();
        double iconHeight = font.getStringBounds(iconContent, frc).getHeight();
        double maxSideSizeTemp = Math.max(iconWidth, iconHeight);
        double fontSize = (double)(minSize * 80) / maxSideSizeTemp;
        iconHeight *= fontSize / 100.0;
        iconWidth *= fontSize / 100.0;
        g.setColor(color.getAwtColor());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setFont(new Font(fontFamilyIcons, 0, (int)Math.round(fontSize)));
        FontMetrics fm = g.getFontMetrics(new Font(fontFamilyIcons, 0, (int)Math.round(fontSize)));
        float x = Math.round((double)(minSize / 2) - iconWidth / 2.0);
        float y = Math.round((double)(minSize / 2) + iconHeight / 2.0 - (double)fm.getDescent());
        g.drawString(iconContent, x, y);
        BufferedImage resultImage = new BufferedImage(width, height, 6);
        resultImage.createGraphics().drawImage(image, 0, 0, width, height, null);
        return resultImage;
    }

    public static String getIsonSetContent(StiFontIconSet iconSet) {
        StringBuilder builtString = new StringBuilder();
        for (StiFontIcons icon : StiFontIconsHelper.getFontIcons(iconSet)) {
            builtString.append(StiFontIconsHelper.getContent(icon));
            builtString.append(' ');
        }
        return builtString.toString();
    }

    public static List<StiFontIcons> getFontIcons(StiFontIconSet iconSet) {
        switch (iconSet) {
            case Rating: {
                return Arrays.asList(StiFontIcons.Rating0, StiFontIcons.Rating1, StiFontIcons.Rating2, StiFontIcons.Rating3, StiFontIcons.Rating4);
            }
            case Quarter: {
                return Arrays.asList(StiFontIcons.QuarterNone, StiFontIcons.QuarterQuarter, StiFontIcons.QuarterHalf, StiFontIcons.QuarterThreeFourth, StiFontIcons.QuarterFull);
            }
            case Square: {
                return Arrays.asList(StiFontIcons.Square4, StiFontIcons.Square3, StiFontIcons.Square2, StiFontIcons.Square1, StiFontIcons.Square0);
            }
            case Star: {
                return Arrays.asList(StiFontIcons.StarNone, StiFontIcons.StarQuarter, StiFontIcons.StarHalf, StiFontIcons.StarThreeFourth, StiFontIcons.StarFull);
            }
            case Latin: {
                return Arrays.asList(StiFontIcons.Latin1, StiFontIcons.Latin2, StiFontIcons.Latin3, StiFontIcons.Latin4);
            }
        }
        return Arrays.asList(StiFontIcons.Rating0, StiFontIcons.Rating1, StiFontIcons.Rating2, StiFontIcons.Rating3, StiFontIcons.Rating4);
    }
}

