/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.helpers;

import com.stimulsoft.base.system.geometry.StiPoint;

public class StiCurveHelper {
    public static StiPoint[] cardinalSpline(StiPoint[] pts, boolean closed) {
        StiPoint p0;
        int i;
        StiPoint p1 = new StiPoint();
        StiPoint p2 = new StiPoint();
        double tension = 0.16666666666666666;
        int nrRetPts = closed ? (pts.length + 1) * 3 - 2 : pts.length * 3 - 2;
        StiPoint[] retPnt = new StiPoint[nrRetPts];
        for (i = 0; i < nrRetPts; ++i) {
            retPnt[i] = new StiPoint();
        }
        if (!closed) {
            p0 = new StiPoint((double)((int)pts[0].x), (double)((int)pts[0].y));
            p1 = StiCurveHelper.calcCurveEnd(p0, new StiPoint((double)((int)pts[1].x), (double)((int)pts[1].y)), tension, p1);
            retPnt[0] = p0;
            retPnt[1] = p1.clone();
        }
        for (i = 0; i < pts.length - (closed ? 1 : 2); ++i) {
            p0 = new StiPoint((double)((int)pts[i + 1].x), (double)((int)pts[i + 1].y));
            StiCurveHelper.calcCurve(new StiPoint[]{new StiPoint((double)((int)pts[i].x), (double)((int)pts[i].y)), p0, new StiPoint((double)((int)pts[(i + 2) % pts.length].x), (double)((int)pts[(i + 2) % pts.length].y))}, tension, p1, p2);
            retPnt[3 * i + 2] = p1.clone();
            retPnt[3 * i + 3] = p0;
            retPnt[3 * i + 4] = p2.clone();
        }
        if (closed) {
            p0 = new StiPoint((double)((int)pts[0].x), (double)((int)pts[0].y));
            StiCurveHelper.calcCurve(new StiPoint[]{new StiPoint((double)((int)pts[pts.length - 1].x), (double)((int)pts[pts.length - 1].y)), p0, new StiPoint((double)((int)pts[1].x), (double)((int)pts[1].y))}, tension, p1, p2);
            retPnt[nrRetPts - 2] = p1;
            retPnt[0] = p0;
            retPnt[1] = p2.clone();
            retPnt[nrRetPts - 1] = retPnt[0].clone();
        } else {
            p0 = new StiPoint((double)((int)pts[pts.length - 1].x), (double)((int)pts[pts.length - 1].y));
            p1 = StiCurveHelper.calcCurveEnd(p0, new StiPoint((double)((int)pts[pts.length - 2].x), (double)((int)pts[pts.length - 2].y)), tension, p1);
            retPnt[nrRetPts - 2] = p1.clone();
            retPnt[nrRetPts - 1] = p0;
        }
        return retPnt;
    }

    private static StiPoint calcCurveEnd(StiPoint end, StiPoint adj, double tension, StiPoint p1) {
        return new StiPoint((double)((int)(tension * (adj.x - end.x) + end.x)), (double)((int)(tension * (adj.y - end.y) + end.y)));
    }

    private static void calcCurve(StiPoint[] pts, double tenstion, StiPoint p1, StiPoint p2) {
        double deltaX = pts[2].x - pts[0].x;
        double deltaY = pts[2].y - pts[0].y;
        p1.x = (int)(pts[1].x - tenstion * deltaX);
        p1.y = (int)(pts[1].y - tenstion * deltaY);
        p2.x = (int)(pts[1].x + tenstion * deltaX);
        p2.y = (int)(pts[1].y + tenstion * deltaY);
    }
}

