/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.helpers;

import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.utils.StiMath;

public class StiAbbreviationNumberFormatHelper {
    public static String format(double value) {
        StiRefObject postfix = new StiRefObject((Object)"");
        double result = StiAbbreviationNumberFormatHelper.format(value, (StiRefObject<String>)postfix);
        if (result == 0.0) {
            return "0";
        }
        if ("".equals(postfix.argvalue)) {
            return String.valueOf(StiMath.round((double)value, (int)2));
        }
        return result + (String)postfix.argvalue;
    }

    public static double format(double value, StiRefObject<String> postfix) {
        double result;
        postfix.argvalue = "";
        if (value == 0.0) {
            return 0.0;
        }
        boolean negative = false;
        if (value < 0.0) {
            negative = true;
            value = Math.abs(value);
        }
        if (value < 1000.0) {
            result = value;
        } else if (value < 1000000.0) {
            result = (int)(value / 1000.0);
            double round = StiMath.round((double)(value / 1000.0), (int)2);
            result += round - (double)((int)round);
            postfix.argvalue = "K";
        } else if (value < 1.0E9) {
            result = (int)(value / 1000000.0);
            double round = StiMath.round((double)(value / 1000000.0), (int)2);
            result += round - (double)((int)round);
            postfix.argvalue = "M";
        } else if (value < 1.0E12) {
            result = (int)(value / 1.0E9);
            double round = StiMath.round((double)(value / 1.0E9), (int)2);
            result += round - (double)((int)round);
            postfix.argvalue = "B";
        } else {
            result = value;
        }
        if (negative) {
            result = -result;
        }
        return result;
    }
}

