/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service.helper;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiAnimationType;
import com.stimulsoft.base.context.chart.IStiContextPainter;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiColumnAnimation;
import com.stimulsoft.base.context.chart.animation.StiInteractionDataGeom;
import com.stimulsoft.base.context.chart.animation.StiLabelAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.animation.StiPieLabelAnimation;
import com.stimulsoft.base.context.chart.animation.StiPieSegmentAnimation;
import com.stimulsoft.base.context.chart.animation.StiPointsAnimation;
import com.stimulsoft.base.context.chart.geoms.StiArcSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiBorderGeom;
import com.stimulsoft.base.context.chart.geoms.StiCachedShadowGeom;
import com.stimulsoft.base.context.chart.geoms.StiCloseFigureSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiCurveGeom;
import com.stimulsoft.base.context.chart.geoms.StiCurveSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiEllipseGeom;
import com.stimulsoft.base.context.chart.geoms.StiGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLinesGeom;
import com.stimulsoft.base.context.chart.geoms.StiLinesSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiPieSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPopClipGeom;
import com.stimulsoft.base.context.chart.geoms.StiPopTransformGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushClipGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushRotateTransformGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushTranslateTransformGeom;
import com.stimulsoft.base.context.chart.geoms.StiSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiShadowGeom;
import com.stimulsoft.base.context.chart.geoms.StiTextGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiBorderAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiClusteredBarSeriesAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiClusteredColumnSeriesAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiCurveAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiEllipseAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiLabelAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiLinesAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiPathAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiPathElementAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiShadowAnimationGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.StringFormat;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.components.enums.StiImageRotation;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.service.helper.StiBrushSvgHelper;
import com.stimulsoft.report.helpers.StiCurveHelper;
import com.stimulsoft.report.painters.StiContextPainter;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiChartSvgHelper {
    private static void addAnimation(Element el, String actions, Integer begin, Integer duration) {
        StiChartSvgHelper.addAnimation(el, actions, begin, duration, "");
    }

    private static void addAnimation(Element el, String actions, Double begin, Integer duration) {
        StiChartSvgHelper.addAnimation(el, actions, begin != null ? Integer.valueOf(begin.intValue()) : null, duration, "");
    }

    private static void addAnimation(Element el, String actions, Integer begin, Integer duration, String number) {
        String animation = String.format("{\"actions\":%s, \"begin\":%s, \"duration\":%s}", actions, begin != null ? begin : 0, duration);
        el.setAttribute("_animation" + number, animation);
    }

    public static String writeFillBrush(Element el, Object brush, StiRectangle rect, double dx, double dy, Document document) {
        StiRectangle sRect = rect.clone();
        sRect.x += dx;
        sRect.y += dy;
        if (brush instanceof StiColor) {
            StiColor color = (StiColor)brush;
            return String.format("fill:rgb(%s,%s,%s);fill-opacity:%s;", color.getR(), color.getG(), color.getB(), String.valueOf(StiMath.round((float)((float)color.getA() / 255.0f), (int)3)).replace(',', '.'));
        }
        if (brush instanceof StiGradientBrush) {
            String gradientId = StiBrushSvgHelper.writeGradientBrush(el, brush, sRect, document);
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiGlareBrush) {
            String gradientId = StiBrushSvgHelper.writeGlareBrush(el, brush, sRect, document);
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiGlassBrush) {
            String gradientId = StiBrushSvgHelper.writeGlassBrush(el, brush, sRect, document);
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiHatchBrush) {
            String gradientId = StiBrushSvgHelper.writeHatchBrush(el, brush, document);
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiBrush) {
            StiColor color = StiBrush.ToColor((StiBrush)((StiBrush)brush));
            return String.format("fill:rgb(%s,%s,%s);fill-opacity:%s;", color.getR(), color.getG(), color.getB(), String.valueOf(StiMath.round((float)((float)color.getA() / 255.0f), (int)3)).replace(',', '.'));
        }
        return "fill:none;";
    }

    private static boolean checkPenGeom(StiPenGeom penGeom) {
        return penGeom != null && penGeom.getBrush() != null && penGeom.getPenStyle() != StiPenStyle.None;
    }

    public static void writeChart(Element el, StiSvgExportService.StiSvgHelper.StiSvgData svgData, Boolean needAnimation, Document doc) {
        StiChartSvgHelper.writeChart(el, svgData, 1.0, needAnimation, doc);
    }

    private static String r(Object o) {
        return String.valueOf(o).replace(',', '.');
    }

    private static String p(Object o) {
        return StiChartSvgHelper.r(o);
    }

    public static void writeChart(Element elem, StiSvgExportService.StiSvgHelper.StiSvgData svgData, double zoom, Boolean needAnimation, Document doc) {
        StiChart chart = (StiChart)svgData.Component;
        float dx = 0.0f;
        float dy = 0.0f;
        boolean storeIsAnimation = chart.isAnimation;
        chart.isAnimation = needAnimation;
        ArrayList<StiGeom> listTransformGeom = new ArrayList<StiGeom>();
        BufferedImage bmp = new BufferedImage(10, 10, 1);
        StiGraphics gg = new StiGraphics((Graphics)bmp.createGraphics());
        StiContextPainter painter = new StiContextPainter(gg, zoom, zoom);
        StiContext context = new StiContext((IStiContextPainter)painter, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(chart.getIsPrinting()), zoom);
        double svgWidth = svgData.Width;
        double svgHeight = svgData.Height;
        if (chart.getRotation() == StiImageRotation.Rotate90CCW || chart.getRotation() == StiImageRotation.Rotate90CW) {
            svgWidth = svgData.Height;
            svgHeight = svgData.Width;
        }
        StiCellGeom chartGeom = chart.getCore().Render(context, new StiRectangle(0.0, 0.0, svgWidth, svgHeight), true);
        chartGeom.DrawGeom(context);
        chart.isAnimation = storeIsAnimation;
        double finishTime = 0.0;
        boolean needStaticShadow = true;
        for (StiGeom geom : context.getGeoms()) {
            StiAnimationGeom ag;
            StiAnimationGeom stiAnimationGeom = ag = geom instanceof StiAnimationGeom ? (StiAnimationGeom)geom : null;
            if (ag != null && ag.getAnimation() != null) {
                int n = ag.getAnimation().getDuration();
                int n2 = ag.getAnimation().getBeginTime() != null ? ag.getAnimation().getBeginTime() : 0;
                if ((double)(n + n2) > finishTime) {
                    finishTime = ag.getAnimation().getDuration() + (ag.getAnimation().getBeginTime() != null ? ag.getAnimation().getBeginTime() : 0);
                }
            }
            if (!(geom instanceof StiShadowAnimationGeom)) continue;
            needStaticShadow = false;
        }
        Stack<Element> gStack = new Stack<Element>();
        String clip = "";
        Element g = doc.createElement("g");
        elem.appendChild(g);
        Element el = g;
        double translateX = svgData.X + 0.5;
        double translateY = svgData.Y + 0.5;
        String rotation = "";
        switch (chart.getRotation()) {
            case Rotate90CW: {
                rotation = " rotate(90)";
                translateX += svgHeight;
                break;
            }
            case Rotate90CCW: {
                rotation = " rotate(-90)";
                translateY += svgWidth;
                break;
            }
            case Rotate180: {
                rotation = " rotate(180)";
                translateY += svgHeight;
                translateX += svgWidth;
                break;
            }
            case FlipHorizontal: {
                rotation = " scale(-1, 1)";
                translateX += svgWidth;
                break;
            }
            case FlipVertical: {
                rotation = " scale(1, -1)";
                translateY += svgHeight;
                break;
            }
        }
        g.setAttribute("transform", String.format("translate(%s,%s)%s", StiChartSvgHelper.p(translateX), StiChartSvgHelper.p(translateY), rotation));
        for (StiGeom geom : context.getGeoms()) {
            StiLineGeom line;
            int index;
            StiCurveGeom curve;
            Element pathEl;
            Integer duration;
            StringBuilder animatedPath;
            StiPathElementAnimationGeom path;
            String stroke;
            CharSequence style;
            StiEllipseAnimationGeom ellipse;
            String guid;
            StiLinesGeom lines;
            String stroke2;
            CharSequence style2;
            Element filterEl;
            Element defsEl;
            StiShadowAnimationGeom shadow;
            String guid2;
            StiLabelAnimationGeom textGeom;
            Element titleEl;
            StringBuilder style3;
            StiRectangle rectFrom;
            StiColumnAnimation columnAnimation;
            StiRectangle rect;
            StiClusteredBarSeriesAnimationGeom border;
            Element g2;
            if (geom instanceof StiPushTranslateTransformGeom) {
                listTransformGeom.add(geom);
                g2 = doc.createElement("g");
                el.appendChild(g2);
                gStack.push(el);
                el = g2;
                dx += ((StiPushTranslateTransformGeom)geom).getX();
                dy += ((StiPushTranslateTransformGeom)geom).getY();
            }
            if (geom instanceof StiPushRotateTransformGeom) {
                listTransformGeom.add(geom);
                g2 = doc.createElement("g");
                el.appendChild(g2);
                gStack.push(el);
                el = g2;
                g2.setAttribute("transform", String.format("rotate(%s)", String.valueOf(((StiPushRotateTransformGeom)geom).getAngle()).replace(',', '.')));
            }
            if (geom instanceof StiPopTransformGeom) {
                StiPushTranslateTransformGeom lastTranslateTransformGeom;
                StiGeom lastTransformGeom = (StiGeom)listTransformGeom.get(listTransformGeom.size() - 1);
                StiPushTranslateTransformGeom stiPushTranslateTransformGeom = lastTranslateTransformGeom = lastTransformGeom instanceof StiPushTranslateTransformGeom ? (StiPushTranslateTransformGeom)lastTransformGeom : null;
                if (lastTranslateTransformGeom != null) {
                    dx -= lastTranslateTransformGeom.getX();
                    dy -= lastTranslateTransformGeom.getY();
                }
                listTransformGeom.remove(lastTransformGeom);
                el = (Element)gStack.pop();
            }
            if (geom instanceof StiClusteredBarSeriesAnimationGeom) {
                border = (StiClusteredBarSeriesAnimationGeom)geom;
                rect = StiChartSvgHelper.rectToRectangleF(border.getColumnRect());
                columnAnimation = border.getAnimation() instanceof StiColumnAnimation ? (StiColumnAnimation)border.getAnimation() : null;
                rectFrom = columnAnimation != null ? columnAnimation.getRectFrom() : StiRectangle.empty();
                style3 = new StringBuilder();
                if (border.getBackground() != null) {
                    style3.append(StiChartSvgHelper.writeFillBrush(el, border.getBackground(), rect, dx, dy, doc));
                } else {
                    style3.append("fill:none;");
                }
                if (StiChartSvgHelper.checkPenGeom(border.getBorderPen())) {
                    String stroke3 = String.format("%s", StiChartSvgHelper.writeBorderStroke(el, border.getBorderPen().getBrush(), rect, doc));
                    style3.append(String.format("%s;stroke-width:%s;", stroke3, border.getBorderPen().getThickness()));
                }
                String rectWidth = StiChartSvgHelper.r(rect.width);
                Element rectEl = doc.createElement("rect");
                el.appendChild(rectEl);
                if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                    rectEl.setAttribute("clip-path", String.format("url(#%s)", clip));
                }
                rectEl.setAttribute("y", StiChartSvgHelper.r(rect.y + (double)dy));
                rectEl.setAttribute("height", StiChartSvgHelper.r(rect.height));
                rectEl.setAttribute("shape-rendering", "crispEdges");
                if (needAnimation.booleanValue()) {
                    if (border.getValue() < 0.0) {
                        if (rectFrom.width == 0.0) {
                            rectEl.setAttribute("x", StiChartSvgHelper.p(rect.x + (double)dx));
                            StiChartSvgHelper.addAnimation(rectEl, "[[\"width\", 0, " + rectWidth + ",\"\"]]", border.getAnimation().getBeginTime(), border.getAnimation().getDuration());
                        } else if (columnAnimation.getValueFrom() <= 0.0) {
                            rectEl.setAttribute("x", StiChartSvgHelper.p(rectFrom.x + (double)dx));
                            StiChartSvgHelper.addAnimation(rectEl, "[[\"width\", " + StiChartSvgHelper.p(rectFrom.width) + ", " + rectWidth + ",\"\"]]", border.getAnimation().getBeginTime(), border.getAnimation().getDuration());
                        } else {
                            rectEl.setAttribute("x", StiChartSvgHelper.p(rectFrom.x + (double)dx));
                            StiChartSvgHelper.addAnimation(rectEl, "[[\"width\", " + StiChartSvgHelper.p(rectFrom.width) + ", 0, \"\"], [\"x\"," + StiChartSvgHelper.p(rectFrom.x + (double)dx) + ", " + StiChartSvgHelper.p(rectFrom.width + rectFrom.x + (double)dx) + ", \"\"]]", border.getAnimation().getBeginTime(), (Integer)(border.getAnimation().getDuration() - border.getAnimation().getDuration() / 2));
                            StiChartSvgHelper.addAnimation(rectEl, "[[\"width\", 0, " + rectWidth + ", \"\"]]", border.getAnimation().getBeginTime() + border.getAnimation().getDuration() / 2, border.getAnimation().getDuration() - border.getAnimation().getDuration() / 2, "1");
                        }
                    } else if (rectFrom.width == 0.0) {
                        rectEl.setAttribute("x", StiChartSvgHelper.p(rect.width + rect.x + (double)dx));
                        StiChartSvgHelper.addAnimation(rectEl, "[[\"width\", 0, " + rectWidth + ", \"\"], [\"x\"," + StiChartSvgHelper.p(rect.width + rect.x + (double)dx) + ", " + StiChartSvgHelper.p(rect.x + (double)dx) + ", \"\"]]", border.getAnimation().getBeginTime(), border.getAnimation().getDuration());
                    } else {
                        rectEl.setAttribute("x", StiChartSvgHelper.p(rectFrom.x + (double)dx));
                        if (columnAnimation.getValueFrom() <= 0.0) {
                            StiChartSvgHelper.addAnimation(rectEl, "[[\"width\"," + StiChartSvgHelper.p(rectFrom.width) + ", 0,\"\"]]", border.getAnimation().getBeginTime(), (Integer)(border.getAnimation().getDuration() - border.getAnimation().getDuration() / 2));
                            StiChartSvgHelper.addAnimation(rectEl, "[[\"width\", 0, " + StiChartSvgHelper.p(rect.width) + ", \"\"], [\"x\"," + StiChartSvgHelper.p(rect.width + rect.x + (double)dx) + ", " + StiChartSvgHelper.p(rect.x + (double)dx) + ", \"\"]]", border.getAnimation().getBeginTime() + border.getAnimation().getDuration() / 2, border.getAnimation().getDuration() - border.getAnimation().getDuration() / 2, "1");
                        } else {
                            StiChartSvgHelper.addAnimation(rectEl, "[[\"width\", " + StiChartSvgHelper.p(rectFrom.width) + ", " + rectWidth + ", \"\"], [\"x\"," + StiChartSvgHelper.p(rectFrom.x + (double)dx) + ", " + StiChartSvgHelper.p(rect.x + (double)dx) + ", \"\"]]", border.getAnimation().getBeginTime(), border.getAnimation().getDuration());
                        }
                    }
                } else {
                    rectEl.setAttribute("width", rectWidth);
                    rectEl.setAttribute("x", StiChartSvgHelper.p(rect.x + (double)dx));
                }
                StiChartSvgHelper.writeInteracrion(rectEl, border.getInteraction());
                rectEl.setAttribute("style", style3.toString());
                if (!StiValidationUtil.isNullOrEmpty((String)border.getToolTip())) {
                    titleEl = doc.createElement("title");
                    rectEl.appendChild(titleEl);
                    titleEl.setTextContent(border.getToolTip());
                }
            } else if (geom instanceof StiLabelAnimationGeom) {
                int decimals;
                textGeom = (StiLabelAnimationGeom)geom;
                StiLabelAnimation labelAnimation = textGeom.getAnimation() instanceof StiLabelAnimation ? (StiLabelAnimation)textGeom.getAnimation() : null;
                StiPieLabelAnimation animationPieLabel = textGeom.getAnimation() instanceof StiPieLabelAnimation ? (StiPieLabelAnimation)textGeom.getAnimation() : null;
                StiRectangle rect2 = StiChartSvgHelper.rectToRectangleF(textGeom.getRectangle());
                rect2 = StiChartSvgHelper.correctRectLabel(textGeom.getRotationMode(), rect2);
                style3 = new StringBuilder();
                if (textGeom.getLabelBrush() != null) {
                    style3.append(StiChartSvgHelper.writeFillBrush(el, textGeom.getLabelBrush(), rect2, dx, dy, doc));
                } else {
                    style3.append("fill:none;");
                }
                if (StiChartSvgHelper.checkPenGeom(textGeom.getPenBorder())) {
                    String stroke4 = String.format("%s", StiChartSvgHelper.writeBorderStroke(el, textGeom.getPenBorder().getBrush(), rect2, doc));
                    style3.append(String.format("%s;stroke-width:%s;", stroke4, textGeom.getPenBorder().getThickness()));
                }
                Element rectEl = doc.createElement("rect");
                el.appendChild(rectEl);
                if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                    rectEl.setAttribute("clip-path", String.format("url(#%s)", clip));
                }
                rectEl.setAttribute("x", labelAnimation != null ? StiChartSvgHelper.p(labelAnimation.getLabelRect().x + (double)dx) : (animationPieLabel != null ? StiChartSvgHelper.p(animationPieLabel.getRectLabelFrom().x + (double)dx) : StiChartSvgHelper.p(rect2.x + (double)dx)));
                rectEl.setAttribute("y", labelAnimation != null ? StiChartSvgHelper.p(labelAnimation.getLabelRect().y + (double)dy) : (animationPieLabel != null ? StiChartSvgHelper.p(animationPieLabel.getRectLabelFrom().y + (double)dy) : StiChartSvgHelper.p(rect2.y + (double)dy)));
                rectEl.setAttribute("width", StiChartSvgHelper.r(rect2.width));
                rectEl.setAttribute("height", StiChartSvgHelper.r(rect2.height));
                rectEl.setAttribute("style", style3.toString());
                rectEl.setAttribute("shape-rendering", "crispEdges");
                rectEl.setAttribute("opacity", labelAnimation != null || animationPieLabel != null ? "1" : "0");
                rectEl.setAttribute("fill", "rgba(0,0,0,0)");
                if (labelAnimation != null) {
                    StiChartSvgHelper.addAnimation(rectEl, "[[\"x\", " + StiChartSvgHelper.p(labelAnimation.getLabelRect().x) + ", " + StiChartSvgHelper.p(rect2.x) + ", \"\"],[\"y\", " + StiChartSvgHelper.p(labelAnimation.getLabelRect().y) + ", " + StiChartSvgHelper.p(rect2.y) + ", \"\"]]", labelAnimation.getBeginTime(), labelAnimation.getDuration());
                } else if (animationPieLabel != null) {
                    StiChartSvgHelper.addAnimation(rectEl, "[[\"x\", " + StiChartSvgHelper.p(animationPieLabel.getRectLabelFrom().x) + ", " + StiChartSvgHelper.p(rect2.x) + ", \"\"],[\"y\", " + StiChartSvgHelper.p(animationPieLabel.getRectLabelFrom().y) + ", " + StiChartSvgHelper.p(rect2.y) + ", \"\"]]", animationPieLabel.getBeginTime(), animationPieLabel.getDuration());
                } else {
                    StiChartSvgHelper.addAnimation(rectEl, "[[\"opacity\", 0, 1, \"\"]]", finishTime, (Integer)500);
                }
                StiFont font = new StiFont(textGeom.getFont().getFontName(), textGeom.getFont().getFontSize(), textGeom.getFont().getFontStyle());
                StringFormat sf = new StringFormat();
                sf.Alignment = textGeom.getStringFormat().getAlignment();
                sf.FormatFlags = textGeom.getStringFormat().getFormatFlags();
                sf.HotkeyPrefix = textGeom.getStringFormat().getHotkeyPrefix();
                sf.LineAlignment = textGeom.getStringFormat().getLineAlignment();
                sf.Trimming = textGeom.getStringFormat().getTrimming();
                style3 = new StringBuilder();
                double size = font.size * 4.0 / 3.0;
                Element textEl = doc.createElement("text");
                el.appendChild(textEl);
                Object[] objectArray = new Object[3];
                Object object = labelAnimation != null ? StiChartSvgHelper.p(labelAnimation.getLabelRect().x + (double)dx) : (objectArray[0] = animationPieLabel != null ? StiChartSvgHelper.p(animationPieLabel.getRectLabelFrom().x + (double)dx) : StiChartSvgHelper.p(rect2.x + (double)dx));
                objectArray[1] = labelAnimation != null ? StiChartSvgHelper.p(labelAnimation.getLabelRect().y + (double)dy) : (animationPieLabel != null ? StiChartSvgHelper.p(animationPieLabel.getRectLabelFrom().y + (double)dy) : StiChartSvgHelper.p(rect2.y + (double)dy));
                objectArray[2] = StiChartSvgHelper.p(textGeom.getAngle());
                textEl.setAttribute("transform", String.format("translate(%s, %s) rotate(%s 0,0)", objectArray));
                textEl.setAttribute("font-size", StiChartSvgHelper.r(size));
                textEl.setAttribute("font-family", font.getName());
                textEl.setAttribute("dy", "0.9em");
                StiColor textColor = StiBrush.ToColor((StiBrush)((StiBrush)textGeom.getTextBrush()));
                style3.append(String.format("fill:%s;", textColor.toHTML()));
                if (textColor.getA() != 255) {
                    style3.append(String.format("fill-opacity:%s", StiMath.round((float)((float)textColor.getA() / 255.0f), (int)3)));
                }
                textEl.setAttribute("style", style3.toString());
                textEl.setAttribute("opacity", labelAnimation != null || animationPieLabel != null ? "1" : "0");
                if (labelAnimation != null) {
                    StiChartSvgHelper.addAnimation(textEl, String.format("[[\"translate\",\"" + StiChartSvgHelper.p(labelAnimation.getLabelRect().x + (double)dx) + ":" + StiChartSvgHelper.p(labelAnimation.getLabelRect().y + (double)dy) + "\",\"" + StiChartSvgHelper.p(rect2.x + (double)dx) + ":" + StiChartSvgHelper.p(rect2.y + (double)dy) + "\",\" rotate(%s 0, 0)\"]]", StiChartSvgHelper.p(textGeom.getAngle())), labelAnimation.getBeginTime(), labelAnimation.getDuration());
                    if (labelAnimation.getValueFrom() != null && labelAnimation.getValue() != null) {
                        double val = labelAnimation.getValueFrom() - labelAnimation.getValue();
                        decimals = (int)val;
                        StiChartSvgHelper.addAnimation(textEl, "[[\"value\", " + StiChartSvgHelper.p(labelAnimation.getValueFrom()) + ", " + StiChartSvgHelper.p(labelAnimation.getValue()) + ", \"" + decimals + "\"]]", labelAnimation.getBeginTime(), labelAnimation.getDuration(), "a1");
                    }
                } else if (animationPieLabel != null) {
                    StiChartSvgHelper.addAnimation(textEl, String.format("[[\"translate\",\"" + StiChartSvgHelper.p(animationPieLabel.getRectLabelFrom().x + (double)dx) + ":" + StiChartSvgHelper.p(animationPieLabel.getRectLabelFrom().y + (double)dy) + "\",\"" + StiChartSvgHelper.p(rect2.x + (double)dx) + ":" + StiChartSvgHelper.p(rect2.y + (double)dy) + "\",\" rotate(%s 0, 0)\"]]", StiChartSvgHelper.p(textGeom.getAngle())), animationPieLabel.getBeginTime(), animationPieLabel.getDuration());
                    if (animationPieLabel.getValueFrom() != null && animationPieLabel.getValue() != null) {
                        double val = animationPieLabel.getValueFrom() - animationPieLabel.getValue();
                        decimals = (int)val;
                        StiChartSvgHelper.addAnimation(textEl, "[[\"value\", " + StiChartSvgHelper.p(animationPieLabel.getValueFrom()) + ", " + StiChartSvgHelper.p(animationPieLabel.getValue()) + ", \"" + decimals + "\"]]", animationPieLabel.getBeginTime(), animationPieLabel.getDuration(), "a1");
                    }
                } else {
                    StiChartSvgHelper.addAnimation(textEl, "[[\"opacity\", 0, 1, \"\"]]", finishTime, (Integer)500);
                }
                if (labelAnimation != null && labelAnimation.getValueFrom() != null) {
                    textEl.setTextContent(StiChartSvgHelper.p(labelAnimation.getValueFrom()));
                } else if (animationPieLabel != null && animationPieLabel.getValueFrom() != null) {
                    textEl.setTextContent(StiChartSvgHelper.p(animationPieLabel.getValueFrom()));
                } else {
                    textEl.setTextContent(textGeom.getText());
                }
            } else if (geom instanceof StiPushClipGeom) {
                StiPushClipGeom clipGeom = (StiPushClipGeom)geom;
                rect = clipGeom.getClipRectangle();
                guid2 = "s" + StiGuid.newGuid();
                Element defs = doc.createElement("defs");
                el.appendChild(defs);
                Element clipPath = doc.createElement("clipPath");
                defs.appendChild(clipPath);
                clipPath.setAttribute("id", guid2);
                Element rect2 = doc.createElement("rect");
                clipPath.appendChild(rect2);
                rect2.setAttribute("x", StiChartSvgHelper.r(rect.x + (double)dx));
                rect2.setAttribute("y", StiChartSvgHelper.r(rect.y + (double)dy));
                rect2.setAttribute("width", StiChartSvgHelper.r(rect.width));
                rect2.setAttribute("height", StiChartSvgHelper.r(rect.height));
                clip = guid2;
            } else if (geom instanceof StiPopClipGeom) {
                clip = "";
            } else if (geom instanceof StiShadowAnimationGeom) {
                shadow = (StiShadowAnimationGeom)geom;
                rect = StiChartSvgHelper.rectToRectangleF(shadow.getRect());
                guid2 = "s" + StiGuid.newGuidStringPlain();
                defsEl = doc.createElement("defs");
                el.appendChild(defsEl);
                filterEl = doc.createElement("filter");
                defsEl.appendChild(filterEl);
                filterEl.setAttribute("id", guid2);
                filterEl.setAttribute("x", "0");
                filterEl.setAttribute("y", "0");
                filterEl.setAttribute("width", "200%");
                filterEl.setAttribute("height", "200%");
                Element feOffsetEl = doc.createElement("feOffset");
                filterEl.appendChild(feOffsetEl);
                feOffsetEl.setAttribute("result", "offOut");
                feOffsetEl.setAttribute("in", "SourceGraphic");
                feOffsetEl.setAttribute("dx", "1.111111111111111");
                feOffsetEl.setAttribute("dy", "1.111111111111111");
                Element feColorMatrixEl = doc.createElement("feColorMatrix");
                filterEl.appendChild(feColorMatrixEl);
                feColorMatrixEl.setAttribute("result", "matrixOut");
                feColorMatrixEl.setAttribute("in", "offOut");
                feColorMatrixEl.setAttribute("type", "matrix");
                feColorMatrixEl.setAttribute("values", "0.58 0 0 0 0 0 0.58 0 0 0 0 0 0.58 0 0 0 0 0 1 0");
                Element feGaussianBlurEl = doc.createElement("feGaussianBlur");
                filterEl.appendChild(feGaussianBlurEl);
                feGaussianBlurEl.setAttribute("result", "blurOut");
                feGaussianBlurEl.setAttribute("in", "matrixOut");
                feGaussianBlurEl.setAttribute("stdDeviation", "1.111111111111111");
                Element feBlendEl = doc.createElement("feBlend");
                filterEl.appendChild(feBlendEl);
                feBlendEl.setAttribute("mode", "normal");
                feBlendEl.setAttribute("in", "SourceGraphic");
                feBlendEl.setAttribute("in2", "blurOut");
                Element rectEl = doc.createElement("rect");
                el.appendChild(rectEl);
                if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                    rectEl.setAttribute("clip-path", String.format("url(#%s)", clip));
                }
                rectEl.setAttribute("x", StiChartSvgHelper.p(rect.x + (double)dx));
                rectEl.setAttribute("y", StiChartSvgHelper.p(rect.y + (double)dy));
                rectEl.setAttribute("height", StiChartSvgHelper.p(rect.height));
                rectEl.setAttribute("width", StiChartSvgHelper.p(rect.width));
                rectEl.setAttribute("fill", "rgb(150,150,150)");
                rectEl.setAttribute("filter", String.format("url(#%s)", guid2));
                rectEl.setAttribute("rx", StiChartSvgHelper.p(shadow.getRadiusX()));
                rectEl.setAttribute("ry", StiChartSvgHelper.p(shadow.getRadiusY()));
                if (needAnimation.booleanValue()) {
                    rectEl.setAttribute("opacity", "0");
                    StiChartSvgHelper.addAnimation(rectEl, "[[\"opacity\", 0, 1, \"\"]]", shadow.getAnimation().getBeginTime(), shadow.getAnimation().getDuration());
                }
            } else if (geom instanceof StiBorderAnimationGeom) {
                border = (StiBorderAnimationGeom)geom;
                rect = StiChartSvgHelper.rectToRectangleF(border.getRect());
                StiOpacityAnimation animation = (StiOpacityAnimation)border.getAnimation();
                style2 = new StringBuilder();
                if (border.getBackground() != null) {
                    style2.append(StiChartSvgHelper.writeFillBrush(el, border.getBackground(), rect, dx, dy, doc));
                } else {
                    style2.append("fill:none;");
                }
                if (StiChartSvgHelper.checkPenGeom(border.getBorderPen())) {
                    stroke2 = StiChartSvgHelper.writeBorderStroke(el, border.getBorderPen().getBrush(), rect, doc);
                    style2.append(String.format("%s;stroke-width:{1};", stroke2, border.getBorderPen().getThickness()));
                }
                Element rectEl = doc.createElement("rect");
                el.appendChild(rectEl);
                if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                    rectEl.setAttribute("clip-path", String.format("url(#%s)", clip));
                }
                rectEl.setAttribute("x", StiChartSvgHelper.r(rect.x + (double)dx));
                rectEl.setAttribute("y", StiChartSvgHelper.r(rect.y + (double)dy));
                rectEl.setAttribute("width", StiChartSvgHelper.r(rect.width));
                rectEl.setAttribute("height", StiChartSvgHelper.r(rect.height));
                rectEl.setAttribute("style", style2.toString());
                rectEl.setAttribute("shape-rendering", "crispEdges");
                if (animation != null) {
                    rectEl.setAttribute("opacity", "0");
                    StiChartSvgHelper.addAnimation(rectEl, "[[\"opacity\", 0 , 1,\"\"]]", animation.beginTime, animation.duration);
                }
                if (!StiValidationUtil.isNullOrEmpty((String)border.getToolTip())) {
                    Element titleEl2 = doc.createElement("title");
                    rectEl.appendChild(titleEl2);
                    titleEl2.setTextContent(border.getToolTip());
                }
            } else if (geom instanceof StiClusteredColumnSeriesAnimationGeom) {
                border = (StiClusteredColumnSeriesAnimationGeom)geom;
                rect = StiChartSvgHelper.rectToRectangleF(border.getColumnRect());
                columnAnimation = border.getAnimation() instanceof StiColumnAnimation ? (StiColumnAnimation)border.getAnimation() : null;
                rectFrom = columnAnimation != null ? columnAnimation.getRectFrom() : StiRectangle.empty();
                style3 = new StringBuilder();
                if (border.getBackground() != null) {
                    style3.append(StiChartSvgHelper.writeFillBrush(el, border.getBackground(), rect, dx, dy, doc));
                } else {
                    style3.append("fill:none;");
                }
                if (StiChartSvgHelper.checkPenGeom(border.getBorderPen())) {
                    String stroke5 = String.format("%s", StiChartSvgHelper.writeBorderStroke(el, border.getBorderPen().getBrush(), rect, doc));
                    style3.append(String.format("%s;stroke-width:%s;", stroke5, border.getBorderPen().getThickness()));
                }
                String rectHeight = StiChartSvgHelper.r(rect.height);
                Element rectEl = doc.createElement("rect");
                el.appendChild(rectEl);
                if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                    rectEl.setAttribute("clip-path", String.format("url(#%s)", clip));
                }
                rectEl.setAttribute("shape-rendering", "crispEdges");
                rectEl.setAttribute("width", StiChartSvgHelper.p(rect.width));
                rectEl.setAttribute("x", StiChartSvgHelper.p(rect.x + (double)dx));
                if (needAnimation.booleanValue()) {
                    if (border.getValue() > 0.0) {
                        if (rectFrom.height == 0.0) {
                            rectEl.setAttribute("y", StiChartSvgHelper.p(rect.height + rect.y + (double)dy));
                            StiChartSvgHelper.addAnimation(rectEl, "[[\"height\", 0, " + rectHeight + ", \"\"], [\"y\"," + StiChartSvgHelper.p(rect.height + rect.y + (double)dy) + ", " + StiChartSvgHelper.p(rect.y + (double)dy) + ", \"\"]]", border.getAnimation().getBeginTime(), border.getAnimation().getDuration());
                        } else {
                            rectEl.setAttribute("y", StiChartSvgHelper.p(rectFrom.y + (double)dy));
                            if (columnAnimation.getValueFrom() >= 0.0) {
                                StiChartSvgHelper.addAnimation(rectEl, "[[\"height\", " + StiChartSvgHelper.p(rectFrom.height) + ", " + rectHeight + ", \"\"], [\"y\"," + StiChartSvgHelper.p(rectFrom.y + (double)dy) + ", " + StiChartSvgHelper.p(rect.y + (double)dy) + ", \"\"]]", border.getAnimation().getBeginTime(), border.getAnimation().getDuration());
                            } else {
                                StiChartSvgHelper.addAnimation(rectEl, "[[\"height\"," + StiChartSvgHelper.p(rectFrom.height) + ", 0,\"\"]]", border.getAnimation().getBeginTime(), (Integer)(border.getAnimation().getDuration() - border.getAnimation().getDuration() / 2));
                                StiChartSvgHelper.addAnimation(rectEl, "[[\"height\", 0, " + StiChartSvgHelper.p(rect.height) + ", \"\"], [\"y\"," + StiChartSvgHelper.p(rect.height + rect.y + (double)dy) + ", " + StiChartSvgHelper.p(rect.y + (double)dy) + ", \"\"]]", border.getAnimation().getBeginTime() + border.getAnimation().getDuration() / 2, border.getAnimation().getDuration() - border.getAnimation().getDuration() / 2, "1");
                            }
                        }
                    } else if (rectFrom.height == 0.0) {
                        rectEl.setAttribute("y", StiChartSvgHelper.p(rect.y + (double)dy));
                        StiChartSvgHelper.addAnimation(rectEl, "[[\"height\", 0, " + rectHeight + ",\"\"]]", border.getAnimation().getBeginTime(), border.getAnimation().getDuration());
                    } else if (columnAnimation.getValueFrom() >= 0.0) {
                        rectEl.setAttribute("y", StiChartSvgHelper.p(rectFrom.y + (double)dy));
                        StiChartSvgHelper.addAnimation(rectEl, "[[\"height\", " + StiChartSvgHelper.p(rectFrom.height) + ", 0, \"\"], [\"y\"," + StiChartSvgHelper.p(rectFrom.y + (double)dy) + ", " + StiChartSvgHelper.p(rectFrom.height + rectFrom.y + (double)dy) + ", \"\"]]", border.getAnimation().getBeginTime(), (Integer)(border.getAnimation().getDuration() - border.getAnimation().getDuration() / 2));
                        StiChartSvgHelper.addAnimation(rectEl, "[[\"height\", 0, " + rectHeight + ", \"\"]]", border.getAnimation().getBeginTime() + border.getAnimation().getDuration() / 2, border.getAnimation().getDuration() - border.getAnimation().getDuration() / 2, "1");
                    } else {
                        rectEl.setAttribute("y", StiChartSvgHelper.p(rectFrom.y + (double)dy));
                        StiChartSvgHelper.addAnimation(rectEl, "[[\"height\", " + StiChartSvgHelper.p(rectFrom.height) + ", " + rectHeight + ",\"\"]]", border.getAnimation().getBeginTime(), border.getAnimation().getDuration());
                    }
                } else {
                    rectEl.setAttribute("height", StiChartSvgHelper.p(rect.height));
                    rectEl.setAttribute("y", StiChartSvgHelper.p(rect.y + (double)dy));
                }
                StiChartSvgHelper.writeInteracrion(rectEl, border.getInteraction());
                rectEl.setAttribute("style", style3.toString());
                if (!StiValidationUtil.isNullOrEmpty((String)border.getToolTip())) {
                    titleEl = doc.createElement("title");
                    rectEl.appendChild(titleEl);
                    titleEl.setTextContent(border.getToolTip());
                }
            } else if (geom instanceof StiLinesAnimationGeom) {
                lines = (StiLinesAnimationGeom)geom;
                if (StiChartSvgHelper.checkPenGeom(lines.getPen())) {
                    guid = "g" + StiGuid.newGuidStringPlain();
                    if (lines.getAnimation().getType() == StiAnimationType.Translation) {
                        StiColor color = (StiColor)lines.getPen().getBrush();
                        Element gEl = doc.createElement("g");
                        el.appendChild(gEl);
                        Element defsEl2 = doc.createElement("defs");
                        gEl.appendChild(defsEl2);
                        Element linearGradientEl = doc.createElement("linearGradient");
                        defsEl2.appendChild(linearGradientEl);
                        linearGradientEl.setAttribute("id", guid);
                        linearGradientEl.setAttribute("x1", "0%");
                        linearGradientEl.setAttribute("y1", "0%");
                        linearGradientEl.setAttribute("x2", "100%");
                        linearGradientEl.setAttribute("y2", "0%");
                        Element stopEl = doc.createElement("stop");
                        linearGradientEl.appendChild(stopEl);
                        stopEl.setAttribute("offset", "0%");
                        stopEl.setAttribute("stop-color", String.format("rgba(%s,%s,%s,%s)", color.r, color.g, color.b, StiChartSvgHelper.r(StiMath.round((float)((float)color.a / 255.0f), (int)3))));
                        stopEl.setAttribute("stop-opacity", "1");
                        stopEl.setAttribute("style", "x: 0px;");
                        StiChartSvgHelper.addAnimation(stopEl, "[[\"offset\", 0 , 100,\"%\"]]", lines.getAnimation().getBeginTime(), lines.getAnimation().getDuration());
                        stopEl = doc.createElement("stop");
                        linearGradientEl.appendChild(stopEl);
                        stopEl.setAttribute("offset", "0%");
                        stopEl.setAttribute("stop-color", "transparent");
                        stopEl.setAttribute("stop-opacity", "0");
                        stopEl.setAttribute("style", "x: 00px;");
                    }
                    StiPointsAnimation animationPoints = lines.getAnimation() instanceof StiPointsAnimation ? (StiPointsAnimation)lines.getAnimation() : null;
                    Element polylineEl = doc.createElement("polyline");
                    el.appendChild(polylineEl);
                    if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                        polylineEl.setAttribute("clip-path", String.format("url(#%s)", clip));
                    }
                    StringBuilder sb = new StringBuilder();
                    StringBuilder pointsTo = new StringBuilder();
                    for (int indexPoint = 0; lines.getPoints().length > indexPoint; ++indexPoint) {
                        StiPoint point = lines.getPoints()[indexPoint];
                        float deltaFix = 0.0f;
                        if (indexPoint == lines.getPoints().length - 1) {
                            deltaFix = 1.0E-4f * (float)indexPoint;
                        }
                        if (animationPoints == null) {
                            sb.append(String.format("%s,%s ", StiChartSvgHelper.p(point.x + (double)dx), StiChartSvgHelper.p(point.y + (double)dy + (double)deltaFix)));
                            continue;
                        }
                        sb.append(String.format("%s,%s ", StiChartSvgHelper.p(animationPoints.getPointsFrom()[indexPoint].x + (double)dx), StiChartSvgHelper.p(animationPoints.getPointsFrom()[indexPoint].y + (double)dy + (double)deltaFix)));
                        pointsTo.append(String.format("%s,%s ", StiChartSvgHelper.p(point.x + (double)dx), StiChartSvgHelper.p(point.y + (double)dy + (double)deltaFix)));
                    }
                    polylineEl.setAttribute("fill", "none");
                    polylineEl.setAttribute("points", sb.toString());
                    if (lines.getAnimation().getType() == StiAnimationType.Opacity || animationPoints != null) {
                        String stroke6 = String.format("%s", StiChartSvgHelper.writeBorderStroke(polylineEl, lines.getPen().getBrush(), new StiRectangle(), doc));
                        StringBuilder style4 = new StringBuilder();
                        style4.append(String.format("%s;stroke-width:%s;", stroke6, StiChartSvgHelper.p(lines.getPen().getThickness())));
                        polylineEl.setAttribute("style", style4.toString());
                        if (animationPoints == null) {
                            polylineEl.setAttribute("opacity", "0");
                            StiChartSvgHelper.addAnimation(polylineEl, "[[\"opacity\", 0 , 1,\"\"]]", lines.getAnimation().getBeginTime(), lines.getAnimation().getDuration());
                        } else {
                            StiChartSvgHelper.addAnimation(polylineEl, "[[\"points\", \"" + sb.toString() + "\", \"" + pointsTo.toString() + "\",\"\"]]", lines.getAnimation().getBeginTime(), lines.getAnimation().getDuration());
                        }
                    } else if (lines.getAnimation().getType() == StiAnimationType.Translation) {
                        polylineEl.setAttribute("stroke-width", StiChartSvgHelper.p(lines.getPen().getThickness()));
                        polylineEl.setAttribute("stroke", String.format("url(#%s)", guid));
                    }
                    if (lines.getPen().getPenStyle() != StiPenStyle.Solid) {
                        polylineEl.setAttribute("stroke-dasharray", StiSvgExportService.StiSvgHelper.getLineStyleDash(lines.getPen().getPenStyle(), lines.getPen().getThickness()));
                    }
                }
            } else if (geom instanceof StiEllipseAnimationGeom) {
                ellipse = (StiEllipseAnimationGeom)geom;
                rect = StiChartSvgHelper.rectToRectangleF(ellipse.getRect());
                style = "";
                style = ellipse.getBackground() != null ? StiChartSvgHelper.writeFillBrush(el, ellipse.getBackground(), rect, dx, dy, doc) : "fill:none;";
                if (StiChartSvgHelper.checkPenGeom(ellipse.getBorderPen())) {
                    stroke = String.format("%s", StiChartSvgHelper.writeBorderStroke(el, ellipse.getBorderPen().getBrush(), rect, doc));
                    style = (String)style + String.format("%s;stroke-width:%s;", stroke, StiChartSvgHelper.p(ellipse.getBorderPen().getThickness()));
                }
                Element ellipseEl = doc.createElement("ellipse");
                el.appendChild(ellipseEl);
                ellipseEl.setAttribute("rx", StiChartSvgHelper.p(rect.width / 2.0));
                ellipseEl.setAttribute("ry", StiChartSvgHelper.p(rect.height / 2.0));
                if (ellipse.getAnimation().getType() != StiAnimationType.Scale) {
                    ellipseEl.setAttribute("cx", StiChartSvgHelper.p(rect.x + (double)dx + rect.width / 2.0));
                    ellipseEl.setAttribute("cy", StiChartSvgHelper.p(rect.y + (double)dy + rect.height / 2.0));
                }
                ellipseEl.setAttribute("style", (String)style);
                if (ellipse.getAnimation().getType() == StiAnimationType.Opacity) {
                    ellipseEl.setAttribute("opacity", "0");
                    StiChartSvgHelper.addAnimation(ellipseEl, "[[\"opacity\", 0 , 1,\"\"]]", ellipse.getAnimation().getBeginTime(), ellipse.getAnimation().getDuration());
                } else if (ellipse.getAnimation().getType() == StiAnimationType.Scale) {
                    ellipseEl.setAttribute("transform", "scale(0)");
                    StiChartSvgHelper.addAnimation(ellipseEl, String.format("[[\"transform\", 0 , 1,\")\",\"translate(%s,%s) scale(\"]]", StiChartSvgHelper.p(rect.x + (double)dx + rect.width / 2.0), StiChartSvgHelper.p(rect.y + (double)dy + rect.height / 2.0)), ellipse.getAnimation().getBeginTime(), ellipse.getAnimation().getDuration());
                }
                StiChartSvgHelper.writeInteracrion(ellipseEl, ellipse.getInteraction());
                if (!StiValidationUtil.isNullOrEmpty((String)ellipse.getToolTip())) {
                    Element tittleEl = doc.createElement("title");
                    ellipseEl.appendChild(tittleEl);
                    tittleEl.setTextContent(ellipse.getToolTip());
                }
            } else if (geom instanceof StiPathElementAnimationGeom) {
                path = (StiPathElementAnimationGeom)geom;
                rect = StiChartSvgHelper.rectToRectangleF(path.getRect());
                style = "";
                style = path.getBackground() != null ? StiChartSvgHelper.writeFillBrush(el, path.getBackground(), rect, dx, dy, doc) : "fill:none;";
                if (StiChartSvgHelper.checkPenGeom(path.getBorderPen())) {
                    stroke = String.format("%s", StiChartSvgHelper.writeBorderStroke(el, path.getBorderPen().getBrush(), rect, doc));
                    style = (String)style + String.format("%s;stroke-width:%s;", stroke, StiChartSvgHelper.p(path.getBorderPen().getThickness()));
                }
                animatedPath = new StringBuilder();
                duration = 0;
                Map<String, Object> result = StiChartSvgHelper.getPathData(path.getPathGeoms(), dx, dy, animatedPath, duration);
                duration = (Integer)result.get("duration");
                String pathData = (String)result.get("result");
                pathEl = doc.createElement("path");
                el.appendChild(pathEl);
                if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                    pathEl.setAttribute("clip-path", String.format("url(#%s)", clip));
                }
                pathEl.setAttribute("d", pathData);
                pathEl.setAttribute("style", (String)style);
                if (animatedPath.length() == 0) {
                    if (path.getAnimation() != null) {
                        pathEl.setAttribute("opacity", "0");
                        StiChartSvgHelper.addAnimation(pathEl, "[[\"opacity\", 0 , 1,\"\"]]", path.getAnimation().getBeginTime(), path.getAnimation().getDuration());
                    }
                } else if (path.getPathGeoms().size() == 1 && path.getPathGeoms().get(0) instanceof StiPieSegmentGeom) {
                    StiChartSvgHelper.addAnimation(pathEl, "[[\"pie\", \"" + animatedPath + "\", 1,\"\"]]", 0, duration);
                } else {
                    StiChartSvgHelper.addAnimation(pathEl, "[[\"path\", \"" + animatedPath + "\", 1,\"\"]]", 0, duration);
                }
                StiChartSvgHelper.writeInteracrion(pathEl, path.getInteraction());
                if (!StiValidationUtil.isNullOrEmpty((String)path.getToolTip())) {
                    Element titleEl3 = doc.createElement("title");
                    pathEl.appendChild(titleEl3);
                    titleEl3.setTextContent(path.getToolTip());
                }
            } else if (geom instanceof StiPathAnimationGeom) {
                path = (StiPathAnimationGeom)geom;
                rect = StiChartSvgHelper.rectToRectangleF(path.getRect());
                style = "";
                style = path.getBackground() != null ? StiChartSvgHelper.writeFillBrush(el, path.getBackground(), rect, dx, dy, doc) : "fill:none;";
                if (StiChartSvgHelper.checkPenGeom(path.getPen())) {
                    stroke = String.format("%s", StiChartSvgHelper.writeBorderStroke(el, path.getPen().getBrush(), rect, doc));
                    style = (String)style + String.format("%s;stroke-width:%s;", stroke, StiChartSvgHelper.p(path.getPen().getThickness()));
                }
                animatedPath = new StringBuilder();
                duration = 0;
                Map<String, Object> result = StiChartSvgHelper.getPathData(path.getGeoms(), dx, dy, animatedPath, duration);
                duration = (Integer)result.get("duration");
                String pathData = (String)result.get("result");
                pathEl = doc.createElement("path");
                el.appendChild(pathEl);
                if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                    pathEl.setAttribute("clip-path", String.format("url(#%s)", clip));
                }
                pathEl.setAttribute("d", pathData);
                pathEl.setAttribute("style", (String)style);
                if (path.getAnimation() != null) {
                    pathEl.setAttribute("opacity", "0");
                    StiChartSvgHelper.addAnimation(pathEl, "[[\"opacity\", 0 , 1,\"\"]]", path.getAnimation().getBeginTime(), path.getAnimation().getDuration());
                } else if (animatedPath.length() != 0) {
                    StiChartSvgHelper.addAnimation(pathEl, "[[\"path\", \"" + animatedPath + "\", 1,\"\"]]", 0, duration);
                }
            } else if (geom instanceof StiCurveAnimationGeom) {
                StiPointsAnimation animationPoints;
                curve = (StiCurveAnimationGeom)geom;
                StiPointsAnimation stiPointsAnimation = animationPoints = curve.getAnimation() instanceof StiPointsAnimation ? (StiPointsAnimation)curve.getAnimation() : null;
                if (StiChartSvgHelper.checkPenGeom(curve.getPen())) {
                    guid2 = "g" + StiGuid.newGuidStringPlain();
                    StiColor color = (StiColor)curve.getPen().getBrush();
                    Element gEl = doc.createElement("g");
                    el.appendChild(gEl);
                    Element defsEl3 = doc.createElement("defs");
                    gEl.appendChild(defsEl3);
                    Element linearGradientEl = doc.createElement("linearGradient");
                    defsEl3.appendChild(linearGradientEl);
                    linearGradientEl.setAttribute("id", guid2);
                    linearGradientEl.setAttribute("x1", "0%");
                    linearGradientEl.setAttribute("y1", "0%");
                    linearGradientEl.setAttribute("x2", "100%");
                    linearGradientEl.setAttribute("y2", "0%");
                    Element stopEl = doc.createElement("stop");
                    linearGradientEl.appendChild(stopEl);
                    stopEl.setAttribute("offset", "0%");
                    stopEl.setAttribute("stop-color", String.format("rgba(%s,%s,%s,%s)", color.r, color.g, color.b, StiChartSvgHelper.p(StiMath.round((float)((float)color.a / 255.0f), (int)3))));
                    stopEl.setAttribute("stop-opacity", "1");
                    stopEl.setAttribute("style", "x: 0px;");
                    if (animationPoints == null) {
                        StiChartSvgHelper.addAnimation(stopEl, "[[\"offset\", 0 , 100,\"%\"]]", curve.getAnimation().getBeginTime(), curve.getAnimation().getDuration());
                    }
                    if (animationPoints == null) {
                        stopEl = doc.createElement("stop");
                        linearGradientEl.appendChild(stopEl);
                        stopEl.setAttribute("offset", "0%");
                        stopEl.setAttribute("stop-color", "transparent");
                        stopEl.setAttribute("stop-opacity", "0");
                        stopEl.setAttribute("style", "x: 0px;");
                    }
                    Element pathEl2 = doc.createElement("path");
                    el.appendChild(pathEl2);
                    if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                        pathEl2.setAttribute("clip-path", String.format("url(#%s)", clip));
                    }
                    StiPoint[] pts = StiChartSvgHelper.convertSplineToCubicBezier(curve.getPoints(), curve.getTension());
                    if (animationPoints != null) {
                        StringBuilder animatedPath2 = new StringBuilder();
                        StiPoint[] fromPts = StiChartSvgHelper.convertSplineToCubicBezier(animationPoints.getPointsFrom(), curve.getTension());
                        animatedPath2.append(String.format("M%s:%s,%s:%s C", StiChartSvgHelper.p(fromPts[0].x + (double)dx), StiChartSvgHelper.p(pts[0].x + (double)dx), StiChartSvgHelper.p(fromPts[0].y + (double)dy), StiChartSvgHelper.p(pts[0].y + (double)dy)));
                        for (int index2 = 1; index2 < pts.length; ++index2) {
                            animatedPath2.append(String.format("%s:%s,%s:%s ", StiChartSvgHelper.p(fromPts[index2].x + (double)dx), StiChartSvgHelper.p(pts[index2].x + (double)dx), StiChartSvgHelper.p(fromPts[index2].y + (double)dy), StiChartSvgHelper.p(pts[index2].y + (double)dy + (double)index2 * 1.0E-4)));
                        }
                        StiChartSvgHelper.addAnimation(pathEl2, "[[\"path\", \"" + animatedPath2 + "\", 1,\"\"]]", 0, (Integer)1000);
                        StringBuilder stSpline = new StringBuilder();
                        stSpline.append(String.format("M%s,%s C", StiChartSvgHelper.p(fromPts[0].x + (double)dx), StiChartSvgHelper.p(fromPts[0].y + (double)dy)));
                        for (index = 1; index < fromPts.length; ++index) {
                            stSpline.append(String.format("%s,%s ", StiChartSvgHelper.p(fromPts[index].x + (double)dx), StiChartSvgHelper.p(fromPts[index].y + (double)dy + (double)index * 1.0E-4)));
                        }
                        pathEl2.setAttribute("d", stSpline.toString());
                    } else {
                        StringBuilder stSpline = new StringBuilder();
                        stSpline.append(String.format("M%s,%s C", StiChartSvgHelper.p(pts[0].x + (double)dx), StiChartSvgHelper.p(pts[0].y + (double)dy)));
                        for (int index3 = 1; index3 < pts.length; ++index3) {
                            stSpline.append(String.format("%s,%s ", StiChartSvgHelper.p(pts[index3].x + (double)dx), StiChartSvgHelper.p(pts[index3].y + (double)dy + (double)index3 * 1.0E-4)));
                        }
                        pathEl2.setAttribute("d", stSpline.toString());
                    }
                    pathEl2.setAttribute("fill", "none");
                    pathEl2.setAttribute("stroke-width", StiChartSvgHelper.p(curve.getPen().getThickness()));
                    pathEl2.setAttribute("stroke", String.format("url(#%s)", guid2));
                    if (curve.getPen().getPenStyle() != StiPenStyle.Solid) {
                        pathEl2.setAttribute("stroke-dasharray", StiSvgExportService.StiSvgHelper.getLineStyleDash(curve.getPen().getPenStyle(), curve.getPen().getThickness()));
                    }
                }
            }
            if (geom instanceof StiBorderGeom) {
                border = (StiBorderGeom)geom;
                rect = StiChartSvgHelper.rectToRectangleF(border.getRect());
                style = new StringBuilder();
                if (border.getBackground() != null) {
                    ((StringBuilder)style).append(StiChartSvgHelper.writeFillBrush(el, border.getBackground(), rect, dx, dy, doc));
                } else {
                    ((StringBuilder)style).append("fill:none;");
                }
                if (StiChartSvgHelper.checkPenGeom(border.getBorderPen())) {
                    stroke = String.format("%s", StiChartSvgHelper.writeBorderStroke(el, border.getBorderPen().getBrush(), rect, doc));
                    ((StringBuilder)style).append(String.format("%s;stroke-width:%s;", stroke, border.getBorderPen().getThickness()));
                }
                Element rect2 = doc.createElement("rect");
                el.appendChild(rect2);
                if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                    rect2.setAttribute("clip-path", String.format("url(#%s)", clip));
                }
                rect2.setAttribute("x", StiChartSvgHelper.r(rect.x + (double)dx));
                rect2.setAttribute("y", StiChartSvgHelper.r(rect.y + (double)dy));
                rect2.setAttribute("width", StiChartSvgHelper.r(rect.width));
                rect2.setAttribute("height", StiChartSvgHelper.r(rect.height));
                rect2.setAttribute("style", ((StringBuilder)style).toString());
                rect2.setAttribute("shape-rendering", "crispEdges");
                StiChartSvgHelper.writeInteracrion(rect2, border.getInteraction());
            }
            if (geom instanceof StiLineGeom && StiChartSvgHelper.checkPenGeom((line = (StiLineGeom)geom).getPen())) {
                Element line2 = doc.createElement("line");
                el.appendChild(line2);
                if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                    line2.setAttribute("clip-path", String.format("url(#%s)", clip));
                }
                line2.setAttribute("x1", StiChartSvgHelper.r(Float.valueOf(line.getX1() + dx)));
                line2.setAttribute("y1", StiChartSvgHelper.r(Float.valueOf(line.getY1() + dy)));
                line2.setAttribute("x2", StiChartSvgHelper.r(Float.valueOf(line.getX2() + dx)));
                line2.setAttribute("y2", StiChartSvgHelper.r(Float.valueOf(line.getY2() + dy)));
                String stroke7 = String.format("%s", StiChartSvgHelper.writeBorderStroke(line2, line.getPen().getBrush(), new StiRectangle(), doc));
                style2 = String.format("%s;stroke-width:%s;", stroke7, StiChartSvgHelper.r(line.getPen().getThickness()));
                line2.setAttribute("style", (String)style2);
                if (line.getPen().getPenStyle() != StiPenStyle.Solid) {
                    line2.setAttribute("stroke-dasharray", StiSvgExportService.StiSvgHelper.getLineStyleDash(line.getPen().getPenStyle(), line.getPen().getThickness()));
                }
            }
            if (geom instanceof StiLinesGeom && StiChartSvgHelper.checkPenGeom((lines = (StiLinesGeom)geom).getPen())) {
                Element polyline = doc.createElement("polyline");
                el.appendChild(polyline);
                if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                    polyline.setAttribute("clip-path", String.format("url(#%s)", clip));
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < lines.getPoints().length; ++i) {
                    StiPoint point = lines.getPoints()[i];
                    sb.append(String.format("%s,%s ", StiChartSvgHelper.r(point.x + (double)dx), StiChartSvgHelper.r(point.y + (double)dy + (double)i * 1.0E-4)));
                }
                polyline.setAttribute("fill", "none");
                polyline.setAttribute("points", sb.toString());
                stroke = String.format("%s", StiChartSvgHelper.writeBorderStroke(polyline, lines.getPen().getBrush(), new StiRectangle(), doc));
                style3 = new StringBuilder();
                style3.append(String.format("%s;stroke-width:%s;", stroke, StiChartSvgHelper.r(lines.getPen().getThickness())));
                polyline.setAttribute("style", style3.toString());
                if (lines.getPen().getPenStyle() != StiPenStyle.Solid) {
                    polyline.setAttribute("stroke-dasharray", StiSvgExportService.StiSvgHelper.getLineStyleDash(lines.getPen().getPenStyle(), lines.getPen().getThickness()));
                }
            }
            if (geom instanceof StiCurveGeom && StiChartSvgHelper.checkPenGeom((curve = (StiCurveGeom)geom).getPen())) {
                Element path2 = doc.createElement("path");
                el.appendChild(path2);
                if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                    path2.setAttribute("clip-path", String.format("url(#%s)", clip));
                }
                StiPoint[] pts = StiChartSvgHelper.convertSplineToCubicBezier(curve.getPoints(), curve.getTension());
                StringBuilder stSpline = new StringBuilder();
                stSpline.append(String.format("M%s,%s C", StiChartSvgHelper.r(pts[0].x + (double)dx), StiChartSvgHelper.r(pts[0].y + (double)dy)));
                for (int index4 = 1; index4 < pts.length; ++index4) {
                    stSpline.append(String.format("%s,%s ", StiChartSvgHelper.r(pts[index4].x + (double)dx), StiChartSvgHelper.r(pts[index4].y + (double)dy + (double)index4 * 1.0E-4)));
                }
                path2.setAttribute("d", stSpline.toString());
                path2.setAttribute("fill", "none");
                stroke2 = String.format("%s", StiChartSvgHelper.writeBorderStroke(path2, curve.getPen().getBrush(), new StiRectangle(), doc));
                String style5 = String.format("%s;stroke-width:%s;", stroke2, StiChartSvgHelper.r(curve.getPen().getThickness()));
                path2.setAttribute("style", style5);
                if (curve.getPen().getPenStyle() != StiPenStyle.Solid) {
                    path2.setAttribute("stroke-dasharray", StiSvgExportService.StiSvgHelper.getLineStyleDash(curve.getPen().getPenStyle(), curve.getPen().getThickness()));
                }
            }
            if (geom instanceof StiEllipseGeom) {
                ellipse = (StiEllipseGeom)geom;
                rect = ellipse.getRect();
                style = "";
                style = ellipse.getBackground() != null ? StiChartSvgHelper.writeFillBrush(el, ellipse.getBackground(), rect, dx, dy, doc) : "fill:none;";
                if (StiChartSvgHelper.checkPenGeom(ellipse.getBorderPen())) {
                    stroke = String.format("%s", StiChartSvgHelper.writeBorderStroke(el, ellipse.getBorderPen().getBrush(), rect, doc));
                    style = (String)style + String.format("%s;stroke-width:%s;", stroke, StiChartSvgHelper.r(ellipse.getBorderPen().getThickness()));
                }
                Element ellipse2 = doc.createElement("ellipse");
                el.appendChild(ellipse2);
                if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                    ellipse2.setAttribute("clip-path", String.format("url(#%s)", clip));
                }
                ellipse2.setAttribute("cx", StiChartSvgHelper.r(rect.x + (double)dx + rect.width / 2.0));
                ellipse2.setAttribute("cy", StiChartSvgHelper.r(rect.y + (double)dy + rect.height / 2.0));
                ellipse2.setAttribute("rx", StiChartSvgHelper.r(rect.width / 2.0));
                ellipse2.setAttribute("ry", StiChartSvgHelper.r(rect.height / 2.0));
                ellipse2.setAttribute("style", (String)style);
                StiChartSvgHelper.writeInteracrion(ellipse2, ellipse.getInteraction());
            }
            if (geom instanceof StiCachedShadowGeom && needStaticShadow) {
                shadow = (StiCachedShadowGeom)geom;
                rect = shadow.getRect().clone();
                rect.x += 2.0;
                rect.y += 2.0;
                guid2 = "s" + StiGuid.newGuid();
                defsEl = doc.createElement("defs");
                el.appendChild(defsEl);
                filterEl = doc.createElement("filter");
                defsEl.appendChild(filterEl);
                filterEl.setAttribute("id", guid2);
                Element feGaussianBlurEl = doc.createElement("filter");
                filterEl.appendChild(feGaussianBlurEl);
                feGaussianBlurEl.setAttribute("in", "SourceGraphic");
                feGaussianBlurEl.setAttribute("stdDeviation", "2");
                Element rectEl = doc.createElement("rect");
                el.appendChild(rectEl);
                rectEl.setAttribute("x", StiChartSvgHelper.p(rect.x + (double)dx));
                rectEl.setAttribute("y", StiChartSvgHelper.p(rect.y + (double)dy));
                rectEl.setAttribute("width", StiChartSvgHelper.p(rect.width));
                rectEl.setAttribute("height", StiChartSvgHelper.p(rect.height));
                rectEl.setAttribute("fill", "rgba(190,190,190,10)");
                rectEl.setAttribute("filter", "url(#" + guid2 + ")");
            }
            if (geom instanceof StiShadowGeom) {
                shadow = (StiShadowGeom)geom;
                guid = "s" + StiGuid.newGuid();
                Element defsEl4 = doc.createElement("defs");
                el.appendChild(defsEl4);
                Element filterEl2 = doc.createElement("filter");
                defsEl4.appendChild(filterEl2);
                filterEl2.setAttribute("id", guid);
                filterEl2.setAttribute("x", "0");
                filterEl2.setAttribute("y", "0");
                filterEl2.setAttribute("width", "200%");
                filterEl2.setAttribute("height", "200%");
                Element feOffsetEl = doc.createElement("feOffset");
                filterEl2.appendChild(feOffsetEl);
                feOffsetEl.setAttribute("result", "offOut");
                feOffsetEl.setAttribute("in", "SourceGraphic");
                feOffsetEl.setAttribute("dx", "1.111111111111111");
                feOffsetEl.setAttribute("dy", "1.111111111111111");
                Element feColorMatrixEl = doc.createElement("feColorMatrix");
                filterEl2.appendChild(feColorMatrixEl);
                feColorMatrixEl.setAttribute("result", "matrixOut");
                feColorMatrixEl.setAttribute("in", "offOut");
                feColorMatrixEl.setAttribute("type", "matrix");
                feColorMatrixEl.setAttribute("values", "0.58 0 0 0 0 0 0.58 0 0 0 0 0 0.58 0 0 0 0 0 1 0");
                Element feGaussianBlurEl = doc.createElement("feGaussianBlur");
                filterEl2.appendChild(feGaussianBlurEl);
                feGaussianBlurEl.setAttribute("result", "blurOut");
                feGaussianBlurEl.setAttribute("in", "matrixOut");
                feGaussianBlurEl.setAttribute("stdDeviation", "1.111111111111111");
                Element feBlendEl = doc.createElement("feBlend");
                filterEl2.appendChild(feBlendEl);
                feBlendEl.setAttribute("mode", "normal");
                feBlendEl.setAttribute("in", "SourceGraphic");
                feBlendEl.setAttribute("in2", "blurOut");
                for (StiGeom sgeom : shadow.getShadowContext().getGeoms()) {
                    StringBuilder animatedPath3 = null;
                    int duration2 = 0;
                    StiPathGeom pathGeom = sgeom instanceof StiPathGeom ? (StiPathGeom)sgeom : null;
                    if (pathGeom == null) continue;
                    Map<String, Object> result = StiChartSvgHelper.getPathData(pathGeom.getGeoms(), dx, dy, animatedPath3, duration2);
                    String pathData = (String)result.get("result");
                    Element pathEl3 = doc.createElement("path");
                    el.appendChild(pathEl3);
                    if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                        pathEl3.setAttribute("clip-path", String.format("url(#%s)", clip));
                    }
                    pathEl3.setAttribute("d", pathData);
                    pathEl3.setAttribute("fill", "rgb(150,150,150)");
                    pathEl3.setAttribute("filter", String.format("url(#%s)", guid));
                }
            }
            if (geom instanceof StiTextGeom) {
                StiRectangle rect3;
                textGeom = (StiTextGeom)geom;
                StiFont font = new StiFont(textGeom.getFont().getFontName(), textGeom.getFont().getFontSize(), textGeom.getFont().getFontStyle());
                StringFormat sf = new StringFormat();
                sf.Alignment = textGeom.getStringFormat().getAlignment();
                sf.FormatFlags = textGeom.getStringFormat().getFormatFlags();
                sf.HotkeyPrefix = textGeom.getStringFormat().getHotkeyPrefix();
                sf.LineAlignment = textGeom.getStringFormat().getLineAlignment();
                sf.Trimming = textGeom.getStringFormat().getTrimming();
                StiPoint pointF = new StiPoint();
                if (textGeom.getAngle() == 0.0 && !(textGeom.getLocation() instanceof StiPoint) && !textGeom.isRotatedText()) {
                    rect3 = StiChartSvgHelper.rectToRectangleF(textGeom.getLocation());
                    pointF = new StiPoint(rect3.x, rect3.y);
                } else if (!(textGeom.getLocation() instanceof StiPoint)) {
                    rect3 = StiChartSvgHelper.rectToRectangleF(textGeom.getLocation());
                    pointF = new StiPoint(rect3.x + rect3.width / 2.0, rect3.y + rect3.height / 2.0);
                } else {
                    pointF = (StiPoint)textGeom.getLocation();
                }
                style3 = new StringBuilder();
                double size = font.getSize() * 4.0 / 3.0;
                Element text = doc.createElement("text");
                el.appendChild(text);
                if (textGeom.getRotationMode() == null) {
                    text.setAttribute("dy", "1em");
                } else {
                    switch (textGeom.getRotationMode()) {
                        case LeftCenter: {
                            text.setAttribute("dy", "0.5em");
                            break;
                        }
                        case LeftBottom: {
                            break;
                        }
                        case CenterTop: {
                            style3.append(String.format("text-anchor:%s;", "middle"));
                            text.setAttribute("dy", "1em");
                            break;
                        }
                        case CenterCenter: {
                            style3.append(String.format("text-anchor:%s;", "middle"));
                            text.setAttribute("dy", "0.5em");
                            break;
                        }
                        case CenterBottom: {
                            style3.append(String.format("text-anchor:%s;", "middle"));
                            break;
                        }
                        case RightTop: {
                            style3.append(String.format("text-anchor:%s;", "end"));
                            text.setAttribute("dy", "1em");
                            break;
                        }
                        case RightCenter: {
                            style3.append(String.format("text-anchor:%s;", "end"));
                            text.setAttribute("dy", "0.5em");
                            break;
                        }
                        case RightBottom: {
                            style3.append(String.format("text-anchor:%s;", "end"));
                            break;
                        }
                        default: {
                            text.setAttribute("dy", "1em");
                        }
                    }
                }
                text.setAttribute("transform", String.format("translate(%s, %s) rotate(%s 0,0)", StiChartSvgHelper.r(pointF.x + (double)dx), StiChartSvgHelper.r(pointF.y + (double)dy), textGeom.getAngle()));
                text.setAttribute("font-size", StiChartSvgHelper.r(size));
                text.setAttribute("font-family", font.getName());
                if (textGeom.getFont().getFontStyle().contains((IStiEnum)StiFontStyle.Bold)) {
                    text.setAttribute("font-weight", "bold");
                }
                if (textGeom.getFont().getFontStyle().contains((IStiEnum)StiFontStyle.Italic)) {
                    text.setAttribute("font-style", "italic");
                }
                String valueDecoration = "";
                if (textGeom.getFont().getFontStyle().contains((IStiEnum)StiFontStyle.Underline)) {
                    valueDecoration = valueDecoration + "underline";
                }
                if (textGeom.getFont().getFontStyle().contains((IStiEnum)StiFontStyle.Strikeout)) {
                    valueDecoration = valueDecoration + " line-through";
                }
                if (!StiValidationUtil.isNullOrEmpty((String)valueDecoration)) {
                    text.setAttribute("text-decoration", valueDecoration);
                }
                StiColor textColor = StiBrush.ToColor((StiBrush)((StiBrush)textGeom.getBrush()));
                style3.append(String.format("fill:%s;", textColor.toHTML()));
                if (textColor.getA() != 255) {
                    style3.append(String.format("fill-opacity:%s", StiChartSvgHelper.r(StiMath.round((float)((float)textColor.getA() / 255.0f), (int)3))));
                }
                text.setAttribute("style", style3.toString());
                if (textGeom.getMaximalWidth() != null && textGeom.getMaximalWidth() != 0) {
                    int length;
                    int wrapCharCount = length = textGeom.getText().length();
                    StiSize rectTemp = new StiSize(0, 0);
                    for (index = 0; index < length; ++index) {
                        rectTemp = context.MeasureString(textGeom.getText().substring(0, index), textGeom.getFont());
                        if (!(rectTemp.width > (double)textGeom.getMaximalWidth().intValue()) || index == 0) continue;
                        wrapCharCount = index - 1;
                        break;
                    }
                    double countRow = Math.ceil((double)length / (double)wrapCharCount);
                    double startPointY = 0.0;
                    switch (textGeom.getRotationMode()) {
                        case LeftCenter: 
                        case CenterCenter: 
                        case RightCenter: {
                            startPointY = -countRow * rectTemp.height / 2.0 + rectTemp.height / 2.0;
                            break;
                        }
                        default: {
                            startPointY = 0.0;
                        }
                    }
                    if (wrapCharCount > 0) {
                        int startIndex = 0;
                        int index5 = 0;
                        while (startIndex < length) {
                            Element tspanEl = doc.createElement("tspan");
                            text.appendChild(tspanEl);
                            tspanEl.setAttribute("x", "0");
                            if (index5 == 0) {
                                tspanEl.setAttribute("y", StiChartSvgHelper.p(startPointY));
                            } else {
                                tspanEl.setAttribute("dy", StiChartSvgHelper.p(rectTemp.height));
                            }
                            tspanEl.setTextContent(textGeom.getText().substring(startIndex, Math.min(startIndex + wrapCharCount, textGeom.getText().length())));
                            startIndex += wrapCharCount;
                            ++index5;
                        }
                    }
                } else {
                    text.setTextContent(textGeom.getText());
                }
            }
            if (!(geom instanceof StiPathGeom)) continue;
            path = (StiPathGeom)geom;
            rect = StiChartSvgHelper.rectToRectangleF(path.getRect());
            style = "";
            style = path.getBackground() != null ? StiChartSvgHelper.writeFillBrush(el, path.getBackground(), rect, dx, dy, doc) : "fill:none;";
            if (StiChartSvgHelper.checkPenGeom(path.getPen())) {
                stroke = String.format("%s", StiChartSvgHelper.writeBorderStroke(el, path.getPen().getBrush(), rect, doc));
                style = (String)style + String.format("%s;stroke-width:%s;", stroke, StiChartSvgHelper.r(path.getPen().getThickness()));
            }
            Map<String, Object> result = StiChartSvgHelper.getPathData(path.getGeoms(), dx, dy, new StringBuilder(), 0);
            String pathData = (String)result.get("result");
            Element path2 = doc.createElement("path");
            el.appendChild(path2);
            if (!StiValidationUtil.isNullOrEmpty((String)clip)) {
                path2.setAttribute("clip-path", String.format("url(#%s)", clip));
            }
            path2.setAttribute("d", pathData);
            path2.setAttribute("style", (String)style);
            StiChartSvgHelper.writeInteracrion(path2, path.getInteraction());
        }
    }

    private static void writeInteracrion(Element element, StiInteractionDataGeom interaction) {
        if (interaction != null) {
            element.setAttribute("interaction", interaction.componentName);
            element.setAttribute("pageguid", interaction.pageGuid);
            element.setAttribute("compindex", interaction.componentIndex);
            element.setAttribute("pageindex", interaction.pageIndex);
            element.setAttribute("elementindex", interaction.elementIndex);
        }
    }

    private static Map<String, Object> getPathData(List<StiSegmentGeom> geoms, float dx, float dy, StringBuilder animatedPath, Integer duration) {
        String path = "";
        duration = 0;
        for (StiSegmentGeom geom : geoms) {
            StringBuilder sb;
            StiPointsAnimation animation;
            if (geom instanceof StiArcSegmentGeom) {
                StiArcSegmentGeom arcSegment = (StiArcSegmentGeom)geom;
                path = path + StiChartSvgHelper.addArcPath(arcSegment, path, dx, dy);
                continue;
            }
            if (geom instanceof StiCurveSegmentGeom) {
                StiCurveSegmentGeom curveSegment = (StiCurveSegmentGeom)geom;
                animation = curveSegment.getAnimation() instanceof StiPointsAnimation ? (StiPointsAnimation)curveSegment.getAnimation() : null;
                StiPoint[] points = StiCurveHelper.cardinalSpline(curveSegment.getPoints(), false);
                StiPoint[] pointsFrom = animation != null ? StiCurveHelper.cardinalSpline(animation.getPointsFrom(), false) : null;
                StringBuilder sb2 = new StringBuilder();
                for (int index = 1; index < points.length; index += 3) {
                    if (animation != null) {
                        if (index == 1) {
                            sb2.append(String.format("C%s,%s,%s,%s,%s,%s", StiChartSvgHelper.p(pointsFrom[index].x + (double)dx), StiChartSvgHelper.p(pointsFrom[index].y + (double)dy), StiChartSvgHelper.p(pointsFrom[index + 1].x + (double)dx), StiChartSvgHelper.p(pointsFrom[index + 1].y + (double)dy), StiChartSvgHelper.p(pointsFrom[index + 2].x + (double)dx), StiChartSvgHelper.p(pointsFrom[index + 2].y + (double)dy)));
                        } else {
                            sb2.append(String.format(",%s,%s,%s,%s,%s,%s", StiChartSvgHelper.p(pointsFrom[index].x + (double)dx), StiChartSvgHelper.p(pointsFrom[index].y + (double)dy), StiChartSvgHelper.p(pointsFrom[index + 1].x + (double)dx), StiChartSvgHelper.p(pointsFrom[index + 1].y + (double)dy), StiChartSvgHelper.p(pointsFrom[index + 2].x + (double)dx), StiChartSvgHelper.p(pointsFrom[index + 2].y + (double)dy + (double)index * 1.0E-4)));
                        }
                        if (index == 1) {
                            animatedPath.append(String.format("C%s:%s,%s:%s,%s:%s,%s:%s,%s:%s,%s:%s", StiChartSvgHelper.p(pointsFrom[index].x + (double)dx), StiChartSvgHelper.p(points[index].x + (double)dx), StiChartSvgHelper.p(pointsFrom[index].y + (double)dy), StiChartSvgHelper.p(points[index].y + (double)dy), StiChartSvgHelper.p(pointsFrom[index + 1].x + (double)dx), StiChartSvgHelper.p(points[index + 1].x + (double)dx), StiChartSvgHelper.p(pointsFrom[index + 1].y + (double)dy), StiChartSvgHelper.p(points[index + 1].y + (double)dy), StiChartSvgHelper.p(pointsFrom[index + 2].x + (double)dx), StiChartSvgHelper.p(points[index + 2].x + (double)dx), StiChartSvgHelper.p(pointsFrom[index + 2].y + (double)dy), StiChartSvgHelper.p(points[index + 2].y + (double)dy)));
                        } else {
                            animatedPath.append(String.format(",%s:%s,%s:%s,%s:%s,%s:%s,%s:%s,%s:%s", StiChartSvgHelper.p(pointsFrom[index].x + (double)dx), StiChartSvgHelper.p(points[index].x + (double)dx), StiChartSvgHelper.p(pointsFrom[index].y + (double)dy), StiChartSvgHelper.p(points[index].y + (double)dy), StiChartSvgHelper.p(pointsFrom[index + 1].x + (double)dx), StiChartSvgHelper.p(points[index + 1].x + (double)dx), StiChartSvgHelper.p(pointsFrom[index + 1].y + (double)dy), StiChartSvgHelper.p(points[index + 1].y + (double)dy), StiChartSvgHelper.p(pointsFrom[index + 2].x + (double)dx), StiChartSvgHelper.p(points[index + 2].x + (double)dx), StiChartSvgHelper.p(pointsFrom[index + 2].y + (double)dy), StiChartSvgHelper.p(points[index + 2].y + (double)dy + (double)index * 1.0E-4)));
                        }
                        duration = 1000;
                        continue;
                    }
                    if (index == 1) {
                        sb2.append(String.format("C%s,%s,%s,%s,%s,%s", StiChartSvgHelper.p(points[index].x + (double)dx), StiChartSvgHelper.p(points[index].y + (double)dy), StiChartSvgHelper.p(points[index + 1].x + (double)dx), StiChartSvgHelper.p(points[index + 1].y + (double)dy), StiChartSvgHelper.p(points[index + 2].x + (double)dx), StiChartSvgHelper.p(points[index + 2].y + (double)dy)));
                        continue;
                    }
                    sb2.append(String.format(",%s,%s,%s,%s,%s,%s", StiChartSvgHelper.p(points[index].x + (double)dx), StiChartSvgHelper.p(points[index].y + (double)dy), StiChartSvgHelper.p(points[index + 1].x + (double)dx), StiChartSvgHelper.p(points[index + 1].y + (double)dy), StiChartSvgHelper.p(points[index + 2].x + (double)dx), StiChartSvgHelper.p(points[index + 2].y + (double)dy + (double)index * 1.0E-4)));
                }
                path = path + sb2;
                continue;
            }
            if (geom instanceof StiLineSegmentGeom) {
                StiLineSegmentGeom lineSegment = (StiLineSegmentGeom)geom;
                animation = lineSegment.getAnimation() instanceof StiPointsAnimation ? (StiPointsAnimation)lineSegment.getAnimation() : null;
                sb = new StringBuilder();
                if (!path.startsWith("M")) {
                    if (animation != null) {
                        sb.append(String.format("M%s,%s", StiChartSvgHelper.p(animation.getPointsFrom()[0].x + (double)dx), StiChartSvgHelper.p(animation.getPointsFrom()[0].y + (double)dy)));
                        animatedPath.append(String.format("M%s:%s,%s:%s", StiChartSvgHelper.p(animation.getPointsFrom()[0].x + (double)dx), StiChartSvgHelper.p(lineSegment.getX1() + (double)dx), StiChartSvgHelper.p(animation.getPointsFrom()[0].y + (double)dy), StiChartSvgHelper.p(lineSegment.getY1() + (double)dy + 1.0E-4)));
                    } else {
                        sb.append(String.format("M%s,%s", StiChartSvgHelper.p(lineSegment.getX1() + (double)dx), StiChartSvgHelper.p(lineSegment.getY1() + (double)dy + 1.0E-4)));
                    }
                }
                if (animation != null) {
                    sb.append(String.format("L%s,%s", StiChartSvgHelper.p(animation.getPointsFrom()[1].x + (double)dx), StiChartSvgHelper.p(animation.getPointsFrom()[1].y + (double)dy)));
                    animatedPath.append(String.format("L%s:%s,%s:%s", StiChartSvgHelper.p(animation.getPointsFrom()[1].x + (double)dx), StiChartSvgHelper.p(lineSegment.getX2() + (double)dx), StiChartSvgHelper.p(animation.getPointsFrom()[1].y + (double)dy), StiChartSvgHelper.p(lineSegment.getY2() + (double)dy + 1.0E-4)));
                    duration = animation.getDuration();
                } else {
                    sb.append(String.format("L%s,%s", StiChartSvgHelper.p(lineSegment.getX2() + (double)dx), StiChartSvgHelper.p(lineSegment.getY2() + (double)dy + 1.0E-4)));
                }
                path = path + sb;
                continue;
            }
            if (geom instanceof StiLinesSegmentGeom) {
                StiLinesSegmentGeom linesSegment = (StiLinesSegmentGeom)geom;
                animation = linesSegment.getAnimation() instanceof StiPointsAnimation ? (StiPointsAnimation)linesSegment.getAnimation() : null;
                sb = new StringBuilder();
                if (!path.startsWith("M")) {
                    if (animation != null) {
                        sb.append(String.format("M%s,%s", StiChartSvgHelper.p(animation.getPointsFrom()[0].x + (double)dx), StiChartSvgHelper.p(animation.getPointsFrom()[0].y + (double)dy)));
                        animatedPath.append(String.format("M%s:%s,%s:%s", StiChartSvgHelper.p(animation.getPointsFrom()[0].x + (double)dx), StiChartSvgHelper.p(animation.getPointsFrom()[1].x + (double)dx), StiChartSvgHelper.p(animation.getPointsFrom()[0].y + (double)dy), StiChartSvgHelper.p(animation.getPointsFrom()[1].y + (double)dy + 1.0E-4)));
                    } else {
                        sb.append(String.format("M%s,%s", StiChartSvgHelper.p(linesSegment.getPoints()[0].x + (double)dx), StiChartSvgHelper.p(linesSegment.getPoints()[0].y + (double)dy + 1.0E-4)));
                    }
                }
                for (int index = 0; index < linesSegment.getPoints().length; ++index) {
                    if (animation != null) {
                        sb.append(String.format("%s%s,%s", index == 0 ? "L" : ",", StiChartSvgHelper.p(animation.getPointsFrom()[index].x + (double)dx), StiChartSvgHelper.p(animation.getPointsFrom()[index].y + (double)dy)));
                        animatedPath.append(String.format("%s%s:%s,%s:%s", index == 0 ? "L" : ",", StiChartSvgHelper.p(animation.getPointsFrom()[index].x + (double)dx), StiChartSvgHelper.p(linesSegment.getPoints()[index].x + (double)dx), StiChartSvgHelper.p(animation.getPointsFrom()[index].y + (double)dy), StiChartSvgHelper.p(linesSegment.getPoints()[index].y + (double)dy + (double)index * 1.0E-4)));
                        duration = animation.getDuration();
                        continue;
                    }
                    sb.append(String.format("%s%s,%s", index == 0 ? "L" : ",", StiChartSvgHelper.p(linesSegment.getPoints()[index].x + (double)dx), StiChartSvgHelper.p(linesSegment.getPoints()[index].y + (double)dy + (double)index * 1.0E-4)));
                }
                path = path + sb;
                continue;
            }
            if (geom instanceof StiPieSegmentGeom) {
                StiPieSegmentGeom pieSegment = (StiPieSegmentGeom)geom;
                Map<String, Object> res = StiChartSvgHelper.addPiePath(pieSegment, path, dx, dy, animatedPath, duration);
                path = path + (String)res.get("result");
                duration = (Integer)res.get("duration");
                continue;
            }
            if (!(geom instanceof StiCloseFigureSegmentGeom)) continue;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", path);
        result.put("duration", duration);
        return result;
    }

    private static Map<String, Object> addPiePath(StiPieSegmentGeom pieSegment, String path, float dx, float dy, StringBuilder animatedPath, Integer duration) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        StiPieSegmentAnimation animation = pieSegment.getAnimation() instanceof StiPieSegmentAnimation ? (StiPieSegmentAnimation)pieSegment.getAnimation() : null;
        double centerX = pieSegment.getRect().x + (double)dx + pieSegment.getRect().width / 2.0;
        double centerY = pieSegment.getRect().y + (double)dy + pieSegment.getRect().height / 2.0;
        double radius = pieSegment.getRect().width / 2.0;
        double startAngleFrom = animation == null ? (double)pieSegment.getStartAngle() : (double)animation.getStartAngleFrom();
        double sweepAngleFrom = animation == null ? (double)pieSegment.getSweepAngle() : (double)animation.getSweepAngleFrom();
        double startAngle = startAngleFrom * Math.PI / 180.0;
        double x1 = centerX + radius * Math.cos(startAngle);
        double y1 = centerY + radius * Math.sin(startAngle);
        sb.append(String.format("M%s,%s", StiChartSvgHelper.r(centerX), StiChartSvgHelper.r(centerY)));
        sb.append(String.format("L%s,%s", StiChartSvgHelper.r(x1), StiChartSvgHelper.r(y1)));
        double step = StiChartSvgHelper.round(Math.abs(sweepAngleFrom / 90.0));
        double stepAngle = sweepAngleFrom / step;
        startAngle = startAngleFrom;
        int indexStep = 0;
        while ((double)indexStep < step) {
            StiPoint[] points = StiChartSvgHelper.convertArcToCubicBezier(pieSegment.getRect(), startAngle, stepAngle);
            for (int index = 1; index < points.length - 1; index += 3) {
                if (index == 1) {
                    sb.append(String.format("C%s,%s,%s,%s,%s,%s", StiChartSvgHelper.r(points[index].x + (double)dx), StiChartSvgHelper.r(points[index].y + (double)dy), StiChartSvgHelper.r(points[index + 1].x + (double)dx), StiChartSvgHelper.r(points[index + 1].y + (double)dy), StiChartSvgHelper.r(points[index + 2].x + (double)dx), StiChartSvgHelper.r(points[index + 2].y + (double)dy)));
                    continue;
                }
                sb.append(String.format(",%s,%s,%s,%s,%s,%s", StiChartSvgHelper.r(points[index].x + (double)dx), StiChartSvgHelper.r(points[index].y + (double)dy), StiChartSvgHelper.r(points[index + 1].x + (double)dx), StiChartSvgHelper.r(points[index + 1].y + (double)dy), StiChartSvgHelper.r(points[index + 2].x + (double)dx), StiChartSvgHelper.r(points[index + 2].y + (double)dy)));
            }
            startAngle += stepAngle;
            ++indexStep;
        }
        sb.append(String.format("L%s,%s", StiChartSvgHelper.r(centerX), StiChartSvgHelper.r(centerY)));
        if (animation != null) {
            duration = animation.getDuration();
            animatedPath.append(StiBase64EncoderUtil.encode((String)String.format("{\"startAngle\":%s, \"startAngleFrom\": %s, \"sweepAngle\": %s, \"sweepAngleFrom\": %s, \"x\": %s, \"y\": %s,\"width\": %s, \"height\": %s, \"dx\": %s, \"dy\": %s}", StiChartSvgHelper.p(Float.valueOf(pieSegment.getStartAngle())), StiChartSvgHelper.p(Float.valueOf(animation.getStartAngleFrom())), StiChartSvgHelper.p(Float.valueOf(pieSegment.getSweepAngle())), StiChartSvgHelper.p(Float.valueOf(animation.getSweepAngleFrom())), StiChartSvgHelper.p(pieSegment.getRect().x), StiChartSvgHelper.p(pieSegment.getRect().y), StiChartSvgHelper.p(pieSegment.getRect().width), StiChartSvgHelper.p(pieSegment.getRect().height), StiChartSvgHelper.p(Float.valueOf(dx)), StiChartSvgHelper.p(Float.valueOf(dy)))));
        } else {
            duration = 1000;
        }
        result.put("result", sb.toString());
        result.put("duration", duration);
        return result;
    }

    private static String writeBorderStroke(Element el, Object brush, StiRectangle rect, Document doc) {
        if (brush instanceof StiColor) {
            StiColor color = (StiColor)brush;
            String result = String.format("stroke:rgb(%s,%s,%s);", color.getR(), color.getG(), color.getB());
            double alfa = StiMath.round((float)((float)color.getA() / 255.0f), (int)3);
            if (alfa != 1.0) {
                result = result + String.format("stroke-opacity:%s;", StiChartSvgHelper.r(alfa));
            }
            return result;
        }
        if (brush instanceof StiGradientBrush) {
            String gradientId = StiBrushSvgHelper.writeGradientBrush(el, brush, rect, doc);
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiGlareBrush) {
            String gradientId = StiBrushSvgHelper.writeGlareBrush(el, brush, rect, doc);
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiGlassBrush) {
            String gradientId = StiBrushSvgHelper.writeGlassBrush(el, brush, rect, doc);
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiHatchBrush) {
            String gradientId = StiBrushSvgHelper.writeHatchBrush(el, brush, doc);
            return String.format("fill:url(#%s);", gradientId);
        }
        if (brush instanceof StiBrush) {
            StiColor color = StiBrush.ToColor((StiBrush)((StiBrush)brush));
            String result = String.format("stroke:rgb(%s,%s,%s)", color.getR(), color.getG(), color.getB());
            double alfa = StiMath.round((float)((float)color.getA() / 255.0f), (int)3);
            if (alfa != 1.0) {
                result = result + String.format(";stroke-opacity:%s", StiChartSvgHelper.r(alfa));
            }
            return result;
        }
        return "stroke-opacity:0";
    }

    private static StiPoint[] convertSplineToCubicBezier(StiPoint[] points, float tension) {
        int count = points.length;
        int len_pt = count * 3 - 2;
        StiPoint[] pt = new StiPoint[len_pt];
        pt[0] = points[0];
        pt[1] = StiChartSvgHelper.calculateCurveBezierEndPoints(points[0], points[1], tension *= 0.3f);
        for (int index = 0; index < count - 2; ++index) {
            StiPoint[] temp = StiChartSvgHelper.calculateCurveBezier(points, index, tension);
            pt[3 * index + 2] = temp[0];
            pt[3 * index + 3] = points[index + 1];
            pt[3 * index + 4] = temp[1];
        }
        pt[len_pt - 2] = StiChartSvgHelper.calculateCurveBezierEndPoints(points[count - 1], points[count - 2], tension);
        pt[len_pt - 1] = points[count - 1];
        return pt;
    }

    private static StiPoint[] calculateCurveBezier(StiPoint[] points, int index, float tension) {
        double xDiff = points[index + 2].x - points[index + 0].x;
        double yDiff = points[index + 2].y - points[index + 0].y;
        return new StiPoint[]{new StiPoint(points[index + 1].x - (double)tension * xDiff, points[index + 1].y - (double)tension * yDiff), new StiPoint(points[index + 1].x + (double)tension * xDiff, points[index + 1].y + (double)tension * yDiff)};
    }

    private static StiPoint calculateCurveBezierEndPoints(StiPoint end, StiPoint adj, float tension) {
        return new StiPoint((double)tension * (adj.x - end.x) + end.x, (double)tension * (adj.y - end.y) + end.y);
    }

    private static String addArcPath(StiArcSegmentGeom arcSegment, String path, float dx, float dy) {
        StringBuilder sb = new StringBuilder();
        double centerX = arcSegment.getRect().x + (double)dx + arcSegment.getRect().width / 2.0;
        double centerY = arcSegment.getRect().y + (double)dy + arcSegment.getRect().height / 2.0;
        double radius = arcSegment.getRect().width / 2.0;
        double startAngle = (double)arcSegment.getStartAngle() * Math.PI / 180.0;
        double x1 = centerX + radius * Math.cos(startAngle);
        double y1 = centerY + radius * Math.sin(startAngle);
        if (!path.startsWith("M") || arcSegment.getSweepAngle() % 360.0f == 0.0f) {
            sb.append(String.format("M%s,%s", StiChartSvgHelper.r(x1), StiChartSvgHelper.r(y1)));
        }
        double step = StiChartSvgHelper.round(Math.abs(arcSegment.getSweepAngle() / 90.0f));
        double stepAngle = (double)arcSegment.getSweepAngle() / step;
        startAngle = arcSegment.getStartAngle();
        int indexStep = 0;
        while ((double)indexStep < step) {
            StiPoint[] points = StiChartSvgHelper.convertArcToCubicBezier(arcSegment.getRect(), startAngle, stepAngle);
            if (indexStep == 0) {
                sb.append(String.format("C%s,%s,%s,%s,%s,%s", StiChartSvgHelper.r(points[1].x + (double)dx), StiChartSvgHelper.r(points[1].y + (double)dy), StiChartSvgHelper.r(points[2].x + (double)dx), StiChartSvgHelper.r(points[2].y + (double)dy), StiChartSvgHelper.r(points[3].x + (double)dx), StiChartSvgHelper.r(points[3].y + (double)dy)));
            } else {
                sb.append(String.format(",%s,%s,%s,%s,%s,%s", StiChartSvgHelper.r(points[1].x + (double)dx), StiChartSvgHelper.r(points[1].y + (double)dy), StiChartSvgHelper.r(points[2].x + (double)dx), StiChartSvgHelper.r(points[2].y + (double)dy), StiChartSvgHelper.r(points[3].x + (double)dx), StiChartSvgHelper.r(points[3].y + (double)dy)));
            }
            startAngle += stepAngle;
            ++indexStep;
        }
        return sb.toString();
    }

    private static StiPoint[] convertArcToCubicBezier(StiRectangle rect, double startAngle1, double sweepAngle1) {
        double centerX = rect.x + rect.width / 2.0;
        double centerY = rect.y + rect.height / 2.0;
        double radius = Math.min(rect.width / 2.0, rect.height / 2.0);
        double startAngle = startAngle1 * Math.PI / 180.0;
        double sweepAngle = sweepAngle1 * Math.PI / 180.0;
        double endAngle = (startAngle1 + sweepAngle1) * Math.PI / 180.0;
        double x1 = (float)(centerX + radius * Math.cos(startAngle));
        double y1 = (float)(centerY + radius * Math.sin(startAngle));
        double x2 = (float)(centerX + radius * Math.cos(endAngle));
        double y2 = (float)(centerY + radius * Math.sin(endAngle));
        double l = radius * 4.0 / 3.0 * Math.tan(0.25 * sweepAngle);
        double aL = Math.atan(l / radius);
        double radL = radius / Math.cos(aL);
        double ax1 = (float)(centerX + radL * Math.cos(aL += startAngle));
        double ay1 = (float)(centerY + radL * Math.sin(aL));
        aL = Math.atan(-l / radius);
        double ax2 = (float)(centerX + radL * Math.cos(aL += endAngle));
        double ay2 = (float)(centerY + radL * Math.sin(aL));
        StiPoint[] res = new StiPoint[]{new StiPoint(x1, y1), new StiPoint(ax1, ay1), new StiPoint(ax2, ay2), new StiPoint(x2, y2)};
        return res;
    }

    private static StiRectangle rectToRectangleF(Object rect) {
        if (rect instanceof StiRectangle) {
            return (StiRectangle)rect;
        }
        return new StiRectangle();
    }

    private static double round(double value) {
        int value1 = (int)value;
        double rest = value - (double)value1;
        return rest > 0.0 ? (double)(value1 + 1) : (double)value1;
    }

    public static StiRectangle correctRectLabel(StiRotationMode rotationMode, StiRectangle textRect) {
        switch (rotationMode) {
            case LeftCenter: {
                return new StiRectangle(textRect.x + textRect.width / 2.0, textRect.y, textRect.width, textRect.height);
            }
            case LeftBottom: {
                return new StiRectangle(textRect.x + textRect.width / 2.0, textRect.y - textRect.height / 2.0, textRect.width, textRect.height);
            }
            case LeftTop: {
                return new StiRectangle(textRect.x + textRect.width / 2.0, textRect.y + textRect.height / 2.0, textRect.width, textRect.height);
            }
            case CenterTop: {
                return new StiRectangle(textRect.x, textRect.y + textRect.height / 2.0, textRect.width, textRect.height);
            }
            case CenterCenter: {
                return textRect;
            }
            case CenterBottom: {
                return new StiRectangle(textRect.x, textRect.y - textRect.height / 2.0, textRect.width, textRect.height);
            }
            case RightTop: {
                return new StiRectangle(textRect.x - textRect.width / 2.0, textRect.y + textRect.height / 2.0, textRect.width, textRect.height);
            }
            case RightCenter: {
                return new StiRectangle(textRect.x - textRect.width / 2.0, textRect.y, textRect.width, textRect.height);
            }
            case RightBottom: {
                return new StiRectangle(textRect.x - textRect.width / 2.0, textRect.y - textRect.height / 2.0, textRect.width, textRect.height);
            }
        }
        return textRect;
    }
}

