/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiAdvancedBorder;
import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiTextOptions;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiBidirectionalConvert;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.StiImageCache;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.StiWatermark;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.components.interfaces.IStiText;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.components.interfaces.IStiTextHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiTextOptions;
import com.stimulsoft.report.components.interfaces.IStiVertAlignment;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiRectanglePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiShape;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiXpsExportSettings;
import com.stimulsoft.report.export.tools.StiExportUtils;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.pdf.PdfFonts;
import com.stimulsoft.report.options.ExportOptions;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class StiXpsExportService
extends StiExportService {
    private static final char ALIGN_WIDTH_SYMBOL = '\u0007';
    private static final double HI_TO_DPI = (double)0.96f;
    double FONT_CORRECT_VALUE = 1.279999666213996;
    private StiImageCache imageCache = null;
    private Hashtable<Integer, Integer> pageImages = null;
    private Hashtable<Integer, Integer> pageFonts = null;
    private Hashtable<String, Integer> pageBookmarks = null;
    int indexPage = 0;
    private PdfFonts pdfFont = null;
    private StiBidirectionalConvert bidi = null;
    private final int precision_digits = 3;
    private boolean reduceFontSize = true;
    private boolean useImageComparer = true;
    private float imageQuality = 0.75f;
    private float imageResolution = 96.0f;

    private boolean isWordWrapSymbol(StringBuilder sb, int index) {
        char sym = ' ';
        if (index < sb.length() - 1) {
            sym = sb.charAt(index + 1);
        }
        return this.isWordWrapSymbol(sb.charAt(index), sym);
    }

    private boolean isWordWrapSymbol(char sym1, char sym2) {
        int cat1 = Character.getType(sym1);
        int cat2 = Character.getType(sym2);
        return cat1 == 21 || cat1 == 22 && cat2 != 24 || cat1 == 20 || cat1 == 29 || cat1 == 30 || cat1 == 12;
    }

    private String floatToString(double number) {
        int digits = 3;
        if (Math.abs(number) < 1.0) {
            digits = 5;
        }
        Double numValue = StiMath.round((double)number, (int)digits);
        return numValue.toString();
    }

    private void prepareData() {
        this.bidi = new StiBidirectionalConvert(StiBidirectionalConvert.Mode.Xps);
        this.pdfFont = new PdfFonts();
        this.pdfFont.setStandardPdfFonts(false);
        this.pdfFont.setMaxSymbols(Short.MAX_VALUE);
        this.pdfFont.setFontList(new ArrayList<PdfFonts.pfontInfo>());
        this.imageCache = new StiImageCache(this.useImageComparer, StiImageFormat.Jpeg, this.imageQuality);
    }

    private float getTabsSize(IStiTextOptions textOp, double sizeInPt, double currentPosition) {
        if (textOp != null && textOp.getTextOptions() != null) {
            double position = currentPosition;
            float spaceWidth = 750.0f / (float)sizeInPt;
            float otherTab = spaceWidth * textOp.getTextOptions().getDistanceBetweenTabs();
            float firstTab = spaceWidth * textOp.getTextOptions().getFirstTabOffset() + otherTab;
            if (currentPosition < (double)firstTab) {
                position = firstTab;
            } else if (textOp.getTextOptions().getDistanceBetweenTabs() > 0.0f) {
                int kolTabs = (int)((currentPosition - (double)firstTab) / (double)otherTab);
                position = firstTab + (float)(++kolTabs) * otherTab;
            }
            return (float)(position - currentPosition);
        }
        return 0.0f;
    }

    static String convertToEscapeSequence(String value) {
        String escapeChars = "\r\n\b\f";
        String replaceChars = "rnbf";
        if (value == null) {
            return "";
        }
        String st = "";
        for (int index = 0; index < value.length(); ++index) {
            boolean flg = false;
            for (int index2 = 0; index2 < escapeChars.length(); ++index2) {
                if (value.charAt(index) != escapeChars.charAt(index2)) continue;
                st = st + "\\" + replaceChars.charAt(index2);
                flg = true;
                break;
            }
            if (flg) continue;
            st = st + value.charAt(index);
        }
        return st;
    }

    private String getLineStyleDash(StiPenStyle penStyle) {
        String dashArray = "";
        switch (penStyle) {
            case Dot: {
                dashArray = "1.1 1.1";
                break;
            }
            case Dash: {
                dashArray = "3 1";
                break;
            }
            case DashDot: {
                dashArray = "3 1 1 1";
                break;
            }
            case DashDotDot: {
                dashArray = "3 1 1 1 1 1";
            }
        }
        return dashArray;
    }

    private Document writeContentTypes() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element typesEl = doc.createElement("Types");
        doc.appendChild(typesEl);
        typesEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/content-types");
        Element defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "jpg");
        defaultEl.setAttribute("ContentType", "image/jpeg");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "png");
        defaultEl.setAttribute("ContentType", "image/png");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "rels");
        defaultEl.setAttribute("ContentType", "application/vnd.openxmlformats-package.relationships+xml");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "xml");
        defaultEl.setAttribute("ContentType", "application/xml");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "fdseq");
        defaultEl.setAttribute("ContentType", "application/vnd.ms-package.xps-fixeddocumentsequence+xml");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "fpage");
        defaultEl.setAttribute("ContentType", "application/vnd.ms-package.xps-fixedpage+xml");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "ttf");
        defaultEl.setAttribute("ContentType", "application/vnd.ms-opentype");
        defaultEl = doc.createElement("Default");
        typesEl.appendChild(defaultEl);
        defaultEl.setAttribute("Extension", "fdoc");
        defaultEl.setAttribute("ContentType", "application/vnd.ms-package.xps-fixeddocument+xml");
        Element ovverideEl = doc.createElement("Override");
        typesEl.appendChild(ovverideEl);
        ovverideEl.setAttribute("PartName", "/docProps/core.xml");
        ovverideEl.setAttribute("ContentType", "application/vnd.openxmlformats-package.core-properties+xml");
        return doc;
    }

    private Document writeMainRels() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element relationshipsEl = doc.createElement("Relationships");
        doc.appendChild(relationshipsEl);
        relationshipsEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        Element relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", "rId1");
        relationshipEl.setAttribute("Type", "http://schemas.microsoft.com/xps/2005/06/fixedrepresentation");
        relationshipEl.setAttribute("Target", "FixedDocSeq.fdseq");
        relationshipEl = doc.createElement("Relationship");
        relationshipsEl.appendChild(relationshipEl);
        relationshipEl.setAttribute("Id", "rId2");
        relationshipEl.setAttribute("Type", "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties");
        relationshipEl.setAttribute("Target", "docProps/core.xml");
        return doc;
    }

    private Document writeDocPropsCore(StiReport report) throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element coreEl = doc.createElement("cp:coreProperties");
        doc.appendChild(coreEl);
        coreEl.setAttribute("xmlns:cp", "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
        coreEl.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        coreEl.setAttribute("xmlns:dcterms", "http://purl.org/dc/terms/");
        coreEl.setAttribute("xmlns:dcmitype", "http://purl.org/dc/dcmitype/");
        coreEl.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        String dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH).format(new Date());
        Element createdEl = doc.createElement("dcterms:created");
        coreEl.appendChild(createdEl);
        createdEl.setAttribute("xsi:type", "dcterms:W3CDTF");
        createdEl.setTextContent(dateTime);
        Element modifiedEl = doc.createElement("dcterms:modified");
        coreEl.appendChild(modifiedEl);
        modifiedEl.setAttribute("xsi:type", "dcterms:W3CDTF");
        modifiedEl.setTextContent(dateTime);
        if (report.getReportName() != null && report.getReportName().length() > 0) {
            Element titleEl = doc.createElement("dc:title");
            coreEl.appendChild(titleEl);
            titleEl.setTextContent(report.getReportName());
        }
        if (report.getReportAlias() != null && report.getReportAlias().length() > 0) {
            Element subjectEl = doc.createElement("dc:subject");
            coreEl.appendChild(subjectEl);
            subjectEl.setTextContent(report.getReportAlias());
        }
        if (report.getReportDescription() != null && report.getReportDescription().length() > 0) {
            Element descriptionEl = doc.createElement("dc:description");
            coreEl.appendChild(descriptionEl);
            descriptionEl.setTextContent(report.getReportDescription());
        }
        Element creatorEl = doc.createElement("dc:creator");
        coreEl.appendChild(creatorEl);
        creatorEl.setTextContent(StiExportUtils.getReportVersion());
        return doc;
    }

    private Document writeFixedDocSeq() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element fdsEl = doc.createElement("FixedDocumentSequence");
        doc.appendChild(fdsEl);
        fdsEl.setAttribute("xmlns", "http://schemas.microsoft.com/xps/2005/06");
        Element referenceEl = doc.createElement("DocumentReference");
        fdsEl.appendChild(referenceEl);
        referenceEl.setAttribute("Source", "/Documents/1/FixedDoc.fdoc");
        return doc;
    }

    private Document writeFixedDoc(StiPagesCollection pages) throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element fixedEl = doc.createElement("FixedDocument");
        doc.appendChild(fixedEl);
        fixedEl.setAttribute("xmlns", "http://schemas.microsoft.com/xps/2005/06");
        for (int index = 0; index < pages.size(); ++index) {
            Element pageContentEl = doc.createElement("PageContent");
            fixedEl.appendChild(pageContentEl);
            pageContentEl.setAttribute("Source", String.format("Pages/%s.fpage", index + 1));
            ArrayList<String> bookmarks = new ArrayList<String>();
            for (String key : this.pageBookmarks.keySet()) {
                if (this.pageBookmarks.get(key) != index) continue;
                bookmarks.add(key);
            }
            if (bookmarks.size() <= 0) continue;
            Element pLinkEl = doc.createElement("PageContent.LinkTargets");
            pageContentEl.appendChild(pLinkEl);
            for (String st : bookmarks) {
                Element linkEl = doc.createElement("LinkTarget");
                pLinkEl.appendChild(linkEl);
                linkEl.setAttribute("Name", st);
            }
        }
        return doc;
    }

    private Document writePage(StiPage page, StiReport report) throws ParserConfigurationException {
        Object pp;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        double pageHeight = (double)0.96f * report.getUnit().ConvertToHInches(page.getPageHeight() * (double)page.getSegmentPerHeight());
        double pageWidth = (double)0.96f * report.getUnit().ConvertToHInches(page.getPageWidth() * (double)page.getSegmentPerWidth());
        double mgLeft = (double)0.96f * report.getUnit().ConvertToHInches(page.getMargins().getLeft());
        double mgRight = (double)0.96f * report.getUnit().ConvertToHInches(page.getMargins().getRight());
        double mgTop = (double)0.96f * report.getUnit().ConvertToHInches(page.getMargins().getTop());
        double mgBottom = (double)0.96f * report.getUnit().ConvertToHInches(page.getMargins().getBottom());
        Element fixedPageEl = doc.createElement("FixedPage");
        doc.appendChild(fixedPageEl);
        fixedPageEl.setAttribute("xmlns", "http://schemas.microsoft.com/xps/2005/06");
        fixedPageEl.setAttribute("Width", String.format("%s", this.floatToString(pageWidth)));
        fixedPageEl.setAttribute("Height", String.format("%s", this.floatToString(pageHeight)));
        fixedPageEl.setAttribute("xml:lang", "en-EN");
        Element canvasEl = doc.createElement("Canvas");
        fixedPageEl.appendChild(canvasEl);
        this.writeHyperlinksData(canvasEl, page, false);
        if (page.getBrush() != null) {
            pp = new StiXpsData();
            ((StiXpsData)pp).x = 0.0;
            ((StiXpsData)pp).y = 0.0;
            ((StiXpsData)pp).width = pageWidth;
            ((StiXpsData)pp).height = pageHeight;
            ((StiXpsData)pp).component = new StiContainer();
            ((StiContainer)((StiXpsData)pp).component).setBrush(page.getBrush());
            ((StiContainer)((StiXpsData)pp).component).setBorder(null);
            this.writeBorderFill(canvasEl, (StiXpsData)pp, doc);
        }
        this.writeWatermark(canvasEl, page.getWatermark(), true, pageWidth, pageHeight, doc);
        for (StiComponent component : page.getComponents()) {
            if (!component.getEnabled()) continue;
            double x1 = (double)0.96f * report.getUnit().ConvertToHInches(component.getLeft());
            double y1 = (double)0.96f * report.getUnit().ConvertToHInches(component.getTop());
            double x2 = (double)0.96f * report.getUnit().ConvertToHInches(component.getRight());
            double y2 = (double)0.96f * report.getUnit().ConvertToHInches(component.getBottom());
            StiXpsData pp2 = new StiXpsData();
            pp2.x = x1;
            pp2.y = y1;
            pp2.width = x2 - x1;
            pp2.height = y2 - y1;
            pp2.y += mgTop;
            pp2.x += mgLeft;
            pp2.component = component;
            if (!(component instanceof StiShape)) {
                this.writeBorderFill(canvasEl, pp2, doc);
            }
            if (component instanceof StiText && !component.isExportAsImage(StiExportFormat.Xps)) {
                this.writeText(canvasEl, pp2, doc);
            }
            if (component.isExportAsImage(StiExportFormat.Xps)) {
                this.writeImage(canvasEl, pp2, doc);
            }
            this.writeBorderStroke(canvasEl, pp2, doc);
        }
        if (page.getBorder() != null) {
            pp = new StiXpsData();
            ((StiXpsData)pp).x = mgLeft;
            ((StiXpsData)pp).y = mgTop;
            ((StiXpsData)pp).width = pageWidth - mgLeft - mgRight;
            ((StiXpsData)pp).height = pageHeight - mgTop - mgBottom;
            ((StiXpsData)pp).component = new StiContainer();
            ((StiContainer)((StiXpsData)pp).component).setBorder(page.getBorder());
            this.writeBorderStroke(canvasEl, (StiXpsData)pp, doc);
        }
        this.writeWatermark(canvasEl, page.getWatermark(), false, pageWidth, pageHeight, doc);
        if (!StiLicenseKeyValidator.isValidOnJavaFramework(null)) {
            double tempX = pageWidth / 794.0 * 2.0;
            double tempY = pageHeight / 1123.0 * 2.0;
            if (tempX > tempY) {
                tempX = tempY;
            } else {
                tempY = tempX;
            }
            Element dCanvasEl = doc.createElement("Canvas");
            canvasEl.appendChild(dCanvasEl);
            dCanvasEl.setAttribute("RenderTransform", String.format("%s,0,0,%s,%s,%s", this.floatToString(tempX), this.floatToString(tempY), this.floatToString(pageWidth / 2.0), this.floatToString(pageHeight / 2.0)));
            Element dCanvasEl2 = doc.createElement("Canvas");
            dCanvasEl.appendChild(dCanvasEl2);
            dCanvasEl2.setAttribute("RenderTransform", "0.707,-0.707,0.707,0.707,0,0");
            Element dPathEl = doc.createElement("Path");
            dCanvasEl2.appendChild(dPathEl);
            dPathEl.setAttribute("Stroke", "#40646464");
            dPathEl.setAttribute("StrokeThickness", String.format("%s", this.floatToString(3.0)));
            dPathEl.setAttribute("StrokeStartLineCap", "Round");
            dPathEl.setAttribute("StrokeEndLineCap", "Round");
            dPathEl.setAttribute("StrokeLineJoin", "Round");
            StringBuilder path = new StringBuilder();
            path.append("M 40,0 L 40,100 M 0,100 L 80,100 ");
            path.append("M 100,0 L 100,70 M 100,45 L 120,65 L 130,72 L 140,68 ");
            path.append("M 170,0 L 170,70 M 169,100 L 171,100 ");
            path.append("M 215,60 L 222,69 L 232,71 L 255,70 L 265,60 L 265,5 L 270,0 M 265,44 L 220,31 L 212,20 L 212,10 L 225,0 L 235,0 L 250,5 L 265,18 ");
            path.append("M 310,0 L 310,100 ");
            dPathEl.setAttribute("Data", path.toString());
            dPathEl.setAttribute("RenderTransform", String.format("1,0,0,-1,-155,50", new Object[0]));
        }
        return doc;
    }

    private void writeBorderFill(Element element, StiXpsData data, Document doc) {
        StiRichText mRich;
        IStiBrush mBrush;
        StiColor tempColor = StiColorEnum.Transparent.color();
        IStiBrush iStiBrush = mBrush = data.component instanceof IStiBrush ? (IStiBrush)((Object)data.component) : null;
        if (mBrush != null && mBrush.getBrush() != null) {
            tempColor = StiBrush.ToColor((StiBrush)mBrush.getBrush());
        }
        StiRichText stiRichText = mRich = data.component instanceof StiRichText ? (StiRichText)data.component : null;
        if (mRich != null) {
            tempColor = mRich.getBackColor();
        }
        if (tempColor.getA() != 0) {
            Element pathEl = doc.createElement("Path");
            element.appendChild(pathEl);
            pathEl.setAttribute("Data", String.format("M %s,%s L %s,%s L %s,%s L %s,%s Z ", this.floatToString(data.x), this.floatToString(data.y), this.floatToString(data.x), this.floatToString(data.y + data.height), this.floatToString(data.x + data.width), this.floatToString(data.y + data.height), this.floatToString(data.x + data.width), this.floatToString(data.y)));
            if (!(data.component instanceof StiText) && !(data.component instanceof StiImage)) {
                this.writeHyperlinksData(pathEl, data.component, false);
            }
            Element pathFillEl = doc.createElement("Path.Fill");
            pathEl.appendChild(pathFillEl);
            if (mBrush != null && mBrush.getBrush() != null && mBrush.getBrush() instanceof StiGradientBrush) {
                StiGradientBrush brush = (StiGradientBrush)mBrush.getBrush();
                double xs = 1.0;
                double ys = 1.0;
                double angle = brush.getAngle();
                if (angle < 0.0) {
                    angle += 360.0;
                }
                if (angle >= 270.0 && angle < 360.0) {
                    angle = 360.0 - angle;
                    ys = -1.0;
                }
                if (angle >= 180.0 && angle < 270.0) {
                    angle -= 180.0;
                    ys = -1.0;
                    xs = -1.0;
                }
                if (angle >= 90.0 && angle < 180.0) {
                    angle = 180.0 - angle;
                    xs = -1.0;
                }
                angle = angle * Math.PI / 180.0;
                double x0 = data.x + data.width / 2.0;
                double y0 = data.y + data.height / 2.0;
                double r = Math.sqrt(data.width * data.width + data.height * data.height) / 2.0;
                double a2 = Math.atan2(data.height, data.width);
                double st = 1.5707963267948966 - angle + a2;
                double b = r * Math.sin(st);
                double xr = b * Math.cos(angle) * xs;
                double yr = b * Math.sin(angle) * ys;
                double x1 = x0 - xr;
                double x2 = x0 + xr;
                double y1 = y0 - yr;
                double y2 = y0 + yr;
                Element linearEl = doc.createElement("LinearGradientBrush");
                pathFillEl.appendChild(linearEl);
                linearEl.setAttribute("MappingMode", "Absolute");
                linearEl.setAttribute("StartPoint", String.format("%s,%s", this.floatToString(x1), this.floatToString(y1)));
                linearEl.setAttribute("EndPoint", String.format("%s,%s", this.floatToString(x2), this.floatToString(y2)));
                Element stopsEl = doc.createElement("LinearGradientBrush.GradientStops");
                linearEl.appendChild(stopsEl);
                Element stopEl = doc.createElement("GradientStop");
                stopsEl.appendChild(stopEl);
                stopEl.setAttribute("Color", brush.getStartColor().toArgbHTML());
                stopEl.setAttribute("Offset", "0");
                stopEl = doc.createElement("GradientStop");
                stopsEl.appendChild(stopEl);
                stopEl.setAttribute("Color", brush.getEndColor().toArgbHTML());
                stopEl.setAttribute("Offset", "1");
            } else {
                Element solidEl = doc.createElement("SolidColorBrush");
                pathFillEl.appendChild(solidEl);
                solidEl.setAttribute("Color", tempColor.toArgbHTML());
            }
        } else if (this.writeHyperlinksData(element, data.component, true) && !(data.component instanceof StiText) && !(data.component instanceof StiImage)) {
            Element pathEl = doc.createElement("Path");
            element.appendChild(pathEl);
            pathEl.setAttribute("Data", String.format("M %s,%s L %s,%s L %s,%s L %s,%s Z ", this.floatToString(data.x), this.floatToString(data.y), this.floatToString(data.x), this.floatToString(data.y + data.height), this.floatToString(data.x + data.width), this.floatToString(data.y + data.height), this.floatToString(data.x + data.width), this.floatToString(data.y)));
            this.writeHyperlinksData(pathEl, data.component, false);
        }
    }

    private void writeBorderStroke(Element element, StiXpsData data, Document doc) {
        IStiBorder mBorder;
        IStiBorder iStiBorder = mBorder = data.component instanceof IStiBorder ? (IStiBorder)((Object)data.component) : null;
        if (mBorder != null) {
            boolean needDraw;
            StiColor tempColor;
            if (mBorder.getBorder().getDropShadow() && mBorder.getBorder().getShadowBrush() != null && (tempColor = StiBrush.ToColor((StiBrush)mBorder.getBorder().getShadowBrush())).getA() != 0) {
                double shadowSize = mBorder.getBorder().getShadowSize();
                Element pathEl = doc.createElement("Path");
                element.appendChild(pathEl);
                pathEl.setAttribute("Data", String.format("M %s,%s L %s,%s L %s,%s L %s,%s L %s,%s L %s,%s Z ", this.floatToString(data.x + shadowSize), this.floatToString(data.y + data.height), this.floatToString(data.x + data.width), this.floatToString(data.y + data.height), this.floatToString(data.x + data.width), this.floatToString(data.y + shadowSize), this.floatToString(data.x + data.width + shadowSize), this.floatToString(data.y + shadowSize), this.floatToString(data.x + data.width + shadowSize), this.floatToString(data.y + data.height + shadowSize), this.floatToString(data.x + shadowSize), this.floatToString(data.y + data.height + shadowSize)));
                Element fillEl = doc.createElement("Path.Fill");
                pathEl.appendChild(fillEl);
                Element solidEl = doc.createElement("SolidColorBrush");
                fillEl.appendChild(solidEl);
                solidEl.setAttribute("Color", tempColor.toArgbHTML());
            }
            StiAdvancedBorder advBorder = mBorder.getBorder() instanceof StiAdvancedBorder ? (StiAdvancedBorder)mBorder.getBorder() : null;
            boolean useAdvBorder = advBorder != null;
            StiRectanglePrimitive primitive = new StiRectanglePrimitive();
            if (data.component instanceof StiRectanglePrimitive) {
                primitive = (StiRectanglePrimitive)data.component;
            }
            boolean needBorderLeft = mBorder.getBorder().isLeftBorderSidePresent() && primitive.getLeftSide();
            boolean needBorderRight = mBorder.getBorder().isRightBorderSidePresent() && primitive.getRightSide();
            boolean needBorderTop = mBorder.getBorder().isTopBorderSidePresent() && primitive.getTopSide();
            boolean needBorderBottom = mBorder.getBorder().isBottomBorderSidePresent() && primitive.getBottomSide();
            boolean bl = needDraw = !mBorder.getBorder().getSide().containsOnly((IStiEnum)StiBorderSides.None) && mBorder.getBorder().getStyle() != StiPenStyle.None;
            if (useAdvBorder) {
                needDraw = !advBorder.getSide().containsOnly((IStiEnum)StiBorderSides.None);
            }
            float doubleStyleOffset = 0.9f;
            StiBorderSide border = new StiBorderSide(mBorder.getBorder().getColor(), mBorder.getBorder().getSize(), mBorder.getBorder().getStyle());
            double offset = 0.0;
            if (border.getStyle() == StiPenStyle.Double) {
                offset = 0.9f;
            }
            if (needDraw) {
                String sidePath;
                StringBuilder path = new StringBuilder();
                if (needBorderLeft) {
                    if (useAdvBorder) {
                        border = advBorder.getLeftSide();
                        offset = border.getStyle() == StiPenStyle.Double ? 0.9f : 0.0f;
                    }
                    sidePath = String.format("M %s,%s L %s,%s ", this.floatToString(data.x - offset), this.floatToString(data.y - offset), this.floatToString(data.x - offset), this.floatToString(data.y + offset + data.height));
                    if (border.getStyle() == StiPenStyle.Double) {
                        sidePath = sidePath + String.format("M %s,%s L %s,%s ", this.floatToString(data.x + offset), this.floatToString(data.y + (needBorderTop ? offset : -offset)), this.floatToString(data.x + offset), this.floatToString(data.y + (needBorderBottom ? -offset : offset) + data.height));
                    }
                    if (useAdvBorder) {
                        this.writeBorderSide(element, border, sidePath, doc);
                    } else {
                        path.append(sidePath);
                    }
                }
                if (needBorderRight) {
                    if (useAdvBorder) {
                        border = advBorder.getRightSide();
                        offset = border.getStyle() == StiPenStyle.Double ? 0.9f : 0.0f;
                    }
                    sidePath = String.format("M %s,%s L %s,%s ", this.floatToString(data.x + offset + data.width), this.floatToString(data.y - offset), this.floatToString(data.x + offset + data.width), this.floatToString(data.y + offset + data.height));
                    if (border.getStyle() == StiPenStyle.Double) {
                        sidePath = sidePath + String.format("M %s,%s L %s,%s ", this.floatToString(data.x - offset + data.width), this.floatToString(data.y + (needBorderTop ? offset : -offset)), this.floatToString(data.x - offset + data.width), this.floatToString(data.y + (needBorderBottom ? -offset : offset) + data.height));
                    }
                    if (useAdvBorder) {
                        this.writeBorderSide(element, border, sidePath, doc);
                    } else {
                        path.append(sidePath);
                    }
                }
                if (needBorderTop) {
                    if (useAdvBorder) {
                        border = advBorder.getTopSide();
                        offset = border.getStyle() == StiPenStyle.Double ? 0.9f : 0.0f;
                    }
                    sidePath = String.format("M %s,%s L %s,%s ", this.floatToString(data.x - offset), this.floatToString(data.y - offset), this.floatToString(data.x + offset + data.width), this.floatToString(data.y - offset));
                    if (border.getStyle() == StiPenStyle.Double) {
                        sidePath = sidePath + String.format("M %s,%s L %s,%s ", this.floatToString(data.x + (needBorderLeft ? offset : -offset)), this.floatToString(data.y + offset), this.floatToString(data.x + (needBorderRight ? -offset : offset) + data.width), this.floatToString(data.y + offset));
                    }
                    if (useAdvBorder) {
                        this.writeBorderSide(element, border, sidePath, doc);
                    } else {
                        path.append(sidePath);
                    }
                }
                if (needBorderBottom) {
                    if (useAdvBorder) {
                        border = advBorder.getBottomSide();
                        offset = border.getStyle() == StiPenStyle.Double ? 0.9f : 0.0f;
                    }
                    sidePath = String.format("M %s,%s L %s,%s ", this.floatToString(data.x - offset), this.floatToString(data.y + offset + data.height), this.floatToString(data.x + offset + data.width), this.floatToString(data.y + offset + data.height));
                    if (border.getStyle() == StiPenStyle.Double) {
                        sidePath = sidePath + String.format("M %s,%s L %s,%s ", this.floatToString(data.x + (needBorderLeft ? offset : -offset)), this.floatToString(data.y - offset + data.height), this.floatToString(data.x + (needBorderRight ? -offset : offset) + data.width), this.floatToString(data.y - offset + data.height));
                    }
                    if (useAdvBorder) {
                        this.writeBorderSide(element, border, sidePath, doc);
                    } else {
                        path.append(sidePath);
                    }
                }
                if (!useAdvBorder) {
                    this.writeBorderSide(element, new StiBorderSide(mBorder.getBorder().getColor(), mBorder.getBorder().getSize(), mBorder.getBorder().getStyle()), path.toString(), doc);
                }
            }
        }
    }

    private void writeBorderSide(Element element, StiBorderSide border, String path, Document doc) {
        double borderSizeHi = border.getSize();
        if (border.getStyle() == StiPenStyle.Double) {
            borderSizeHi = 1.0;
        }
        double borderSize = borderSizeHi * 0.9;
        StiColor tempColor = border.getColor();
        String dashArray = this.getLineStyleDash(border.getStyle());
        Element pathEl = doc.createElement("Path");
        element.appendChild(pathEl);
        pathEl.setAttribute("Stroke", tempColor.toArgbHTML());
        pathEl.setAttribute("StrokeThickness", String.format("%s", borderSize));
        pathEl.setAttribute("StrokeStartLineCap", "Square");
        pathEl.setAttribute("StrokeEndLineCap", "Square");
        if (!"".equals(dashArray)) {
            pathEl.setAttribute("StrokeDashArray", dashArray);
            pathEl.setAttribute("StrokeDashCap", "Flat");
        }
        pathEl.setAttribute("Data", path);
    }

    private boolean writeHyperlinksData(Element element, StiComponent component, boolean check) {
        boolean flag = false;
        if (component.getBookmarkValue() != null && !"".equals(component.getBookmarkValue())) {
            String bookmark = StiNameValidator.CorrectName(component.getBookmarkValue());
            if (!check && !this.pageBookmarks.containsKey(bookmark)) {
                element.setAttribute("Name", bookmark);
                this.pageBookmarks.put(bookmark, this.indexPage);
            }
            flag = true;
        }
        if (component.getHyperlinkValue() != null && component.getHyperlinkValue().trim().length() > 0 && !component.getHyperlinkValue().trim().startsWith("javascript:")) {
            String hyperlink = component.getHyperlinkValue().trim();
            if (!check) {
                if (hyperlink.startsWith("#")) {
                    hyperlink = StiNameValidator.CorrectName(hyperlink.substring(1));
                    element.setAttribute("FixedPage.NavigateUri", String.format("../FixedDoc.fdoc#%s", hyperlink));
                } else {
                    element.setAttribute("FixedPage.NavigateUri", hyperlink);
                }
            }
            flag = true;
        }
        return flag;
    }

    private void writeText(Element element, StiXpsData pp, Document doc) {
        IStiText text = pp.component instanceof IStiText ? (IStiText)((Object)pp.component) : null;
        StiText stiText = pp.component instanceof StiText ? (StiText)pp.component : null;
        IStiFont mFont = pp.component instanceof IStiFont ? (IStiFont)((Object)pp.component) : null;
        IStiTextBrush mTextBrush = pp.component instanceof IStiTextBrush ? (IStiTextBrush)((Object)pp.component) : null;
        IStiTextOptions textOpt = pp.component instanceof IStiTextOptions ? (IStiTextOptions)((Object)pp.component) : null;
        IStiTextHorAlignment mTextHorAlign = pp.component instanceof IStiTextHorAlignment ? (IStiTextHorAlignment)((Object)pp.component) : null;
        IStiVertAlignment mVertAlign = pp.component instanceof IStiVertAlignment ? (IStiVertAlignment)((Object)pp.component) : null;
        boolean wordWrap = textOpt != null && textOpt.getTextOptions().getWordWrap();
        boolean needWidthAlign = mTextHorAlign != null && mTextHorAlign.getHorAlignment() == StiTextHorAlignment.Width;
        boolean useRightToLeft = textOpt != null && textOpt.getTextOptions() != null && textOpt.getTextOptions().getRightToLeft();
        int linesCount = 0;
        float textAngle = 0.0f;
        int fontNumber = 0;
        double fontSize = 0.0;
        if (mFont != null) {
            fontNumber = this.pdfFont.getFontNumber(mFont.getFont());
            fontSize = mFont.getFont().getSize() * this.FONT_CORRECT_VALUE;
            this.pageFonts.put(fontNumber, fontNumber);
        }
        if (text != null) {
            StiColor tempColor = StiColorEnum.Transparent.color();
            if (mTextBrush != null) {
                tempColor = StiBrush.ToColor((StiBrush)mTextBrush.getTextBrush());
            }
            double sizeInPt = 1.0;
            if (mFont != null) {
                sizeInPt = mFont.getFont().getSize() - 0.0;
            }
            double fonttmASC = sizeInPt * this.FONT_CORRECT_VALUE * (double)this.pdfFont.tmASC / 1000.0;
            double fonttmDESC = sizeInPt * this.FONT_CORRECT_VALUE * (double)this.pdfFont.tmDESC / 1000.0 * -1.0;
            double fonttmExternal = sizeInPt * this.FONT_CORRECT_VALUE * (double)this.pdfFont.tmExternal / 1000.0;
            double fontUnderscoreSize = sizeInPt * this.FONT_CORRECT_VALUE * (double)this.pdfFont.UnderscoreSize / 1000.0;
            double fontUnderscorePosition = sizeInPt * this.FONT_CORRECT_VALUE * (double)this.pdfFont.UnderscorePosition / 1000.0;
            double fontStrikeoutSize = sizeInPt * this.FONT_CORRECT_VALUE * (double)this.pdfFont.StrikeoutSize / 1000.0;
            double fontStrikeoutPosition = sizeInPt * this.FONT_CORRECT_VALUE * (double)this.pdfFont.StrikeoutPosition / 1000.0;
            double fontLineHeight = (fonttmASC - fonttmDESC + fonttmExternal) * (double)stiText.getLineSpacing();
            double fontAscF = fonttmASC;
            double fontDescF = fonttmDESC;
            double marginL = stiText.getMargins().getLeft();
            double marginR = stiText.getMargins().getRight();
            double marginT = stiText.getMargins().getTop();
            double marginB = stiText.getMargins().getBottom();
            double textX = pp.x + marginL;
            double textY = pp.y + marginB;
            double textW = pp.width - marginL - marginR;
            double textH = pp.height - marginT - marginB;
            float correctX = 2.0f;
            float correctY = 1.0f;
            textX += (double)correctX;
            textW -= (double)(correctX * 2.0f);
            textY += (double)correctY;
            textH -= (double)(correctY * 2.0f);
            StringBuilder sb = new StringBuilder(text.getTextInternal().replaceAll("\r", ""));
            if (textW > 0.0 && sb.length() > 0) {
                String stt;
                Element canvasEl = doc.createElement("Canvas");
                element.appendChild(canvasEl);
                canvasEl.setAttribute("Clip", String.format("M %s,%s L %s,%s L %s,%s L %s,%s Z ", this.floatToString(pp.x), this.floatToString(pp.y), this.floatToString(pp.x), this.floatToString(pp.y + pp.height), this.floatToString(pp.x + pp.width), this.floatToString(pp.y + pp.height), this.floatToString(pp.x + pp.width), this.floatToString(pp.y)));
                this.writeHyperlinksData(canvasEl, pp.component, false);
                ArrayList<String> stringList = StiExportUtils.splitString(sb.toString(), true);
                linesCount = stringList.size();
                double normTextX = textX;
                double normTextY = textY;
                double normTextW = textW;
                double normTextH = textH;
                if (textOpt != null && (textAngle = textOpt.getTextOptions().getAngle()) != 0.0f) {
                    if (textAngle > 45.0f && textAngle < 135.0f || textAngle > 225.0f && textAngle < 315.0f) {
                        double tempValue = textW;
                        textW = textH;
                        textH = tempValue;
                    }
                    textX = -textW / 2.0;
                    textY = -textH / 2.0;
                }
                Element canvas2El = doc.createElement("Canvas");
                canvasEl.appendChild(canvas2El);
                if (textAngle != 0.0f) {
                    double AngleInRadians = (double)(-textAngle) * Math.PI / 180.0;
                    canvas2El.setAttribute("RenderTransform", String.format("%s,%s,%s,%s,%s,%s", this.floatToString(Math.cos(AngleInRadians)), this.floatToString(Math.sin(AngleInRadians)), this.floatToString(-Math.sin(AngleInRadians)), this.floatToString(Math.cos(AngleInRadians)), this.floatToString(normTextX + normTextW / 2.0), this.floatToString(normTextY + normTextH / 2.0)));
                }
                if (wordWrap) {
                    for (int indexLine = 0; indexLine < stringList.size(); ++indexLine) {
                        stt = stringList.remove(indexLine);
                        StringBuilder sbt = new StringBuilder();
                        int indexChar = 0;
                        while (indexChar < stt.length()) {
                            if (Character.isWhitespace(stt.charAt(indexChar))) {
                                sbt.append(stt.charAt(indexChar));
                                ++indexChar;
                                continue;
                            }
                            StringBuilder sbtWord = new StringBuilder();
                            while (indexChar < stt.length() && !Character.isWhitespace(stt.charAt(indexChar))) {
                                sbtWord.append(stt.charAt(indexChar));
                                ++indexChar;
                            }
                            StringBuilder sbtWordBidi = this.bidi.convert(sbtWord, false);
                            sbt.append((CharSequence)sbtWordBidi);
                            int lenWord = sbtWord.length() - sbtWordBidi.length();
                            if (lenWord <= 0) continue;
                            sbt.append(StiStringUtil.repeatString((String)Character.toString('\u0000'), (int)lenWord));
                        }
                        int[] charr = new int[stt.length()];
                        for (int tempIndex = 0; tempIndex < stt.length(); ++tempIndex) {
                            charr[tempIndex] = this.pdfFont.UnicodeMap[sbt.charAt(tempIndex)];
                        }
                        int[] summarr = new int[stt.length()];
                        int[] wordarr = new int[stt.length()];
                        int wordCounter = 0;
                        float summ = 0.0f;
                        for (int index = 0; index < charr.length; ++index) {
                            if (charr[index] >= 32) {
                                summ += (float)this.pdfFont.Widths[charr[index] - 32];
                            }
                            if (charr[index] == 9) {
                                summ += this.getTabsSize(textOpt, sizeInPt, summ);
                            }
                            summarr[index] = (int)summ;
                            if (!this.isWordWrapSymbol(sbt, index) || index > 0) {
                                // empty if block
                            }
                            wordarr[index] = ++wordCounter;
                        }
                        double summf = (double)summ * (sizeInPt * this.FONT_CORRECT_VALUE) / 1000.0;
                        if (summf > textW) {
                            int index;
                            int textWint = (int)(textW * 1000.0 / (sizeInPt * this.FONT_CORRECT_VALUE));
                            for (index = stt.length() - 1; summarr[index] > textWint && index > 0; --index) {
                            }
                            int index2 = index;
                            if (wordarr[index] > 0) {
                                if (wordarr[index] != wordarr[index + 1]) {
                                    index2 = index++;
                                    while (Character.isWhitespace(sbt.charAt(index))) {
                                        ++index;
                                    }
                                } else {
                                    while (!this.isWordWrapSymbol(sbt, index)) {
                                        --index;
                                    }
                                    for (index2 = index - 1; Character.isWhitespace(sbt.charAt(index2)) && index2 > 0; --index2) {
                                    }
                                    while (Character.isWhitespace(sbt.charAt(index))) {
                                        ++index;
                                    }
                                }
                            } else {
                                ++index;
                            }
                            if (needWidthAlign) {
                                stringList.add(indexLine, stt.substring(0, index2 + 1) + '\u0007');
                            } else {
                                stringList.add(indexLine, stt.substring(0, index2 + 1));
                            }
                            stringList.add(indexLine + 1, stt.substring(index, stt.length()).replaceAll("^\\s+", ""));
                            continue;
                        }
                        stringList.add(indexLine, stt);
                    }
                }
                for (int indexLine = 0; indexLine < stringList.size(); ++indexLine) {
                    stt = stringList.remove(indexLine);
                    StringBuilder sbTemp = this.bidi.convert(new StringBuilder(stt), useRightToLeft);
                    stringList.add(indexLine, sbTemp.toString());
                }
                if (mVertAlign != null) {
                    double lineHeight = fontLineHeight;
                    double textHeight = (double)stringList.size() * lineHeight;
                    StiVertAlignment vertAlignment = mVertAlign.getVertAlignment();
                    if (textAngle != 0.0f && textAngle != 90.0f && textAngle != 180.0f && textAngle != 270.0f) {
                        vertAlignment = StiVertAlignment.Center;
                    }
                    if (vertAlignment == StiVertAlignment.Top) {
                        textY += fontAscF;
                    }
                    if (vertAlignment == StiVertAlignment.Center) {
                        textY += (textH - textHeight) / 2.0 + fontAscF;
                    }
                    if (vertAlignment == StiVertAlignment.Bottom) {
                        textY += textH - textHeight + fontAscF;
                    }
                }
                double[][] underlineArray = new double[stringList.size()][3];
                for (int indexLine = 0; indexLine < stringList.size(); ++indexLine) {
                    String stt2 = stringList.get(indexLine);
                    if (stt2.length() <= 0) continue;
                    double[] sttWidths = new double[stt2.length()];
                    double summ = 0.0;
                    for (int index = 0; index < stt2.length(); ++index) {
                        char charrSym = stt2.charAt(index);
                        if (charrSym >= ' ') {
                            summ += (double)this.pdfFont.Widths[this.pdfFont.UnicodeMap[charrSym] - 32];
                        }
                        if (charrSym != '\t') continue;
                        float tabSize = this.getTabsSize(textOpt, sizeInPt, (float)summ);
                        summ += (double)tabSize;
                        sttWidths[index] = tabSize / 10.0f;
                    }
                    summ = summ * (sizeInPt * this.FONT_CORRECT_VALUE) / 1000.0;
                    if ((stt2 = StiXpsExportService.convertToEscapeSequence(stt2)).charAt(0) == '{') {
                        stt2 = "{}" + stt2;
                    }
                    double textLineX = textX;
                    double textLineY = textY + fontLineHeight * (double)indexLine;
                    if (mTextHorAlign != null) {
                        StiTextHorAlignment horAlign = mTextHorAlign.getHorAlignment();
                        if (needWidthAlign) {
                            if (stt2.length() > 0 && stt2.charAt(stt2.length() - 1) == '\u0007') {
                                stt2 = stt2.substring(0, stt2.length() - 1);
                            } else {
                                horAlign = StiTextHorAlignment.Left;
                            }
                        }
                        if (textOpt != null && textOpt.getTextOptions() != null && textOpt.getTextOptions().getRightToLeft()) {
                            if (horAlign == StiTextHorAlignment.Left) {
                                horAlign = StiTextHorAlignment.Right;
                            } else if (horAlign == StiTextHorAlignment.Right) {
                                horAlign = StiTextHorAlignment.Left;
                            }
                        }
                        if (horAlign == StiTextHorAlignment.Center) {
                            textLineX += (textW - summ) / 2.0;
                        }
                        if (horAlign == StiTextHorAlignment.Right) {
                            textLineX += textW - summ;
                        }
                        if (horAlign == StiTextHorAlignment.Width) {
                            double spaceOffset;
                            int numSpaces = 0;
                            for (int spaceIndex = 0; spaceIndex < stt2.length(); ++spaceIndex) {
                                if (stt2.charAt(spaceIndex) != ' ') continue;
                                ++numSpaces;
                            }
                            if (numSpaces > 0 && indexLine != stringList.size() - 1 && (spaceOffset = (textW - summ) / (double)numSpaces * 100.0 / (sizeInPt * this.FONT_CORRECT_VALUE)) > 0.0) {
                                spaceOffset += (double)(this.pdfFont.Widths[0] / 10);
                                for (int charIndex = 0; charIndex < stt2.length(); ++charIndex) {
                                    if (stt2.charAt(charIndex) != ' ') continue;
                                    sttWidths[charIndex] = spaceOffset;
                                }
                            }
                        }
                    }
                    underlineArray[indexLine][0] = textLineX;
                    underlineArray[indexLine][1] = textLineY;
                    underlineArray[indexLine][2] = summ;
                    PdfFonts.pfontInfo tempInfo = this.pdfFont.getFontList().get(fontNumber);
                    StringBuilder tempSb = new StringBuilder(tempInfo.name.replaceAll(" ", "_"));
                    if (tempInfo.bold || tempInfo.italic) {
                        if (tempInfo.bold) {
                            tempSb.append("_Bold");
                        }
                        if (tempInfo.italic) {
                            tempSb.append("_Italic");
                        }
                    }
                    boolean useIndices = false;
                    StringBuilder indices = new StringBuilder();
                    for (int index = 0; index < sttWidths.length - 1; ++index) {
                        if (sttWidths[index] != 0.0) {
                            indices.append(",");
                            indices.append(this.floatToString(sttWidths[index]));
                            useIndices = true;
                        }
                        if (index == sttWidths.length - 1 - 1) continue;
                        indices.append(";");
                    }
                    Element glyphsEl = doc.createElement("Glyphs");
                    canvas2El.appendChild(glyphsEl);
                    glyphsEl.setAttribute("BidiLevel", "0");
                    glyphsEl.setAttribute("Fill", tempColor.toArgbHTML());
                    glyphsEl.setAttribute("FontUri", String.format("/Resources/%s.ttf", tempSb.toString()));
                    glyphsEl.setAttribute("FontRenderingEmSize", this.floatToString(fontSize));
                    glyphsEl.setAttribute("StyleSimulations", "None");
                    glyphsEl.setAttribute("OriginX", this.floatToString(textLineX));
                    glyphsEl.setAttribute("OriginY", this.floatToString(textLineY));
                    glyphsEl.setAttribute("UnicodeString", stt2);
                    glyphsEl.setAttribute("Indices", useIndices ? indices.toString() : "");
                }
                if (mFont != null && mFont.getFont().underline()) {
                    double underscoreSize = sizeInPt * 0.09;
                    double underscorePosition = -sizeInPt * 0.115;
                    if (this.pdfFont.UnderscoreSize != 0) {
                        underscoreSize = fontUnderscoreSize;
                        underscorePosition = fontUnderscorePosition;
                    }
                    if (underscoreSize < (double)0.1f) {
                        underscoreSize = 0.1f;
                    }
                    for (int tempIndex = 0; tempIndex < stringList.size(); ++tempIndex) {
                        if (underlineArray[tempIndex][2] == 0.0) continue;
                        Element pathEl = doc.createElement("Path");
                        canvas2El.appendChild(pathEl);
                        pathEl.setAttribute("Stroke", tempColor.toArgbHTML());
                        pathEl.setAttribute("StrokeThickness", String.format("%s", this.floatToString(underscoreSize)));
                        pathEl.setAttribute("Data", String.format("M %s,%s L %s,%s", this.floatToString(underlineArray[tempIndex][0]), this.floatToString(underlineArray[tempIndex][1] - underscorePosition), this.floatToString(underlineArray[tempIndex][0] + underlineArray[tempIndex][2]), this.floatToString(underlineArray[tempIndex][1] - underscorePosition)));
                    }
                }
                if (mFont != null && mFont.getFont().strikeout()) {
                    double strikeoutSize = sizeInPt * 0.09;
                    double strikeoutPosition = sizeInPt * 0.4;
                    if (this.pdfFont.StrikeoutSize != 0) {
                        strikeoutSize = fontStrikeoutSize;
                        strikeoutPosition = fontStrikeoutPosition;
                    }
                    if (strikeoutSize < (double)0.1f) {
                        strikeoutSize = 0.1f;
                    }
                    for (int tempIndex = 0; tempIndex < stringList.size(); ++tempIndex) {
                        if (underlineArray[tempIndex][2] == 0.0) continue;
                        Element pathEl = doc.createElement("Path");
                        canvas2El.appendChild(pathEl);
                        pathEl.setAttribute("Stroke", tempColor.toArgbHTML());
                        pathEl.setAttribute("StrokeThickness", String.format("%s", this.floatToString(strikeoutSize)));
                        pathEl.setAttribute("Data", String.format("M %s,%s L %s,%s", this.floatToString(underlineArray[tempIndex][0]), this.floatToString(underlineArray[tempIndex][1] - strikeoutPosition), this.floatToString(underlineArray[tempIndex][0] + underlineArray[tempIndex][2]), this.floatToString(underlineArray[tempIndex][1] - strikeoutPosition)));
                    }
                }
            }
            if (text.getLinesOfUnderline() != StiPenStyle.None) {
                IStiBorder mBorder;
                double coordTextY = pp.y + marginB + (double)correctY;
                boolean needLineUp = true;
                boolean needLineDown = true;
                if (mVertAlign != null) {
                    if (linesCount == 0) {
                        linesCount = 1;
                    }
                    double textHeight = fontLineHeight * (double)linesCount;
                    StiVertAlignment vertAlignment = mVertAlign.getVertAlignment();
                    if (textAngle != 0.0f && textAngle != 90.0f && textAngle != 180.0f && textAngle != 270.0f) {
                        vertAlignment = StiVertAlignment.Center;
                    }
                    if (vertAlignment == StiVertAlignment.Top) {
                        coordTextY += fontAscF;
                        needLineUp = false;
                    }
                    if (vertAlignment == StiVertAlignment.Center) {
                        coordTextY += (textH - textHeight) / 2.0 + fontAscF;
                    }
                    if (vertAlignment == StiVertAlignment.Bottom) {
                        coordTextY += textH - fontLineHeight + fontAscF;
                        needLineDown = false;
                    }
                }
                coordTextY += -fontDescF;
                IStiBorder iStiBorder = mBorder = pp.component instanceof IStiBorder ? (IStiBorder)((Object)pp.component) : null;
                if (mBorder != null) {
                    double borderSizeHi = mBorder.getBorder().getSize();
                    double borderSize = borderSizeHi * 0.9;
                    StiColor tempColor2 = mBorder.getBorder().getColor();
                    String dashArray = this.getLineStyleDash(text.getLinesOfUnderline());
                    StringBuilder path = new StringBuilder();
                    double lineY = coordTextY;
                    if (needLineUp) {
                        while (lineY - fontLineHeight > pp.y + marginT) {
                            lineY -= fontLineHeight;
                        }
                    }
                    while (true) {
                        double d = pp.y + pp.height - marginB;
                        double d2 = needLineDown ? 0.0 : fontLineHeight;
                        if (!(lineY < d - d2)) break;
                        path.append(String.format("M %s,%s L %s,%s ", this.floatToString(pp.x), this.floatToString(lineY), this.floatToString(pp.x + pp.width), this.floatToString(lineY)));
                        lineY += fontLineHeight;
                    }
                    Element pathEl = doc.createElement("Path");
                    element.appendChild(pathEl);
                    pathEl.setAttribute("Stroke", tempColor2.toArgbHTML());
                    pathEl.setAttribute("StrokeThickness", String.format("%s", borderSize));
                    pathEl.setAttribute("StrokeStartLineCap", "Square");
                    pathEl.setAttribute("StrokeEndLineCap", "Square");
                    if (!"".equals(dashArray)) {
                        pathEl.setAttribute("StrokeDashArray", dashArray);
                        pathEl.setAttribute("StrokeDashCap", "Flat");
                    }
                    pathEl.setAttribute("Data", path.toString());
                }
            }
        }
    }

    private void writeImage(Element element, StiXpsData data, Document doc) {
        double rsImageResolution;
        BufferedImage image;
        IStiExportImageExtended exportImage;
        IStiExportImageExtended iStiExportImageExtended = exportImage = data.component instanceof IStiExportImageExtended ? (IStiExportImageExtended)((Object)data.component) : null;
        if (exportImage != null && data.component.isExportAsImage(StiExportFormat.Xps) && (image = exportImage.getImage(rsImageResolution = (double)this.imageResolution / 100.0, StiExportFormat.Xps)) != null) {
            Element matrixEl;
            int imageIndex = this.imageCache.addImageInt(image);
            int maskIndex = -1;
            this.pageImages.put(imageIndex, imageIndex);
            if (maskIndex != -1) {
                this.pageImages.put(maskIndex, maskIndex);
            }
            Element pathEl = doc.createElement("Path");
            element.appendChild(pathEl);
            this.writeHyperlinksData(pathEl, data.component, false);
            pathEl.setAttribute("Data", String.format("M %s,%s L %s,%s L %s,%s L %s,%s Z ", this.floatToString(data.x), this.floatToString(data.y), this.floatToString(data.x), this.floatToString(data.y + data.height), this.floatToString(data.x + data.width), this.floatToString(data.y + data.height), this.floatToString(data.x + data.width), this.floatToString(data.y)));
            if (maskIndex != -1) {
                Element opacityEl = doc.createElement("Path.OpacityMask");
                pathEl.appendChild(opacityEl);
                Element brushEl = doc.createElement("ImageBrush");
                opacityEl.appendChild(brushEl);
                brushEl.setAttribute("ImageSource", String.format("/Resources/Images/image_%s.png", maskIndex));
                brushEl.setAttribute("Viewbox", String.format("%s,%s,%s,%s", 0, 0, image.getWidth(), image.getHeight()));
                brushEl.setAttribute("TileMode", "None");
                brushEl.setAttribute("ViewboxUnits", "Absolute");
                brushEl.setAttribute("ViewportUnits", "Absolute");
                brushEl.setAttribute("Viewport", "0,0,1,1");
                Element transformEl = doc.createElement("ImageBrush.Transform");
                brushEl.appendChild(transformEl);
                matrixEl = doc.createElement("MatrixTransform");
                transformEl.appendChild(matrixEl);
                matrixEl.setAttribute("Matrix", String.format("%s,%s,%s,%s,%s,%s}", this.floatToString(data.width), 0, 0, this.floatToString(data.height), this.floatToString(data.x), this.floatToString(data.y)));
            }
            Element pathFillEl = doc.createElement("Path.Fill");
            pathEl.appendChild(pathFillEl);
            Element imageBrushEl = doc.createElement("ImageBrush");
            pathFillEl.appendChild(imageBrushEl);
            imageBrushEl.setAttribute("ImageSource", String.format("/Resources/Images/image_%s.jpg", imageIndex));
            imageBrushEl.setAttribute("Viewbox", String.format("%s,%s,%s,%s", 0, 0, image.getWidth(), image.getHeight()));
            imageBrushEl.setAttribute("TileMode", "None");
            imageBrushEl.setAttribute("ViewboxUnits", "Absolute");
            imageBrushEl.setAttribute("ViewportUnits", "Absolute");
            imageBrushEl.setAttribute("Viewport", "0,0,1,1");
            Element brushTransform = doc.createElement("ImageBrush.Transform");
            imageBrushEl.appendChild(brushTransform);
            matrixEl = doc.createElement("MatrixTransform");
            brushTransform.appendChild(matrixEl);
            matrixEl.setAttribute("Matrix", String.format("%s,%s,%s,%s,%s,%s", this.floatToString(data.width), 0, 0, this.floatToString(data.height), this.floatToString(data.x), this.floatToString(data.y)));
        }
    }

    private void writeWatermark(Element element, StiWatermark watermark, boolean behind, double pageWidth, double pageHeight, Document doc) {
        if (watermark != null && watermark.getText() != null && !"".equals(watermark.getText()) && watermark.getShowBehind() == behind) {
            StiXpsData pp = new StiXpsData();
            pp.x = 0.0;
            pp.y = 0.0;
            pp.width = pageWidth;
            pp.height = pageHeight;
            StiText stt = new StiText(new StiRectangle(pp.x, pp.y, pp.width, pp.height), "");
            stt.setText(watermark.getText());
            stt.setTextBrush(watermark.getTextBrush());
            stt.setFont(watermark.getFont());
            stt.setTextOptions(new StiTextOptions());
            stt.getTextOptions().setAngle((float)watermark.getAngle());
            stt.setHorAlignment(StiTextHorAlignment.Center);
            stt.setVertAlignment(StiVertAlignment.Center);
            pp.component = stt;
            this.writeText(element, pp, doc);
        }
    }

    private Document writePageRels() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element relationshipsEl = doc.createElement("Relationships");
        doc.appendChild(relationshipsEl);
        relationshipsEl.setAttribute("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        Integer[] fonts = this.pageFonts.values().toArray(new Integer[0]);
        for (int indexFont = 0; indexFont < fonts.length; ++indexFont) {
            PdfFonts.pfontInfo tempInfo = this.pdfFont.getFontList().get(fonts[indexFont]);
            StringBuilder tempSb = new StringBuilder(tempInfo.name.replaceAll(" ", "_"));
            if (tempInfo.bold || tempInfo.italic) {
                if (tempInfo.bold) {
                    tempSb.append("_Bold");
                }
                if (tempInfo.italic) {
                    tempSb.append("_Italic");
                }
            }
            Element relEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relEl);
            relEl.setAttribute("Id", String.format("rId%s", indexFont + 1));
            relEl.setAttribute("Type", "http://schemas.microsoft.com/xps/2005/06/required-resource");
            relEl.setAttribute("Target", String.format("../../../Resources/%s.ttf", tempSb.toString()));
        }
        Integer[] images = this.pageImages.values().toArray(new Integer[0]);
        for (int indexImage = 0; indexImage < images.length; ++indexImage) {
            Element relEl = doc.createElement("Relationship");
            relationshipsEl.appendChild(relEl);
            relEl.setAttribute("Id", String.format("rId%s", this.pageFonts.size() + indexImage + 1));
            relEl.setAttribute("Type", "http://schemas.microsoft.com/xps/2005/06/required-resource");
            String fileExtension = "jpg";
            relEl.setAttribute("Target", String.format("../../../Resources/Images/image_%s.%s", images[indexImage], fileExtension));
        }
        return doc;
    }

    private byte[] writeResourceImage(int index) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StiImageHelper.saveWithDPI(this.imageCache.getImageByIndex(index), out, StiImageFormat.Jpeg, (Integer)72, this.imageQuality);
        byte[] bytes = out.toByteArray();
        out.close();
        return bytes;
    }

    private byte[] writeRecourceFont(int index) throws IOException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        this.pdfFont.setCurrentFont(index);
        PdfFonts.pfontInfo tempInfo = this.pdfFont.getFontList().get(index);
        byte[] buff = this.pdfFont.getFontDataBuf(tempInfo.font);
        if (buff.length > 0 && this.reduceFontSize) {
            buff = this.pdfFont.reduceFontSize(buff, tempInfo.name, true);
        }
        return buff;
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        this.exportXps(report, outputStream, exportSettings);
    }

    public void exportXps(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        try {
            this.exportXpsException(report, outputStream, exportSettings);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    private void exportXpsException(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws IOException, ParserConfigurationException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, StiException {
        StiLicenseKeyValidator.isValidOnJavaFramework(null);
        StiXpsExportSettings settings = (StiXpsExportSettings)exportSettings;
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        StiPagesRange pageRange = settings.getPageRange();
        this.imageResolution = settings.getImageResolution();
        this.imageQuality = settings.getImageQuality();
        if (this.imageQuality < 0.0f) {
            this.imageQuality = 0.0f;
        }
        if (this.imageQuality > 1.0f) {
            this.imageQuality = 1.0f;
        }
        if (this.imageResolution < 10.0f) {
            this.imageResolution = 10.0f;
        }
        this.useImageComparer = ExportOptions.Xps.getAllowImageComparer();
        this.reduceFontSize = ExportOptions.Xps.getReduceFontFileSize();
        try {
            StiPagesCollection pages = pageRange.getSelectedPages(report.getRenderedPages());
            if (this.isStoped()) {
                return;
            }
            this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
            this.prepareData();
            for (Object page : pages) {
                pages.GetPage((StiPage)page);
                if (pages.getCacheMode()) {
                    this.invokeExporting((StiPage)page, pages);
                }
                if (((StiPage)page).getWatermark() != null && ((StiPage)page).getWatermark().getText() != null && !"".equals(((StiPage)page).getWatermark().getText())) {
                    if (((StiPage)page).getWatermark().getFont() != null) {
                        this.pdfFont.getFontNumber(((StiPage)page).getWatermark().getFont());
                    }
                    Object sb = new StringBuilder(((StiPage)page).getWatermark().getText());
                    sb = this.bidi.convert((StringBuilder)sb, false);
                    this.pdfFont.storeUnicodeSymbolsInMap((StringBuilder)sb);
                }
                for (StiComponent component : ((StiContainer)page).getComponents()) {
                    IStiTextOptions textOpt;
                    IStiFont mFont;
                    if (!component.getEnabled()) continue;
                    IStiFont iStiFont = mFont = component instanceof IStiFont ? (IStiFont)((Object)component) : null;
                    if (mFont != null) {
                        this.pdfFont.getFontNumber(mFont.getFont());
                    }
                    IStiTextOptions iStiTextOptions = textOpt = component instanceof IStiTextOptions ? (IStiTextOptions)((Object)component) : null;
                    if (!(component instanceof StiText) || component.isExportAsImage(StiExportFormat.Xps)) continue;
                    IStiText text = component instanceof IStiText ? (IStiText)((Object)component) : null;
                    boolean useRightToLeft = textOpt != null && textOpt.getTextOptions() != null && textOpt.getTextOptions().getRightToLeft();
                    StringBuilder sb = new StringBuilder(text.getTextInternal());
                    sb = this.bidi.convert(sb, useRightToLeft);
                    this.pdfFont.storeUnicodeSymbolsInMap(sb);
                }
            }
            this.pdfFont.initFontsData();
            ZipOutputStream zos = new ZipOutputStream(outputStream);
            this.putInZip(zos, "[Content_Types].xml", this.writeContentTypes());
            zos.putNextEntry(new ZipEntry("_rels/"));
            zos.closeEntry();
            this.putInZip(zos, "_rels/.rels", this.writeMainRels());
            zos.putNextEntry(new ZipEntry("docProps/"));
            zos.closeEntry();
            this.putInZip(zos, "docProps/core.xml", this.writeDocPropsCore(report));
            this.putInZip(zos, "FixedDocSeq.fdseq", this.writeFixedDocSeq());
            zos.putNextEntry(new ZipEntry("Documents/"));
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry("Documents/1/"));
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry("Documents/1/_rels/"));
            zos.closeEntry();
            this.pageFonts = new Hashtable();
            this.pageImages = new Hashtable();
            this.pageBookmarks = new Hashtable();
            this.indexPage = 0;
            for (StiPage page : pages) {
                pages.GetPage(page);
                this.invokeExporting(page, pages);
                if (this.isStoped()) {
                    return;
                }
                this.putInZip(zos, String.format("Documents/1/Pages/%s.fpage", this.indexPage + 1), this.writePage(page, report));
                if (this.pageFonts.size() > 0 || this.pageImages.size() > 0) {
                    this.putInZip(zos, String.format("Documents/1/Pages/_rels/%s.fpage.rels", this.indexPage + 1), this.writePageRels());
                }
                this.pageFonts.clear();
                this.pageImages.clear();
                if (this.isStoped()) {
                    return;
                }
                ++this.indexPage;
            }
            this.putInZip(zos, "Documents/1/FixedDoc.fdoc", this.writeFixedDoc(pages));
            zos.putNextEntry(new ZipEntry("Resources/"));
            zos.closeEntry();
            if (this.pdfFont.getFontList().size() > 0) {
                for (int index = 0; index < this.pdfFont.getFontList().size(); ++index) {
                    PdfFonts.pfontInfo tempInfo = this.pdfFont.getFontList().get(index);
                    StringBuilder tempSb = new StringBuilder(tempInfo.name.replaceAll(" ", "_"));
                    if (tempInfo.bold || tempInfo.italic) {
                        if (tempInfo.bold) {
                            tempSb.append("_Bold");
                        }
                        if (tempInfo.italic) {
                            tempSb.append("_Italic");
                        }
                    }
                    this.putInZip(zos, String.format("Resources/%s.ttf", tempSb), this.writeRecourceFont(index));
                }
            }
            zos.putNextEntry(new ZipEntry("Resources/Images/"));
            zos.closeEntry();
            if (this.imageCache.getImageStoreSize() > 0) {
                for (int index = 0; index < this.imageCache.getImageStoreSize(); ++index) {
                    String fileExtension = "jpg";
                    this.putInZip(zos, String.format("Resources/Images/image_%s.%s", index, fileExtension), this.writeResourceImage(index));
                }
            }
            zos.close();
            this.closeProgress();
        }
        catch (Throwable e) {
            throw new StiException(e);
        }
        finally {
            this.pdfFont = null;
            this.bidi.clear();
            this.bidi = null;
            this.pageFonts = null;
            this.pageImages = null;
            this.imageCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInZip(ZipOutputStream zos, String path, Document doc) throws IOException, TransformerException {
        try {
            zos.putNextEntry(new ZipEntry(path));
            zos.write(StiXmlHelper.serialize((Document)doc).getBytes("UTF-8"));
        }
        finally {
            zos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInZip(ZipOutputStream zos, String path, byte[] bytes) throws IOException {
        try {
            zos.putNextEntry(new ZipEntry(path));
            zos.write(bytes);
        }
        finally {
            zos.closeEntry();
        }
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Xps;
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }

    private class StiXpsData {
        public double x;
        public double y;
        public double width;
        public double height;
        public StiComponent component;

        private StiXpsData() {
        }
    }
}

