/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiDataExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.tools.StiDataExportMode;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiPagesRange;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiXmlExportService
extends StiExportService {
    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        this.exportXml(report, outputStream, exportSettings);
    }

    public void exportXml(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        try {
            this.exportXmlException(report, outputStream, exportSettings);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    private void exportXmlException(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws IOException, ParserConfigurationException, TransformerException {
        StiLicenseKeyValidator.isValidOnJavaFramework(null);
        StiDataExportSettings settings = (StiDataExportSettings)exportSettings;
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        StiDataExportMode mode = settings.getDataExportMode();
        StiPagesCollection pages = StiPagesRange.All.getSelectedPages(report.getRenderedPages());
        StiMatrix matrix = new StiMatrix(pages, false, this);
        matrix.scanComponentsPlacement(false);
        if (this.isStoped()) {
            return;
        }
        matrix.prepareDocument(this, mode);
        Hashtable<String, String> hs = new Hashtable<String, String>();
        for (int index = 0; index < matrix.getFields().length; ++index) {
            String st = matrix.getFields()[index].Name.toUpperCase();
            String stNum = "";
            Integer num = 0;
            while (hs.contains(st + stNum)) {
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num + 1);
                stNum = num.toString();
            }
            matrix.getFields()[index].Name = st = st + stNum;
            hs.put(st, st);
        }
        String title = report.getReportAlias();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement(StiXmlHelper.validName((String)title));
        doc.appendChild(root);
        this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
        for (int rowIndex = 0; rowIndex < matrix.DataArrayLength; ++rowIndex) {
            this.invokeExporting(rowIndex, matrix.DataArrayLength);
            if (this.isStoped()) {
                return;
            }
            Element table = doc.createElement("Table1");
            root.appendChild(table);
            for (int columnIndex = 0; columnIndex < matrix.getFields().length; ++columnIndex) {
                String text = matrix.getFields()[columnIndex].DataArray[rowIndex];
                Element element = doc.createElement(StiXmlHelper.validName((String)matrix.getFields()[columnIndex].Name));
                table.appendChild(element);
                element.setTextContent(text);
            }
        }
        outputStream.write(StiXmlHelper.serialize((Document)doc).getBytes("UTF-8"));
        if (matrix != null) {
            matrix.clear();
            matrix = null;
        }
        this.closeProgress();
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Xml;
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }
}

