/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.drawing.StiHtmlState;
import com.stimulsoft.base.drawing.StiTextRendererParseHtml;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiRtfHelper;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.interfaces.IStiTextHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiTextOptions;
import com.stimulsoft.report.components.interfaces.IStiVertAlignment;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiTxtExportSettings;
import com.stimulsoft.report.export.tools.StiCell;
import com.stimulsoft.report.export.tools.StiEscapeCodesCollection;
import com.stimulsoft.report.export.tools.StiExportUtils;
import com.stimulsoft.report.export.tools.StiMapUtil;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiTextRenderer;
import com.stimulsoft.report.export.tools.StiTxtBorderType;
import com.stimulsoft.report.options.ExportOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StiTxtExportService
extends StiExportService {
    private final String BORDER_CODES = "\u0006\t\f\n\u0005\u0003\r\u000b\u000e\u0007\u000f\u0001\u0002\u0004\b";
    private boolean[] needVerticalBorders = null;
    private boolean[] needHorizontalBorders = null;
    private boolean useFullTextBoxWidth = false;
    private boolean useFullVerticalBorder = true;
    private boolean useFullHorizontalBorder = true;
    private boolean useEscapeCodes = false;
    private ArrayList<StiTxtStyleInfo> styleList = null;
    private List<String> escapeCodesList = null;
    private StiReport report;

    private char getBorderChar(int code, StiTxtBorderType type) {
        if (this.useFullVerticalBorder) {
            switch (type) {
                case UnicodeSingle: {
                    return "\u2500\u2502\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c \u2500  ".charAt(code);
                }
                case UnicodeDouble: {
                    return "\u2550\u2551\u2554\u2557\u255a\u255d\u2560\u2563\u2566\u2569\u256c \u2550  ".charAt(code);
                }
            }
            return "-|+++++++++ -  ".charAt(code);
        }
        switch (type) {
            case UnicodeSingle: {
                return "\u2500\u2502\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c    ".charAt(code);
            }
            case UnicodeDouble: {
                return "\u2550\u2551\u2554\u2557\u255a\u255d\u2560\u2563\u2566\u2569\u256c    ".charAt(code);
            }
        }
        return "-|+++++++++    ".charAt(code);
    }

    private void lineFill(StringBuilder sb, int code, int startPosition, int count) {
        char ch = "\u0006\t\f\n\u0005\u0003\r\u000b\u000e\u0007\u000f\u0001\u0002\u0004\b".charAt(code - 1);
        for (int index = 0; index < count; ++index) {
            if ("\u0006\t\f\n\u0005\u0003\r\u000b\u000e\u0007\u000f\u0001\u0002\u0004\b".indexOf(sb.charAt(startPosition + index)) == -1) {
                if (sb.charAt(startPosition + index) != ' ') continue;
                sb.setCharAt(startPosition + index, ch);
                continue;
            }
            sb.setCharAt(startPosition + index, (char)(sb.charAt(startPosition + index) | ch));
        }
    }

    private void lineFillChar(StringBuilder sb, int code, int startPosition, int count) {
        for (int index = 0; index < count; ++index) {
            sb.setCharAt(startPosition + index, (char)code);
        }
    }

    private String[] checkWordWrap(StiCell cell, String[] arraySt, int cellWidth, boolean cutLongLines) {
        IStiTextOptions textOpt;
        if (this.useEscapeCodes) {
            for (int index = 0; index < arraySt.length; ++index) {
                StringBuilder text = new StringBuilder(arraySt[index]);
                for (int pos = 0; pos < text.length(); ++pos) {
                    if (text.charAt(pos) != '<' || pos >= text.length() + 1 || text.charAt(pos + 1) != '#') continue;
                    int pos2 = pos;
                    StringBuilder escapeString = new StringBuilder();
                    while (text.charAt(pos2) == '<' && pos2 < text.length() + 1 && text.charAt(pos2 + 1) == '#') {
                        while (pos2 < text.length() && text.charAt(pos2) != '>') {
                            escapeString.append(text.charAt(pos2));
                            ++pos2;
                        }
                        escapeString.append('>');
                        if (++pos2 <= text.length() - 1) continue;
                    }
                    if (pos2 > text.length() - 1) {
                        escapeString.append('\uffff');
                    } else {
                        escapeString.append(text.charAt(pos2));
                        ++pos2;
                    }
                    int escapeIndex = this.getEscapeNumber(this.escapeCodesList, escapeString.toString());
                    text.delete(pos, pos2);
                    text.insert(pos, (char)(65279 - escapeIndex));
                }
                if (text.length() == arraySt[index].length()) continue;
                arraySt[index] = text.toString();
            }
        }
        int widthOfCell = cellWidth;
        if (this.useFullVerticalBorder) {
            if (this.needVerticalBorders[cell.getLeft() + cell.getWidth()]) {
                --widthOfCell;
            }
        } else if (!this.useFullTextBoxWidth && widthOfCell > 1) {
            --widthOfCell;
        }
        boolean wordWrap = false;
        IStiTextOptions iStiTextOptions = textOpt = cell.getComponent() instanceof IStiTextOptions ? (IStiTextOptions)((Object)cell.getComponent()) : null;
        if (textOpt != null) {
            wordWrap = textOpt.getTextOptions().getWordWrap();
        }
        if (wordWrap) {
            ArrayList<String> stringList = new ArrayList<String>(Arrays.asList(arraySt));
            for (int indexLine = 0; indexLine < stringList.size(); ++indexLine) {
                int index;
                String stt = (String)stringList.get(indexLine);
                if (stt.length() <= widthOfCell - 1 || widthOfCell <= 1) continue;
                int[] wordarr = new int[stt.length()];
                int wordCounter = 0;
                int tempIndexSpace = 0;
                while (stt.charAt(tempIndexSpace) == ' ') {
                    wordarr[tempIndexSpace] = wordCounter;
                    ++tempIndexSpace;
                }
                for (int tempIndex = tempIndexSpace; tempIndex < stt.length(); ++tempIndex) {
                    if (stt.charAt(tempIndex) == ' ') {
                        // empty if block
                    }
                    wordarr[tempIndex] = ++wordCounter;
                }
                int index2 = index = widthOfCell - 1 - 1;
                if (wordarr[index] > 0) {
                    if (wordarr[index] != wordarr[index + 1]) {
                        index2 = index++;
                        while (stt.charAt(index) == ' ') {
                            ++index;
                        }
                    } else {
                        while (stt.charAt(index) != ' ') {
                            --index;
                        }
                        index2 = index++;
                        while (stt.charAt(index2) == ' ') {
                            --index2;
                        }
                    }
                } else {
                    ++index;
                }
                stringList.set(indexLine, stt.substring(0, index2 + 1));
                stringList.add(indexLine + 1, stt.substring(index, stt.length()));
            }
            if (stringList.size() > arraySt.length) {
                arraySt = stringList.toArray(new String[0]);
            }
        }
        if (cutLongLines) {
            for (int index = 0; index < arraySt.length; ++index) {
                if (arraySt[index].length() <= widthOfCell) continue;
                arraySt[index] = arraySt[index].substring(0, widthOfCell);
            }
        }
        return arraySt;
    }

    private void checkGrow(List<StringBuilder> lines, List<Boolean> pageBreaks, int currentY) {
        while (lines.size() <= currentY) {
            lines.add(new StringBuilder());
            pageBreaks.add(false);
        }
    }

    private int getStyleNumber(ArrayList<StiTxtStyleInfo> tmpStyleList, StiTxtStyleInfo styleInfo) {
        if (tmpStyleList.size() > 0) {
            for (int index = 0; index < tmpStyleList.size(); ++index) {
                StiTxtStyleInfo tmpStyle = tmpStyleList.get(index);
                if (tmpStyle.Bold != styleInfo.Bold || tmpStyle.Italic != styleInfo.Italic || tmpStyle.Underline != styleInfo.Underline || !StiStringUtil.stringsEquals((String)tmpStyle.Codes, (String)styleInfo.Codes)) continue;
                return index;
            }
        }
        tmpStyleList.add(styleInfo);
        int temp = tmpStyleList.size() - 1;
        return temp;
    }

    private int getEscapeNumber(List<String> tmpStyleList, String escapeCodes) {
        if (tmpStyleList.size() > 0) {
            for (int index = 0; index < tmpStyleList.size(); ++index) {
                if (!tmpStyleList.get(index).equals(escapeCodes)) continue;
                return index + 1;
            }
        }
        tmpStyleList.add(escapeCodes);
        int temp = tmpStyleList.size();
        return temp;
    }

    private StringBuilder getEscapeNames(int oldStyleNumber, int newStyleNumber) {
        StiTxtStyleInfo oldStyle = this.styleList.get(oldStyleNumber);
        StiTxtStyleInfo newStyle = this.styleList.get(newStyleNumber);
        StringBuilder sb = new StringBuilder();
        if (!oldStyle.Bold && newStyle.Bold) {
            sb.append("<#b>");
        }
        if (oldStyle.Bold && !newStyle.Bold) {
            sb.append("<#/b>");
        }
        if (!oldStyle.Italic && newStyle.Italic) {
            sb.append("<#i>");
        }
        if (oldStyle.Italic && !newStyle.Italic) {
            sb.append("<#/i>");
        }
        if (!oldStyle.Underline && newStyle.Underline) {
            sb.append("<#u>");
        }
        if (oldStyle.Underline && !newStyle.Underline) {
            sb.append("<#/u>");
        }
        return sb;
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        this.exportTxt(report, outputStream, (StiTxtExportSettings)exportSettings);
    }

    public void exportTxt(StiReport report, OutputStream outputStream, StiTxtExportSettings settings) throws StiException {
        try {
            this.exportTxtException(report, outputStream, settings);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void exportTxtException(StiReport report, OutputStream outputStream, StiTxtExportSettings settings) throws IOException {
        StiLicenseKeyValidator.isValidOnJavaFramework(null);
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        this.report = report;
        pageRange = settings.getPageRange();
        encoding = settings.getEncoding();
        drawBorder = settings.isDrawBorder();
        borderType = settings.getBorderType();
        killSpaceLines = settings.isKillSpaceLines();
        killSpaceGraphLines = settings.isKillSpaceGraphLines();
        putFeedPageCode = settings.isPutFeedPageCode();
        cutLongLines = settings.isCutLongLines();
        zoomX = settings.getZoomX();
        zoomY = settings.getZoomY();
        this.useEscapeCodes = settings.isUseEscapeCodes();
        escapeCodesCollectionName = settings.getEscapeCodesCollectionName();
        this.useFullTextBoxWidth = ExportOptions.Txt.getUseFullTextBoxWidth();
        this.useFullVerticalBorder = ExportOptions.Txt.getUseFullVerticalBorder();
        this.useFullHorizontalBorder = ExportOptions.Txt.getUseFullHorizontalBorder();
        insideScaleX = 9.7;
        insideScaleY = 18.0;
        if (!killSpaceLines) {
            killSpaceGraphLines = false;
        }
        if (!drawBorder) {
            killSpaceGraphLines = false;
        }
        if (this.useFullVerticalBorder) {
            this.useFullTextBoxWidth = false;
        }
        tempStream = new ByteArrayOutputStream();
        sw = new OutputStreamWriter((OutputStream)tempStream, encoding);
        this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
        pages = pageRange.getSelectedPages(report.getRenderedPages());
        lines = null;
        styles = null;
        pageLines = 0;
        this.styleList = new ArrayList<E>();
        baseStyle = new StiTxtStyleInfo();
        this.getStyleNumber(this.styleList, baseStyle);
        this.escapeCodesList = new ArrayList<String>();
        matrix = new StiMatrix(pages, false, this);
        if (this.isStoped()) {
            return;
        }
        this.needVerticalBorders = new boolean[matrix.getCoordX().size()];
        for (columnIndex = 1; columnIndex < matrix.getCoordX().size(); ++columnIndex) {
            needVertical = false;
            for (rowIndex = 1; rowIndex < matrix.getCoordY().size(); ++rowIndex) {
                if (matrix.getBordersY()[rowIndex - 1][columnIndex] == null) continue;
                needVertical = true;
                break;
            }
            this.needVerticalBorders[columnIndex - 1] = needVertical;
        }
        this.needHorizontalBorders = new boolean[matrix.getCoordY().size()];
        for (rowIndex = 1; rowIndex < matrix.getCoordY().size(); ++rowIndex) {
            needHorizontal = false;
            for (columnIndex = 1; columnIndex < matrix.getCoordX().size(); ++columnIndex) {
                if (matrix.getBordersX()[rowIndex][columnIndex - 1] == null) continue;
                needHorizontal = true;
                break;
            }
            this.needHorizontalBorders[rowIndex - 1] = needHorizontal;
        }
        defaultWidths = new int[matrix.getCoordX().size()];
        for (columnIndex = 1; columnIndex < matrix.getCoordX().size(); ++columnIndex) {
            value2 = (Double)StiMapUtil.getByIndex(matrix.getCoordX(), columnIndex);
            value1 = (Double)StiMapUtil.getByIndex(matrix.getCoordX(), columnIndex - 1);
            defaultWidths[columnIndex - 1] = (int)Math.round((value2 - value1) / (insideScaleX / (double)zoomX));
            if (!this.useFullVerticalBorder || !this.needVerticalBorders[columnIndex - 1]) continue;
            v0 = columnIndex - 1;
            defaultWidths[v0] = defaultWidths[v0] + 1;
        }
        readyCells = new boolean[matrix.getCoordY().size()][matrix.getCoordX().size()];
        widths = new int[matrix.getCoordY().size()][matrix.getCoordX().size()];
        heights = new int[matrix.getCoordY().size()][matrix.getCoordX().size()];
        for (rowIndex = 1; rowIndex < matrix.getCoordY().size(); ++rowIndex) {
            for (columnIndex = 1; columnIndex < matrix.getCoordX().size(); ++columnIndex) {
                block130: {
                    block129: {
                        if (readyCells[rowIndex - 1][columnIndex - 1]) continue;
                        cell = matrix.getCells()[rowIndex - 1][columnIndex - 1];
                        widths[rowIndex - 1][columnIndex - 1] = defaultWidths[columnIndex - 1];
                        if (cell == null) continue;
                        if (cell.getWidth() > 0) {
                            for (index = 0; index < cell.getWidth(); ++index) {
                                v1 = widths[rowIndex - 1];
                                v2 = columnIndex - 1;
                                v1[v2] = v1[v2] + defaultWidths[columnIndex - 1 + 1 + index];
                            }
                        }
                        if (cell.getComponent() == null) break block130;
                        if (cell.getComponent() != null && (sTag = cell.getComponent().getTagStrValue()) != null && sTag.length() > 0) {
                            sTag = sTag.trim();
                            param = 0;
                            try {
                                param = Integer.parseInt(sTag);
                                if (param <= 0) break block129;
                                widths[rowIndex - 1][columnIndex - 1] = param;
                            }
                            catch (Exception e) {
                                try {
                                    param = 0;
                                    if (param <= 0) break block129;
                                    widths[rowIndex - 1][columnIndex - 1] = param;
                                }
                                catch (Throwable var37_56) {
                                    if (param > 0) {
                                        widths[rowIndex - 1][columnIndex - 1] = param;
                                        if (this.useFullVerticalBorder && this.needVerticalBorders[columnIndex - 1 + cell.getWidth()]) {
                                            v5 = widths[rowIndex - 1];
                                            v6 = columnIndex - 1;
                                            v5[v6] = v5[v6] + 1;
                                        }
                                    }
                                    throw var37_56;
                                }
                                if (this.useFullVerticalBorder && this.needVerticalBorders[columnIndex - 1 + cell.getWidth()]) {
                                    v7 = widths[rowIndex - 1];
                                    v8 = columnIndex - 1;
                                    v7[v8] = v7[v8] + 1;
                                } else {
                                    ** GOTO lbl117
                                }
                            }
                            if (this.useFullVerticalBorder && this.needVerticalBorders[columnIndex - 1 + cell.getWidth()]) {
                                v3 = widths[rowIndex - 1];
                                v4 = columnIndex - 1;
                                v3[v4] = v3[v4] + 1;
                            }
                        }
                    }
                    str = cell.getText();
                    v9 = rtf = cell.getComponent() instanceof StiRichText != false ? (StiRichText)cell.getComponent() : null;
                    if (rtf != null && StiValidationUtil.isNotNullOrEmpty((String)rtf.unpackRTF())) {
                        str = StiRtfHelper.rtfToPlain((String)rtf.unpackRTF());
                    }
                    v10 = mCheckbox = cell.getComponent() instanceof StiCheckBox != false ? (StiCheckBox)cell.getComponent() : null;
                    if (mCheckbox != null && mCheckbox.getCheckedValue() != null) {
                        isTrue = false;
                        isFalse = false;
                        if (mCheckbox.getCheckedValue() instanceof Boolean) {
                            if (((Boolean)mCheckbox.getCheckedValue()).booleanValue()) {
                                isTrue = true;
                            } else {
                                isFalse = true;
                            }
                        }
                        if (mCheckbox.getCheckedValue() instanceof String) {
                            if (((String)mCheckbox.getCheckedValue()).equalsIgnoreCase("true")) {
                                isTrue = true;
                            } else {
                                isFalse = true;
                            }
                        }
                        if (isTrue) {
                            str = ExportOptions.Txt.getCheckBoxTextForTrue();
                        }
                        if (isFalse) {
                            str = ExportOptions.Txt.getCheckBoxTextForFalse();
                        }
                    }
                    if (!cell.getComponent().isExportAsImage(StiExportFormat.Text) && str != null && str.length() > 0) {
                        if (cell.getComponent() instanceof StiText && ((StiText)cell.getComponent()).getAllowHtmlTags()) {
                            baseState = new StiHtmlState();
                            baseState.setText(new StringBuilder());
                            listStates = StiTextRendererParseHtml.parseHtmlToStates((String)str, (StiHtmlState)baseState);
                            sb = new StringBuilder();
                            for (StiHtmlState state : listStates) {
                                sb.append((CharSequence)StiTextRenderer.prepareStateText(state.getText()));
                            }
                            str = sb.toString();
                        }
                        stringList = StiExportUtils.splitString(str.replaceAll("\r", ""), false);
                        arraySt = new String[stringList.size()];
                        for (indexLine = 0; indexLine < stringList.size(); ++indexLine) {
                            arraySt[indexLine] = stringList.get(indexLine);
                        }
                        arraySt = this.checkWordWrap(cell, arraySt, widths[rowIndex - 1][columnIndex - 1], cutLongLines);
                        heights[rowIndex - 1][columnIndex - 1] = numLines = arraySt.length;
                    }
                }
                for (yy = 0; yy <= cell.getHeight(); ++yy) {
                    for (xx = 0; xx <= cell.getWidth(); ++xx) {
                        readyCells[rowIndex - 1 + yy][columnIndex - 1 + xx] = true;
                    }
                    widths[rowIndex - 1 + yy][columnIndex - 1] = widths[rowIndex - 1][columnIndex - 1];
                }
            }
        }
        rowHeights = new int[matrix.getCoordY().size()];
        pageLines = 1;
        for (rowIndex = 1; rowIndex < matrix.getCoordY().size(); ++rowIndex) {
            value2 = (Double)StiMapUtil.getByIndex(matrix.getCoordY(), rowIndex);
            defaultHeight = (int)Math.round((value2 - (value1 = ((Double)StiMapUtil.getByIndex(matrix.getCoordY(), rowIndex - 1)).doubleValue())) / (insideScaleY / (double)zoomY));
            if (defaultHeight < 1) {
                defaultHeight = 1;
            }
            for (columnIndex = 1; columnIndex < matrix.getCoordX().size(); ++columnIndex) {
                cell = matrix.getCells()[rowIndex - 1][columnIndex - 1];
                if (cell == null || cell.getHeight() >= 1 || heights[rowIndex - 1][columnIndex - 1] <= defaultHeight) continue;
                defaultHeight = heights[rowIndex - 1][columnIndex - 1];
            }
            if (!this.useFullHorizontalBorder || this.needHorizontalBorders[rowIndex - 1]) {
                // empty if block
            }
            rowHeights[rowIndex - 1] = ++defaultHeight;
            pageLines += defaultHeight;
        }
        ++pageLines;
        lines = new ArrayList<StringBuilder>();
        styles = new ArrayList<StringBuilder>();
        pageBreaks = new ArrayList<Boolean>();
        for (indexLine = 0; indexLine < pageLines; ++indexLine) {
            lines.add(new StringBuilder());
            styles.add(new StringBuilder());
            pageBreaks.add(false);
        }
        readyCells = new boolean[matrix.getCoordY().size()][matrix.getCoordX().size()];
        cellPositionY = drawBorder != false ? 1 : 0;
        checkboxText = new StiText();
        checkboxText.setVertAlignment(StiVertAlignment.Center);
        checkboxText.setHorAlignment(StiTextHorAlignment.Center);
        for (rowIndex = 1; rowIndex < matrix.getCoordY().size(); ++rowIndex) {
            this.invokeExporting(rowIndex, matrix.getCoordY().size());
            for (indexLine = 0; indexLine < matrix.getHorizontalPageBreaks().size(); ++indexLine) {
                if (matrix.getHorizontalPageBreaks().get(indexLine) != rowIndex - 1) continue;
                pageBreaks.set(cellPositionY - (drawBorder != false && rowIndex > 1 && this.needHorizontalBorders[rowIndex - 1 - 1] != false ? 1 : 0), true);
            }
            cellPositionX = drawBorder != false ? 1 : 0;
            for (columnIndex = 1; columnIndex < matrix.getCoordX().size(); ++columnIndex) {
                cell = matrix.getCells()[rowIndex - 1][columnIndex - 1];
                cellSizeX = widths[rowIndex - 1][columnIndex - 1];
                cellSizeY = rowHeights[rowIndex - 1];
                if (!readyCells[rowIndex - 1][columnIndex - 1]) {
                    cellWidth = 0;
                    cellHeight = 0;
                    cellStyleIndex = 0;
                    if (cell != null) {
                        cellWidth = cell.getWidth();
                        cellHeight = cell.getHeight();
                        for (xx = 0; xx <= cell.getWidth(); ++xx) {
                            for (yy = 0; yy <= cell.getHeight(); ++yy) {
                                readyCells[rowIndex - 1 + yy][columnIndex - 1 + xx] = true;
                            }
                        }
                        if (cell.getHeight() > 0) {
                            for (index = 0; index < cell.getHeight(); ++index) {
                                cellSizeY += rowHeights[rowIndex - 1 + 1 + index];
                            }
                        }
                        if (this.useFullHorizontalBorder && this.needHorizontalBorders[rowIndex - 1 + cellHeight]) {
                            --cellSizeY;
                        }
                        if (cell.getComponent() != null) {
                            v11 = textComp = cell.getComponent() instanceof StiText != false ? (StiText)cell.getComponent() : null;
                            if (textComp != null) {
                                styleInfo = new StiTxtStyleInfo();
                                styleInfo.Bold = textComp.getFont().bold();
                                styleInfo.Italic = textComp.getFont().italic();
                                styleInfo.Underline = textComp.getFont().underline();
                                styleInfo.Codes = null;
                                cellStyleIndex = this.getStyleNumber(this.styleList, styleInfo);
                            }
                            str = cell.getText();
                            v12 = rtf = cell.getComponent() instanceof StiRichText != false ? (StiRichText)cell.getComponent() : null;
                            if (rtf != null && StiValidationUtil.isNotNullOrEmpty((String)rtf.unpackRTF())) {
                                str = StiRtfHelper.rtfToPlain((String)rtf.unpackRTF());
                            }
                            v13 = mCheckbox = cell.getComponent() instanceof StiCheckBox != false ? (StiCheckBox)cell.getComponent() : null;
                            if (mCheckbox != null && mCheckbox.getCheckedValue() != null) {
                                isTrue = false;
                                isFalse = false;
                                if (mCheckbox.getCheckedValue() instanceof Boolean) {
                                    if (((Boolean)mCheckbox.getCheckedValue()).booleanValue()) {
                                        isTrue = true;
                                    } else {
                                        isFalse = true;
                                    }
                                }
                                if (mCheckbox.getCheckedValue() instanceof String) {
                                    if ("true".equals(((String)mCheckbox.getCheckedValue()).toLowerCase())) {
                                        isTrue = true;
                                    } else {
                                        isFalse = true;
                                    }
                                }
                                if (isTrue) {
                                    str = ExportOptions.Txt.getCheckBoxTextForTrue();
                                }
                                if (isFalse) {
                                    str = ExportOptions.Txt.getCheckBoxTextForFalse();
                                }
                            }
                            if (!cell.getComponent().isExportAsImage(StiExportFormat.Text) && str != null && str.length() > 0) {
                                if (cell.getComponent() instanceof StiText && ((StiText)cell.getComponent()).getAllowHtmlTags()) {
                                    baseState = new StiHtmlState();
                                    baseState.setText(new StringBuilder());
                                    listStates = StiTextRendererParseHtml.parseHtmlToStates((String)str, (StiHtmlState)baseState);
                                    sb = new StringBuilder();
                                    for (StiHtmlState state : listStates) {
                                        sb.append((CharSequence)StiTextRenderer.prepareStateText(state.getText()));
                                    }
                                    str = sb.toString();
                                }
                                stringList = StiExportUtils.splitString(str.replaceAll("\r", ""), false);
                                arraySt = new String[stringList.size()];
                                for (indexLine = 0; indexLine < stringList.size(); ++indexLine) {
                                    arraySt[indexLine] = stringList.get(indexLine);
                                }
                                arraySt = this.checkWordWrap(cell, arraySt, widths[rowIndex - 1][columnIndex - 1], cutLongLines);
                                textOffsetY = 0;
                                v14 = vertAlignment = cell.getComponent() instanceof IStiVertAlignment != false ? (IStiVertAlignment)cell.getComponent() : null;
                                if (mCheckbox != null) {
                                    vertAlignment = checkboxText;
                                }
                                if (vertAlignment != null && arraySt.length < cellSizeY) {
                                    if (vertAlignment.getVertAlignment() == StiVertAlignment.Center) {
                                        textOffsetY = (cellSizeY - arraySt.length) / 2;
                                    }
                                    if (vertAlignment.getVertAlignment() == StiVertAlignment.Bottom) {
                                        textOffsetY = cellSizeY - arraySt.length;
                                    }
                                }
                                for (indexLine = 0; indexLine < arraySt.length; ++indexLine) {
                                    textOffsetX = 0;
                                    widthOfText = cellSizeX;
                                    if (this.useFullVerticalBorder) {
                                        if (this.needVerticalBorders[cell.getLeft() + cell.getWidth()]) {
                                            --widthOfText;
                                        }
                                    } else if (!this.useFullTextBoxWidth && widthOfText > 1) {
                                        --widthOfText;
                                    }
                                    v15 = horAlignment = cell.getComponent() instanceof IStiTextHorAlignment != false ? (IStiTextHorAlignment)cell.getComponent() : null;
                                    if (mCheckbox != null) {
                                        horAlignment = checkboxText;
                                    }
                                    if (horAlignment != null) {
                                        if (horAlignment.getHorAlignment() == StiTextHorAlignment.Center) {
                                            textOffsetX = (widthOfText - arraySt[indexLine].length()) / 2;
                                        }
                                        if (horAlignment.getHorAlignment() == StiTextHorAlignment.Right) {
                                            textOffsetX = widthOfText - arraySt[indexLine].length();
                                        }
                                    }
                                    textX = cellPositionX + textOffsetX;
                                    textY = cellPositionY + textOffsetY + indexLine;
                                    if (textX < 0) {
                                        textX = 0;
                                    }
                                    lineEndPos = textX + arraySt[indexLine].length();
                                    this.checkGrow(lines, pageBreaks, textY);
                                    if (((StringBuilder)lines.get(textY)).length() < lineEndPos) {
                                        ((StringBuilder)lines.get(textY)).append(StiStringUtil.repeatString((String)" ", (int)(lineEndPos - ((StringBuilder)lines.get(textY)).length())));
                                    }
                                    for (indexChar = 0; indexChar < arraySt[indexLine].length(); ++indexChar) {
                                        sym = arraySt[indexLine].charAt(indexChar);
                                        if (sym < 32) {
                                            sym += 65280;
                                        }
                                        ((StringBuilder)lines.get(textY)).setCharAt(textX + indexChar, (char)sym);
                                    }
                                }
                            }
                        }
                    } else if (this.useFullHorizontalBorder && this.needHorizontalBorders[rowIndex - 1]) {
                        --cellSizeY;
                    }
                    if (!this.useFullHorizontalBorder) {
                        --cellSizeY;
                    }
                    for (tempIndexY = 0; tempIndexY < cellSizeY; ++tempIndexY) {
                        if (((StringBuilder)styles.get(cellPositionY + tempIndexY)).length() < cellPositionX + cellSizeX) {
                            ((StringBuilder)styles.get(cellPositionY + tempIndexY)).append(StiStringUtil.repeatString((String)"\u0000", (int)(cellPositionX + cellSizeX - ((StringBuilder)styles.get(cellPositionY + tempIndexY)).length())));
                        }
                        widthOfText = cellSizeX;
                        if (this.useFullVerticalBorder) {
                            if (cell != null && this.needVerticalBorders[cell.getLeft() + cell.getWidth()]) {
                                --widthOfText;
                            }
                        } else if (!this.useFullTextBoxWidth && widthOfText > 1) {
                            --widthOfText;
                        }
                        this.lineFillChar((StringBuilder)styles.get(cellPositionY + tempIndexY), cellStyleIndex, cellPositionX, widthOfText);
                    }
                    if (drawBorder) {
                        lineEndPos = cellPositionX + cellSizeX - 1;
                        for (index = -1; index <= cellSizeY; ++index) {
                            this.checkGrow(lines, pageBreaks, cellPositionY + index);
                            if (((StringBuilder)lines.get(cellPositionY + index)).length() >= lineEndPos + 1) continue;
                            ((StringBuilder)lines.get(cellPositionY + index)).append(StiStringUtil.repeatString((String)" ", (int)(lineEndPos + 1 - ((StringBuilder)lines.get(cellPositionY + index)).length())));
                        }
                        needBorderLeft = true;
                        needBorderRight = true;
                        for (index = 0; index < cellHeight + 1; ++index) {
                            if (matrix.getBordersY()[rowIndex - 1 + index][columnIndex - 1] == null) {
                                needBorderLeft = false;
                            }
                            if (matrix.getBordersY()[rowIndex - 1 + index][columnIndex - 1 + cellWidth + 1] != null) continue;
                            needBorderRight = false;
                        }
                        needBorderTop = true;
                        needBorderBottom = true;
                        for (index = 0; index < cellWidth + 1; ++index) {
                            if (matrix.getBordersX()[rowIndex - 1][columnIndex - 1 + index] == null) {
                                needBorderTop = false;
                            }
                            if (matrix.getBordersX()[rowIndex - 1 + cellHeight + 1][columnIndex - 1 + index] != null) continue;
                            needBorderBottom = false;
                        }
                        if (needBorderTop) {
                            this.lineFill((StringBuilder)lines.get(cellPositionY - 1), 14, cellPositionX - 1, 1);
                            this.lineFill((StringBuilder)lines.get(cellPositionY - 1), 1, cellPositionX, cellSizeX - 1);
                            this.lineFill((StringBuilder)lines.get(cellPositionY - 1), 13, cellPositionX + cellSizeX - 1, 1);
                        }
                        if (needBorderLeft) {
                            this.lineFill((StringBuilder)lines.get(cellPositionY - 1), 15, cellPositionX - 1, 1);
                            for (index = 0; index < cellSizeY; ++index) {
                                this.lineFill((StringBuilder)lines.get(cellPositionY + index), 2, cellPositionX - 1, 1);
                            }
                            this.lineFill((StringBuilder)lines.get(cellPositionY + cellSizeY), 12, cellPositionX - 1, 1);
                        }
                        if (needBorderRight) {
                            this.lineFill((StringBuilder)lines.get(cellPositionY - 1), 15, cellPositionX + cellSizeX - 1, 1);
                            for (index = 0; index < cellSizeY; ++index) {
                                this.lineFill((StringBuilder)lines.get(cellPositionY + index), 2, cellPositionX + cellSizeX - 1, 1);
                            }
                            this.lineFill((StringBuilder)lines.get(cellPositionY + cellSizeY), 12, cellPositionX + cellSizeX - 1, 1);
                        }
                        if (needBorderBottom) {
                            this.lineFill((StringBuilder)lines.get(cellPositionY + cellSizeY), 14, cellPositionX - 1, 1);
                            this.lineFill((StringBuilder)lines.get(cellPositionY + cellSizeY), 1, cellPositionX, cellSizeX - 1);
                            this.lineFill((StringBuilder)lines.get(cellPositionY + cellSizeY), 13, cellPositionX + cellSizeX - 1, 1);
                        }
                    }
                }
                cellPositionX += cellSizeX;
            }
            cellPositionY += rowHeights[rowIndex - 1];
        }
        lastStyleNumber = 0;
        for (indexLine = 0; indexLine < lines.size(); ++indexLine) {
            if (((StringBuilder)lines.get(indexLine)).length() > 0) {
                for (index = 0; index < "\u0006\t\f\n\u0005\u0003\r\u000b\u000e\u0007\u000f\u0001\u0002\u0004\b".length(); ++index) {
                    ((StringBuilder)lines.get(indexLine)).replace(0, ((StringBuilder)lines.get(indexLine)).length(), ((StringBuilder)lines.get(indexLine)).toString().replace("\u0006\t\f\n\u0005\u0003\r\u000b\u000e\u0007\u000f\u0001\u0002\u0004\b".charAt(index), this.getBorderChar(index, borderType)));
                }
                if (ExportOptions.Txt.getTrimTrailingSpaces()) {
                    for (index = ((StringBuilder)lines.get(indexLine)).length() - 1; index >= 0 && ((StringBuilder)lines.get(indexLine)).charAt(index) == ' '; --index) {
                        ((StringBuilder)lines.get(indexLine)).setLength(((StringBuilder)lines.get(indexLine)).length() - 1);
                    }
                }
                if (killSpaceGraphLines) {
                    st = this.getBorderChar(1, borderType) + " ";
                    bb = true;
                    for (index = 0; index < ((StringBuilder)lines.get(indexLine)).length(); ++index) {
                        if (st.indexOf(((StringBuilder)lines.get(indexLine)).charAt(index)) != -1) continue;
                        bb = false;
                    }
                    if (bb) {
                        ((StringBuilder)lines.get(indexLine)).setLength(0);
                    }
                }
                if (putFeedPageCode && ((Boolean)pageBreaks.get(indexLine)).booleanValue()) {
                    if (this.useEscapeCodes) {
                        sw.write(this.getEscapeNames(lastStyleNumber, 0).toString());
                    }
                    lastStyleNumber = 0;
                    sw.write("\f\r\n");
                }
                if (this.useEscapeCodes) {
                    sbt = new StringBuilder();
                    for (indexChar = 0; indexChar < ((StringBuilder)lines.get(indexLine)).length(); ++indexChar) {
                        currentStyleNumber = 0;
                        if (indexChar < ((StringBuilder)styles.get(indexLine)).length()) {
                            currentStyleNumber = ((StringBuilder)styles.get(indexLine)).charAt(indexChar);
                        }
                        if (currentStyleNumber != lastStyleNumber) {
                            sbt.append((CharSequence)this.getEscapeNames(lastStyleNumber, currentStyleNumber));
                            lastStyleNumber = currentStyleNumber;
                        }
                        if ((ch = ((StringBuilder)lines.get(indexLine)).charAt(indexChar)) > '\ubfff' && ch <= '\ufeff') {
                            escapeStringIndex = 65279 - ch;
                            escapeString = this.escapeCodesList.get(escapeStringIndex - 1);
                            if (escapeString.charAt(escapeString.length() - 1) == '\uffff') {
                                escapeString = escapeString.substring(0, escapeString.length() - 1) + ' ';
                            }
                            sbt.append(escapeString);
                            continue;
                        }
                        sbt.append(ch);
                    }
                    if (sbt.length() > ((StringBuilder)lines.get(indexLine)).length()) {
                        lines.set(indexLine, sbt);
                    }
                }
            }
            if (killSpaceLines && ((StringBuilder)lines.get(indexLine)).length() <= 0) continue;
            for (indexSym = 0; indexSym < ((StringBuilder)lines.get(indexLine)).length(); ++indexSym) {
                if (((StringBuilder)lines.get(indexLine)).charAt(indexSym) < '\uff00') continue;
                ((StringBuilder)lines.get(indexLine)).setCharAt(indexSym, (char)(((StringBuilder)lines.get(indexLine)).charAt(indexSym) - 65280));
            }
            sw.write(((StringBuilder)lines.get(indexLine)).toString() + "\r\n");
        }
        sbb = new StringBuilder();
        if (this.useEscapeCodes) {
            sbb.append((CharSequence)this.getEscapeNames(lastStyleNumber, 0));
        }
        if (putFeedPageCode) {
            sbb.append("\f");
        }
        if (sbb.length() > 0) {
            sw.write(sbb.toString() + "\r\n");
        }
        sw.close();
        tempStream.close();
        osw = new OutputStreamWriter(outputStream, encoding);
        st = new String(tempStream.toByteArray(), encoding);
        text = this.useEscapeCodes != false ? StiEscapeCodesCollection.convertEscapeCodes(st, escapeCodesCollectionName) : st;
        osw.write(text);
        osw.close();
        this.needVerticalBorders = null;
        this.needHorizontalBorders = null;
        this.styleList = null;
        this.escapeCodesList = null;
        this.closeProgress();
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Text;
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }

    private class StiTxtStyleInfo {
        public boolean Bold;
        public boolean Italic;
        public boolean Underline;
        public String Codes;

        private StiTxtStyleInfo() {
        }
    }
}

