/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiAdvancedBorder;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiCap;
import com.stimulsoft.base.drawing.StiCapStyle;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiCultureInfo;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiXmlTextWriter;
import com.stimulsoft.base.utils.StiZipWriter20;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiImageCache;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiExportImage;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiTextOptions;
import com.stimulsoft.report.components.simplecomponents.StiHorizontalLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiShape;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.simplecomponents.StiVerticalLinePrimitive;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExcel2007ExportService;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiPpt2007ExportSettings;
import com.stimulsoft.report.export.tools.StiColorImageFormat;
import com.stimulsoft.report.export.tools.StiExportUtils;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.StiTextRenderer;
import com.stimulsoft.report.expressions.StiExpression;
import com.stimulsoft.report.options.ExportOptions;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

public class StiPpt2007ExportService
extends StiExportService {
    private StiReport report;
    private String fileName;
    private boolean sendEMail;
    private int imageListOffset = 0;
    private float imageResolution = 1.0f;
    private float imageQuality = 0.75f;
    private StiImageCache imageCache = null;
    private int idCounter = 2;
    private ArrayList<String> hyperlinkList = null;
    private int xmlIndentation = 1;
    private StiCultureInfo currentCulture = null;
    private StiCultureInfo newCulture = null;
    private static double HiToTwips = 14.328;

    public String getDefaultExtension() {
        return "pptx";
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Ppt2007;
    }

    @Override
    public void export(StiReport report, OutputStream stream, StiExportSettings settings) throws StiException {
        try {
            this.exportPowerPoint(report, stream, (StiPpt2007ExportSettings)settings);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
        this.invokeExporting(100, 100);
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }

    public String getFilter() {
        return StiLocalization.Get((String)"FileFilters", (String)"Ppt2007Files");
    }

    private String getLineStyle(StiPenStyle penStyle) {
        switch (penStyle) {
            case Solid: {
                return "solid";
            }
            case Dot: {
                return "sysDot";
            }
            case Dash: {
                return "sysDash";
            }
            case DashDot: {
                return "sysDashDot";
            }
            case DashDotDot: {
                return "sysDashDotDot";
            }
            case Double: {
                return "solid";
            }
        }
        return "solid";
    }

    private String stringToUrl(String input) throws UnsupportedEncodingException {
        byte[] buf = input.getBytes("UTF8");
        StringBuilder output = new StringBuilder();
        for (byte byt : buf) {
            if (byt < 32 || StiExcel2007ExportService.WRONG_URL_SYMBOLS.indexOf(byt) != -1) {
                output.append(String.format("%%%02x", byt));
                continue;
            }
            output.append((char)byt);
        }
        return output.toString();
    }

    private int convert(double x) {
        return (int)Math.round(x * HiToTwips);
    }

    private int convertTwipsToEmu(double x) {
        return (int)Math.round(x / HiToTwips / 100.0 * 914400.0);
    }

    private Integer convertToEmu(double x) {
        return (int)Math.round(x / 100.0 * 914400.0);
    }

    private void writeColor(StiXmlTextWriter writer, StiColor color) {
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", color.toHTML().substring(1));
        if (color.a != 255) {
            int alphaValue = (int)((float)color.a / 256.0f * 100000.0f);
            writer.writeStartElement("a:alpha");
            writer.writeAttributeString("val", String.format("%s", alphaValue));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private Document writeContentTypes(int pagesCount) throws ParserConfigurationException {
        int index;
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("Types");
        writer.writeAttributeString("xmlns", "http://schemas.openxmlformats.org/package/2006/content-types");
        for (index = 0; index < 11; ++index) {
            writer.writeStartElement("Override");
            writer.writeAttributeString("PartName", String.format("/ppt/slideLayouts/slideLayout%s.xml", index + 1));
            writer.writeAttributeString("ContentType", "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml");
            writer.writeEndElement();
        }
        writer.writeStartElement("Override");
        writer.writeAttributeString("PartName", "/ppt/slideMasters/slideMaster1.xml");
        writer.writeAttributeString("ContentType", "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml");
        writer.writeEndElement();
        writer.writeStartElement("Override");
        writer.writeAttributeString("PartName", "/ppt/presProps.xml");
        writer.writeAttributeString("ContentType", "application/vnd.openxmlformats-officedocument.presentationml.presProps+xml");
        writer.writeEndElement();
        for (index = 0; index < pagesCount; ++index) {
            writer.writeStartElement("Override");
            writer.writeAttributeString("PartName", String.format("/ppt/slides/slide%s.xml", index + 1));
            writer.writeAttributeString("ContentType", "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
            writer.writeEndElement();
        }
        writer.writeStartElement("Override");
        writer.writeAttributeString("PartName", "/ppt/theme/theme1.xml");
        writer.writeAttributeString("ContentType", "application/vnd.openxmlformats-officedocument.theme+xml");
        writer.writeEndElement();
        writer.writeStartElement("Default");
        writer.writeAttributeString("Extension", "jpeg");
        writer.writeAttributeString("ContentType", "image/jpeg");
        writer.writeEndElement();
        writer.writeStartElement("Default");
        writer.writeAttributeString("Extension", "png");
        writer.writeAttributeString("ContentType", "image/png");
        writer.writeEndElement();
        writer.writeStartElement("Default");
        writer.writeAttributeString("Extension", "rels");
        writer.writeAttributeString("ContentType", "application/vnd.openxmlformats-package.relationships+xml");
        writer.writeEndElement();
        writer.writeStartElement("Default");
        writer.writeAttributeString("Extension", "xml");
        writer.writeAttributeString("ContentType", "application/xml");
        writer.writeEndElement();
        writer.writeStartElement("Override");
        writer.writeAttributeString("PartName", "/ppt/presentation.xml");
        writer.writeAttributeString("ContentType", "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml");
        writer.writeEndElement();
        writer.writeStartElement("Override");
        writer.writeAttributeString("PartName", "/docProps/app.xml");
        writer.writeAttributeString("ContentType", "application/vnd.openxmlformats-officedocument.extended-properties+xml");
        writer.writeEndElement();
        writer.writeStartElement("Override");
        writer.writeAttributeString("PartName", "/ppt/tableStyles.xml");
        writer.writeAttributeString("ContentType", "application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml");
        writer.writeEndElement();
        writer.writeStartElement("Override");
        writer.writeAttributeString("PartName", "/ppt/viewProps.xml");
        writer.writeAttributeString("ContentType", "application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml");
        writer.writeEndElement();
        writer.writeStartElement("Override");
        writer.writeAttributeString("PartName", "/docProps/core.xml");
        writer.writeAttributeString("ContentType", "application/vnd.openxmlformats-package.core-properties+xml");
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeMainRels() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("Relationships");
        writer.writeAttributeString("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        writer.writeStartElement("Relationship");
        writer.writeAttributeString("Id", "rId1");
        writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        writer.writeAttributeString("Target", "ppt/presentation.xml");
        writer.writeEndElement();
        writer.writeStartElement("Relationship");
        writer.writeAttributeString("Id", "rId2");
        writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties");
        writer.writeAttributeString("Target", "docProps/core.xml");
        writer.writeEndElement();
        writer.writeStartElement("Relationship");
        writer.writeAttributeString("Id", "rId3");
        writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties");
        writer.writeAttributeString("Target", "docProps/app.xml");
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeDocPropsApp(int pagesCount) throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("Properties");
        writer.writeAttributeString("xmlns", "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties");
        writer.writeAttributeString("xmlns:vt", "http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes");
        writer.writeElementString("Application", "Microsoft Office PowerPoint");
        writer.writeElementString("Slides", String.format("%s", pagesCount));
        writer.writeElementString("PresentationFormat", "On-screen Show (4:3)");
        writer.writeElementString("TotalTime", "0");
        writer.writeElementString("Words", "0");
        writer.writeElementString("Paragraphs", "0");
        writer.writeElementString("Notes", "0");
        writer.writeElementString("HiddenSlides", "0");
        writer.writeElementString("MMClips", "0");
        writer.writeElementString("ScaleCrop", "false");
        writer.writeStartElement("HeadingPairs");
        writer.writeStartElement("vt:vector");
        writer.writeAttributeString("size", "4");
        writer.writeAttributeString("baseType", "variant");
        writer.writeStartElement("vt:variant");
        writer.writeElementString("vt:lpstr", "Theme");
        writer.writeEndElement();
        writer.writeStartElement("vt:variant");
        writer.writeElementString("vt:i4", String.format("%s", pagesCount));
        writer.writeEndElement();
        writer.writeStartElement("vt:variant");
        writer.writeElementString("vt:lpstr", "Slide Titles");
        writer.writeEndElement();
        writer.writeStartElement("vt:variant");
        writer.writeElementString("vt:i4", String.format("%s", pagesCount));
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("TitlesOfParts");
        writer.writeStartElement("vt:vector");
        writer.writeAttributeString("size", String.format("%s", 1 + pagesCount));
        writer.writeAttributeString("baseType", "lpstr");
        writer.writeElementString("vt:lpstr", "Office Theme");
        for (int index = 0; index < pagesCount; ++index) {
            writer.writeElementString("vt:lpstr", String.format("Slide %s", index + 1));
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeElementString("Company", "Stimulsoft");
        writer.writeElementString("LinksUpToDate", "false");
        writer.writeElementString("SharedDoc", "false");
        writer.writeElementString("HyperlinksChanged", "false");
        writer.writeElementString("AppVersion", "12.0000");
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeDocPropsCore() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("cp:coreProperties");
        writer.writeAttributeString("xmlns:cp", "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
        writer.writeAttributeString("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        writer.writeAttributeString("xmlns:dcterms", "http://purl.org/dc/terms/");
        writer.writeAttributeString("xmlns:dcmitype", "http://purl.org/dc/dcmitype/");
        writer.writeAttributeString("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        String dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH).format(new Date());
        writer.writeElementString("dc:title", "");
        writer.writeElementString("dc:subject", "");
        writer.writeElementString("dc:creator", StiExportUtils.getReportVersion());
        writer.writeElementString("cp:keywords", "");
        writer.writeElementString("dc:description", "");
        writer.writeElementString("cp:lastModifiedBy", "Stimulsoft Reports");
        writer.writeElementString("cp:revision", "1");
        writer.writeStartElement("dcterms:created");
        writer.writeAttributeString("xsi:type", "dcterms:W3CDTF");
        writer.writeString(dateTime);
        writer.writeEndElement();
        writer.writeStartElement("dcterms:modified");
        writer.writeAttributeString("xsi:type", "dcterms:W3CDTF");
        writer.writeString(dateTime);
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeTableStyles() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("a:tblStyleLst");
        writer.writeAttributeString("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        writer.writeAttributeString("def", "{5C22544A-7EE6-4342-B048-85BDC9FD1C3A}");
        writer.writeEndElement();
        return writer.getDocument();
    }

    private Document writePresProps() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("p:presentationPr");
        writer.writeAttributeString("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        writer.writeAttributeString("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        writer.writeAttributeString("xmlns:p", "http://schemas.openxmlformats.org/presentationml/2006/main");
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeViewProps() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("p:viewPr");
        writer.writeAttributeString("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        writer.writeAttributeString("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        writer.writeAttributeString("xmlns:p", "http://schemas.openxmlformats.org/presentationml/2006/main");
        writer.writeStartElement("p:normalViewPr");
        writer.writeAttributeString("showOutlineIcons", "0");
        writer.writeStartElement("p:restoredLeft");
        writer.writeAttributeString("sz", "15591");
        writer.writeAttributeString("autoAdjust", "0");
        writer.writeEndElement();
        writer.writeStartElement("p:restoredTop");
        writer.writeAttributeString("sz", "94675");
        writer.writeAttributeString("autoAdjust", "0");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("p:slideViewPr");
        writer.writeStartElement("p:cSldViewPr");
        writer.writeStartElement("p:cViewPr");
        writer.writeAttributeString("varScale", "1");
        writer.writeStartElement("p:scale");
        writer.writeStartElement("a:sx");
        writer.writeAttributeString("n", "107");
        writer.writeAttributeString("d", "100");
        writer.writeEndElement();
        writer.writeStartElement("a:sy");
        writer.writeAttributeString("n", "107");
        writer.writeAttributeString("d", "100");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("p:origin");
        writer.writeAttributeString("x", "-1098");
        writer.writeAttributeString("y", "-84");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("p:guideLst");
        writer.writeStartElement("p:guide");
        writer.writeAttributeString("orient", "horz");
        writer.writeAttributeString("pos", "2160");
        writer.writeEndElement();
        writer.writeStartElement("p:guide");
        writer.writeAttributeString("pos", "2880");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("p:notesTextViewPr");
        writer.writeStartElement("p:cViewPr");
        writer.writeStartElement("p:scale");
        writer.writeStartElement("a:sx");
        writer.writeAttributeString("n", "100");
        writer.writeAttributeString("d", "100");
        writer.writeEndElement();
        writer.writeStartElement("a:sy");
        writer.writeAttributeString("n", "100");
        writer.writeAttributeString("d", "100");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("p:origin");
        writer.writeAttributeString("x", "0");
        writer.writeAttributeString("y", "0");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("p:gridSpacing");
        writer.writeAttributeString("cx", "73736200");
        writer.writeAttributeString("cy", "73736200");
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeTheme() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("a:theme");
        writer.writeAttributeString("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        writer.writeAttributeString("name", "Office Theme");
        writer.writeStartElement("a:themeElements");
        writer.writeStartElement("a:clrScheme");
        writer.writeAttributeString("name", "Office");
        writer.writeStartElement("a:dk1");
        writer.writeStartElement("a:sysClr");
        writer.writeAttributeString("val", "windowText");
        writer.writeAttributeString("lastClr", "000000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:lt1");
        writer.writeStartElement("a:sysClr");
        writer.writeAttributeString("val", "window");
        writer.writeAttributeString("lastClr", "FFFFFF");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:dk2");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "1F497D");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:lt2");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "EEECE1");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:accent1");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "4F81BD");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:accent2");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "C0504D");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:accent3");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "9BBB59");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:accent4");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "8064A2");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:accent5");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "4BACC6");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:accent6");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "F79646");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:hlink");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "0000FF");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:folHlink");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "800080");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:fontScheme");
        writer.writeAttributeString("name", "Office");
        writer.writeStartElement("a:majorFont");
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "Calibri");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Jpan");
        writer.writeAttributeString("typeface", "\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Hang");
        writer.writeAttributeString("typeface", "\ub9d1\uc740 \uace0\ub515");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Hans");
        writer.writeAttributeString("typeface", "\u5b8b\u4f53");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Hant");
        writer.writeAttributeString("typeface", "\u65b0\u7d30\u660e\u9ad4");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Arab");
        writer.writeAttributeString("typeface", "Times New Roman");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Hebr");
        writer.writeAttributeString("typeface", "Times New Roman");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Thai");
        writer.writeAttributeString("typeface", "Angsana New");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Ethi");
        writer.writeAttributeString("typeface", "Nyala");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Beng");
        writer.writeAttributeString("typeface", "Vrinda");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Gujr");
        writer.writeAttributeString("typeface", "Shruti");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Khmr");
        writer.writeAttributeString("typeface", "MoolBoran");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Knda");
        writer.writeAttributeString("typeface", "Tunga");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Guru");
        writer.writeAttributeString("typeface", "Raavi");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Cans");
        writer.writeAttributeString("typeface", "Euphemia");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Cher");
        writer.writeAttributeString("typeface", "Plantagenet Cherokee");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Yiii");
        writer.writeAttributeString("typeface", "Microsoft Yi Baiti");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Tibt");
        writer.writeAttributeString("typeface", "Microsoft Himalaya");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Thaa");
        writer.writeAttributeString("typeface", "MV Boli");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Deva");
        writer.writeAttributeString("typeface", "Mangal");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Telu");
        writer.writeAttributeString("typeface", "Gautami");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Taml");
        writer.writeAttributeString("typeface", "Latha");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Syrc");
        writer.writeAttributeString("typeface", "Estrangelo Edessa");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Orya");
        writer.writeAttributeString("typeface", "Kalinga");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Mlym");
        writer.writeAttributeString("typeface", "Kartika");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Laoo");
        writer.writeAttributeString("typeface", "DokChampa");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Sinh");
        writer.writeAttributeString("typeface", "Iskoola Pota");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Mong");
        writer.writeAttributeString("typeface", "Mongolian Baiti");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Viet");
        writer.writeAttributeString("typeface", "Times New Roman");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Uigh");
        writer.writeAttributeString("typeface", "Microsoft Uighur");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:minorFont");
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "Calibri");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Jpan");
        writer.writeAttributeString("typeface", "\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Hang");
        writer.writeAttributeString("typeface", "\ub9d1\uc740 \uace0\ub515");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Hans");
        writer.writeAttributeString("typeface", "\u5b8b\u4f53");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Hant");
        writer.writeAttributeString("typeface", "\u65b0\u7d30\u660e\u9ad4");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Arab");
        writer.writeAttributeString("typeface", "Arial");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Hebr");
        writer.writeAttributeString("typeface", "Arial");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Thai");
        writer.writeAttributeString("typeface", "Cordia New");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Ethi");
        writer.writeAttributeString("typeface", "Nyala");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Beng");
        writer.writeAttributeString("typeface", "Vrinda");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Gujr");
        writer.writeAttributeString("typeface", "Shruti");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Khmr");
        writer.writeAttributeString("typeface", "DaunPenh");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Knda");
        writer.writeAttributeString("typeface", "Tunga");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Guru");
        writer.writeAttributeString("typeface", "Raavi");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Cans");
        writer.writeAttributeString("typeface", "Euphemia");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Cher");
        writer.writeAttributeString("typeface", "Plantagenet Cherokee");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Yiii");
        writer.writeAttributeString("typeface", "Microsoft Yi Baiti");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Tibt");
        writer.writeAttributeString("typeface", "Microsoft Himalaya");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Thaa");
        writer.writeAttributeString("typeface", "MV Boli");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Deva");
        writer.writeAttributeString("typeface", "Mangal");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Telu");
        writer.writeAttributeString("typeface", "Gautami");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Taml");
        writer.writeAttributeString("typeface", "Latha");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Syrc");
        writer.writeAttributeString("typeface", "Estrangelo Edessa");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Orya");
        writer.writeAttributeString("typeface", "Kalinga");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Mlym");
        writer.writeAttributeString("typeface", "Kartika");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Laoo");
        writer.writeAttributeString("typeface", "DokChampa");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Sinh");
        writer.writeAttributeString("typeface", "Iskoola Pota");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Mong");
        writer.writeAttributeString("typeface", "Mongolian Baiti");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Viet");
        writer.writeAttributeString("typeface", "Arial");
        writer.writeEndElement();
        writer.writeStartElement("a:font");
        writer.writeAttributeString("script", "Uigh");
        writer.writeAttributeString("typeface", "Microsoft Uighur");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:fmtScheme");
        writer.writeAttributeString("name", "Office");
        writer.writeStartElement("a:fillStyleLst");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:gradFill");
        writer.writeAttributeString("rotWithShape", "1");
        writer.writeStartElement("a:gsLst");
        writer.writeStartElement("a:gs");
        writer.writeAttributeString("pos", "0");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeStartElement("a:tint");
        writer.writeAttributeString("val", "50000");
        writer.writeEndElement();
        writer.writeStartElement("a:satMod");
        writer.writeAttributeString("val", "300000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:gs");
        writer.writeAttributeString("pos", "35000");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeStartElement("a:tint");
        writer.writeAttributeString("val", "37000");
        writer.writeEndElement();
        writer.writeStartElement("a:satMod");
        writer.writeAttributeString("val", "300000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:gs");
        writer.writeAttributeString("pos", "100000");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeStartElement("a:tint");
        writer.writeAttributeString("val", "15000");
        writer.writeEndElement();
        writer.writeStartElement("a:satMod");
        writer.writeAttributeString("val", "350000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:lin");
        writer.writeAttributeString("ang", "16200000");
        writer.writeAttributeString("scaled", "1");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:gradFill");
        writer.writeAttributeString("rotWithShape", "1");
        writer.writeStartElement("a:gsLst");
        writer.writeStartElement("a:gs");
        writer.writeAttributeString("pos", "0");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeStartElement("a:shade");
        writer.writeAttributeString("val", "51000");
        writer.writeEndElement();
        writer.writeStartElement("a:satMod");
        writer.writeAttributeString("val", "130000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:gs");
        writer.writeAttributeString("pos", "80000");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeStartElement("a:shade");
        writer.writeAttributeString("val", "93000");
        writer.writeEndElement();
        writer.writeStartElement("a:satMod");
        writer.writeAttributeString("val", "130000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:gs");
        writer.writeAttributeString("pos", "100000");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeStartElement("a:shade");
        writer.writeAttributeString("val", "94000");
        writer.writeEndElement();
        writer.writeStartElement("a:satMod");
        writer.writeAttributeString("val", "135000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:lin");
        writer.writeAttributeString("ang", "16200000");
        writer.writeAttributeString("scaled", "0");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:lnStyleLst");
        writer.writeStartElement("a:ln");
        writer.writeAttributeString("w", "9525");
        writer.writeAttributeString("cap", "flat");
        writer.writeAttributeString("cmpd", "sng");
        writer.writeAttributeString("algn", "ctr");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeStartElement("a:shade");
        writer.writeAttributeString("val", "95000");
        writer.writeEndElement();
        writer.writeStartElement("a:satMod");
        writer.writeAttributeString("val", "105000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:prstDash");
        writer.writeAttributeString("val", "solid");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:ln");
        writer.writeAttributeString("w", "25400");
        writer.writeAttributeString("cap", "flat");
        writer.writeAttributeString("cmpd", "sng");
        writer.writeAttributeString("algn", "ctr");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:prstDash");
        writer.writeAttributeString("val", "solid");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:ln");
        writer.writeAttributeString("w", "38100");
        writer.writeAttributeString("cap", "flat");
        writer.writeAttributeString("cmpd", "sng");
        writer.writeAttributeString("algn", "ctr");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:prstDash");
        writer.writeAttributeString("val", "solid");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:effectStyleLst");
        writer.writeStartElement("a:effectStyle");
        writer.writeStartElement("a:effectLst");
        writer.writeStartElement("a:outerShdw");
        writer.writeAttributeString("blurRad", "40000");
        writer.writeAttributeString("dist", "20000");
        writer.writeAttributeString("dir", "5400000");
        writer.writeAttributeString("rotWithShape", "0");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "000000");
        writer.writeStartElement("a:alpha");
        writer.writeAttributeString("val", "38000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:effectStyle");
        writer.writeStartElement("a:effectLst");
        writer.writeStartElement("a:outerShdw");
        writer.writeAttributeString("blurRad", "40000");
        writer.writeAttributeString("dist", "23000");
        writer.writeAttributeString("dir", "5400000");
        writer.writeAttributeString("rotWithShape", "0");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "000000");
        writer.writeStartElement("a:alpha");
        writer.writeAttributeString("val", "35000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:effectStyle");
        writer.writeStartElement("a:effectLst");
        writer.writeStartElement("a:outerShdw");
        writer.writeAttributeString("blurRad", "40000");
        writer.writeAttributeString("dist", "23000");
        writer.writeAttributeString("dir", "5400000");
        writer.writeAttributeString("rotWithShape", "0");
        writer.writeStartElement("a:srgbClr");
        writer.writeAttributeString("val", "000000");
        writer.writeStartElement("a:alpha");
        writer.writeAttributeString("val", "35000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:scene3d");
        writer.writeStartElement("a:camera");
        writer.writeAttributeString("prst", "orthographicFront");
        writer.writeStartElement("a:rot");
        writer.writeAttributeString("lat", "0");
        writer.writeAttributeString("lon", "0");
        writer.writeAttributeString("rev", "0");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:lightRig");
        writer.writeAttributeString("rig", "threePt");
        writer.writeAttributeString("dir", "t");
        writer.writeStartElement("a:rot");
        writer.writeAttributeString("lat", "0");
        writer.writeAttributeString("lon", "0");
        writer.writeAttributeString("rev", "1200000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:sp3d");
        writer.writeStartElement("a:bevelT");
        writer.writeAttributeString("w", "63500");
        writer.writeAttributeString("h", "25400");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:bgFillStyleLst");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:gradFill");
        writer.writeAttributeString("rotWithShape", "1");
        writer.writeStartElement("a:gsLst");
        writer.writeStartElement("a:gs");
        writer.writeAttributeString("pos", "0");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeStartElement("a:tint");
        writer.writeAttributeString("val", "40000");
        writer.writeEndElement();
        writer.writeStartElement("a:satMod");
        writer.writeAttributeString("val", "350000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:gs");
        writer.writeAttributeString("pos", "40000");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeStartElement("a:tint");
        writer.writeAttributeString("val", "45000");
        writer.writeEndElement();
        writer.writeStartElement("a:shade");
        writer.writeAttributeString("val", "99000");
        writer.writeEndElement();
        writer.writeStartElement("a:satMod");
        writer.writeAttributeString("val", "350000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:gs");
        writer.writeAttributeString("pos", "100000");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeStartElement("a:shade");
        writer.writeAttributeString("val", "20000");
        writer.writeEndElement();
        writer.writeStartElement("a:satMod");
        writer.writeAttributeString("val", "255000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:path");
        writer.writeAttributeString("path", "circle");
        writer.writeStartElement("a:fillToRect");
        writer.writeAttributeString("l", "50000");
        writer.writeAttributeString("t", "-80000");
        writer.writeAttributeString("r", "50000");
        writer.writeAttributeString("b", "180000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:gradFill");
        writer.writeAttributeString("rotWithShape", "1");
        writer.writeStartElement("a:gsLst");
        writer.writeStartElement("a:gs");
        writer.writeAttributeString("pos", "0");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeStartElement("a:tint");
        writer.writeAttributeString("val", "80000");
        writer.writeEndElement();
        writer.writeStartElement("a:satMod");
        writer.writeAttributeString("val", "300000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:gs");
        writer.writeAttributeString("pos", "100000");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "phClr");
        writer.writeStartElement("a:shade");
        writer.writeAttributeString("val", "30000");
        writer.writeEndElement();
        writer.writeStartElement("a:satMod");
        writer.writeAttributeString("val", "200000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:path");
        writer.writeAttributeString("path", "circle");
        writer.writeStartElement("a:fillToRect");
        writer.writeAttributeString("l", "50000");
        writer.writeAttributeString("t", "50000");
        writer.writeAttributeString("r", "50000");
        writer.writeAttributeString("b", "50000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:objectDefaults");
        writer.writeEndElement();
        writer.writeStartElement("a:extraClrSchemeLst");
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeSlideMasterRels() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("Relationships");
        writer.writeAttributeString("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        for (int index = 0; index < 11; ++index) {
            writer.writeStartElement("Relationship");
            writer.writeAttributeString("Id", String.format("rId%s", index + 1));
            writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideLayout");
            writer.writeAttributeString("Target", String.format("../slideLayouts/slideLayout%s.xml", index + 1));
            writer.writeEndElement();
        }
        writer.writeStartElement("Relationship");
        writer.writeAttributeString("Id", "rId12");
        writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme");
        writer.writeAttributeString("Target", "../theme/theme1.xml");
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeSlideMaster() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("p:sldMaster");
        writer.writeAttributeString("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        writer.writeAttributeString("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        writer.writeAttributeString("xmlns:p", "http://schemas.openxmlformats.org/presentationml/2006/main");
        writer.writeStartElement("p:cSld");
        writer.writeStartElement("p:bg");
        writer.writeStartElement("p:bgRef");
        writer.writeAttributeString("idx", "1001");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "bg1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:spTree");
        writer.writeStartElement("p:nvGrpSpPr");
        writer.writeStartElement("p:cNvPr");
        writer.writeAttributeString("id", "1");
        writer.writeAttributeString("name", "");
        writer.writeEndElement();
        writer.writeStartElement("p:cNvGrpSpPr");
        writer.writeEndElement();
        writer.writeStartElement("p:nvPr");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:grpSpPr");
        writer.writeStartElement("a:xfrm");
        writer.writeStartElement("a:off");
        writer.writeAttributeString("x", "0");
        writer.writeAttributeString("y", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:ext");
        writer.writeAttributeString("cx", "0");
        writer.writeAttributeString("cy", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:chOff");
        writer.writeAttributeString("x", "0");
        writer.writeAttributeString("y", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:chExt");
        writer.writeAttributeString("cx", "0");
        writer.writeAttributeString("cy", "0");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:sp");
        writer.writeStartElement("p:nvSpPr");
        writer.writeStartElement("p:cNvPr");
        writer.writeAttributeString("id", "2");
        writer.writeAttributeString("name", "Title Placeholder 1");
        writer.writeEndElement();
        writer.writeStartElement("p:cNvSpPr");
        writer.writeStartElement("a:spLocks");
        writer.writeAttributeString("noGrp", "1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:nvPr");
        writer.writeStartElement("p:ph");
        writer.writeAttributeString("type", "title");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:spPr");
        writer.writeStartElement("a:xfrm");
        writer.writeStartElement("a:off");
        writer.writeAttributeString("x", "457200");
        writer.writeAttributeString("y", "274638");
        writer.writeEndElement();
        writer.writeStartElement("a:ext");
        writer.writeAttributeString("cx", "8229600");
        writer.writeAttributeString("cy", "1143000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:prstGeom");
        writer.writeAttributeString("prst", "rect");
        writer.writeStartElement("a:avLst");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:txBody");
        writer.writeStartElement("a:bodyPr");
        writer.writeAttributeString("vert", "horz");
        writer.writeAttributeString("lIns", "91440");
        writer.writeAttributeString("tIns", "45720");
        writer.writeAttributeString("rIns", "91440");
        writer.writeAttributeString("bIns", "45720");
        writer.writeAttributeString("rtlCol", "0");
        writer.writeAttributeString("anchor", "ctr");
        writer.writeStartElement("a:normAutofit");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lstStyle");
        writer.writeEndElement();
        writer.writeStartElement("a:p");
        writer.writeStartElement("a:r");
        writer.writeStartElement("a:rPr");
        writer.writeAttributeString("lang", "en-US");
        writer.writeAttributeString("smtClean", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:t");
        writer.writeString("Click to edit Master title style");
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:endParaRPr");
        writer.writeAttributeString("lang", "ru-RU");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:sp");
        writer.writeStartElement("p:nvSpPr");
        writer.writeStartElement("p:cNvPr");
        writer.writeAttributeString("id", "3");
        writer.writeAttributeString("name", "Text Placeholder 2");
        writer.writeEndElement();
        writer.writeStartElement("p:cNvSpPr");
        writer.writeStartElement("a:spLocks");
        writer.writeAttributeString("noGrp", "1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:nvPr");
        writer.writeStartElement("p:ph");
        writer.writeAttributeString("type", "body");
        writer.writeAttributeString("idx", "1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:spPr");
        writer.writeStartElement("a:xfrm");
        writer.writeStartElement("a:off");
        writer.writeAttributeString("x", "457200");
        writer.writeAttributeString("y", "1600200");
        writer.writeEndElement();
        writer.writeStartElement("a:ext");
        writer.writeAttributeString("cx", "8229600");
        writer.writeAttributeString("cy", "4525963");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:prstGeom");
        writer.writeAttributeString("prst", "rect");
        writer.writeStartElement("a:avLst");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:txBody");
        writer.writeStartElement("a:bodyPr");
        writer.writeAttributeString("vert", "horz");
        writer.writeAttributeString("lIns", "91440");
        writer.writeAttributeString("tIns", "45720");
        writer.writeAttributeString("rIns", "91440");
        writer.writeAttributeString("bIns", "45720");
        writer.writeAttributeString("rtlCol", "0");
        writer.writeStartElement("a:normAutofit");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lstStyle");
        writer.writeEndElement();
        writer.writeStartElement("a:p");
        writer.writeStartElement("a:pPr");
        writer.writeAttributeString("lvl", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:r");
        writer.writeStartElement("a:rPr");
        writer.writeAttributeString("lang", "en-US");
        writer.writeAttributeString("smtClean", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:t");
        writer.writeString("Click to edit Master text styles");
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:p");
        writer.writeStartElement("a:pPr");
        writer.writeAttributeString("lvl", "1");
        writer.writeEndElement();
        writer.writeStartElement("a:r");
        writer.writeStartElement("a:rPr");
        writer.writeAttributeString("lang", "en-US");
        writer.writeAttributeString("smtClean", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:t");
        writer.writeString("Second level");
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:p");
        writer.writeStartElement("a:pPr");
        writer.writeAttributeString("lvl", "2");
        writer.writeEndElement();
        writer.writeStartElement("a:r");
        writer.writeStartElement("a:rPr");
        writer.writeAttributeString("lang", "en-US");
        writer.writeAttributeString("smtClean", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:t");
        writer.writeString("Third level");
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:p");
        writer.writeStartElement("a:pPr");
        writer.writeAttributeString("lvl", "3");
        writer.writeEndElement();
        writer.writeStartElement("a:r");
        writer.writeStartElement("a:rPr");
        writer.writeAttributeString("lang", "en-US");
        writer.writeAttributeString("smtClean", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:t");
        writer.writeString("Fourth level");
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:p");
        writer.writeStartElement("a:pPr");
        writer.writeAttributeString("lvl", "4");
        writer.writeEndElement();
        writer.writeStartElement("a:r");
        writer.writeStartElement("a:rPr");
        writer.writeAttributeString("lang", "en-US");
        writer.writeAttributeString("smtClean", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:t");
        writer.writeString("Fifth level");
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:endParaRPr");
        writer.writeAttributeString("lang", "ru-RU");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:sp");
        writer.writeStartElement("p:nvSpPr");
        writer.writeStartElement("p:cNvPr");
        writer.writeAttributeString("id", "4");
        writer.writeAttributeString("name", "Date Placeholder 3");
        writer.writeEndElement();
        writer.writeStartElement("p:cNvSpPr");
        writer.writeStartElement("a:spLocks");
        writer.writeAttributeString("noGrp", "1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:nvPr");
        writer.writeStartElement("p:ph");
        writer.writeAttributeString("type", "dt");
        writer.writeAttributeString("sz", "half");
        writer.writeAttributeString("idx", "2");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:spPr");
        writer.writeStartElement("a:xfrm");
        writer.writeStartElement("a:off");
        writer.writeAttributeString("x", "457200");
        writer.writeAttributeString("y", "6356350");
        writer.writeEndElement();
        writer.writeStartElement("a:ext");
        writer.writeAttributeString("cx", "2133600");
        writer.writeAttributeString("cy", "365125");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:prstGeom");
        writer.writeAttributeString("prst", "rect");
        writer.writeStartElement("a:avLst");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:txBody");
        writer.writeStartElement("a:bodyPr");
        writer.writeAttributeString("vert", "horz");
        writer.writeAttributeString("lIns", "91440");
        writer.writeAttributeString("tIns", "45720");
        writer.writeAttributeString("rIns", "91440");
        writer.writeAttributeString("bIns", "45720");
        writer.writeAttributeString("rtlCol", "0");
        writer.writeAttributeString("anchor", "ctr");
        writer.writeEndElement();
        writer.writeStartElement("a:lstStyle");
        writer.writeStartElement("a:lvl1pPr");
        writer.writeAttributeString("algn", "l");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeStartElement("a:tint");
        writer.writeAttributeString("val", "75000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:p");
        writer.writeStartElement("a:fld");
        writer.writeAttributeString("id", "{BBCD0B08-7874-4091-A11F-B0CCB138CA98}");
        writer.writeAttributeString("type", "datetimeFigureOut");
        writer.writeStartElement("a:rPr");
        writer.writeAttributeString("lang", "ru-RU");
        writer.writeAttributeString("smtClean", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:t");
        writer.writeString("15.04.2009");
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:endParaRPr");
        writer.writeAttributeString("lang", "ru-RU");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:sp");
        writer.writeStartElement("p:nvSpPr");
        writer.writeStartElement("p:cNvPr");
        writer.writeAttributeString("id", "5");
        writer.writeAttributeString("name", "Footer Placeholder 4");
        writer.writeEndElement();
        writer.writeStartElement("p:cNvSpPr");
        writer.writeStartElement("a:spLocks");
        writer.writeAttributeString("noGrp", "1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:nvPr");
        writer.writeStartElement("p:ph");
        writer.writeAttributeString("type", "ftr");
        writer.writeAttributeString("sz", "quarter");
        writer.writeAttributeString("idx", "3");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:spPr");
        writer.writeStartElement("a:xfrm");
        writer.writeStartElement("a:off");
        writer.writeAttributeString("x", "3124200");
        writer.writeAttributeString("y", "6356350");
        writer.writeEndElement();
        writer.writeStartElement("a:ext");
        writer.writeAttributeString("cx", "2895600");
        writer.writeAttributeString("cy", "365125");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:prstGeom");
        writer.writeAttributeString("prst", "rect");
        writer.writeStartElement("a:avLst");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:txBody");
        writer.writeStartElement("a:bodyPr");
        writer.writeAttributeString("vert", "horz");
        writer.writeAttributeString("lIns", "91440");
        writer.writeAttributeString("tIns", "45720");
        writer.writeAttributeString("rIns", "91440");
        writer.writeAttributeString("bIns", "45720");
        writer.writeAttributeString("rtlCol", "0");
        writer.writeAttributeString("anchor", "ctr");
        writer.writeEndElement();
        writer.writeStartElement("a:lstStyle");
        writer.writeStartElement("a:lvl1pPr");
        writer.writeAttributeString("algn", "ctr");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeStartElement("a:tint");
        writer.writeAttributeString("val", "75000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:p");
        writer.writeStartElement("a:endParaRPr");
        writer.writeAttributeString("lang", "ru-RU");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:sp");
        writer.writeStartElement("p:nvSpPr");
        writer.writeStartElement("p:cNvPr");
        writer.writeAttributeString("id", "6");
        writer.writeAttributeString("name", "Slide Number Placeholder 5");
        writer.writeEndElement();
        writer.writeStartElement("p:cNvSpPr");
        writer.writeStartElement("a:spLocks");
        writer.writeAttributeString("noGrp", "1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:nvPr");
        writer.writeStartElement("p:ph");
        writer.writeAttributeString("type", "sldNum");
        writer.writeAttributeString("sz", "quarter");
        writer.writeAttributeString("idx", "4");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:spPr");
        writer.writeStartElement("a:xfrm");
        writer.writeStartElement("a:off");
        writer.writeAttributeString("x", "6553200");
        writer.writeAttributeString("y", "6356350");
        writer.writeEndElement();
        writer.writeStartElement("a:ext");
        writer.writeAttributeString("cx", "2133600");
        writer.writeAttributeString("cy", "365125");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:prstGeom");
        writer.writeAttributeString("prst", "rect");
        writer.writeStartElement("a:avLst");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:txBody");
        writer.writeStartElement("a:bodyPr");
        writer.writeAttributeString("vert", "horz");
        writer.writeAttributeString("lIns", "91440");
        writer.writeAttributeString("tIns", "45720");
        writer.writeAttributeString("rIns", "91440");
        writer.writeAttributeString("bIns", "45720");
        writer.writeAttributeString("rtlCol", "0");
        writer.writeAttributeString("anchor", "ctr");
        writer.writeEndElement();
        writer.writeStartElement("a:lstStyle");
        writer.writeStartElement("a:lvl1pPr");
        writer.writeAttributeString("algn", "r");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeStartElement("a:tint");
        writer.writeAttributeString("val", "75000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:p");
        writer.writeStartElement("a:fld");
        writer.writeAttributeString("id", "{F548980B-80A5-4AC9-8F15-D7D0FD0AEED9}");
        writer.writeAttributeString("type", "slidenum");
        writer.writeStartElement("a:rPr");
        writer.writeAttributeString("lang", "ru-RU");
        writer.writeAttributeString("smtClean", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:t");
        writer.writeString("\u2039#\u203a");
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:endParaRPr");
        writer.writeAttributeString("lang", "ru-RU");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:clrMap");
        writer.writeAttributeString("bg1", "lt1");
        writer.writeAttributeString("tx1", "dk1");
        writer.writeAttributeString("bg2", "lt2");
        writer.writeAttributeString("tx2", "dk2");
        writer.writeAttributeString("accent1", "accent1");
        writer.writeAttributeString("accent2", "accent2");
        writer.writeAttributeString("accent3", "accent3");
        writer.writeAttributeString("accent4", "accent4");
        writer.writeAttributeString("accent5", "accent5");
        writer.writeAttributeString("accent6", "accent6");
        writer.writeAttributeString("hlink", "hlink");
        writer.writeAttributeString("folHlink", "folHlink");
        writer.writeEndElement();
        writer.writeStartElement("p:sldLayoutIdLst");
        writer.writeStartElement("p:sldLayoutId");
        writer.writeAttributeString("id", "2147483649");
        writer.writeAttributeString("r:id", "rId1");
        writer.writeEndElement();
        writer.writeStartElement("p:sldLayoutId");
        writer.writeAttributeString("id", "2147483650");
        writer.writeAttributeString("r:id", "rId2");
        writer.writeEndElement();
        writer.writeStartElement("p:sldLayoutId");
        writer.writeAttributeString("id", "2147483651");
        writer.writeAttributeString("r:id", "rId3");
        writer.writeEndElement();
        writer.writeStartElement("p:sldLayoutId");
        writer.writeAttributeString("id", "2147483652");
        writer.writeAttributeString("r:id", "rId4");
        writer.writeEndElement();
        writer.writeStartElement("p:sldLayoutId");
        writer.writeAttributeString("id", "2147483653");
        writer.writeAttributeString("r:id", "rId5");
        writer.writeEndElement();
        writer.writeStartElement("p:sldLayoutId");
        writer.writeAttributeString("id", "2147483654");
        writer.writeAttributeString("r:id", "rId6");
        writer.writeEndElement();
        writer.writeStartElement("p:sldLayoutId");
        writer.writeAttributeString("id", "2147483655");
        writer.writeAttributeString("r:id", "rId7");
        writer.writeEndElement();
        writer.writeStartElement("p:sldLayoutId");
        writer.writeAttributeString("id", "2147483656");
        writer.writeAttributeString("r:id", "rId8");
        writer.writeEndElement();
        writer.writeStartElement("p:sldLayoutId");
        writer.writeAttributeString("id", "2147483657");
        writer.writeAttributeString("r:id", "rId9");
        writer.writeEndElement();
        writer.writeStartElement("p:sldLayoutId");
        writer.writeAttributeString("id", "2147483658");
        writer.writeAttributeString("r:id", "rId10");
        writer.writeEndElement();
        writer.writeStartElement("p:sldLayoutId");
        writer.writeAttributeString("id", "2147483659");
        writer.writeAttributeString("r:id", "rId11");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:txStyles");
        writer.writeStartElement("p:titleStyle");
        writer.writeStartElement("a:lvl1pPr");
        writer.writeAttributeString("algn", "ctr");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:spcBef");
        writer.writeStartElement("a:spcPct");
        writer.writeAttributeString("val", "0");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:buNone");
        writer.writeEndElement();
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "4400");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mj-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mj-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mj-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:bodyStyle");
        writer.writeStartElement("a:lvl1pPr");
        writer.writeAttributeString("marL", "342900");
        writer.writeAttributeString("indent", "-342900");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:spcBef");
        writer.writeStartElement("a:spcPct");
        writer.writeAttributeString("val", "20000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:buFont");
        writer.writeAttributeString("typeface", "Arial");
        writer.writeAttributeString("pitchFamily", "34");
        writer.writeAttributeString("charset", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:buChar");
        writer.writeAttributeString("char", "\u2022");
        writer.writeEndElement();
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "3200");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl2pPr");
        writer.writeAttributeString("marL", "742950");
        writer.writeAttributeString("indent", "-285750");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:spcBef");
        writer.writeStartElement("a:spcPct");
        writer.writeAttributeString("val", "20000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:buFont");
        writer.writeAttributeString("typeface", "Arial");
        writer.writeAttributeString("pitchFamily", "34");
        writer.writeAttributeString("charset", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:buChar");
        writer.writeAttributeString("char", "\u2013");
        writer.writeEndElement();
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "2800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl3pPr");
        writer.writeAttributeString("marL", "1143000");
        writer.writeAttributeString("indent", "-228600");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:spcBef");
        writer.writeStartElement("a:spcPct");
        writer.writeAttributeString("val", "20000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:buFont");
        writer.writeAttributeString("typeface", "Arial");
        writer.writeAttributeString("pitchFamily", "34");
        writer.writeAttributeString("charset", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:buChar");
        writer.writeAttributeString("char", "\u2022");
        writer.writeEndElement();
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "2400");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl4pPr");
        writer.writeAttributeString("marL", "1600200");
        writer.writeAttributeString("indent", "-228600");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:spcBef");
        writer.writeStartElement("a:spcPct");
        writer.writeAttributeString("val", "20000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:buFont");
        writer.writeAttributeString("typeface", "Arial");
        writer.writeAttributeString("pitchFamily", "34");
        writer.writeAttributeString("charset", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:buChar");
        writer.writeAttributeString("char", "\u2013");
        writer.writeEndElement();
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "2000");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl5pPr");
        writer.writeAttributeString("marL", "2057400");
        writer.writeAttributeString("indent", "-228600");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:spcBef");
        writer.writeStartElement("a:spcPct");
        writer.writeAttributeString("val", "20000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:buFont");
        writer.writeAttributeString("typeface", "Arial");
        writer.writeAttributeString("pitchFamily", "34");
        writer.writeAttributeString("charset", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:buChar");
        writer.writeAttributeString("char", "\u00bb");
        writer.writeEndElement();
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "2000");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl6pPr");
        writer.writeAttributeString("marL", "2514600");
        writer.writeAttributeString("indent", "-228600");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:spcBef");
        writer.writeStartElement("a:spcPct");
        writer.writeAttributeString("val", "20000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:buFont");
        writer.writeAttributeString("typeface", "Arial");
        writer.writeAttributeString("pitchFamily", "34");
        writer.writeAttributeString("charset", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:buChar");
        writer.writeAttributeString("char", "\u2022");
        writer.writeEndElement();
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "2000");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl7pPr");
        writer.writeAttributeString("marL", "2971800");
        writer.writeAttributeString("indent", "-228600");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:spcBef");
        writer.writeStartElement("a:spcPct");
        writer.writeAttributeString("val", "20000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:buFont");
        writer.writeAttributeString("typeface", "Arial");
        writer.writeAttributeString("pitchFamily", "34");
        writer.writeAttributeString("charset", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:buChar");
        writer.writeAttributeString("char", "\u2022");
        writer.writeEndElement();
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "2000");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl8pPr");
        writer.writeAttributeString("marL", "3429000");
        writer.writeAttributeString("indent", "-228600");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:spcBef");
        writer.writeStartElement("a:spcPct");
        writer.writeAttributeString("val", "20000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:buFont");
        writer.writeAttributeString("typeface", "Arial");
        writer.writeAttributeString("pitchFamily", "34");
        writer.writeAttributeString("charset", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:buChar");
        writer.writeAttributeString("char", "\u2022");
        writer.writeEndElement();
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "2000");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl9pPr");
        writer.writeAttributeString("marL", "3886200");
        writer.writeAttributeString("indent", "-228600");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:spcBef");
        writer.writeStartElement("a:spcPct");
        writer.writeAttributeString("val", "20000");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:buFont");
        writer.writeAttributeString("typeface", "Arial");
        writer.writeAttributeString("pitchFamily", "34");
        writer.writeAttributeString("charset", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:buChar");
        writer.writeAttributeString("char", "\u2022");
        writer.writeEndElement();
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "2000");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:otherStyle");
        writer.writeStartElement("a:defPPr");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("lang", "ru-RU");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl1pPr");
        writer.writeAttributeString("marL", "0");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl2pPr");
        writer.writeAttributeString("marL", "457200");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl3pPr");
        writer.writeAttributeString("marL", "914400");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl4pPr");
        writer.writeAttributeString("marL", "1371600");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl5pPr");
        writer.writeAttributeString("marL", "1828800");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl6pPr");
        writer.writeAttributeString("marL", "2286000");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl7pPr");
        writer.writeAttributeString("marL", "2743200");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl8pPr");
        writer.writeAttributeString("marL", "3200400");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl9pPr");
        writer.writeAttributeString("marL", "3657600");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeSlideLayoutRels() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("Relationships");
        writer.writeAttributeString("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        writer.writeStartElement("Relationship");
        writer.writeAttributeString("Id", "rId1");
        writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideMaster");
        writer.writeAttributeString("Target", "../slideMasters/slideMaster1.xml");
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    /*
     * Opcode count of 14725 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private Document writeSlideLayout(int index, StiPage page) throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("p:sldLayout");
        writer.writeAttributeString("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        writer.writeAttributeString("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        writer.writeAttributeString("xmlns:p", "http://schemas.openxmlformats.org/presentationml/2006/main");
        if (index == 1) {
            writer.writeAttributeString("type", "title");
            writer.writeAttributeString("preserve", "1");
            writer.writeStartElement("p:cSld");
            writer.writeAttributeString("name", "Title Slide");
            writer.writeStartElement("p:spTree");
            writer.writeStartElement("p:nvGrpSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "1");
            writer.writeAttributeString("name", "");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvGrpSpPr");
            writer.writeEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:grpSpPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chOff");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chExt");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "2");
            writer.writeAttributeString("name", "Title 1");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "ctrTitle");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "685800");
            writer.writeAttributeString("y", "2130425");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "7772400");
            writer.writeAttributeString("cy", "1470025");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master title style");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "3");
            writer.writeAttributeString("name", "Subtitle 2");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "subTitle");
            writer.writeAttributeString("idx", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "1371600");
            writer.writeAttributeString("y", "3886200");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "6400800");
            writer.writeAttributeString("cy", "1752600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeAttributeString("marL", "0");
            writer.writeAttributeString("indent", "0");
            writer.writeAttributeString("algn", "ctr");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl2pPr");
            writer.writeAttributeString("marL", "457200");
            writer.writeAttributeString("indent", "0");
            writer.writeAttributeString("algn", "ctr");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl3pPr");
            writer.writeAttributeString("marL", "914400");
            writer.writeAttributeString("indent", "0");
            writer.writeAttributeString("algn", "ctr");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl4pPr");
            writer.writeAttributeString("marL", "1371600");
            writer.writeAttributeString("indent", "0");
            writer.writeAttributeString("algn", "ctr");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl5pPr");
            writer.writeAttributeString("marL", "1828800");
            writer.writeAttributeString("indent", "0");
            writer.writeAttributeString("algn", "ctr");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl6pPr");
            writer.writeAttributeString("marL", "2286000");
            writer.writeAttributeString("indent", "0");
            writer.writeAttributeString("algn", "ctr");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl7pPr");
            writer.writeAttributeString("marL", "2743200");
            writer.writeAttributeString("indent", "0");
            writer.writeAttributeString("algn", "ctr");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl8pPr");
            writer.writeAttributeString("marL", "3200400");
            writer.writeAttributeString("indent", "0");
            writer.writeAttributeString("algn", "ctr");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl9pPr");
            writer.writeAttributeString("marL", "3657600");
            writer.writeAttributeString("indent", "0");
            writer.writeAttributeString("algn", "ctr");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master subtitle style");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "4");
            writer.writeAttributeString("name", "Date Placeholder 3");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "dt");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "10");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{BBCD0B08-7874-4091-A11F-B0CCB138CA98}");
            writer.writeAttributeString("type", "datetimeFigureOut");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("15.04.2009");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "5");
            writer.writeAttributeString("name", "Footer Placeholder 4");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "ftr");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "11");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "6");
            writer.writeAttributeString("name", "Slide Number Placeholder 5");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "sldNum");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "12");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{F548980B-80A5-4AC9-8F15-D7D0FD0AEED9}");
            writer.writeAttributeString("type", "slidenum");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("\u2039#\u203a");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
        }
        if (index == 2) {
            writer.writeAttributeString("type", "obj");
            writer.writeAttributeString("preserve", "1");
            writer.writeStartElement("p:cSld");
            writer.writeAttributeString("name", "Title and Content");
            writer.writeStartElement("p:spTree");
            writer.writeStartElement("p:nvGrpSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "1");
            writer.writeAttributeString("name", "");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvGrpSpPr");
            writer.writeEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:grpSpPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chOff");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chExt");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "2");
            writer.writeAttributeString("name", "Title 1");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "title");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master title style");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "3");
            writer.writeAttributeString("name", "Content Placeholder 2");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("idx", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "1");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Second level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "2");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Third level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "3");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fourth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "4");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fifth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "4");
            writer.writeAttributeString("name", "Date Placeholder 3");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "dt");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "10");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{BBCD0B08-7874-4091-A11F-B0CCB138CA98}");
            writer.writeAttributeString("type", "datetimeFigureOut");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("15.04.2009");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "5");
            writer.writeAttributeString("name", "Footer Placeholder 4");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "ftr");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "11");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "6");
            writer.writeAttributeString("name", "Slide Number Placeholder 5");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "sldNum");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "12");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{F548980B-80A5-4AC9-8F15-D7D0FD0AEED9}");
            writer.writeAttributeString("type", "slidenum");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("\u2039#\u203a");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
        }
        if (index == 3) {
            writer.writeAttributeString("type", "secHead");
            writer.writeAttributeString("preserve", "1");
            writer.writeStartElement("p:cSld");
            writer.writeAttributeString("name", "Section Header");
            writer.writeStartElement("p:spTree");
            writer.writeStartElement("p:nvGrpSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "1");
            writer.writeAttributeString("name", "");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvGrpSpPr");
            writer.writeEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:grpSpPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chOff");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chExt");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "2");
            writer.writeAttributeString("name", "Title 1");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "title");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "722313");
            writer.writeAttributeString("y", "4406900");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "7772400");
            writer.writeAttributeString("cy", "1362075");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeAttributeString("anchor", "t");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeAttributeString("algn", "l");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "4000");
            writer.writeAttributeString("b", "1");
            writer.writeAttributeString("cap", "all");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master title style");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "3");
            writer.writeAttributeString("name", "Text Placeholder 2");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "body");
            writer.writeAttributeString("idx", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "722313");
            writer.writeAttributeString("y", "2906713");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "7772400");
            writer.writeAttributeString("cy", "1500187");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeAttributeString("anchor", "b");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeAttributeString("marL", "0");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl2pPr");
            writer.writeAttributeString("marL", "457200");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl3pPr");
            writer.writeAttributeString("marL", "914400");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl4pPr");
            writer.writeAttributeString("marL", "1371600");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1400");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl5pPr");
            writer.writeAttributeString("marL", "1828800");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1400");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl6pPr");
            writer.writeAttributeString("marL", "2286000");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1400");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl7pPr");
            writer.writeAttributeString("marL", "2743200");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1400");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl8pPr");
            writer.writeAttributeString("marL", "3200400");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1400");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl9pPr");
            writer.writeAttributeString("marL", "3657600");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1400");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:tint");
            writer.writeAttributeString("val", "75000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "4");
            writer.writeAttributeString("name", "Date Placeholder 3");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "dt");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "10");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{BBCD0B08-7874-4091-A11F-B0CCB138CA98}");
            writer.writeAttributeString("type", "datetimeFigureOut");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("15.04.2009");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "5");
            writer.writeAttributeString("name", "Footer Placeholder 4");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "ftr");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "11");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "6");
            writer.writeAttributeString("name", "Slide Number Placeholder 5");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "sldNum");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "12");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{F548980B-80A5-4AC9-8F15-D7D0FD0AEED9}");
            writer.writeAttributeString("type", "slidenum");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("\u2039#\u203a");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
        }
        if (index == 4) {
            writer.writeAttributeString("type", "twoObj");
            writer.writeAttributeString("preserve", "1");
            writer.writeStartElement("p:cSld");
            writer.writeAttributeString("name", "Two Content");
            writer.writeStartElement("p:spTree");
            writer.writeStartElement("p:nvGrpSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "1");
            writer.writeAttributeString("name", "");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvGrpSpPr");
            writer.writeEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:grpSpPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chOff");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chExt");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "2");
            writer.writeAttributeString("name", "Title 1");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "title");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master title style");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "3");
            writer.writeAttributeString("name", "Content Placeholder 2");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "457200");
            writer.writeAttributeString("y", "1600200");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "4038600");
            writer.writeAttributeString("cy", "4525963");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl2pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2400");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl3pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl4pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl5pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl6pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl7pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl8pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl9pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "1");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Second level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "2");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Third level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "3");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fourth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "4");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fifth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "4");
            writer.writeAttributeString("name", "Content Placeholder 3");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "2");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "4648200");
            writer.writeAttributeString("y", "1600200");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "4038600");
            writer.writeAttributeString("cy", "4525963");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl2pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2400");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl3pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl4pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl5pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl6pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl7pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl8pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl9pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "1");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Second level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "2");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Third level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "3");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fourth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "4");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fifth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "5");
            writer.writeAttributeString("name", "Date Placeholder 4");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "dt");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "10");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{BBCD0B08-7874-4091-A11F-B0CCB138CA98}");
            writer.writeAttributeString("type", "datetimeFigureOut");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("15.04.2009");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "6");
            writer.writeAttributeString("name", "Footer Placeholder 5");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "ftr");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "11");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "7");
            writer.writeAttributeString("name", "Slide Number Placeholder 6");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "sldNum");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "12");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{F548980B-80A5-4AC9-8F15-D7D0FD0AEED9}");
            writer.writeAttributeString("type", "slidenum");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("\u2039#\u203a");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
        }
        if (index == 5) {
            writer.writeAttributeString("type", "twoTxTwoObj");
            writer.writeAttributeString("preserve", "1");
            writer.writeStartElement("p:cSld");
            writer.writeAttributeString("name", "Comparison");
            writer.writeStartElement("p:spTree");
            writer.writeStartElement("p:nvGrpSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "1");
            writer.writeAttributeString("name", "");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvGrpSpPr");
            writer.writeEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:grpSpPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chOff");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chExt");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "2");
            writer.writeAttributeString("name", "Title 1");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "title");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master title style");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "3");
            writer.writeAttributeString("name", "Text Placeholder 2");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "body");
            writer.writeAttributeString("idx", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "457200");
            writer.writeAttributeString("y", "1535113");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "4040188");
            writer.writeAttributeString("cy", "639762");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeAttributeString("anchor", "b");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeAttributeString("marL", "0");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2400");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl2pPr");
            writer.writeAttributeString("marL", "457200");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl3pPr");
            writer.writeAttributeString("marL", "914400");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl4pPr");
            writer.writeAttributeString("marL", "1371600");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl5pPr");
            writer.writeAttributeString("marL", "1828800");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl6pPr");
            writer.writeAttributeString("marL", "2286000");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl7pPr");
            writer.writeAttributeString("marL", "2743200");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl8pPr");
            writer.writeAttributeString("marL", "3200400");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl9pPr");
            writer.writeAttributeString("marL", "3657600");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "4");
            writer.writeAttributeString("name", "Content Placeholder 3");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "2");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "457200");
            writer.writeAttributeString("y", "2174875");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "4040188");
            writer.writeAttributeString("cy", "3951288");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2400");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl2pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl3pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl4pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl5pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl6pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl7pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl8pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl9pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "1");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Second level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "2");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Third level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "3");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fourth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "4");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fifth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "5");
            writer.writeAttributeString("name", "Text Placeholder 4");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "body");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "3");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "4645025");
            writer.writeAttributeString("y", "1535113");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "4041775");
            writer.writeAttributeString("cy", "639762");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeAttributeString("anchor", "b");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeAttributeString("marL", "0");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2400");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl2pPr");
            writer.writeAttributeString("marL", "457200");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl3pPr");
            writer.writeAttributeString("marL", "914400");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl4pPr");
            writer.writeAttributeString("marL", "1371600");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl5pPr");
            writer.writeAttributeString("marL", "1828800");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl6pPr");
            writer.writeAttributeString("marL", "2286000");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl7pPr");
            writer.writeAttributeString("marL", "2743200");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl8pPr");
            writer.writeAttributeString("marL", "3200400");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl9pPr");
            writer.writeAttributeString("marL", "3657600");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "6");
            writer.writeAttributeString("name", "Content Placeholder 5");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "4");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "4645025");
            writer.writeAttributeString("y", "2174875");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "4041775");
            writer.writeAttributeString("cy", "3951288");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2400");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl2pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl3pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl4pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl5pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl6pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl7pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl8pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl9pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1600");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "1");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Second level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "2");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Third level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "3");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fourth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "4");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fifth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "7");
            writer.writeAttributeString("name", "Date Placeholder 6");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "dt");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "10");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{BBCD0B08-7874-4091-A11F-B0CCB138CA98}");
            writer.writeAttributeString("type", "datetimeFigureOut");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("15.04.2009");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "8");
            writer.writeAttributeString("name", "Footer Placeholder 7");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "ftr");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "11");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "9");
            writer.writeAttributeString("name", "Slide Number Placeholder 8");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "sldNum");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "12");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{F548980B-80A5-4AC9-8F15-D7D0FD0AEED9}");
            writer.writeAttributeString("type", "slidenum");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("\u2039#\u203a");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
        }
        if (index == 6) {
            writer.writeAttributeString("type", "titleOnly");
            writer.writeAttributeString("preserve", "1");
            writer.writeStartElement("p:cSld");
            writer.writeAttributeString("name", "Title Only");
            writer.writeStartElement("p:spTree");
            writer.writeStartElement("p:nvGrpSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "1");
            writer.writeAttributeString("name", "");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvGrpSpPr");
            writer.writeEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:grpSpPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chOff");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chExt");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "2");
            writer.writeAttributeString("name", "Title 1");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "title");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master title style");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "3");
            writer.writeAttributeString("name", "Date Placeholder 2");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "dt");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "10");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{BBCD0B08-7874-4091-A11F-B0CCB138CA98}");
            writer.writeAttributeString("type", "datetimeFigureOut");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("15.04.2009");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "4");
            writer.writeAttributeString("name", "Footer Placeholder 3");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "ftr");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "11");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "5");
            writer.writeAttributeString("name", "Slide Number Placeholder 4");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "sldNum");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "12");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{F548980B-80A5-4AC9-8F15-D7D0FD0AEED9}");
            writer.writeAttributeString("type", "slidenum");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("\u2039#\u203a");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
        }
        if (index == 7) {
            boolean isTrial;
            writer.writeAttributeString("type", "blank");
            writer.writeAttributeString("preserve", "1");
            writer.writeStartElement("p:cSld");
            writer.writeAttributeString("name", "Blank");
            writer.writeStartElement("p:spTree");
            writer.writeStartElement("p:nvGrpSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "1");
            writer.writeAttributeString("name", "");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvGrpSpPr");
            writer.writeEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:grpSpPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chOff");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chExt");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "2");
            writer.writeAttributeString("name", "Date Placeholder 1");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "dt");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "10");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{BBCD0B08-7874-4091-A11F-B0CCB138CA98}");
            writer.writeAttributeString("type", "datetimeFigureOut");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("15.04.2009");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "3");
            writer.writeAttributeString("name", "Footer Placeholder 2");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "ftr");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "11");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "4");
            writer.writeAttributeString("name", "Slide Number Placeholder 3");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "sldNum");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "12");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{F548980B-80A5-4AC9-8F15-D7D0FD0AEED9}");
            writer.writeAttributeString("type", "slidenum");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("\u2039#\u203a");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            boolean bl = isTrial = !StiLicenseKeyValidator.isValidOnJavaFramework(null);
            if (isTrial) {
                double pageWidth = page.getUnit().ConvertToHInches(page.getPageWidth() - page.getMargins().getLeft() - page.getMargins().getRight());
                double pageHeight = page.getUnit().ConvertToHInches(page.getPageHeight() - page.getMargins().getTop() - page.getMargins().getBottom());
                double mgLeft = page.getUnit().ConvertToHInches(page.getMargins().getLeft());
                double mgTop = page.getUnit().ConvertToHInches(page.getMargins().getTop());
                writer.writeStartElement("p:sp");
                writer.writeStartElement("p:nvSpPr");
                writer.writeStartElement("p:cNvPr");
                writer.writeAttributeString("id", "67");
                writer.writeAttributeString("name", "TextBox Additional");
                writer.writeEndElement();
                writer.writeStartElement("p:cNvSpPr");
                writer.writeAttributeString("txBox", "1");
                writer.writeEndElement();
                writer.writeStartElement("p:nvPr");
                writer.writeAttributeString("userDrawn", "1");
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeStartElement("p:spPr");
                writer.writeStartElement("a:xfrm");
                writer.writeAttributeString("rot", "-2700000");
                writer.writeStartElement("a:off");
                writer.writeAttributeString("x", this.convertToEmu(mgLeft).toString());
                writer.writeAttributeString("y", this.convertToEmu(mgTop + pageHeight * 0.45).toString());
                writer.writeEndElement();
                writer.writeStartElement("a:ext");
                writer.writeAttributeString("cx", this.convertToEmu(pageWidth).toString());
                writer.writeAttributeString("cy", this.convertToEmu(pageHeight * 0.1).toString());
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeStartElement("a:prstGeom");
                writer.writeAttributeString("prst", "rect");
                writer.writeStartElement("a:avLst");
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeStartElement("a:noFill");
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeStartElement("p:txBody");
                writer.writeStartElement("a:bodyPr");
                writer.writeAttributeString("wrap", "square");
                writer.writeAttributeString("rtlCol", "0");
                writer.writeAttributeString("anchor", "ctr");
                writer.writeAttributeString("anchorCtr", "0");
                writer.writeStartElement("a:spAutoFit");
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeStartElement("a:lstStyle");
                writer.writeEndElement();
                writer.writeStartElement("a:p");
                writer.writeStartElement("a:pPr");
                writer.writeAttributeString("algn", "ctr");
                writer.writeEndElement();
                writer.writeStartElement("a:r");
                writer.writeStartElement("a:rPr");
                writer.writeAttributeString("lang", "en-US");
                writer.writeAttributeString("sz", "9600");
                writer.writeAttributeString("b", "1");
                writer.writeAttributeString("dirty", "0");
                writer.writeAttributeString("smtClean", "0");
                writer.writeStartElement("a:solidFill");
                writer.writeStartElement("a:schemeClr");
                writer.writeAttributeString("val", "tx1");
                writer.writeStartElement("a:alpha");
                writer.writeAttributeString("val", "12000");
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeStartElement("a:latin");
                writer.writeAttributeString("typeface", "Arial");
                writer.writeAttributeString("panose", "020B0604020202020204");
                writer.writeAttributeString("pitchFamily", "34");
                writer.writeAttributeString("charset", "0");
                writer.writeEndElement();
                writer.writeStartElement("a:cs");
                writer.writeAttributeString("typeface", "Arial");
                writer.writeAttributeString("panose", "020B0604020202020204");
                writer.writeAttributeString("pitchFamily", "34");
                writer.writeAttributeString("charset", "0");
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeStartElement("a:t");
                writer.writeString("Trial");
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeFullEndElement();
            writer.writeFullEndElement();
        }
        if (index == 8) {
            writer.writeAttributeString("type", "objTx");
            writer.writeAttributeString("preserve", "1");
            writer.writeStartElement("p:cSld");
            writer.writeAttributeString("name", "Content with Caption");
            writer.writeStartElement("p:spTree");
            writer.writeStartElement("p:nvGrpSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "1");
            writer.writeAttributeString("name", "");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvGrpSpPr");
            writer.writeEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:grpSpPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chOff");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chExt");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "2");
            writer.writeAttributeString("name", "Title 1");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "title");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "457200");
            writer.writeAttributeString("y", "273050");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "3008313");
            writer.writeAttributeString("cy", "1162050");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeAttributeString("anchor", "b");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeAttributeString("algn", "l");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master title style");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "3");
            writer.writeAttributeString("name", "Content Placeholder 2");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("idx", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "3575050");
            writer.writeAttributeString("y", "273050");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "5111750");
            writer.writeAttributeString("cy", "5853113");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "3200");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl2pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl3pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2400");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl4pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl5pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl6pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl7pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl8pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl9pPr");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "1");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Second level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "2");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Third level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "3");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fourth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "4");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fifth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "4");
            writer.writeAttributeString("name", "Text Placeholder 3");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "body");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "2");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "457200");
            writer.writeAttributeString("y", "1435100");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "3008313");
            writer.writeAttributeString("cy", "4691063");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeAttributeString("marL", "0");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1400");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl2pPr");
            writer.writeAttributeString("marL", "457200");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1200");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl3pPr");
            writer.writeAttributeString("marL", "914400");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl4pPr");
            writer.writeAttributeString("marL", "1371600");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "900");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl5pPr");
            writer.writeAttributeString("marL", "1828800");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "900");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl6pPr");
            writer.writeAttributeString("marL", "2286000");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "900");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl7pPr");
            writer.writeAttributeString("marL", "2743200");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "900");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl8pPr");
            writer.writeAttributeString("marL", "3200400");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "900");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl9pPr");
            writer.writeAttributeString("marL", "3657600");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "900");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "5");
            writer.writeAttributeString("name", "Date Placeholder 4");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "dt");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "10");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{BBCD0B08-7874-4091-A11F-B0CCB138CA98}");
            writer.writeAttributeString("type", "datetimeFigureOut");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("15.04.2009");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "6");
            writer.writeAttributeString("name", "Footer Placeholder 5");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "ftr");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "11");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "7");
            writer.writeAttributeString("name", "Slide Number Placeholder 6");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "sldNum");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "12");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{F548980B-80A5-4AC9-8F15-D7D0FD0AEED9}");
            writer.writeAttributeString("type", "slidenum");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("\u2039#\u203a");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
        }
        if (index == 9) {
            writer.writeAttributeString("type", "picTx");
            writer.writeAttributeString("preserve", "1");
            writer.writeStartElement("p:cSld");
            writer.writeAttributeString("name", "Picture with Caption");
            writer.writeStartElement("p:spTree");
            writer.writeStartElement("p:nvGrpSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "1");
            writer.writeAttributeString("name", "");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvGrpSpPr");
            writer.writeEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:grpSpPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chOff");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chExt");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "2");
            writer.writeAttributeString("name", "Title 1");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "title");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "1792288");
            writer.writeAttributeString("y", "4800600");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "5486400");
            writer.writeAttributeString("cy", "566738");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeAttributeString("anchor", "b");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeAttributeString("algn", "l");
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeAttributeString("b", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master title style");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "3");
            writer.writeAttributeString("name", "Picture Placeholder 2");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "pic");
            writer.writeAttributeString("idx", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "1792288");
            writer.writeAttributeString("y", "612775");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "5486400");
            writer.writeAttributeString("cy", "4114800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeAttributeString("marL", "0");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "3200");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl2pPr");
            writer.writeAttributeString("marL", "457200");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2800");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl3pPr");
            writer.writeAttributeString("marL", "914400");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2400");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl4pPr");
            writer.writeAttributeString("marL", "1371600");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl5pPr");
            writer.writeAttributeString("marL", "1828800");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl6pPr");
            writer.writeAttributeString("marL", "2286000");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl7pPr");
            writer.writeAttributeString("marL", "2743200");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl8pPr");
            writer.writeAttributeString("marL", "3200400");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl9pPr");
            writer.writeAttributeString("marL", "3657600");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "2000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "4");
            writer.writeAttributeString("name", "Text Placeholder 3");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "body");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "2");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "1792288");
            writer.writeAttributeString("y", "5367338");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "5486400");
            writer.writeAttributeString("cy", "804862");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeStartElement("a:lvl1pPr");
            writer.writeAttributeString("marL", "0");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1400");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl2pPr");
            writer.writeAttributeString("marL", "457200");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1200");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl3pPr");
            writer.writeAttributeString("marL", "914400");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "1000");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl4pPr");
            writer.writeAttributeString("marL", "1371600");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "900");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl5pPr");
            writer.writeAttributeString("marL", "1828800");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "900");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl6pPr");
            writer.writeAttributeString("marL", "2286000");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "900");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl7pPr");
            writer.writeAttributeString("marL", "2743200");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "900");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl8pPr");
            writer.writeAttributeString("marL", "3200400");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "900");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:lvl9pPr");
            writer.writeAttributeString("marL", "3657600");
            writer.writeAttributeString("indent", "0");
            writer.writeStartElement("a:buNone");
            writer.writeEndElement();
            writer.writeStartElement("a:defRPr");
            writer.writeAttributeString("sz", "900");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "5");
            writer.writeAttributeString("name", "Date Placeholder 4");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "dt");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "10");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{BBCD0B08-7874-4091-A11F-B0CCB138CA98}");
            writer.writeAttributeString("type", "datetimeFigureOut");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("15.04.2009");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "6");
            writer.writeAttributeString("name", "Footer Placeholder 5");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "ftr");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "11");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "7");
            writer.writeAttributeString("name", "Slide Number Placeholder 6");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "sldNum");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "12");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{F548980B-80A5-4AC9-8F15-D7D0FD0AEED9}");
            writer.writeAttributeString("type", "slidenum");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("\u2039#\u203a");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
        }
        if (index == 10) {
            writer.writeAttributeString("type", "vertTx");
            writer.writeAttributeString("preserve", "1");
            writer.writeStartElement("p:cSld");
            writer.writeAttributeString("name", "Title and Vertical Text");
            writer.writeStartElement("p:spTree");
            writer.writeStartElement("p:nvGrpSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "1");
            writer.writeAttributeString("name", "");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvGrpSpPr");
            writer.writeEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:grpSpPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chOff");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chExt");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "2");
            writer.writeAttributeString("name", "Title 1");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "title");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master title style");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "3");
            writer.writeAttributeString("name", "Vertical Text Placeholder 2");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "body");
            writer.writeAttributeString("orient", "vert");
            writer.writeAttributeString("idx", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeAttributeString("vert", "eaVert");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "1");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Second level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "2");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Third level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "3");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fourth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "4");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fifth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "4");
            writer.writeAttributeString("name", "Date Placeholder 3");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "dt");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "10");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{BBCD0B08-7874-4091-A11F-B0CCB138CA98}");
            writer.writeAttributeString("type", "datetimeFigureOut");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("15.04.2009");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "5");
            writer.writeAttributeString("name", "Footer Placeholder 4");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "ftr");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "11");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "6");
            writer.writeAttributeString("name", "Slide Number Placeholder 5");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "sldNum");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "12");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{F548980B-80A5-4AC9-8F15-D7D0FD0AEED9}");
            writer.writeAttributeString("type", "slidenum");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("\u2039#\u203a");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
        }
        if (index == 11) {
            writer.writeAttributeString("type", "vertTitleAndTx");
            writer.writeAttributeString("preserve", "1");
            writer.writeStartElement("p:cSld");
            writer.writeAttributeString("name", "Vertical Title and Text");
            writer.writeStartElement("p:spTree");
            writer.writeStartElement("p:nvGrpSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "1");
            writer.writeAttributeString("name", "");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvGrpSpPr");
            writer.writeEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:grpSpPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chOff");
            writer.writeAttributeString("x", "0");
            writer.writeAttributeString("y", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:chExt");
            writer.writeAttributeString("cx", "0");
            writer.writeAttributeString("cy", "0");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "2");
            writer.writeAttributeString("name", "Vertical Title 1");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "title");
            writer.writeAttributeString("orient", "vert");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "6629400");
            writer.writeAttributeString("y", "274638");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "2057400");
            writer.writeAttributeString("cy", "5851525");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeAttributeString("vert", "eaVert");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master title style");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "3");
            writer.writeAttributeString("name", "Vertical Text Placeholder 2");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "body");
            writer.writeAttributeString("orient", "vert");
            writer.writeAttributeString("idx", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", "457200");
            writer.writeAttributeString("y", "274638");
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", "6019800");
            writer.writeAttributeString("cy", "5851525");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeAttributeString("vert", "eaVert");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Click to edit Master text styles");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "1");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Second level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "2");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Third level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "3");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fourth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("lvl", "4");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Fifth level");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "4");
            writer.writeAttributeString("name", "Date Placeholder 3");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "dt");
            writer.writeAttributeString("sz", "half");
            writer.writeAttributeString("idx", "10");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{BBCD0B08-7874-4091-A11F-B0CCB138CA98}");
            writer.writeAttributeString("type", "datetimeFigureOut");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("15.04.2009");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "5");
            writer.writeAttributeString("name", "Footer Placeholder 4");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "ftr");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "11");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "6");
            writer.writeAttributeString("name", "Slide Number Placeholder 5");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeStartElement("a:spLocks");
            writer.writeAttributeString("noGrp", "1");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeStartElement("p:ph");
            writer.writeAttributeString("type", "sldNum");
            writer.writeAttributeString("sz", "quarter");
            writer.writeAttributeString("idx", "12");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:fld");
            writer.writeAttributeString("id", "{F548980B-80A5-4AC9-8F15-D7D0FD0AEED9}");
            writer.writeAttributeString("type", "slidenum");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeAttributeString("smtClean", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("\u2039#\u203a");
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeStartElement("a:endParaRPr");
            writer.writeAttributeString("lang", "ru-RU");
            writer.writeEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
            writer.writeFullEndElement();
        }
        writer.writeStartElement("p:clrMapOvr");
        writer.writeStartElement("a:masterClrMapping");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writePresentationRels(StiPagesCollection allPages) throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("Relationships");
        writer.writeAttributeString("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        writer.writeStartElement("Relationship");
        writer.writeAttributeString("Id", "rId1");
        writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/tableStyles");
        writer.writeAttributeString("Target", "tableStyles.xml");
        writer.writeEndElement();
        writer.writeStartElement("Relationship");
        writer.writeAttributeString("Id", "rId2");
        writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/viewProps");
        writer.writeAttributeString("Target", "viewProps.xml");
        writer.writeEndElement();
        writer.writeStartElement("Relationship");
        writer.writeAttributeString("Id", "rId3");
        writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/presProps");
        writer.writeAttributeString("Target", "presProps.xml");
        writer.writeEndElement();
        writer.writeStartElement("Relationship");
        writer.writeAttributeString("Id", "rId4");
        writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme");
        writer.writeAttributeString("Target", "theme/theme1.xml");
        writer.writeEndElement();
        writer.writeStartElement("Relationship");
        writer.writeAttributeString("Id", "rId5");
        writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideMaster");
        writer.writeAttributeString("Target", "slideMasters/slideMaster1.xml");
        writer.writeEndElement();
        for (int index = 0; index < allPages.size(); ++index) {
            writer.writeStartElement("Relationship");
            writer.writeAttributeString("Id", String.format("rId%s", 6 + index));
            writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide");
            writer.writeAttributeString("Target", String.format("slides/slide%s.xml", index + 1));
            writer.writeEndElement();
        }
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writePresentation(StiPagesCollection allPages) throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("p:presentation");
        writer.writeAttributeString("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        writer.writeAttributeString("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        writer.writeAttributeString("xmlns:p", "http://schemas.openxmlformats.org/presentationml/2006/main");
        writer.writeAttributeString("saveSubsetFonts", "1");
        writer.writeStartElement("p:sldMasterIdLst");
        writer.writeStartElement("p:sldMasterId");
        writer.writeAttributeString("id", "2147483648");
        writer.writeAttributeString("r:id", "rId5");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("p:sldIdLst");
        for (int index = 0; index < allPages.size(); ++index) {
            writer.writeStartElement("p:sldId");
            writer.writeAttributeString("id", String.format("%s", 256 + index));
            writer.writeAttributeString("r:id", String.format("rId%s", 6 + index));
            writer.writeEndElement();
        }
        writer.writeEndElement();
        StiPage page = allPages.get(0);
        writer.writeStartElement("p:sldSz");
        writer.writeAttributeString("cx", this.convertToEmu(page.getUnit().ConvertToHInches(page.getWidth() + page.getMargins().getLeft() + page.getMargins().getRight())).toString());
        writer.writeAttributeString("cy", this.convertToEmu(page.getUnit().ConvertToHInches(page.getHeight() + page.getMargins().getTop() + page.getMargins().getBottom())).toString());
        writer.writeEndElement();
        writer.writeStartElement("p:notesSz");
        writer.writeAttributeString("cx", "6858000");
        writer.writeAttributeString("cy", "9144000");
        writer.writeEndElement();
        writer.writeStartElement("p:defaultTextStyle");
        writer.writeStartElement("a:defPPr");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("lang", "ru-RU");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl1pPr");
        writer.writeAttributeString("marL", "0");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl2pPr");
        writer.writeAttributeString("marL", "457200");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl3pPr");
        writer.writeAttributeString("marL", "914400");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl4pPr");
        writer.writeAttributeString("marL", "1371600");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl5pPr");
        writer.writeAttributeString("marL", "1828800");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl6pPr");
        writer.writeAttributeString("marL", "2286000");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl7pPr");
        writer.writeAttributeString("marL", "2743200");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl8pPr");
        writer.writeAttributeString("marL", "3200400");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:lvl9pPr");
        writer.writeAttributeString("marL", "3657600");
        writer.writeAttributeString("algn", "l");
        writer.writeAttributeString("defTabSz", "914400");
        writer.writeAttributeString("rtl", "0");
        writer.writeAttributeString("eaLnBrk", "1");
        writer.writeAttributeString("latinLnBrk", "0");
        writer.writeAttributeString("hangingPunct", "1");
        writer.writeStartElement("a:defRPr");
        writer.writeAttributeString("sz", "1800");
        writer.writeAttributeString("kern", "1200");
        writer.writeStartElement("a:solidFill");
        writer.writeStartElement("a:schemeClr");
        writer.writeAttributeString("val", "tx1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", "+mn-lt");
        writer.writeEndElement();
        writer.writeStartElement("a:ea");
        writer.writeAttributeString("typeface", "+mn-ea");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", "+mn-cs");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeSlideRels(int indexSheet) throws ParserConfigurationException {
        int index;
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("Relationships");
        writer.writeAttributeString("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
        writer.writeStartElement("Relationship");
        writer.writeAttributeString("Id", "rId1");
        writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideLayout");
        writer.writeAttributeString("Target", "../slideLayouts/slideLayout7.xml");
        writer.writeEndElement();
        if (this.imageCache.getImageIndex().size() > this.imageListOffset) {
            for (index = 0; index < this.imageCache.getImageIndex().size() - this.imageListOffset; ++index) {
                writer.writeStartElement("Relationship");
                writer.writeAttributeString("Id", String.format("rId%s", 2 + index));
                writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
                writer.writeAttributeString("Target", String.format("../media/image%05x.%s", this.imageCache.getImageIndex().get(this.imageListOffset + index) + 1, ExportOptions.PowerPoint.storeImagesAsPng ? "png" : "jpeg"));
                writer.writeEndElement();
            }
        }
        if (this.hyperlinkList.size() > 0) {
            for (index = 0; index < this.hyperlinkList.size(); ++index) {
                writer.writeStartElement("Relationship");
                writer.writeAttributeString("Id", String.format("hId%s", index + 1));
                String link = this.hyperlinkList.get(index);
                if (link instanceof String) {
                    writer.writeAttributeString("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
                    writer.writeAttributeString("Target", link);
                    writer.writeAttributeString("TargetMode", "External");
                }
                writer.writeEndElement();
            }
        }
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeSlide(int indexPage, StiPagesCollection allPages) throws UnsupportedEncodingException, ParserConfigurationException {
        boolean isTrial;
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("p:sld");
        writer.writeAttributeString("xmlns:a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        writer.writeAttributeString("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        writer.writeAttributeString("xmlns:p", "http://schemas.openxmlformats.org/presentationml/2006/main");
        writer.writeStartElement("p:cSld");
        writer.writeStartElement("p:spTree");
        writer.writeStartElement("p:nvGrpSpPr");
        writer.writeStartElement("p:cNvPr");
        writer.writeAttributeString("id", "1");
        writer.writeAttributeString("name", "");
        writer.writeEndElement();
        writer.writeStartElement("p:cNvGrpSpPr");
        writer.writeEndElement();
        writer.writeStartElement("p:nvPr");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("p:grpSpPr");
        writer.writeStartElement("a:xfrm");
        writer.writeStartElement("a:off");
        writer.writeAttributeString("x", "0");
        writer.writeAttributeString("y", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:ext");
        writer.writeAttributeString("cx", "0");
        writer.writeAttributeString("cy", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:chOff");
        writer.writeAttributeString("x", "0");
        writer.writeAttributeString("y", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:chExt");
        writer.writeAttributeString("cx", "0");
        writer.writeAttributeString("cy", "0");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        this.idCounter = 2;
        StiPage page = allPages.get(indexPage);
        allPages.GetPage(page);
        this.writeWatermark(writer, page, true);
        for (StiComponent comp : page.getComponents()) {
            StiText textBox;
            if (!comp.getEnabled() || !(comp.getWidth() > 0.0) || !(comp.getHeight() > 0.0)) continue;
            StiText stiText = textBox = comp instanceof StiText ? (StiText)comp : null;
            if (textBox != null && !textBox.getAllowHtmlTags()) {
                float angle = textBox.getAngle() % 360.0f;
                if (angle < 0.0f) {
                    angle = 360.0f + angle;
                }
                if (angle == 0.0f || angle == 90.0f || angle == 270.0f) {
                    this.writeStiTextbox(writer, comp);
                } else {
                    StiText tempText = (StiText)textBox.clone();
                    tempText.setText((StiExpression)null);
                    tempText.setAngle(0.0f);
                    this.writeStiTextbox(writer, tempText);
                    tempText = (StiText)textBox.clone();
                    tempText.setBorder(null);
                    tempText.setBrush(null);
                    tempText.setHorAlignment(StiTextHorAlignment.Center);
                    tempText.setVertAlignment(StiVertAlignment.Center);
                    this.writeStiTextbox(writer, tempText);
                }
            } else if (comp instanceof StiContainer) {
                StiText newText = new StiText(comp.getClientRectangle());
                newText.setPage(comp.getPage());
                newText.setBorder(((StiContainer)comp).getBorder());
                newText.setBrush(((StiContainer)comp).getBrush());
                newText.setHyperlinkValue(comp.getHyperlinkValue());
                this.writeStiTextbox(writer, newText);
            } else {
                this.writeStiImage(writer, comp);
            }
            ++this.idCounter;
        }
        this.writeWatermark(writer, page, false);
        boolean bl = isTrial = !StiLicenseKeyValidator.isValidOnJavaFramework(null);
        if (isTrial) {
            double pageWidth = page.getUnit().ConvertToHInches(page.getPageWidth() - page.getMargins().getLeft() - page.getMargins().getRight());
            double pageHeight = page.getUnit().ConvertToHInches(page.getPageHeight() - page.getMargins().getTop() - page.getMargins().getBottom());
            double mgLeft = page.getUnit().ConvertToHInches(page.getMargins().getLeft());
            double mgTop = page.getUnit().ConvertToHInches(page.getMargins().getTop());
            writer.writeStartElement("p:sp");
            writer.writeStartElement("p:nvSpPr");
            writer.writeStartElement("p:cNvPr");
            writer.writeAttributeString("id", "67");
            writer.writeAttributeString("name", "TextBox Additional");
            writer.writeEndElement();
            writer.writeStartElement("p:cNvSpPr");
            writer.writeAttributeString("txBox", "1");
            writer.writeEndElement();
            writer.writeStartElement("p:nvPr");
            writer.writeAttributeString("userDrawn", "1");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("p:spPr");
            writer.writeStartElement("a:xfrm");
            writer.writeAttributeString("rot", "-2700000");
            writer.writeStartElement("a:off");
            writer.writeAttributeString("x", this.convertToEmu(mgLeft).toString());
            writer.writeAttributeString("y", this.convertToEmu(mgTop + pageHeight * 0.45).toString());
            writer.writeEndElement();
            writer.writeStartElement("a:ext");
            writer.writeAttributeString("cx", this.convertToEmu(pageWidth).toString());
            writer.writeAttributeString("cy", this.convertToEmu(pageHeight * 0.1).toString());
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("a:prstGeom");
            writer.writeAttributeString("prst", "rect");
            writer.writeStartElement("a:avLst");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("a:noFill");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("p:txBody");
            writer.writeStartElement("a:bodyPr");
            writer.writeAttributeString("wrap", "square");
            writer.writeAttributeString("rtlCol", "0");
            writer.writeAttributeString("anchor", "ctr");
            writer.writeAttributeString("anchorCtr", "0");
            writer.writeStartElement("a:spAutoFit");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("a:lstStyle");
            writer.writeEndElement();
            writer.writeStartElement("a:p");
            writer.writeStartElement("a:pPr");
            writer.writeAttributeString("algn", "ctr");
            writer.writeEndElement();
            writer.writeStartElement("a:r");
            writer.writeStartElement("a:rPr");
            writer.writeAttributeString("lang", "en-US");
            writer.writeAttributeString("sz", "9600");
            writer.writeAttributeString("b", "1");
            writer.writeAttributeString("dirty", "0");
            writer.writeAttributeString("smtClean", "0");
            writer.writeStartElement("a:solidFill");
            writer.writeStartElement("a:schemeClr");
            writer.writeAttributeString("val", "tx1");
            writer.writeStartElement("a:alpha");
            writer.writeAttributeString("val", "12000");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("a:latin");
            writer.writeAttributeString("typeface", "Arial");
            writer.writeAttributeString("panose", "020B0604020202020204");
            writer.writeAttributeString("pitchFamily", "34");
            writer.writeAttributeString("charset", "0");
            writer.writeEndElement();
            writer.writeStartElement("a:cs");
            writer.writeAttributeString("typeface", "Arial");
            writer.writeAttributeString("panose", "020B0604020202020204");
            writer.writeAttributeString("pitchFamily", "34");
            writer.writeAttributeString("charset", "0");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("a:t");
            writer.writeString("Trial");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeFullEndElement();
        writer.writeEndElement();
        writer.writeStartElement("p:clrMapOvr");
        writer.writeStartElement("a:masterClrMapping");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private void writeStiTextbox(StiXmlTextWriter writer, StiComponent comp) throws UnsupportedEncodingException {
        StiText stiText = (StiText)comp;
        writer.writeStartElement("p:sp");
        writer.writeStartElement("p:nvSpPr");
        writer.writeStartElement("p:cNvPr");
        writer.writeAttributeString("id", String.format("%s", this.idCounter));
        writer.writeAttributeString("name", String.format("TextBox %s", this.idCounter));
        this.writeHyperlinkInfo(writer, comp);
        writer.writeEndElement();
        writer.writeStartElement("p:cNvSpPr");
        writer.writeAttributeString("txBox", "1");
        writer.writeEndElement();
        writer.writeStartElement("p:nvPr");
        writer.writeEndElement();
        writer.writeEndElement();
        boolean topmost = this.writeSpPr(writer, comp);
        writer.writeStartElement("p:txBody");
        writer.writeStartElement("a:bodyPr");
        boolean textWordWrap = false;
        String stTextAngle = "";
        if (stiText.getTextOptions() != null) {
            textWordWrap = stiText.getTextOptions().getWordWrap();
            float textAngle = stiText.getTextOptions().getAngle() % 360.0f;
            if (textAngle < 0.0f) {
                textAngle = 360.0f + textAngle;
            }
            if (textAngle == 90.0f) {
                stTextAngle = "vert270";
            }
            if (textAngle == 270.0f) {
                stTextAngle = "vert";
            }
        }
        if (!"".equals(stTextAngle)) {
            writer.writeAttributeString("vert", stTextAngle);
        }
        writer.writeAttributeString("horzOverflow", "clip");
        writer.writeAttributeString("vertOverflow", "clip");
        int mLeft = this.convertToEmu(stiText.getMargins().getLeft());
        int mRight = this.convertToEmu(stiText.getMargins().getRight());
        int mTop = this.convertToEmu(stiText.getMargins().getTop());
        int mBottom = this.convertToEmu(stiText.getMargins().getBottom());
        writer.writeAttributeString("lIns", String.format("%s", mLeft));
        writer.writeAttributeString("tIns", String.format("%s", mTop));
        writer.writeAttributeString("rIns", String.format("%s", mRight));
        writer.writeAttributeString("bIns", String.format("%s", mBottom));
        writer.writeAttributeString("wrap", textWordWrap ? "square" : "none");
        writer.writeAttributeString("rtlCol", "0");
        String vertAlign = "t";
        if (stiText.getVertAlignment() == StiVertAlignment.Center) {
            vertAlign = "ctr";
        }
        if (stiText.getVertAlignment() == StiVertAlignment.Bottom) {
            vertAlign = "b";
        }
        writer.writeAttributeString("anchor", vertAlign);
        writer.writeAttributeString("anchorCtr", "0");
        writer.writeStartElement("a:noAutofit");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:lstStyle");
        writer.writeEndElement();
        writer.writeStartElement("a:p");
        boolean rightToLeft = false;
        if (stiText.getTextOptions() != null) {
            rightToLeft = stiText.getTextOptions().getRightToLeft();
        }
        writer.writeStartElement("a:pPr");
        String horAlign = "";
        if (stiText.getHorAlignment() == StiTextHorAlignment.Center) {
            horAlign = "ctr";
        }
        if (stiText.getHorAlignment() == StiTextHorAlignment.Right && !rightToLeft || stiText.getHorAlignment() == StiTextHorAlignment.Left && rightToLeft) {
            horAlign = "r";
        }
        if (stiText.getHorAlignment() == StiTextHorAlignment.Width) {
            horAlign = "just";
        }
        if (!"".equals(horAlign)) {
            writer.writeAttributeString("algn", horAlign);
        }
        if (rightToLeft) {
            writer.writeAttributeString("rtl", "1");
        }
        writer.writeStartElement("a:lnSpc");
        writer.writeStartElement("a:spcPct");
        writer.writeAttributeString("val", String.format("%s", (int)StiMath.round((double)((double)stiText.getLineSpacing() * 0.94 * 100000.0), (int)0)));
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:r");
        writer.writeStartElement("a:rPr");
        writer.writeAttributeString("lang", "en-US");
        writer.writeAttributeString("sz", String.valueOf((int)(stiText.getFont().size * 100.0 * 0.984)));
        if (stiText.getFont().bold()) {
            writer.writeAttributeString("b", "1");
        }
        if (stiText.getFont().italic()) {
            writer.writeAttributeString("i", "1");
        }
        if (stiText.getFont().underline()) {
            writer.writeAttributeString("u", "sng");
        }
        if (stiText.getFont().strikeout()) {
            writer.writeAttributeString("strike", "sngStrike");
        }
        writer.writeAttributeString("dirty", "0");
        writer.writeAttributeString("smtClean", "0");
        writer.writeStartElement("a:solidFill");
        this.writeColor(writer, StiBrush.ToColor((StiBrush)stiText.getTextBrush()));
        writer.writeFullEndElement();
        String st = "";
        if (stiText.getText() != null) {
            st = stiText.getText().toString();
        }
        if ((stiText.getTextQuality() == StiTextQuality.Wysiwyg || stiText.getHorAlignment() == StiTextHorAlignment.Width) && !StiValidationUtil.isNullOrEmpty((String)st) && st.endsWith(StiTextRenderer.StiForceWidthAlignTag)) {
            st = st.substring(0, st.length() - StiTextRenderer.StiForceWidthAlignTag.length());
        }
        writer.writeStartElement("a:latin");
        writer.writeAttributeString("typeface", stiText.getFont().getName());
        writer.writeAttributeString("pitchFamily", "18");
        writer.writeAttributeString("charset", "0");
        writer.writeEndElement();
        writer.writeStartElement("a:cs");
        writer.writeAttributeString("typeface", stiText.getFont().getName());
        writer.writeAttributeString("pitchFamily", "18");
        writer.writeAttributeString("charset", "0");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeElementString("a:t", st);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        if (topmost) {
            this.writeBorder(writer, comp);
        }
    }

    private void writeStiImage(StiXmlTextWriter writer, StiComponent comp) throws UnsupportedEncodingException {
        IStiExportImage exportImage;
        boolean topmost = false;
        IStiExportImage iStiExportImage = exportImage = comp instanceof IStiExportImage ? (IStiExportImage)((Object)comp) : null;
        if (exportImage != null) {
            IStiExportImageExtended exportImageExtended = exportImage instanceof IStiExportImageExtended ? (IStiExportImageExtended)exportImage : null;
            float zoom = this.imageResolution;
            BufferedImage image = null;
            if (comp.isExportAsImage(StiExportFormat.Ppt2007)) {
                image = exportImageExtended != null && exportImageExtended.isExportAsImage(StiExportFormat.Ppt2007) ? exportImageExtended.getImage(Double.valueOf(zoom), StiExportFormat.ImagePng) : exportImage.getImage(Double.valueOf(zoom));
            }
            if (image != null) {
                int imageIndex = this.imageCache.addImageInt(image, this.imageCache.imageSaveFormat, StiColorImageFormat.Color, null, true);
                writer.writeStartElement("p:pic");
                writer.writeStartElement("p:nvPicPr");
                writer.writeStartElement("p:cNvPr");
                writer.writeAttributeString("id", String.format("%s", this.idCounter));
                writer.writeAttributeString("name", String.format("Picture %s", this.idCounter + 1));
                writer.writeAttributeString("descr", String.format("Picture %s description", this.idCounter + 1));
                this.writeHyperlinkInfo(writer, comp);
                writer.writeEndElement();
                writer.writeStartElement("p:cNvPicPr");
                writer.writeStartElement("a:picLocks");
                writer.writeAttributeString("noChangeAspect", "1");
                writer.writeEndElement();
                writer.writeFullEndElement();
                writer.writeStartElement("p:nvPr");
                writer.writeEndElement();
                writer.writeFullEndElement();
                writer.writeStartElement("p:blipFill");
                writer.writeStartElement("a:blip");
                writer.writeAttributeString("r:embed", String.format("rId%s", 1 + this.imageCache.getImageIndex().size() - this.imageListOffset));
                writer.writeEndElement();
                writer.writeStartElement("a:stretch");
                writer.writeStartElement("a:fillRect");
                writer.writeEndElement();
                writer.writeFullEndElement();
                writer.writeFullEndElement();
                topmost = this.writeSpPr(writer, comp);
                writer.writeFullEndElement();
            }
        }
        if (topmost || comp instanceof StiLinePrimitive) {
            this.writeBorder(writer, comp);
        }
    }

    private boolean writeSpPr(StiXmlTextWriter writer, StiComponent comp) {
        IStiTextOptions txtOpt;
        int x1 = this.convertToEmu(comp.getReport().getUnit().ConvertToHInches(comp.getLeft() + comp.getPage().getMargins().getLeft()));
        int y1 = this.convertToEmu(comp.getReport().getUnit().ConvertToHInches(comp.getTop() + comp.getPage().getMargins().getTop()));
        int x2 = this.convertToEmu(comp.getReport().getUnit().ConvertToHInches(comp.getRight() + comp.getPage().getMargins().getLeft()));
        int y2 = this.convertToEmu(comp.getReport().getUnit().ConvertToHInches(comp.getBottom() + comp.getPage().getMargins().getTop()));
        float angle = 0.0f;
        IStiTextOptions iStiTextOptions = txtOpt = comp instanceof IStiTextOptions ? (IStiTextOptions)((Object)comp) : null;
        if (txtOpt != null && txtOpt.getTextOptions() != null && ((angle = txtOpt.getTextOptions().getAngle() % 360.0f) == 90.0f || angle == 270.0f || angle == -90.0f || angle == -270.0f)) {
            angle = 0.0f;
        }
        writer.writeStartElement("p:spPr");
        writer.writeStartElement("a:xfrm");
        if (angle != 0.0f) {
            writer.writeAttributeString("rot", String.format("%s", Math.round(-angle * 60000.0f)));
        }
        writer.writeStartElement("a:off");
        writer.writeAttributeString("x", String.format("%s", x1));
        writer.writeAttributeString("y", String.format("%s", y1));
        writer.writeEndElement();
        writer.writeStartElement("a:ext");
        writer.writeAttributeString("cx", String.format("%s", x2 - x1));
        writer.writeAttributeString("cy", String.format("%s", y2 - y1));
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:prstGeom");
        writer.writeAttributeString("prst", "rect");
        writer.writeStartElement("a:avLst");
        writer.writeEndElement();
        writer.writeEndElement();
        boolean noNeedFill = comp instanceof StiShape || comp instanceof StiImage;
        StiColor color = StiColorEnum.Transparent.color();
        if (comp instanceof IStiBrush) {
            color = StiBrush.ToColor((StiBrush)((IStiBrush)((Object)comp)).getBrush());
        }
        if (color.a == 0 || noNeedFill) {
            writer.writeStartElement("a:noFill");
            writer.writeEndElement();
        } else {
            writer.writeStartElement("a:solidFill");
            this.writeColor(writer, color);
            writer.writeFullEndElement();
        }
        boolean topmost = false;
        StiBorder border = null;
        if (comp instanceof IStiBorder) {
            border = ((IStiBorder)((Object)comp)).getBorder();
        }
        if (border != null && !border.getSide().containsOnly((IStiEnum)StiBorderSides.None) && border.getStyle() != StiPenStyle.None) {
            if (!border.getSide().containsOnly((IStiEnum)StiBorderSides.All) || border instanceof StiAdvancedBorder) {
                topmost = true;
            } else {
                writer.writeStartElement("a:ln");
                writer.writeAttributeString("w", String.format("%s", this.convertToEmu(border.getSize())));
                writer.writeStartElement("a:solidFill");
                this.writeColor(writer, border.getColor());
                writer.writeFullEndElement();
                writer.writeStartElement("a:prstDash");
                writer.writeAttributeString("val", this.getLineStyle(border.getStyle()));
                writer.writeEndElement();
                writer.writeStartElement("a:miter");
                writer.writeAttributeString("lim", "800000");
                writer.writeEndElement();
                writer.writeFullEndElement();
            }
        }
        writer.writeEndElement();
        return topmost;
    }

    private void writeBorder(StiXmlTextWriter writer, StiComponent comp) {
        StiBorder border = ((IStiBorder)((Object)comp)).getBorder();
        if (border instanceof StiAdvancedBorder) {
            StiAdvancedBorder adv = (StiAdvancedBorder)border;
            if (adv.isLeftBorderSidePresent()) {
                this.writeLine(writer, comp, new StiRectangle(comp.getLeft(), comp.getTop(), 0.0, comp.getHeight()), adv.getLeftSide().getSize(), adv.getLeftSide().getStyle(), adv.getLeftSide().getColor());
            }
            if (adv.isRightBorderSidePresent()) {
                this.writeLine(writer, comp, new StiRectangle(comp.getRight(), comp.getTop(), 0.0, comp.getHeight()), adv.getRightSide().getSize(), adv.getRightSide().getStyle(), adv.getRightSide().getColor());
            }
            if (adv.isTopBorderSidePresent()) {
                this.writeLine(writer, comp, new StiRectangle(comp.getLeft(), comp.getTop(), comp.getWidth(), 0.0), adv.getTopSide().getSize(), adv.getTopSide().getStyle(), adv.getTopSide().getColor());
            }
            if (adv.isBottomBorderSidePresent()) {
                this.writeLine(writer, comp, new StiRectangle(comp.getLeft(), comp.getBottom(), comp.getWidth(), 0.0), adv.getBottomSide().getSize(), adv.getBottomSide().getStyle(), adv.getBottomSide().getColor());
            }
        } else {
            if (border.isLeftBorderSidePresent()) {
                this.writeLine(writer, comp, new StiRectangle(comp.getLeft(), comp.getTop(), 0.0, comp.getHeight()), border.getSize(), border.getStyle(), border.getColor());
            }
            if (border.isRightBorderSidePresent()) {
                this.writeLine(writer, comp, new StiRectangle(comp.getRight(), comp.getTop(), 0.0, comp.getHeight()), border.getSize(), border.getStyle(), border.getColor());
            }
            if (border.isTopBorderSidePresent()) {
                this.writeLine(writer, comp, new StiRectangle(comp.getLeft(), comp.getTop(), comp.getWidth(), 0.0), border.getSize(), border.getStyle(), border.getColor());
            }
            if (border.isBottomBorderSidePresent()) {
                this.writeLine(writer, comp, new StiRectangle(comp.getLeft(), comp.getBottom(), comp.getWidth(), 0.0), border.getSize(), border.getStyle(), border.getColor());
            }
        }
    }

    private void writeLine(StiXmlTextWriter writer, StiComponent comp, StiRectangle rect, double size, StiPenStyle style, StiColor color) {
        StiLinePrimitive linePrimitive;
        if (style == StiPenStyle.None || color.equals(StiColorEnum.Transparent.color())) {
            return;
        }
        writer.writeStartElement("p:cxnSp");
        writer.writeStartElement("p:nvCxnSpPr");
        writer.writeStartElement("p:cNvPr");
        writer.writeAttributeString("id", String.format("%s", this.idCounter));
        writer.writeAttributeString("name", String.format("Line %s", this.idCounter));
        writer.writeEndElement();
        writer.writeStartElement("p:cNvCxnSpPr");
        writer.writeEndElement();
        writer.writeStartElement("p:nvPr");
        writer.writeEndElement();
        writer.writeEndElement();
        int x1 = this.convertToEmu(comp.getReport().getUnit().ConvertToHInches(rect.getLeft() + comp.getPage().getMargins().getLeft()));
        int y1 = this.convertToEmu(comp.getReport().getUnit().ConvertToHInches(rect.getTop() + comp.getPage().getMargins().getTop()));
        int x2 = this.convertToEmu(comp.getReport().getUnit().ConvertToHInches(rect.getRight() + comp.getPage().getMargins().getLeft()));
        int y2 = this.convertToEmu(comp.getReport().getUnit().ConvertToHInches(rect.getBottom() + comp.getPage().getMargins().getTop()));
        writer.writeStartElement("p:spPr");
        writer.writeStartElement("a:xfrm");
        writer.writeStartElement("a:off");
        writer.writeAttributeString("x", String.format("%s", x1));
        writer.writeAttributeString("y", String.format("%s", y1));
        writer.writeEndElement();
        writer.writeStartElement("a:ext");
        writer.writeAttributeString("cx", String.format("%s", x2 - x1));
        writer.writeAttributeString("cy", String.format("%s", y2 - y1));
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:prstGeom");
        writer.writeAttributeString("prst", "line");
        writer.writeStartElement("a:avLst");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("a:ln");
        writer.writeAttributeString("w", String.format("%s", this.convertToEmu(size)));
        writer.writeStartElement("a:solidFill");
        this.writeColor(writer, color);
        writer.writeFullEndElement();
        writer.writeStartElement("a:prstDash");
        writer.writeAttributeString("val", this.getLineStyle(style));
        writer.writeEndElement();
        StiLinePrimitive stiLinePrimitive = linePrimitive = comp instanceof StiLinePrimitive ? (StiLinePrimitive)comp : null;
        if (linePrimitive != null) {
            String capStyle;
            StiCap cap1 = null;
            StiCap cap2 = null;
            if (linePrimitive instanceof StiHorizontalLinePrimitive) {
                cap1 = ((StiHorizontalLinePrimitive)linePrimitive).getStartCap();
                cap2 = ((StiHorizontalLinePrimitive)linePrimitive).getEndCap();
            }
            if (linePrimitive instanceof StiVerticalLinePrimitive) {
                cap1 = ((StiVerticalLinePrimitive)linePrimitive).getStartCap();
                cap2 = ((StiVerticalLinePrimitive)linePrimitive).getEndCap();
            }
            if (cap1 != null && !StiValidationUtil.isNullOrEmpty((String)(capStyle = this.capStyleToPptStyle(cap1.getStyle())))) {
                writer.writeStartElement("a:headEnd");
                writer.writeAttributeString("type", capStyle);
                writer.writeEndElement();
            }
            if (cap2 != null && !StiValidationUtil.isNullOrEmpty((String)(capStyle = this.capStyleToPptStyle(cap2.getStyle())))) {
                writer.writeStartElement("a:tailEnd");
                writer.writeAttributeString("type", capStyle);
                writer.writeEndElement();
            }
        }
        writer.writeFullEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private String capStyleToPptStyle(StiCapStyle capStyle) {
        switch (capStyle) {
            case Arrow: {
                return "triangle";
            }
            case Diamond: {
                return "diamond";
            }
            case Square: {
                return "diamond";
            }
            case Open: {
                return "arrow";
            }
            case Oval: {
                return "oval";
            }
            case Stealth: {
                return "stealth";
            }
        }
        return null;
    }

    private void writeWatermark(StiXmlTextWriter writer, StiPage page, boolean showBehind) throws UnsupportedEncodingException {
        if (page.getWatermark() != null && (page.getWatermark().existImage() || !StiValidationUtil.isNullOrWhiteSpace((String)page.getWatermark().getImageHyperlink())) && page.getWatermark().getShowImageBehind() == showBehind) {
            StiImage image = new StiImage();
            image.setPage(page);
            image.setImageBytes(StiImageHelper.imageToBase64(page.getWatermark().getBufferedImage(page.getReport(), page.getPaintRectangle()), StiImageFormat.Png));
            image.setLeft(image.getLeft() - page.getMargins().getLeft());
            image.setTop(image.getTop() - page.getMargins().getTop());
            image.setWidth(page.getPageWidth());
            image.setHeight(page.getPageHeight());
            if (page.getWatermark().getImageStretch()) {
                image.setStretch(true);
            }
            image.setVertAlignment(StiVertAlignment.Center);
            image.setHorAlignment(StiHorAlignment.Center);
            this.writeStiImage(writer, image);
        }
    }

    private void writeHyperlinkInfo(StiXmlTextWriter writer, StiComponent comp) throws UnsupportedEncodingException {
        String hyperlink;
        if (comp.getHyperlinkValue() != null && (hyperlink = comp.getHyperlinkValue().toString().trim()).length() > 0 && !hyperlink.startsWith("javascript:") && !hyperlink.startsWith("#")) {
            String hypRefText = this.stringToUrl(hyperlink);
            int hypRefId = this.hyperlinkList.indexOf(hypRefText);
            if (hypRefId == -1) {
                this.hyperlinkList.add(hypRefText);
                hypRefId = this.hyperlinkList.size();
            }
            writer.writeStartElement("a:hlinkClick");
            writer.writeAttributeString("r:id", String.format("hId%s", hypRefId));
            writer.writeEndElement();
        }
    }

    private byte[] writeImage(int index) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StiImageHelper.saveWithDPI(this.imageCache.getImageByIndex(index), out, ExportOptions.PowerPoint.storeImagesAsPng ? StiImageFormat.Png : StiImageFormat.Jpeg, (Integer)72, this.imageQuality);
        byte[] bytes = out.toByteArray();
        out.close();
        return bytes;
    }

    public void exportPowerPoint(StiReport report, OutputStream stream) throws Exception {
        this.exportPowerPoint(report, stream, new StiPpt2007ExportSettings());
    }

    public void exportPowerPoint(StiReport report, OutputStream stream, StiPagesRange pageRange) throws Exception {
        StiPpt2007ExportSettings settings = new StiPpt2007ExportSettings();
        settings.setPageRange(pageRange);
        this.exportPowerPoint(report, stream, settings);
    }

    public void exportPowerPoint(StiReport report, OutputStream stream, StiPpt2007ExportSettings settings) throws StiException {
        try {
            this.exportPowerPointException(report, stream, settings);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPowerPointException(StiReport report, OutputStream outputStream, StiPpt2007ExportSettings settings) throws IOException, TransformerException, ParserConfigurationException {
        StiLicenseKeyValidator.isValidOnJavaFramework(null);
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        StiPagesRange pageRange = settings.getPageRange();
        this.imageResolution = settings.getImageResolution();
        this.imageQuality = settings.getImageQuality();
        this.xmlIndentation = -1;
        if (this.imageResolution < 10.0f) {
            this.imageResolution = 10.0f;
        }
        this.imageResolution /= 100.0f;
        try {
            int index;
            StiPagesCollection allPages = pageRange.getSelectedPages(report.getRenderedPages());
            this.setStatusString(StiLocalization.Get((String)"Export", (String)"ExportingCreatingDocument"));
            this.imageCache = new StiImageCache(ExportOptions.PowerPoint.allowImageComparer, ExportOptions.PowerPoint.storeImagesAsPng ? StiImageFormat.Png : StiImageFormat.Jpeg, this.imageQuality);
            StiZipWriter20 zip = new StiZipWriter20(outputStream);
            zip.addFile("", "[Content_Types].xml", this.writeContentTypes(allPages.size()));
            zip.addFile("_rels/", ".rels", this.writeMainRels());
            zip.addFile("docProps/", "app.xml", this.writeDocPropsApp(allPages.size()));
            zip.addFile("docProps/", "core.xml", this.writeDocPropsCore());
            zip.addFile("ppt/", "tableStyles.xml", this.writeTableStyles());
            zip.addFile("ppt/", "presProps.xml", this.writePresProps());
            zip.addFile("ppt/", "viewProps.xml", this.writeViewProps());
            zip.addFile("ppt/theme/", "theme1.xml", this.writeTheme());
            zip.addFile("ppt/slideMasters/", "slideMaster1.xml", this.writeSlideMaster());
            zip.addFile("ppt/slideMasters/_rels/", "slideMaster1.xml.rels", this.writeSlideMasterRels());
            for (index = 0; index < 11; ++index) {
                zip.addFile("ppt/slideLayouts/", String.format("slideLayout%s.xml", index + 1), this.writeSlideLayout(index + 1, allPages.get(0)));
                zip.addFile("ppt/slideLayouts/_rels/", String.format("slideLayout%s.xml.rels", index + 1), this.writeSlideLayoutRels());
            }
            zip.addFile("ppt/", "presentation.xml", this.writePresentation(allPages));
            zip.addFile("ppt/_rels/", "presentation.xml.rels", this.writePresentationRels(allPages));
            this.imageListOffset = 0;
            this.hyperlinkList = new ArrayList();
            for (int indexPage = 0; indexPage < allPages.size(); ++indexPage) {
                this.invokeExporting(indexPage, allPages.size());
                StiPage page = allPages.get(indexPage);
                allPages.GetPage(page);
                zip.addFile("ppt/slides/", String.format("slide%s.xml", indexPage + 1), this.writeSlide(indexPage, allPages));
                zip.addFile("ppt/slides/_rels/", String.format("slide%s.xml.rels", indexPage + 1), this.writeSlideRels(indexPage));
                this.imageListOffset = this.imageCache.getImageIndex().size();
                this.hyperlinkList.clear();
            }
            if (this.imageCache.getImageStoreSize() > 0) {
                for (index = 0; index < this.imageCache.getImageStoreSize(); ++index) {
                    zip.addFile("ppt/media/", String.format("image%05x.%s", index + 1, ExportOptions.PowerPoint.storeImagesAsPng ? "png" : "jpeg"), this.writeImage(index));
                }
            }
            zip.finish();
        }
        finally {
            this.imageCache.clear();
            this.hyperlinkList = null;
        }
    }
}

