/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiImageExportService;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiMonochromeDitheringType;
import com.stimulsoft.report.export.tools.StiPcxPaletteType;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;

public class StiPcxExportService
extends StiImageExportService {
    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.ImagePcx;
    }

    @Override
    public StiImageFormat getImageFormat() {
        return null;
    }

    public static class StiPcxHelper {
        private static void dwByte(byte[] bfData, int position, byte dataValue) {
            bfData[position] = dataValue;
        }

        private static void dwByte(byte[] bfData, int position, byte dv1, byte dv2) {
            StiPcxHelper.dwByte(bfData, position, dv1);
            StiPcxHelper.dwByte(bfData, position + 1, dv2);
        }

        private static void dwByte(byte[] bfData, int position, byte dv1, byte dv2, byte dv3) {
            StiPcxHelper.dwByte(bfData, position, dv1, dv2);
            StiPcxHelper.dwByte(bfData, position + 2, dv3);
        }

        private static void dwShort(byte[] bfData, int position, int dataValue) {
            short dv = (short)dataValue;
            bfData[position + 0] = (byte)(dv & 0xFF);
            bfData[position + 1] = (byte)(dv >> 8 & 0xFF);
        }

        private static void dwEncodedData(OutputStream stream, byte byt, int runLen) throws IOException {
            if (runLen == 1 && (byt & 0xC0) != 192) {
                stream.write(byt);
            } else {
                stream.write((byte)(runLen | 0xC0));
                stream.write(byt);
            }
        }

        public static void saveToStream(BufferedImage imageForExport, StiPcxPaletteType paletteType, StiMonochromeDitheringType ditheringType, OutputStream stream) throws IOException {
            int indexY;
            BufferedImage bitmap = imageForExport;
            int imageWidth = bitmap.getWidth();
            int imageHeight = bitmap.getHeight();
            int bytesPerLine = 0;
            byte[] buf = new byte[1];
            WritableRaster originalRaster = imageForExport.getRaster();
            if (paletteType == StiPcxPaletteType.Monochrome) {
                bytesPerLine = ((imageWidth - 1) / 16 + 1) * 2;
                buf = new byte[bytesPerLine * imageHeight];
                for (indexY = 0; indexY < imageHeight; ++indexY) {
                    int bitPos = 128;
                    int bytePos = indexY * bytesPerLine;
                    int val = 0;
                    for (int indexX = 0; indexX < imageWidth; ++indexX) {
                        if (originalRaster.getSample(indexX, indexY, 0) != 0) {
                            val = (byte)(val | bitPos);
                        }
                        if ((bitPos >>= 1) != 0) continue;
                        buf[bytePos] = val;
                        val = 0;
                        bitPos = 128;
                        ++bytePos;
                    }
                    if (bitPos == -128 || bytePos >= bytesPerLine * imageHeight) continue;
                    buf[bytePos] = val;
                }
            }
            if (paletteType == StiPcxPaletteType.Color) {
                bytesPerLine = ((imageWidth - 1) / 2 + 1) * 2;
                buf = new byte[bytesPerLine * 3 * imageHeight];
                for (indexY = 0; indexY < imageHeight; ++indexY) {
                    int offset2 = bytesPerLine * 3 * indexY;
                    for (int indexX = 0; indexX < imageWidth; ++indexX) {
                        buf[offset2 + bytesPerLine * 0] = (byte)originalRaster.getSample(indexX, indexY, 0);
                        buf[offset2 + bytesPerLine * 1] = (byte)originalRaster.getSample(indexX, indexY, 1);
                        buf[offset2 + bytesPerLine * 2] = (byte)originalRaster.getSample(indexX, indexY, 2);
                        ++offset2;
                    }
                }
            }
            byte[] header = new byte[128];
            StiPcxHelper.dwByte(header, 0, (byte)10);
            StiPcxHelper.dwByte(header, 1, (byte)5);
            StiPcxHelper.dwByte(header, 2, (byte)1);
            if (paletteType == StiPcxPaletteType.Monochrome) {
                StiPcxHelper.dwByte(header, 3, (byte)1);
            }
            if (paletteType == StiPcxPaletteType.Color) {
                StiPcxHelper.dwByte(header, 3, (byte)8);
            }
            StiPcxHelper.dwShort(header, 4, 0);
            StiPcxHelper.dwShort(header, 6, 0);
            StiPcxHelper.dwShort(header, 8, imageWidth - 1);
            StiPcxHelper.dwShort(header, 10, imageHeight - 1);
            StiPcxHelper.dwShort(header, 12, 72);
            StiPcxHelper.dwShort(header, 14, 72);
            StiPcxHelper.dwByte(header, 16, (byte)0, (byte)0, (byte)0);
            StiPcxHelper.dwByte(header, 19, (byte)-1, (byte)-1, (byte)-1);
            StiPcxHelper.dwByte(header, 64, (byte)0);
            if (paletteType == StiPcxPaletteType.Monochrome) {
                StiPcxHelper.dwByte(header, 65, (byte)1);
            }
            if (paletteType == StiPcxPaletteType.Color) {
                StiPcxHelper.dwByte(header, 65, (byte)3);
            }
            StiPcxHelper.dwShort(header, 66, bytesPerLine);
            StiPcxHelper.dwShort(header, 68, 1);
            stream.write(header);
            int runLen = 1;
            byte lastByte = buf[0];
            for (int indexByte = 1; indexByte < buf.length; ++indexByte) {
                byte thisByte = buf[indexByte];
                if (lastByte == thisByte) {
                    if (++runLen != 63 && (indexByte + 1) % bytesPerLine != 0) continue;
                    StiPcxHelper.dwEncodedData(stream, lastByte, runLen);
                    runLen = 0;
                    continue;
                }
                if (runLen != 0) {
                    StiPcxHelper.dwEncodedData(stream, lastByte, runLen);
                }
                lastByte = thisByte;
                runLen = 1;
            }
            if (runLen != 0) {
                StiPcxHelper.dwEncodedData(stream, lastByte, runLen);
            }
            stream.flush();
            stream.close();
        }
    }
}

