/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiXmlTextWriter;
import com.stimulsoft.base.utils.StiZipWriter20;
import com.stimulsoft.report.StiImageCache;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.enums.StiPageOrientation;
import com.stimulsoft.report.components.interfaces.IStiExportImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.StiSegmentPagesDivider;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiOdtExportSettings;
import com.stimulsoft.report.export.tools.StiCell;
import com.stimulsoft.report.export.tools.StiCellStyle;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiMapUtil;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.options.ExportOptions;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiOdtExportService
extends StiExportService {
    private StiMatrix matrix = null;
    private boolean removeEmptySpaceAtBottom = ExportOptions.OpenDocumentWriter.removeEmptySpaceAtBottom;
    private StiImageCache imageCache = null;
    private ArrayList<CellStyleData> cellStyleList = null;
    private ArrayList<ParagraphStyleData> paragraphStyleList = null;
    private float imageQuality = 0.75f;
    private float imageResolution = 96.0f;
    private boolean usePageHeadersAndFooters = false;

    public String getDefaultExtension() {
        return "odt";
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Odt;
    }

    public String getExportNameInMenu() {
        return StiLocalization.Get((String)"Export", (String)"ExportTypeWriterFile");
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }

    public String getFilter() {
        return StiLocalization.Get((String)"FileFilters", (String)"WriterFiles");
    }

    public boolean getRemoveEmptySpaceAtBottom() {
        return this.removeEmptySpaceAtBottom;
    }

    private static String doubleToString(double number) {
        return String.valueOf(StiMath.round((double)(number / 100.0), (int)4)).replace(',', '.') + "in";
    }

    private static String getColumnName(int column) {
        int columnHigh = column / 26;
        int columnLow = column % 26;
        StringBuilder output = new StringBuilder();
        if (columnHigh > 0) {
            output.append((char)(65 + columnHigh - 1));
        }
        output.append((char)(65 + columnLow));
        return output.toString();
    }

    private static String getColorString(StiColor color) {
        return color.toHTML();
    }

    private int getCellStyleNumber(int indexRow, int indexColumn, int height, int width) {
        int index;
        CellStyleData style = new CellStyleData();
        boolean needBorderLeft = true;
        boolean needBorderRight = true;
        for (int index2 = 0; index2 < height; ++index2) {
            if (this.matrix.getBordersY()[indexRow + index2][indexColumn] == null) {
                needBorderLeft = false;
            }
            if (this.matrix.getBordersY()[indexRow + index2][indexColumn + width] != null) continue;
            needBorderRight = false;
        }
        boolean needBorderTop = true;
        boolean needBorderBottom = true;
        for (index = 0; index < width; ++index) {
            if (this.matrix.getBordersX()[indexRow][indexColumn + index] == null) {
                needBorderTop = false;
            }
            if (this.matrix.getBordersX()[indexRow + height][indexColumn + index] != null) continue;
            needBorderBottom = false;
        }
        if (needBorderTop) {
            style.BorderTop = StiOdtExportService.getStringFromBorder(this.matrix.getBordersX()[indexRow][indexColumn]);
        }
        if (needBorderLeft) {
            style.BorderLeft = StiOdtExportService.getStringFromBorder(this.matrix.getBordersY()[indexRow][indexColumn]);
        }
        if (needBorderBottom) {
            style.BorderBottom = StiOdtExportService.getStringFromBorder(this.matrix.getBordersX()[indexRow + height][indexColumn]);
        }
        if (needBorderRight) {
            style.BorderRight = StiOdtExportService.getStringFromBorder(this.matrix.getBordersY()[indexRow][indexColumn + width]);
        }
        if (this.matrix.getCells()[indexRow][indexColumn] != null) {
            float textAngle;
            StiCell cell = this.matrix.getCells()[indexRow][indexColumn];
            style.BackColor = cell.getCellStyle().getColor();
            style.VertAlign = cell.getCellStyle().getVertAlignment();
            if (cell.getCellStyle().getTextOptions() != null && ((textAngle = cell.getCellStyle().getTextOptions().getAngle()) > 45.0f && textAngle < 135.0f || textAngle > 225.0f && textAngle < 315.0f)) {
                if (cell.getCellStyle().getHorAlignment() == StiTextHorAlignment.Left) {
                    style.VertAlign = StiVertAlignment.Bottom;
                }
                if (cell.getCellStyle().getHorAlignment() == StiTextHorAlignment.Center) {
                    style.VertAlign = StiVertAlignment.Center;
                }
                if (cell.getCellStyle().getHorAlignment() == StiTextHorAlignment.Right) {
                    style.VertAlign = StiVertAlignment.Top;
                }
                if (cell.getCellStyle().getHorAlignment() == StiTextHorAlignment.Width) {
                    style.VertAlign = StiVertAlignment.Bottom;
                }
            }
        }
        if (this.cellStyleList.size() > 0) {
            for (index = 0; index < this.cellStyleList.size(); ++index) {
                CellStyleData tempStyle = this.cellStyleList.get(index);
                if (tempStyle.BorderLeft != style.BorderLeft || tempStyle.BorderRight != style.BorderRight || tempStyle.BorderTop != style.BorderTop || tempStyle.BorderBottom != style.BorderBottom || tempStyle.BackColor != style.BackColor || tempStyle.VertAlign != style.VertAlign) continue;
                return index;
            }
        }
        this.cellStyleList.add(style);
        int temp = this.cellStyleList.size() - 1;
        return temp;
    }

    private static String getStringFromBorder(StiBorderSide border) {
        return String.format("%s solid %s", StiOdtExportService.doubleToString(border.getSize()), StiOdtExportService.getColorString(border.getColor()));
    }

    private int getParagraphStyleNumber(int indexRow, int indexColumn) {
        StiCellStyle cellStyle = this.matrix.getCells()[indexRow][indexColumn].getCellStyle();
        ParagraphStyleData style = new ParagraphStyleData();
        style.FontName = cellStyle.getFont().getName();
        style.FontSize = (float)cellStyle.getFont().size;
        style.Bold = cellStyle.getFont().bold();
        style.Italic = cellStyle.getFont().italic();
        style.Underline = cellStyle.getFont().underline();
        style.FontColor = cellStyle.getTextColor();
        style.HorAlign = cellStyle.getHorAlignment();
        float textAngle = 0.0f;
        if (cellStyle.getTextOptions() != null) {
            textAngle = cellStyle.getTextOptions().getAngle();
        }
        if (textAngle > 45.0f && textAngle < 135.0f) {
            style.Angle = 90;
        }
        if (textAngle > 225.0f && textAngle < 315.0f) {
            style.Angle = 270;
        }
        if (style.Angle != 0) {
            if (cellStyle.getVertAlignment() == StiVertAlignment.Top) {
                style.HorAlign = StiTextHorAlignment.Left;
            }
            if (cellStyle.getVertAlignment() == StiVertAlignment.Center) {
                style.HorAlign = StiTextHorAlignment.Center;
            }
            if (cellStyle.getVertAlignment() == StiVertAlignment.Bottom) {
                style.HorAlign = StiTextHorAlignment.Right;
            }
        }
        if (this.paragraphStyleList.size() > 0) {
            for (int index = 0; index < this.paragraphStyleList.size(); ++index) {
                ParagraphStyleData tempStyle = this.paragraphStyleList.get(index);
                if (tempStyle.FontName != style.FontName || tempStyle.FontSize != style.FontSize || tempStyle.Bold != style.Bold || tempStyle.Italic != style.Italic || tempStyle.Underline != style.Underline || tempStyle.FontColor != style.FontColor || tempStyle.HorAlign != style.HorAlign || tempStyle.Angle != style.Angle) continue;
                return index;
            }
        }
        this.paragraphStyleList.add(style);
        int temp = this.paragraphStyleList.size() - 1;
        return temp;
    }

    private byte[] writeMimetype() {
        return "application/vnd.oasis.opendocument.text".getBytes();
    }

    private Document writeMeta() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element officeEl = doc.createElement("office:document-meta");
        doc.appendChild(officeEl);
        officeEl.setAttribute("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        officeEl.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        officeEl.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        officeEl.setAttribute("xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        officeEl.setAttribute("xmlns:ooo", "http://openoffice.org/2004/office");
        officeEl.setAttribute("office:version", "1.1");
        Element metaEl = doc.createElement("office:meta");
        officeEl.appendChild(metaEl);
        String dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH).format(new Date());
        Element el = doc.createElement("meta:generator");
        officeEl.appendChild(el);
        el.setTextContent("Stimulsoft Reports");
        el = doc.createElement("meta:creation-date");
        officeEl.appendChild(el);
        el.setTextContent(dateTime);
        el = doc.createElement("dc:date");
        officeEl.appendChild(el);
        el.setTextContent(dateTime);
        el = doc.createElement("meta:editing-cycles");
        officeEl.appendChild(el);
        el.setTextContent("1");
        el = doc.createElement("meta:editing-duration");
        officeEl.appendChild(el);
        el.setTextContent("PT0M01S");
        Element userEl = doc.createElement("meta:user-defined");
        officeEl.appendChild(userEl);
        userEl.setAttribute("meta:name", "Info 1");
        userEl = doc.createElement("meta:user-defined");
        officeEl.appendChild(userEl);
        userEl.setAttribute("meta:name", "Info 2");
        userEl = doc.createElement("meta:user-defined");
        officeEl.appendChild(userEl);
        userEl.setAttribute("meta:name", "Info 3");
        userEl = doc.createElement("meta:user-defined");
        officeEl.appendChild(userEl);
        userEl.setAttribute("meta:name", "Info 4");
        Element statisticEl = doc.createElement("meta:document-statistic");
        officeEl.appendChild(statisticEl);
        statisticEl.setAttribute("meta:table-count", "1");
        statisticEl.setAttribute("meta:image-count", "0");
        statisticEl.setAttribute("meta:object-count", "0");
        statisticEl.setAttribute("meta:page-count", "1");
        statisticEl.setAttribute("meta:paragraph-count", "1");
        statisticEl.setAttribute("meta:word-count", "1");
        statisticEl.setAttribute("meta:character-count", "1");
        return doc;
    }

    private Document writeManifest() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element mainfestEl = doc.createElement("manifest:manifest");
        doc.appendChild(mainfestEl);
        mainfestEl.setAttribute("xmlns:manifest", "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0");
        Element fileEl = doc.createElement("manifest:file-entry");
        mainfestEl.appendChild(fileEl);
        fileEl.setAttribute("manifest:media-type", "application/vnd.oasis.opendocument.text");
        fileEl.setAttribute("manifest:full-path", "/");
        for (int index = 0; index < this.imageCache.imageStore.size(); ++index) {
            fileEl = doc.createElement("manifest:file-entry");
            mainfestEl.appendChild(fileEl);
            fileEl.setAttribute("manifest:media-type", "image/jpeg");
            fileEl.setAttribute("manifest:full-path", String.format("Pictures/%05d.jpg", index + 1));
        }
        fileEl = doc.createElement("manifest:file-entry");
        mainfestEl.appendChild(fileEl);
        fileEl.setAttribute("manifest:media-type", "text/xml");
        fileEl.setAttribute("manifest:full-path", "content.xml");
        fileEl = doc.createElement("manifest:file-entry");
        mainfestEl.appendChild(fileEl);
        fileEl.setAttribute("manifest:media-type", "text/xml");
        fileEl.setAttribute("manifest:full-path", "styles.xml");
        fileEl = doc.createElement("manifest:file-entry");
        mainfestEl.appendChild(fileEl);
        fileEl.setAttribute("manifest:media-type", "text/xml");
        fileEl.setAttribute("manifest:full-path", "meta.xml");
        fileEl = doc.createElement("manifest:file-entry");
        mainfestEl.appendChild(fileEl);
        fileEl.setAttribute("manifest:media-type", "text/xml");
        fileEl.setAttribute("manifest:full-path", "settings.xml");
        return doc;
    }

    private byte[] writeImage(int index) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StiImageHelper.saveWithDPI(this.imageCache.getImageByIndex(index), out, StiImageFormat.Jpeg, (Integer)72, this.imageQuality);
        byte[] bytes = out.toByteArray();
        out.close();
        return bytes;
    }

    private Document writeSettings() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("office:document-settings");
        writer.writeAttributeString("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        writer.writeAttributeString("xmlns:xlink", "http://www.w3.org/1999/xlink");
        writer.writeAttributeString("xmlns:config", "urn:oasis:names:tc:opendocument:xmlns:config:1.0");
        writer.writeAttributeString("xmlns:ooo", "http://openoffice.org/2004/office");
        writer.writeAttributeString("office:version", "1.1");
        writer.writeStartElement("office:settings");
        writer.writeStartElement("config:config-item-set");
        writer.writeAttributeString("config:name", "ooo:view-settings");
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ViewAreaTop");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ViewAreaLeft");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("-10107");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ViewAreaWidth");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("43208");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ViewAreaHeight");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("22174");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ShowRedlineChanges");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "InBrowseMode");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item-map-indexed");
        writer.writeAttributeString("config:name", "Views");
        writer.writeStartElement("config:config-item-map-entry");
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ViewId");
        writer.writeAttributeString("config:type", "string");
        writer.writeString("view2");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ViewLeft");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("3002");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ViewTop");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("10435");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "VisibleLeft");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("-10107");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "VisibleTop");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "VisibleRight");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("33099");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "VisibleBottom");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("22172");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ZoomType");
        writer.writeAttributeString("config:type", "short");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ZoomFactor");
        writer.writeAttributeString("config:type", "short");
        writer.writeString("100");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "IsSelectedFrame");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("config:config-item-set");
        writer.writeAttributeString("config:name", "ooo:configuration-settings");
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "AddParaTableSpacing");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintReversed");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "OutlineLevelYieldsNumbering");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "LinkUpdateMode");
        writer.writeAttributeString("config:type", "short");
        writer.writeString("1");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintEmptyPages");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "IgnoreFirstLineIndentInNumbering");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "CharacterCompressionType");
        writer.writeAttributeString("config:type", "short");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintSingleJobs");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "UpdateFromTemplate");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintPaperFromSetup");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "AddFrameOffsets");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintLeftPages");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "RedlineProtectionKey");
        writer.writeAttributeString("config:type", "base64Binary");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintTables");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ChartAutoUpdate");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintControls");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrinterSetup");
        writer.writeAttributeString("config:type", "base64Binary");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "IgnoreTabsAndBlanksForLineCalculation");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintAnnotationMode");
        writer.writeAttributeString("config:type", "short");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "LoadReadonly");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "AddParaSpacingToTableCells");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "AddExternalLeading");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ApplyUserData");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "FieldAutoUpdate");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "SaveVersionOnClose");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "SaveGlobalDocumentLinks");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "IsKernAsianPunctuation");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "AlignTabStopPosition");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ClipAsCharacterAnchoredWriterFlyFrames");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "CurrentDatabaseDataSource");
        writer.writeAttributeString("config:type", "string");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "DoNotCaptureDrawObjsOnPage");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "TableRowKeep");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrinterName");
        writer.writeAttributeString("config:type", "string");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintFaxName");
        writer.writeAttributeString("config:type", "string");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ConsiderTextWrapOnObjPos");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "UseOldPrinterMetrics");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintRightPages");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "IsLabelDocument");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "UseFormerLineSpacing");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "AddParaTableSpacingAtStart");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "UseFormerTextWrapping");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "DoNotResetParaAttrsForNumFont");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintProspect");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintGraphics");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "AllowPrintJobCancel");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "CurrentDatabaseCommandType");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "DoNotJustifyLinesWithManualBreak");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "UseFormerObjectPositioning");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrinterIndependentLayout");
        writer.writeAttributeString("config:type", "string");
        writer.writeString("high-resolution");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "UseOldNumbering");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintPageBackground");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "CurrentDatabaseCommand");
        writer.writeAttributeString("config:type", "string");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintDrawings");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrintBlackFonts");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "UnxForceZeroExtLeading");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeEndElement();
        return writer.getDocument();
    }

    private Document writeStyles(StiPagesCollection pages) throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("office:document-styles");
        writer.setAttribute("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        writer.setAttribute("xmlns:style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        writer.setAttribute("xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        writer.setAttribute("xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        writer.setAttribute("xmlns:draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        writer.setAttribute("xmlns:fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        writer.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        writer.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        writer.setAttribute("xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        writer.setAttribute("xmlns:number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        writer.setAttribute("xmlns:svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        writer.setAttribute("xmlns:chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        writer.setAttribute("xmlns:dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        writer.setAttribute("xmlns:math", "http://www.w3.org/1998/Math/MathML");
        writer.setAttribute("xmlns:form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        writer.setAttribute("xmlns:script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        writer.setAttribute("xmlns:ooo", "http://openoffice.org/2004/office");
        writer.setAttribute("xmlns:ooow", "http://openoffice.org/2004/writer");
        writer.setAttribute("xmlns:oooc", "http://openoffice.org/2004/calc");
        writer.setAttribute("xmlns:dom", "http://www.w3.org/2001/xml-events");
        writer.setAttribute("office:version", "1.1");
        writer.writeStartElement("office:font-face-decls");
        writer.writeStartElement("style:font-face");
        writer.setAttribute("style:name", "Arial");
        writer.setAttribute("svg:font-family", "Arial");
        writer.writeEndElement();
        writer.writeStartElement("style:font-face");
        writer.setAttribute("style:name", "Tahoma");
        writer.setAttribute("svg:font-family", "Tahoma");
        writer.setAttribute("style:font-family-generic", "system");
        writer.setAttribute("style:font-pitch", "variable");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("office:styles");
        writer.writeStartElement("style:default-style");
        writer.setAttribute("style:family", "graphic");
        writer.writeStartElement("style:graphic-properties");
        writer.setAttribute("draw:shadow-offset-x", "0.3cm");
        writer.setAttribute("draw:shadow-offset-y", "0.3cm");
        writer.setAttribute("draw:start-line-spacing-horizontal", "0.283cm");
        writer.setAttribute("draw:start-line-spacing-vertical", "0.283cm");
        writer.setAttribute("draw:end-line-spacing-horizontal", "0.283cm");
        writer.setAttribute("draw:end-line-spacing-vertical", "0.283cm");
        writer.setAttribute("style:flow-with-text", "false");
        writer.writeEndElement();
        writer.writeStartElement("style:paragraph-properties");
        writer.setAttribute("style:text-autospace", "ideograph-alpha");
        writer.setAttribute("style:line-break", "strict");
        writer.setAttribute("style:writing-mode", "lr-tb");
        writer.setAttribute("style:font-independent-line-spacing", "false");
        writer.writeStartElement("style:tab-stops");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:text-properties");
        writer.setAttribute("style:use-window-font-color", "true");
        writer.setAttribute("fo:font-size", "10pt");
        writer.setAttribute("style:letter-kerning", "true");
        writer.setAttribute("style:font-size-asian", "12pt");
        writer.setAttribute("style:language-asian", "zxx");
        writer.setAttribute("style:country-asian", "none");
        writer.setAttribute("style:font-size-complex", "12pt");
        writer.setAttribute("style:language-complex", "zxx");
        writer.setAttribute("style:country-complex", "none");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:default-style");
        writer.setAttribute("style:family", "paragraph");
        writer.writeStartElement("style:paragraph-properties");
        writer.setAttribute("fo:hyphenation-ladder-count", "no-limit");
        writer.setAttribute("style:text-autospace", "ideograph-alpha");
        writer.setAttribute("style:punctuation-wrap", "hanging");
        writer.setAttribute("style:line-break", "strict");
        writer.setAttribute("style:tab-stop-distance", "1.251cm");
        writer.setAttribute("style:writing-mode", "page");
        writer.writeEndElement();
        writer.writeStartElement("style:text-properties");
        writer.setAttribute("style:use-window-font-color", "true");
        writer.setAttribute("style:font-name", "Arial");
        writer.setAttribute("fo:font-size", "10pt");
        writer.setAttribute("style:letter-kerning", "true");
        writer.setAttribute("style:font-name-asian", "Lucida Sans Unicode");
        writer.setAttribute("style:font-size-asian", "12pt");
        writer.setAttribute("style:language-asian", "zxx");
        writer.setAttribute("style:country-asian", "none");
        writer.setAttribute("style:font-name-complex", "Tahoma");
        writer.setAttribute("style:font-size-complex", "12pt");
        writer.setAttribute("style:language-complex", "zxx");
        writer.setAttribute("style:country-complex", "none");
        writer.setAttribute("fo:hyphenate", "false");
        writer.setAttribute("fo:hyphenation-remain-char-count", "2");
        writer.setAttribute("fo:hyphenation-push-char-count", "2");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:default-style");
        writer.setAttribute("style:family", "table");
        writer.writeStartElement("style:table-properties");
        writer.setAttribute("table:border-model", "collapsing");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:default-style");
        writer.setAttribute("style:family", "table-row");
        writer.writeStartElement("style:table-row-properties");
        writer.setAttribute("fo:keep-together", "auto");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.setAttribute("style:name", "Standard");
        writer.setAttribute("style:family", "paragraph");
        writer.setAttribute("style:class", "text");
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.setAttribute("style:name", "Title");
        writer.setAttribute("style:family", "paragraph");
        writer.setAttribute("style:parent-style-name", "Standard");
        writer.setAttribute("style:next-style-name", "Text_20_body");
        writer.setAttribute("style:class", "text");
        writer.writeStartElement("style:paragraph-properties");
        writer.setAttribute("fo:margin-top", "0.423cm");
        writer.setAttribute("fo:margin-bottom", "0.212cm");
        writer.setAttribute("fo:keep-with-next", "always");
        writer.writeEndElement();
        writer.writeStartElement("style:text-properties");
        writer.setAttribute("style:font-name", "Arial1");
        writer.setAttribute("fo:font-size", "14pt");
        writer.setAttribute("style:font-name-asian", "Lucida Sans Unicode");
        writer.setAttribute("style:font-size-asian", "14pt");
        writer.setAttribute("style:font-name-complex", "Tahoma");
        writer.setAttribute("style:font-size-complex", "14pt");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.setAttribute("style:name", "Text_20_body");
        writer.setAttribute("style:display-name", "Text body");
        writer.setAttribute("style:family", "paragraph");
        writer.setAttribute("style:parent-style-name", "Standard");
        writer.setAttribute("style:class", "text");
        writer.writeStartElement("style:paragraph-properties");
        writer.setAttribute("fo:margin-top", "0cm");
        writer.setAttribute("fo:margin-bottom", "0.212cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.setAttribute("style:name", "Subtitle");
        writer.setAttribute("style:family", "paragraph");
        writer.setAttribute("style:parent-style-name", "Title");
        writer.setAttribute("style:next-style-name", "Text_20_body");
        writer.setAttribute("style:class", "chapter");
        writer.writeStartElement("style:paragraph-properties");
        writer.setAttribute("fo:text-align", "center");
        writer.setAttribute("style:justify-single-word", "false");
        writer.writeEndElement();
        writer.writeStartElement("style:text-properties");
        writer.setAttribute("fo:font-size", "14pt");
        writer.setAttribute("fo:font-style", "italic");
        writer.setAttribute("style:font-size-asian", "14pt");
        writer.setAttribute("style:font-style-asian", "italic");
        writer.setAttribute("style:font-size-complex", "14pt");
        writer.setAttribute("style:font-style-complex", "italic");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.setAttribute("style:name", "List");
        writer.setAttribute("style:family", "paragraph");
        writer.setAttribute("style:parent-style-name", "Text_20_body");
        writer.setAttribute("style:class", "list");
        writer.writeStartElement("style:text-properties");
        writer.setAttribute("style:font-name", "Arial");
        writer.setAttribute("style:font-name-complex", "Tahoma1");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.setAttribute("style:name", "Caption");
        writer.setAttribute("style:family", "paragraph");
        writer.setAttribute("style:parent-style-name", "Standard");
        writer.setAttribute("style:class", "extra");
        writer.writeStartElement("style:paragraph-properties");
        writer.setAttribute("fo:margin-top", "0.212cm");
        writer.setAttribute("fo:margin-bottom", "0.212cm");
        writer.setAttribute("text:number-lines", "false");
        writer.setAttribute("text:line-number", "0");
        writer.writeEndElement();
        writer.writeStartElement("style:text-properties");
        writer.setAttribute("style:font-name", "Arial");
        writer.setAttribute("fo:font-size", "10pt");
        writer.setAttribute("fo:font-style", "italic");
        writer.setAttribute("style:font-size-asian", "12pt");
        writer.setAttribute("style:font-style-asian", "italic");
        writer.setAttribute("style:font-name-complex", "Tahoma1");
        writer.setAttribute("style:font-size-complex", "12pt");
        writer.setAttribute("style:font-style-complex", "italic");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.setAttribute("style:name", "Index");
        writer.setAttribute("style:family", "paragraph");
        writer.setAttribute("style:parent-style-name", "Standard");
        writer.setAttribute("style:class", "index");
        writer.writeStartElement("style:paragraph-properties");
        writer.setAttribute("text:number-lines", "false");
        writer.setAttribute("text:line-number", "0");
        writer.writeEndElement();
        writer.writeStartElement("style:text-properties");
        writer.setAttribute("style:font-name", "Arial");
        writer.setAttribute("style:font-name-complex", "Tahoma1");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.setAttribute("style:name", "Table_20_Contents");
        writer.setAttribute("style:display-name", "Table Contents");
        writer.setAttribute("style:family", "paragraph");
        writer.setAttribute("style:parent-style-name", "Standard");
        writer.setAttribute("style:class", "extra");
        writer.writeStartElement("style:paragraph-properties");
        writer.setAttribute("text:number-lines", "false");
        writer.setAttribute("text:line-number", "0");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.setAttribute("style:name", "Graphics");
        writer.setAttribute("style:family", "graphic");
        writer.writeStartElement("style:graphic-properties");
        writer.setAttribute("text:anchor-type", "paragraph");
        writer.setAttribute("svg:x", "0cm");
        writer.setAttribute("svg:y", "0cm");
        writer.setAttribute("style:wrap", "dynamic");
        writer.setAttribute("style:number-wrapped-paragraphs", "no-limit");
        writer.setAttribute("style:wrap-contour", "false");
        writer.setAttribute("style:vertical-pos", "top");
        writer.setAttribute("style:vertical-rel", "paragraph");
        writer.setAttribute("style:horizontal-pos", "center");
        writer.setAttribute("style:horizontal-rel", "paragraph");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("text:outline-style");
        writer.writeStartElement("text:outline-level-style");
        writer.setAttribute("text:level", "1");
        writer.setAttribute("style:num-format", "");
        writer.writeStartElement("style:list-level-properties");
        writer.setAttribute("text:min-label-distance", "0.381cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("text:outline-level-style");
        writer.setAttribute("text:level", "2");
        writer.setAttribute("style:num-format", "");
        writer.writeStartElement("style:list-level-properties");
        writer.setAttribute("text:min-label-distance", "0.381cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("text:outline-level-style");
        writer.setAttribute("text:level", "3");
        writer.setAttribute("style:num-format", "");
        writer.writeStartElement("style:list-level-properties");
        writer.setAttribute("text:min-label-distance", "0.381cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("text:outline-level-style");
        writer.setAttribute("text:level", "4");
        writer.setAttribute("style:num-format", "");
        writer.writeStartElement("style:list-level-properties");
        writer.setAttribute("text:min-label-distance", "0.381cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("text:outline-level-style");
        writer.setAttribute("text:level", "5");
        writer.setAttribute("style:num-format", "");
        writer.writeStartElement("style:list-level-properties");
        writer.setAttribute("text:min-label-distance", "0.381cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("text:outline-level-style");
        writer.setAttribute("text:level", "6");
        writer.setAttribute("style:num-format", "");
        writer.writeStartElement("style:list-level-properties");
        writer.setAttribute("text:min-label-distance", "0.381cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("text:outline-level-style");
        writer.setAttribute("text:level", "7");
        writer.setAttribute("style:num-format", "");
        writer.writeStartElement("style:list-level-properties");
        writer.setAttribute("text:min-label-distance", "0.381cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("text:outline-level-style");
        writer.setAttribute("text:level", "8");
        writer.setAttribute("style:num-format", "");
        writer.writeStartElement("style:list-level-properties");
        writer.setAttribute("text:min-label-distance", "0.381cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("text:outline-level-style");
        writer.setAttribute("text:level", "9");
        writer.setAttribute("style:num-format", "");
        writer.writeStartElement("style:list-level-properties");
        writer.setAttribute("text:min-label-distance", "0.381cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("text:outline-level-style");
        writer.setAttribute("text:level", "10");
        writer.setAttribute("style:num-format", "");
        writer.writeStartElement("style:list-level-properties");
        writer.setAttribute("text:min-label-distance", "0.381cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("text:notes-configuration");
        writer.setAttribute("text:note-class", "footnote");
        writer.setAttribute("style:num-format", "1");
        writer.setAttribute("text:start-value", "0");
        writer.setAttribute("text:footnotes-position", "page");
        writer.setAttribute("text:start-numbering-at", "document");
        writer.writeEndElement();
        writer.writeStartElement("text:notes-configuration");
        writer.setAttribute("text:note-class", "endnote");
        writer.setAttribute("style:num-format", "i");
        writer.setAttribute("text:start-value", "0");
        writer.writeEndElement();
        writer.writeStartElement("text:linenumbering-configuration");
        writer.setAttribute("text:number-lines", "false");
        writer.setAttribute("text:offset", "0.499cm");
        writer.setAttribute("style:num-format", "1");
        writer.setAttribute("text:number-position", "left");
        writer.setAttribute("text:increment", "5");
        writer.writeEndElement();
        writer.writeEndElement();
        StiPage page = pages.get(0);
        double pageHeight = page.getUnit().ConvertToHInches(page.getPageHeight() * (double)page.getSegmentPerHeight());
        double pageWidth = page.getUnit().ConvertToHInches(page.getPageWidth() * (double)page.getSegmentPerWidth());
        double mgLeft = page.getUnit().ConvertToHInches(page.getMargins().getLeft());
        double mgRight = page.getUnit().ConvertToHInches(page.getMargins().getRight());
        double mgTop = page.getUnit().ConvertToHInches(page.getMargins().getTop());
        double mgBottom = page.getUnit().ConvertToHInches(page.getMargins().getBottom()) - 4.0;
        if (mgBottom < 0.0) {
            mgBottom = 0.0;
        }
        writer.writeStartElement("office:automatic-styles");
        writer.writeStartElement("style:page-layout");
        writer.setAttribute("style:name", "pm1");
        writer.writeStartElement("style:page-layout-properties");
        writer.setAttribute("fo:page-width", StiOdtExportService.doubleToString(pageWidth));
        writer.setAttribute("fo:page-height", StiOdtExportService.doubleToString(pageHeight));
        writer.setAttribute("style:num-format", "1");
        writer.setAttribute("style:print-orientation", page.getOrientation() == StiPageOrientation.Portrait ? "portrait" : "landscape");
        writer.setAttribute("fo:margin-top", StiOdtExportService.doubleToString(mgTop));
        writer.setAttribute("fo:margin-bottom", StiOdtExportService.doubleToString(mgBottom));
        writer.setAttribute("fo:margin-left", StiOdtExportService.doubleToString(mgLeft));
        writer.setAttribute("fo:margin-right", StiOdtExportService.doubleToString(mgRight));
        writer.setAttribute("style:writing-mode", "lr-tb");
        writer.setAttribute("style:footnote-max-height", "0cm");
        writer.writeStartElement("style:footnote-sep");
        writer.setAttribute("style:width", "0.018cm");
        writer.setAttribute("style:distance-before-sep", "0.101cm");
        writer.setAttribute("style:distance-after-sep", "0.101cm");
        writer.setAttribute("style:adjustment", "left");
        writer.setAttribute("style:rel-width", "25%");
        writer.setAttribute("style:color", "#000000");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:header-style");
        writer.writeEndElement();
        writer.writeStartElement("style:footer-style");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("office:master-styles");
        writer.writeStartElement("style:master-page");
        writer.setAttribute("style:name", "Standard");
        writer.setAttribute("style:page-layout-name", "pm1");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeContent() throws ParserConfigurationException {
        int indexStyle;
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("office:document-content");
        writer.setAttribute("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        writer.setAttribute("xmlns:style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        writer.setAttribute("xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        writer.setAttribute("xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        writer.setAttribute("xmlns:draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        writer.setAttribute("xmlns:fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        writer.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        writer.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        writer.setAttribute("xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        writer.setAttribute("xmlns:number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        writer.setAttribute("xmlns:svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        writer.setAttribute("xmlns:chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        writer.setAttribute("xmlns:dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        writer.setAttribute("xmlns:math", "http://www.w3.org/1998/Math/MathML");
        writer.setAttribute("xmlns:form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        writer.setAttribute("xmlns:script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        writer.setAttribute("xmlns:ooo", "http://openoffice.org/2004/office");
        writer.setAttribute("xmlns:ooow", "http://openoffice.org/2004/writer");
        writer.setAttribute("xmlns:oooc", "http://openoffice.org/2004/calc");
        writer.setAttribute("xmlns:dom", "http://www.w3.org/2001/xml-events");
        writer.setAttribute("xmlns:xforms", "http://www.w3.org/2002/xforms");
        writer.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        writer.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.setAttribute("office:version", "1.1");
        boolean[][] readyCells = new boolean[this.matrix.getCoordY().size()][this.matrix.getCoordX().size()];
        int[][] cellStyleTable = new int[this.matrix.getCoordY().size()][this.matrix.getCoordX().size()];
        Hashtable<Double, Integer> rowHeightList = new Hashtable<Double, Integer>();
        Hashtable<Integer, Double> rowHeightList2 = new Hashtable<Integer, Double>();
        int[] rowPosList = new int[this.matrix.getCoordY().size()];
        for (int indexRow = 1; indexRow < this.matrix.getCoordY().size(); ++indexRow) {
            double rowHeight = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), indexRow) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), indexRow - 1);
            if (!rowHeightList.containsKey(rowHeight)) {
                int listPos = rowHeightList.size();
                rowHeightList.put(rowHeight, listPos);
                rowHeightList2.put(listPos, rowHeight);
            }
            rowPosList[indexRow - 1] = (Integer)rowHeightList.get(rowHeight);
            for (int indexColumn = 1; indexColumn < this.matrix.getCoordX().size(); ++indexColumn) {
                StiCell cell = this.matrix.getCells()[indexRow - 1][indexColumn - 1];
                if (readyCells[indexRow][indexColumn]) continue;
                if (cell != null) {
                    int yy;
                    for (yy = 0; yy <= cell.getHeight(); ++yy) {
                        for (int xx = 0; xx <= cell.getWidth(); ++xx) {
                            readyCells[indexRow + yy][indexColumn + xx] = true;
                        }
                    }
                    cellStyleTable[indexRow - 1][indexColumn - 1] = this.getCellStyleNumber(indexRow - 1, indexColumn - 1, cell.getHeight() + 1, cell.getWidth() + 1);
                    yy = this.getParagraphStyleNumber(indexRow - 1, indexColumn - 1);
                    continue;
                }
                cellStyleTable[indexRow - 1][indexColumn - 1] = this.getCellStyleNumber(indexRow - 1, indexColumn - 1, 1, 1);
            }
        }
        writer.writeStartElement("office:scripts");
        writer.writeEndElement();
        Hashtable<String, String> fonts = new Hashtable<String, String>();
        for (ParagraphStyleData par : this.paragraphStyleList) {
            fonts.put(par.FontName, par.FontName);
        }
        writer.writeStartElement("office:font-face-decls");
        for (String key : fonts.keySet()) {
            String fontName = (String)fonts.get(key);
            writer.writeStartElement("style:font-face");
            writer.setAttribute("style:name", fontName);
            writer.setAttribute("svg:font-family", fontName);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeStartElement("office:automatic-styles");
        writer.writeStartElement("style:style");
        writer.setAttribute("style:name", "Table1");
        writer.setAttribute("style:family", "table");
        writer.writeStartElement("style:table-properties");
        double tableWidth = (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), this.matrix.getCoordX().size() - 1) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), 0);
        writer.setAttribute("style:width", StiOdtExportService.doubleToString(tableWidth));
        writer.setAttribute("table:align", "left");
        writer.writeEndElement();
        writer.writeEndElement();
        for (int indexColumn = 0; indexColumn < this.matrix.getCoordX().size() - 1; ++indexColumn) {
            writer.writeStartElement("style:style");
            writer.setAttribute("style:name", String.format("Table1.%s", StiOdtExportService.getColumnName(indexColumn)));
            writer.setAttribute("style:family", "table-column");
            writer.writeStartElement("style:table-column-properties");
            double columnWidth = (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), indexColumn + 1) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), indexColumn);
            writer.setAttribute("style:column-width", StiOdtExportService.doubleToString(columnWidth));
            writer.writeEndElement();
            writer.writeEndElement();
        }
        for (int indexRow = 0; indexRow < rowHeightList.size(); ++indexRow) {
            writer.writeStartElement("style:style");
            writer.setAttribute("style:name", String.format("Table1.%s", indexRow + 1));
            writer.setAttribute("style:family", "table-row");
            writer.writeStartElement("style:table-row-properties");
            double rowHeight = (Double)rowHeightList2.get(indexRow);
            writer.setAttribute("style:row-height", StiOdtExportService.doubleToString(rowHeight));
            writer.writeEndElement();
            writer.writeEndElement();
        }
        for (indexStyle = 0; indexStyle < this.cellStyleList.size(); ++indexStyle) {
            CellStyleData style = this.cellStyleList.get(indexStyle);
            writer.writeStartElement("style:style");
            writer.setAttribute("style:name", String.format("cell%s", indexStyle + 1));
            writer.setAttribute("style:family", "table-cell");
            writer.writeStartElement("style:table-cell-properties");
            if (style.VertAlign == StiVertAlignment.Center) {
                writer.setAttribute("style:vertical-align", "middle");
            }
            if (style.VertAlign == StiVertAlignment.Bottom) {
                writer.setAttribute("style:vertical-align", "bottom");
            }
            if (style.BackColor != StiColor.Transparent) {
                writer.setAttribute("fo:background-color", StiOdtExportService.getColorString(style.BackColor));
            } else {
                writer.setAttribute("fo:background-color", "transparent");
            }
            writer.setAttribute("fo:padding", "0in");
            writer.setAttribute("fo:border-left", style.BorderLeft);
            writer.setAttribute("fo:border-right", style.BorderRight);
            writer.setAttribute("fo:border-top", style.BorderTop);
            writer.setAttribute("fo:border-bottom", style.BorderBottom);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        for (indexStyle = 0; indexStyle < this.paragraphStyleList.size(); ++indexStyle) {
            ParagraphStyleData style = this.paragraphStyleList.get(indexStyle);
            writer.writeStartElement("style:style");
            writer.setAttribute("style:name", String.format("par%s", indexStyle + 1));
            writer.setAttribute("style:family", "paragraph");
            writer.setAttribute("style:parent-style-name", "Table_20_Contents");
            if (style.HorAlign != StiTextHorAlignment.Left) {
                writer.writeStartElement("style:paragraph-properties");
                if (style.HorAlign == StiTextHorAlignment.Center) {
                    writer.setAttribute("fo:text-align", "center");
                }
                if (style.HorAlign == StiTextHorAlignment.Right) {
                    writer.setAttribute("fo:text-align", "right");
                }
                if (style.HorAlign == StiTextHorAlignment.Width) {
                    writer.setAttribute("fo:text-align", "justify");
                }
                writer.writeEndElement();
            }
            writer.writeStartElement("style:text-properties");
            writer.setAttribute("fo:color", StiOdtExportService.getColorString(style.FontColor));
            writer.setAttribute("style:font-name", style.FontName);
            String fontSizeSt = String.format("%spt", Float.valueOf(style.FontSize)).replace(',', '.');
            writer.setAttribute("fo:font-size", fontSizeSt);
            writer.setAttribute("fo:font-size-asian", fontSizeSt);
            writer.setAttribute("fo:font-size-complex", fontSizeSt);
            if (style.Italic) {
                writer.setAttribute("fo:font-style", "italic");
                writer.setAttribute("fo:font-style-asian", "italic");
                writer.setAttribute("fo:font-style-complex", "italic");
            }
            if (style.Underline) {
                writer.setAttribute("style:text-underline-style", "solid");
                writer.setAttribute("style:text-underline-width", "auto");
                writer.setAttribute("style:text-underline-color", "font-color");
            }
            if (style.Bold) {
                writer.setAttribute("fo:font-weight", "bold");
                writer.setAttribute("fo:font-weight-asian", "bold");
                writer.setAttribute("fo:font-weight-complex", "bold");
            }
            if (style.Angle != 0) {
                writer.setAttribute("style:text-rotation-angle", String.format("%s", style.Angle));
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeStartElement("style:style");
        writer.setAttribute("style:name", "parEnd");
        writer.setAttribute("style:family", "paragraph");
        writer.setAttribute("style:parent-style-name", "Table_20_Contents");
        writer.writeStartElement("style:text-properties");
        String fontSizeStr = String.format("%spt", 1).replace(',', '.');
        writer.setAttribute("fo:font-size", fontSizeStr);
        writer.setAttribute("fo:font-size-asian", fontSizeStr);
        writer.setAttribute("fo:font-size-complex", fontSizeStr);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.setAttribute("style:name", "fr1");
        writer.setAttribute("style:family", "graphic");
        writer.setAttribute("style:parent-style-name", "Graphics");
        writer.writeStartElement("style:graphic-properties");
        writer.setAttribute("style:vertical-pos", "middle");
        writer.setAttribute("style:vertical-rel", "paragraph");
        writer.setAttribute("style:horizontal-pos", "center");
        writer.setAttribute("style:horizontal-rel", "paragraph");
        writer.setAttribute("fo:background-color", "transparent");
        writer.setAttribute("style:background-transparency", "100%");
        writer.setAttribute("style:shadow", "none");
        writer.setAttribute("style:mirror", "none");
        writer.setAttribute("fo:clip", "rect(0cm 0cm 0cm 0cm)");
        writer.setAttribute("draw:luminance", "0%");
        writer.setAttribute("draw:contrast", "0%");
        writer.setAttribute("draw:red", "0%");
        writer.setAttribute("draw:green", "0%");
        writer.setAttribute("draw:blue", "0%");
        writer.setAttribute("draw:gamma", "100%");
        writer.setAttribute("draw:color-inversion", "false");
        writer.setAttribute("draw:image-opacity", "100%");
        writer.setAttribute("draw:color-mode", "standard");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("office:body");
        writer.writeStartElement("office:text");
        writer.writeStartElement("office:forms");
        writer.setAttribute("form:automatic-focus", "false");
        writer.setAttribute("form:apply-design-mode", "false");
        writer.writeEndElement();
        writer.writeStartElement("text:sequence-decls");
        writer.writeStartElement("text:sequence-decl");
        writer.setAttribute("text:display-outline-level", "0");
        writer.setAttribute("text:name", "Illustration");
        writer.writeEndElement();
        writer.writeStartElement("text:sequence-decl");
        writer.setAttribute("text:display-outline-level", "0");
        writer.setAttribute("text:name", "Table");
        writer.writeEndElement();
        writer.writeStartElement("text:sequence-decl");
        writer.setAttribute("text:display-outline-level", "0");
        writer.setAttribute("text:name", "Text");
        writer.writeEndElement();
        writer.writeStartElement("text:sequence-decl");
        writer.setAttribute("text:display-outline-level", "0");
        writer.setAttribute("text:name", "Drawing");
        writer.writeEndElement();
        writer.writeEndElement();
        readyCells = new boolean[this.matrix.getCoordY().size()][this.matrix.getCoordX().size()];
        writer.writeStartElement("table:table");
        writer.setAttribute("table:name", "Table1");
        writer.setAttribute("table:style-name", "Table1");
        for (int indexColumn = 0; indexColumn < this.matrix.getCoordX().size() - 1; ++indexColumn) {
            writer.writeStartElement("table:table-column");
            writer.setAttribute("table:style-name", String.format("Table1.%s", StiOdtExportService.getColumnName(indexColumn)));
            writer.writeEndElement();
        }
        for (int indexRow = 1; indexRow < this.matrix.getCoordY().size(); ++indexRow) {
            writer.writeStartElement("table:table-row");
            writer.setAttribute("table:style-name", String.format("Table1.%s", rowPosList[indexRow - 1] + 1));
            for (int indexColumn = 1; indexColumn < this.matrix.getCoordX().size(); ++indexColumn) {
                StiCell cell = this.matrix.getCells()[indexRow - 1][indexColumn - 1];
                if (!readyCells[indexRow][indexColumn]) {
                    int cellStyleIndex;
                    if (cell != null) {
                        for (int yy = 0; yy <= cell.getHeight(); ++yy) {
                            for (int xx = 0; xx <= cell.getWidth(); ++xx) {
                                readyCells[indexRow + yy][indexColumn + xx] = true;
                            }
                        }
                        cellStyleIndex = cellStyleTable[indexRow - 1][indexColumn - 1];
                        int parStyleIndex = this.getParagraphStyleNumber(indexRow - 1, indexColumn - 1);
                        writer.writeStartElement("table:table-cell");
                        writer.setAttribute("table:style-name", String.format("cell%s", cellStyleIndex + 1));
                        if (cell.getWidth() > 0) {
                            writer.setAttribute("table:number-columns-spanned", String.format("%s", cell.getWidth() + 1));
                        }
                        if (cell.getHeight() > 0) {
                            writer.setAttribute("table:number-rows-spanned", String.format("%s", cell.getHeight() + 1));
                        }
                        writer.setAttribute("office:value-type", "String");
                        if (cell.getComponent() instanceof StiText && !cell.getComponent().isExportAsImage(StiExportFormat.Odt) && cell.getText() != null) {
                            String cellText = cell.getText();
                            if (this.paragraphStyleList.get((int)parStyleIndex).Angle != 0) {
                                cellText = cellText.replace('\n', ' ');
                            }
                            ArrayList<String> stringList = new ArrayList<String>();
                            String st = "";
                            for (char ch : cellText.toCharArray()) {
                                if (Character.isISOControl(ch) && ch != '\t') {
                                    if (ch != '\n') continue;
                                    stringList.add(st);
                                    st = "";
                                    continue;
                                }
                                st = st + ch;
                            }
                            if (st.length() > 0) {
                                stringList.add(st);
                            }
                            if (stringList.size() == 0) {
                                stringList.add(st);
                            }
                            for (int indexLine = 0; indexLine < stringList.size(); ++indexLine) {
                                String textLine = (String)stringList.get(indexLine);
                                writer.writeStartElement("text:p");
                                writer.setAttribute("text:style-name", String.format("par%s", parStyleIndex + 1));
                                writer.setTextContent(textLine);
                                writer.writeEndElement();
                            }
                        }
                        if (cell.getComponent().isExportAsImage(StiExportFormat.Odt)) {
                            float rsImageResolution;
                            BufferedImage image;
                            IStiExportImage exportImage;
                            IStiExportImage iStiExportImage = exportImage = cell.getComponent() instanceof IStiExportImage ? (IStiExportImage)((Object)cell.getComponent()) : null;
                            if (exportImage != null && (image = exportImage.getImage(Double.valueOf(rsImageResolution = this.imageResolution))) != null) {
                                int indexImage = this.imageCache.addImageInt(image);
                                double imageWidth = (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), indexColumn + cell.getWidth()) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), indexColumn - 1);
                                double imageHeight = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), indexRow + cell.getHeight()) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), indexRow - 1);
                                writer.writeStartElement("text:p");
                                writer.setAttribute("text:style-name", "Table_20_Contents");
                                writer.writeStartElement("draw:frame");
                                writer.setAttribute("draw:style-name", "fr1");
                                writer.setAttribute("draw:name", String.format("Picture%s", indexImage + 1));
                                writer.setAttribute("text:anchor-type", "paragraph");
                                writer.setAttribute("svg:width", StiOdtExportService.doubleToString(imageWidth));
                                writer.setAttribute("svg:height", StiOdtExportService.doubleToString(imageHeight));
                                writer.setAttribute("draw:z-index", "0");
                                writer.writeStartElement("draw:image");
                                writer.setAttribute("xlink:href", String.format("Pictures/%05d.jpg", indexImage + 1));
                                writer.setAttribute("xlink:type", "simple");
                                writer.setAttribute("xlink:show", "embed");
                                writer.setAttribute("xlink:actuate", "onLoad");
                                writer.writeEndElement();
                                writer.writeEndElement();
                                writer.writeEndElement();
                            }
                        }
                        writer.writeEndElement();
                        continue;
                    }
                    cellStyleIndex = cellStyleTable[indexRow - 1][indexColumn - 1];
                    writer.writeStartElement("table:table-cell");
                    writer.setAttribute("table:style-name", String.format("cell%s", cellStyleIndex + 1));
                    writer.writeEndElement();
                    continue;
                }
                writer.writeStartElement("table:covered-table-cell");
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeStartElement("text:p");
        writer.setAttribute("text:style-name", "parEnd");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    public void exportOdt(StiReport report, OutputStream outputStream, StiOdtExportSettings settings) throws StiException {
        try {
            this.exportOdtException(report, outputStream, settings);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportOdtException(StiReport report, OutputStream outputStream, StiOdtExportSettings settings) throws IOException, TransformerException, ParserConfigurationException {
        StiLicenseKeyValidator.isValidOnJavaFramework(null);
        StiPagesRange pageRange = settings.getPageRange();
        this.usePageHeadersAndFooters = settings.isUsePageHeadersAndFooters();
        this.removeEmptySpaceAtBottom = settings.isRemoveEmptySpaceAtBottom();
        this.imageResolution = settings.getImageResolution();
        this.imageQuality = settings.getImageQuality();
        if (this.imageQuality < 0.0f) {
            this.imageQuality = 0.0f;
        }
        if (this.imageQuality > 1.0f) {
            this.imageQuality = 1.0f;
        }
        if (this.imageResolution < 10.0f) {
            this.imageResolution = 10.0f;
        }
        this.imageResolution /= 100.0f;
        try {
            this.imageCache = new StiImageCache(ExportOptions.OpenDocumentWriter.allowImageComparer, StiImageFormat.Jpeg, this.imageQuality);
            this.cellStyleList = new ArrayList();
            this.paragraphStyleList = new ArrayList();
            this.currentPassNumber = 0;
            this.maximumPassNumber = 3 + (ExportOptions.OpenDocumentWriter.divideSegmentPages ? 1 : 0);
            StiPagesCollection pages = pageRange.getSelectedPages(report.getRenderedPages());
            if (ExportOptions.OpenDocumentWriter.divideSegmentPages) {
                pages = StiSegmentPagesDivider.divide(pages, this);
                ++this.currentPassNumber;
            }
            if (this.isStoped()) {
                return;
            }
            this.setStatusString(StiLocalization.Get((String)"Export", (String)"ExportingCreatingDocument"));
            StiZipWriter20 zip = new StiZipWriter20(outputStream);
            this.matrix = new StiMatrix(pages, true, this);
            if (this.isStoped()) {
                return;
            }
            this.setStatusString(StiLocalization.Get((String)"Export", (String)"ExportingCreatingDocument"));
            this.currentPassNumber = 2 + (ExportOptions.OpenDocumentWriter.divideSegmentPages ? 1 : 0);
            zip.addFile("", "content.xml", this.writeContent());
            zip.addFile("", "mimetype", this.writeMimetype());
            zip.addFile("", "meta.xml", this.writeMeta());
            zip.addFile("META-INF/", "manifest.xml", this.writeManifest());
            zip.addFile("", "settings.xml", this.writeSettings());
            zip.addFile("", "styles.xml", this.writeStyles(pages));
            if (this.imageCache.imageStore.size() > 0) {
                for (int index = 0; index < this.imageCache.imageStore.size(); ++index) {
                    zip.addFile("Pictures/", String.format("%05d.jpg", index + 1), this.writeImage(index));
                }
            }
            zip.finish();
        }
        finally {
            if (this.matrix != null) {
                this.matrix.clear();
                this.matrix = null;
            }
            this.cellStyleList.clear();
            this.cellStyleList = null;
            this.paragraphStyleList.clear();
            this.paragraphStyleList = null;
            this.imageCache.clear();
            this.imageCache = null;
        }
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings settings) throws StiException {
        this.exportOdt(report, outputStream, (StiOdtExportSettings)settings);
    }

    private class ParagraphStyleData {
        public String FontName = "Arial";
        public float FontSize = 6.0f;
        public boolean Bold = false;
        public boolean Italic = false;
        public boolean Underline = false;
        public StiColor FontColor = StiColorEnum.Black.color();
        public StiTextHorAlignment HorAlign = StiTextHorAlignment.Left;
        public int Angle = 0;
    }

    private class CellStyleData {
        public String BorderLeft = "none";
        public String BorderRight = "none";
        public String BorderTop = "none";
        public String BorderBottom = "none";
        public StiColor BackColor = StiColor.Transparent;
        public StiVertAlignment VertAlign = StiVertAlignment.Bottom;
    }
}

