/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.report.IStiProgressInformation;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.StiExportingEventArgs;
import com.stimulsoft.report.export.StiProgressEmpty;
import com.stimulsoft.report.export.settings.StiExportSettings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class StiExportService {
    public static final long ONE_HOUR = 3600000L;
    public static final long MILLISECONDS_IN_DAY = 86400000L;
    public static final long DATE_1900 = 2208972528000L;
    protected int RenderedPagesCount = 0;
    protected File exFile;
    private IStiProgressInformation progress = new StiProgressEmpty();
    protected String statusString = "";
    protected boolean multipleFiles = false;
    protected OutputStream outputStream;
    protected StiExportSettings exportSettings;
    protected StiReport exportReport;
    protected List<File> exportedFiles = new ArrayList<File>();
    public int currentPassNumber = 0;
    public int maximumPassNumber = 0;

    public void export() throws Throwable {
        try {
            this.export(this.exportReport, this.outputStream, this.exportSettings);
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
            }
        }
    }

    public abstract void export(StiReport var1, OutputStream var2, StiExportSettings var3) throws StiException;

    public void invokeExporting(StiPage page, StiPagesCollection pages) {
        this.invokeExporting(pages.indexOf(page), pages.size());
    }

    public void invokeExporting(int value, int maximum) {
        this.invokeExporting(new StiExportingEventArgs(value, maximum));
    }

    public void invokeExporting(StiExportingEventArgs e) {
        this.progress.setProgressBar(e.getValue(), e.getMaximum());
    }

    protected void closeProgress() {
        if (!this.isStoped()) {
            this.progress.close();
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void export(StiReport report, String filePath) {
        this.export(report, filePath, false);
    }

    public void export(StiReport report, String filePath, boolean sendEMail) {
    }

    public void export(StiReport report) {
        this.export(report, null, false);
    }

    protected void processFile(boolean sendEMail, boolean openAfterExport, String fileName, StiReport report) {
        if (this.isStoped() || sendEMail) {
            // empty if block
        }
    }

    protected void sendEMail(String subject, String body, String filePath) {
        this.sendEMail("", subject, body, filePath);
    }

    protected void sendEMail(String recipient, String subject, String body, String filePath) {
    }

    public abstract boolean getMultipleFiles();

    public abstract StiExportFormat getExportFormat();

    public String getStatusString() {
        return this.statusString;
    }

    public void setStatusString(String statusString) {
        this.statusString = statusString;
        if (this.progress != null) {
            this.progress.update(statusString);
        }
    }

    public boolean isStoped() {
        return this.progress.getIsBreaked();
    }

    public void setProgress(IStiProgressInformation progress) {
        this.progress = progress;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setExportSettings(StiExportSettings exportSettings) {
        this.exportSettings = exportSettings;
    }

    public void setExportReport(StiReport exportReport) {
        this.exportReport = exportReport;
    }

    public void setExFile(File exFile) {
        this.exFile = exFile;
    }

    public File getExFile() {
        return this.exFile;
    }

    public StiExportSettings getExportSettings() {
        return this.exportSettings;
    }

    public List<File> getExportedFiles() {
        return this.exportedFiles;
    }
}

