/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.enums.StiPaperKind;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiRtfHelper;
import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.enums.StiPageOrientation;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiExcelExportSettings;
import com.stimulsoft.report.export.settings.StiExcelXmlExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.tools.StiCell;
import com.stimulsoft.report.export.tools.StiCellStyle;
import com.stimulsoft.report.export.tools.StiMapUtil;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.options.ExportOptions;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiExcelXmlExportService
extends StiExportService {
    private Element element;
    private Document document;
    private String title;
    private StiMatrix matrix = null;

    private String convertColor(StiColor color) {
        return color.toHTML();
    }

    private String convert(double x) {
        x = x / 300.0 * 72.0 * (double)3.2f * 0.96;
        return String.valueOf(StiMath.round((double)x, (int)3));
    }

    private String convertColumn(double x) {
        x = x / 300.0 * 72.0 * (double)3.2f * 0.864 * 1.015;
        return String.valueOf(StiMath.round((double)x, (int)3));
    }

    private String convertPageMargins(double x) {
        return String.valueOf(StiMath.round((double)(x /= 100.0), (int)3));
    }

    private String getLineStyle(StiPenStyle penStyle) {
        switch (penStyle) {
            case Solid: {
                return "Continuous";
            }
            case Dot: {
                return "Dot";
            }
            case Dash: {
                return "Dash";
            }
            case DashDot: {
                return "DashDot";
            }
            case DashDotDot: {
                return "DashDotDot";
            }
            case Double: {
                return "Double";
            }
        }
        return "None";
    }

    private void renderBeginDoc() {
        Element workbookEl = this.document.createElement("Workbook");
        this.document.appendChild(workbookEl);
        workbookEl.setAttribute("xmlns", "urn:schemas-microsoft-com:office:spreadsheet");
        workbookEl.setAttribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        workbookEl.setAttribute("xmlns:x", "urn:schemas-microsoft-com:office:excel");
        workbookEl.setAttribute("xmlns:ss", "urn:schemas-microsoft-com:office:spreadsheet");
        workbookEl.setAttribute("xmlns:html", "http://www.w3.org/TR/REC-html40");
        Element docProperties = this.document.createElement("DocumentProperties");
        workbookEl.appendChild(docProperties);
        docProperties.setAttribute("xmlns", "urn:schemas-microsoft-com:office:office");
        Element excellWorkbookEl = this.document.createElement("ExcelWorkbook");
        workbookEl.appendChild(excellWorkbookEl);
        excellWorkbookEl.setAttribute("xmlns", "urn:schemas-microsoft-com:office:excel");
        Element el = this.document.createElement("WindowTopX");
        excellWorkbookEl.appendChild(el);
        el.setTextContent("0");
        el = this.document.createElement("WindowTopY");
        excellWorkbookEl.appendChild(el);
        el.setTextContent("0");
        el = this.document.createElement("ProtectStructure");
        excellWorkbookEl.appendChild(el);
        el.setTextContent("False");
        el = this.document.createElement("ProtectWindows");
        excellWorkbookEl.appendChild(el);
        el.setTextContent("False");
        this.element = workbookEl;
    }

    private void renderStyles() {
        Element stylesEl = this.document.createElement("Styles");
        this.element.appendChild(stylesEl);
        Integer index = 0;
        while (index < this.matrix.getStyles().size()) {
            StiCellStyle style = this.matrix.getStyles().get(index);
            Element styleEl = this.document.createElement("Style");
            stylesEl.appendChild(styleEl);
            styleEl.setAttribute("ss:ID", "s" + index.toString());
            this.renderAlignment(style, styleEl);
            this.renderFont(style, styleEl);
            this.renderBorders(style, styleEl);
            this.renderInterior(style, styleEl);
            this.renderNumberFormat(style, styleEl);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
    }

    private void renderNumberFormat(StiCellStyle style, Element element) {
        Element numberFormetEl = this.document.createElement("NumberFormat");
        element.appendChild(numberFormetEl);
        if (style.getFormat() != null && !"".equals(style.getFormat())) {
            numberFormetEl.setAttribute("ss:Format", style.getFormat());
        }
    }

    private void renderAlignment(StiCellStyle style, Element element) {
        Element alignmentEl = this.document.createElement("Alignment");
        element.appendChild(alignmentEl);
        if (style.getTextOptions() != null && style.getTextOptions().getRightToLeft()) {
            alignmentEl.setAttribute("ss:ReadingOrder", "RightToLeft");
        }
        if (style.getHorAlignment() == StiTextHorAlignment.Width) {
            alignmentEl.setAttribute("ss:Horizontal", "Justify");
        } else {
            alignmentEl.setAttribute("ss:Horizontal", style.getHorAlignment().toString());
        }
        alignmentEl.setAttribute("ss:Vertical", style.getVertAlignment().toString());
        if (style.getTextOptions() != null) {
            if (style.getTextOptions().getWordWrap() || style.isWordWrap()) {
                alignmentEl.setAttribute("ss:WrapText", "1");
            }
            alignmentEl.setAttribute("ss:Rotate", String.format("%s", Float.valueOf(style.getTextOptions().getAngle())));
        }
    }

    private void renderFont(StiCellStyle style, Element element) {
        Element fontEl = this.document.createElement("Font");
        element.appendChild(fontEl);
        fontEl.setAttribute("ss:FontName", style.getFont().getName());
        fontEl.setAttribute("ss:Size", String.format("%s", style.getFont().getSize()));
        if (style.getFont().bold()) {
            fontEl.setAttribute("ss:Bold", "1");
        }
        if (style.getFont().italic()) {
            fontEl.setAttribute("ss:Italic", "1");
        }
        if (style.getFont().strikeout()) {
            fontEl.setAttribute("ss:StrikeThrough", "1");
        }
        if (style.getFont().underline()) {
            fontEl.setAttribute("ss:Underline", "Single");
        }
        fontEl.setAttribute("ss:Color", this.convertColor(style.getTextColor()));
    }

    private void renderBorder(StiBorderSide border, String position, Element element) {
        if (border != null && border.getStyle() != StiPenStyle.None) {
            Element borderEl = this.document.createElement("Border");
            element.appendChild(borderEl);
            borderEl.setAttribute("ss:Position", position);
            borderEl.setAttribute("ss:LineStyle", this.getLineStyle(border.getStyle()));
            Double borderSize = border.getSize();
            if (borderSize > 3.0) {
                borderSize = 3.0;
            }
            borderEl.setAttribute("ss:Weight", borderSize.toString());
            borderEl.setAttribute("ss:Color", this.convertColor(border.getColor()));
        }
    }

    private void renderBorders(StiCellStyle style, Element element) {
        if (style.getBorder() != null || style.getBorderL() != null || style.getBorderR() != null || style.getBorderB() != null) {
            Element bordersEl = this.document.createElement("Borders");
            element.appendChild(bordersEl);
            this.renderBorder(style.getBorderL(), "Left", bordersEl);
            this.renderBorder(style.getBorderR(), "Right", bordersEl);
            this.renderBorder(style.getBorder(), "Top", bordersEl);
            this.renderBorder(style.getBorderB(), "Bottom", bordersEl);
        }
    }

    private void renderInterior(StiCellStyle style, Element element) {
        Element interiorEl = this.document.createElement("Interior");
        element.appendChild(interiorEl);
        if (style.getColor().getA() != 0 && !StiColorEnum.White.color().equals(style.getColor())) {
            interiorEl.setAttribute("ss:Color", this.convertColor(style.getColor()));
            interiorEl.setAttribute("ss:Pattern", "Solid");
        }
    }

    private void renderWorksheetOptions(StiPage page, Element element) {
        int paneX = 0;
        int paneY = 0;
        if (ExportOptions.ExcelXml.getAllowFreezePanes()) {
            block0: for (int indexRow = 0; indexRow < this.matrix.getCoordY().size() - 1; ++indexRow) {
                for (int indexColumn = 0; indexColumn < this.matrix.getCoordX().size() - 1; ++indexColumn) {
                    String stPlacement;
                    StiCell cell = this.matrix.getCells()[indexRow][indexColumn];
                    if (cell == null || cell.getComponent() == null || !cell.getComponent().getLocked() && (cell.getComponent().getTagValue() == null || !cell.getComponent().getTagValue().toString().contains("excelfreezepanes")) || (stPlacement = cell.getComponent().getComponentPlacement()) == null || stPlacement.length() <= 0 || !stPlacement.startsWith("rt") && !stPlacement.startsWith("ph") && !stPlacement.startsWith("h")) continue;
                    paneX = cell.getLeft();
                    paneY = cell.getTop() + cell.getHeight() + 1;
                    continue block0;
                }
            }
        }
        Element worksheetOptionsEl = this.document.createElement("WorksheetOptions");
        element.appendChild(worksheetOptionsEl);
        worksheetOptionsEl.setAttribute("xmlns", "urn:schemas-microsoft-com:office:excel");
        Element pageSetupEl = this.document.createElement("PageSetup");
        worksheetOptionsEl.appendChild(pageSetupEl);
        if (page.getOrientation() == StiPageOrientation.Landscape) {
            Element layoutEl = this.document.createElement("Layout");
            pageSetupEl.appendChild(layoutEl);
            layoutEl.setAttribute("x:Orientation", "Landscape");
        }
        Element pageMarginsEl = this.document.createElement("PageMargins");
        pageSetupEl.appendChild(pageMarginsEl);
        pageMarginsEl.setAttribute("x:Bottom", this.convertPageMargins(page.getUnit().ConvertToHInches(page.getMargins().getBottom())));
        pageMarginsEl.setAttribute("x:Left", this.convertPageMargins(page.getUnit().ConvertToHInches(page.getMargins().getLeft())));
        pageMarginsEl.setAttribute("x:Right", this.convertPageMargins(page.getUnit().ConvertToHInches(page.getMargins().getRight())));
        pageMarginsEl.setAttribute("x:Top", this.convertPageMargins(page.getUnit().ConvertToHInches(page.getMargins().getTop())));
        worksheetOptionsEl.appendChild(this.document.createElement("DoNotDisplayGridlines"));
        if (paneX != 0 || paneY != 0) {
            Element activePaneEl;
            Element topRowEl;
            Element splitHorEl;
            if (paneX == 0) {
                splitHorEl = this.document.createElement("SplitHorizontal");
                worksheetOptionsEl.appendChild(splitHorEl);
                splitHorEl.setTextContent(String.valueOf(paneY));
                topRowEl = this.document.createElement("TopRowBottomPane");
                worksheetOptionsEl.appendChild(topRowEl);
                topRowEl.setTextContent(String.valueOf(paneY));
                worksheetOptionsEl.appendChild(this.document.createElement("FreezePanes"));
                worksheetOptionsEl.appendChild(this.document.createElement("FrozenNoSplit"));
                activePaneEl = this.document.createElement("ActivePane");
                worksheetOptionsEl.appendChild(activePaneEl);
                activePaneEl.setTextContent("2");
            } else if (paneY == 0) {
                Element splitVertEl = this.document.createElement("SplitVertical");
                worksheetOptionsEl.appendChild(splitVertEl);
                splitVertEl.setTextContent(String.valueOf(paneX));
                Element leftColEl = this.document.createElement("LeftColumnRightPane");
                worksheetOptionsEl.appendChild(leftColEl);
                leftColEl.setTextContent(String.valueOf(paneX));
                worksheetOptionsEl.appendChild(this.document.createElement("FreezePanes"));
                worksheetOptionsEl.appendChild(this.document.createElement("FrozenNoSplit"));
                activePaneEl = this.document.createElement("ActivePane");
                worksheetOptionsEl.appendChild(activePaneEl);
                activePaneEl.setTextContent("1");
            } else {
                splitHorEl = this.document.createElement("SplitHorizontal");
                worksheetOptionsEl.appendChild(splitHorEl);
                splitHorEl.setTextContent(String.valueOf(paneY));
                topRowEl = this.document.createElement("TopRowBottomPane");
                worksheetOptionsEl.appendChild(topRowEl);
                topRowEl.setTextContent(String.valueOf(paneY));
                Element splitVertEl = this.document.createElement("SplitVertical");
                worksheetOptionsEl.appendChild(splitVertEl);
                splitVertEl.setTextContent(String.valueOf(paneX));
                Element leftColEl = this.document.createElement("LeftColumnRightPane");
                worksheetOptionsEl.appendChild(leftColEl);
                leftColEl.setTextContent(String.valueOf(paneX));
                worksheetOptionsEl.appendChild(this.document.createElement("FreezePanes"));
                worksheetOptionsEl.appendChild(this.document.createElement("FrozenNoSplit"));
                Element activePaneEl2 = this.document.createElement("ActivePane");
                worksheetOptionsEl.appendChild(activePaneEl2);
                activePaneEl2.setTextContent("0");
            }
        }
        Element projectOptionsEl = this.document.createElement("ProtectObjects");
        worksheetOptionsEl.appendChild(projectOptionsEl);
        projectOptionsEl.setTextContent("False");
        Element projectScenariosEl = this.document.createElement("ProtectScenarios");
        worksheetOptionsEl.appendChild(projectScenariosEl);
        projectScenariosEl.setTextContent("False");
        if (page.getPaperSize() != StiPaperKind.Custom) {
            Element printEl = this.document.createElement("Print");
            worksheetOptionsEl.appendChild(printEl);
            Element el = this.document.createElement("ValidPrinterInfo");
            printEl.appendChild(el);
            el = this.document.createElement("PaperSizeIndex");
            printEl.appendChild(el);
            el.setTextContent(String.format("%s", page.getPaperSize().getValue()));
            el = this.document.createElement("HorizontalResolution");
            printEl.appendChild(el);
            el.setTextContent("600");
            el = this.document.createElement("VerticalResolution");
            printEl.appendChild(el);
            el.setTextContent("600");
        }
    }

    private void renderColumns(Element element) {
        for (int columnIndex = 1; columnIndex < this.matrix.getCoordX().size(); ++columnIndex) {
            Element columnEl = this.document.createElement("Column");
            element.appendChild(columnEl);
            columnEl.setAttribute("ss:AutoFitWidth", "0");
            double value2 = (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), columnIndex);
            double value1 = (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), columnIndex - 1);
            columnEl.setAttribute("ss:Width", this.convertColumn(value2 - value1));
        }
    }

    private void renderRows(Element element) {
        boolean[][] readyCells = new boolean[this.matrix.getCoordY().size()][this.matrix.getCoordX().size()];
        for (int rowIndex = 1; rowIndex < this.matrix.getCoordY().size(); ++rowIndex) {
            this.invokeExporting(rowIndex, this.matrix.getCoordY().size());
            if (this.isStoped()) {
                return;
            }
            Element rowEl = this.document.createElement("Row");
            element.appendChild(rowEl);
            rowEl.setAttribute("ss:AutoFitHeight", "0");
            double height = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex - 1);
            rowEl.setAttribute("ss:Height", this.convert(height));
            for (int columnIndex = 1; columnIndex < this.matrix.getCoordX().size(); ++columnIndex) {
                StiCellStyle cellStyle;
                StiCell cell = this.matrix.getCells()[rowIndex - 1][columnIndex - 1];
                if (cell != null && !readyCells[rowIndex][columnIndex]) {
                    StiText textComp;
                    StiCheckBox checkComp;
                    readyCells[rowIndex][columnIndex] = true;
                    StiRichText rtf = cell.getComponent() instanceof StiRichText ? (StiRichText)cell.getComponent() : null;
                    String str = cell.getText();
                    if (rtf != null && !"".equals(rtf.unpackRTF())) {
                        str = StiRtfHelper.rtfToPlain((String)rtf.unpackRTF());
                    }
                    StiCheckBox stiCheckBox = checkComp = cell.getComponent() instanceof StiCheckBox ? (StiCheckBox)cell.getComponent() : null;
                    if (checkComp != null && checkComp.getExcelDataValue() != null && checkComp.getExcelDataValue().length() > 0) {
                        str = checkComp.getExcelDataValue();
                    }
                    Element cellEl = this.document.createElement("Cell");
                    rowEl.appendChild(cellEl);
                    cellEl.setAttribute("ss:Index", String.valueOf(columnIndex));
                    StiCellStyle cellStyle2 = this.matrix.getCellStyles()[rowIndex - 1][columnIndex - 1];
                    int indexStyle = this.matrix.getStyles().indexOf(cellStyle2);
                    cellEl.setAttribute("ss:StyleID", "s" + String.valueOf(indexStyle));
                    if (cell.getWidth() > 0) {
                        cellEl.setAttribute("ss:MergeAcross", String.valueOf(cell.getWidth()));
                    }
                    if (cell.getHeight() > 0) {
                        cellEl.setAttribute("ss:MergeDown", String.valueOf(cell.getHeight()));
                    }
                    for (int xx = 0; xx <= cell.getWidth(); ++xx) {
                        for (int yy = 0; yy <= cell.getHeight(); ++yy) {
                            readyCells[rowIndex + yy][columnIndex + xx] = true;
                        }
                    }
                    StiText stiText = textComp = cell.getComponent() instanceof StiText ? (StiText)cell.getComponent() : null;
                    if (str != null && str.length() > 0 || textComp != null && textComp.getExcelDataValue() != null && textComp.getExcelDataValue() != "-") {
                        Element dataEl = this.document.createElement("Data");
                        cellEl.appendChild(dataEl);
                        String textType = "String";
                        if (textComp != null && textComp.getExcelDataValue() != null) {
                            String value = textComp.getExcelDataValue();
                            value = value.replaceAll(",", ".");
                            boolean isFormatCurrency = false;
                            boolean isFormatPercent = false;
                            boolean isFormatDate = false;
                            boolean isFormatTime = false;
                            String inputFormat = "";
                            if (textComp != null) {
                                inputFormat = textComp.getFormat();
                            }
                            if (inputFormat != null && inputFormat.length() > 0) {
                                if (inputFormat.charAt(0) == 'C') {
                                    isFormatCurrency = true;
                                }
                                if (inputFormat.charAt(0) == 'P') {
                                    isFormatPercent = true;
                                }
                                if (inputFormat.charAt(0) == 'D') {
                                    isFormatDate = true;
                                }
                                if (inputFormat.charAt(0) == 'T') {
                                    isFormatTime = true;
                                }
                            }
                            boolean error = false;
                            try {
                                if (isFormatCurrency || isFormatPercent || isFormatDate || isFormatTime) {
                                    error = true;
                                } else {
                                    Double.parseDouble(value);
                                }
                            }
                            catch (NumberFormatException e) {
                                error = true;
                            }
                            if (!error) {
                                textType = "Number";
                                str = value;
                            }
                        }
                        dataEl.setAttribute("ss:Type", textType);
                        String[] strs = str.replaceAll("\n", "").replace('\t', ' ').split("\r");
                        String outSt = "";
                        for (int index = 0; index < strs.length; ++index) {
                            String lineSt;
                            for (lineSt = strs[index]; lineSt != null && !"".equals(lineSt) && lineSt.endsWith(" "); lineSt = lineSt.substring(0, lineSt.length() - 1)) {
                            }
                            outSt = outSt + lineSt;
                            if (index >= strs.length - 1) continue;
                            outSt = outSt + '\n';
                        }
                        dataEl.setTextContent(outSt);
                    }
                }
                if (cell != null || readyCells[rowIndex][columnIndex] || (cellStyle = this.matrix.getCellStyles()[rowIndex - 1][columnIndex - 1]) == null) continue;
                int indexStyle = this.matrix.getStyles().indexOf(cellStyle);
                Element cellEl = this.document.createElement("Cell");
                rowEl.appendChild(cellEl);
                if (columnIndex > 1) {
                    cellEl.setAttribute("ss:Index", String.valueOf(columnIndex));
                }
                cellEl.setAttribute("ss:StyleID", "s" + String.valueOf(indexStyle));
            }
        }
    }

    private void renderCells(StiPage page) {
        Element worksheetEl = this.document.createElement("Worksheet");
        this.element.appendChild(worksheetEl);
        worksheetEl.setAttribute("ss:Name", this.title);
        Element tableEl = this.document.createElement("Table");
        worksheetEl.appendChild(tableEl);
        tableEl.setAttribute("ss:ExpandedColumnCount", String.valueOf(this.matrix.getCoordX().size() - 1));
        tableEl.setAttribute("ss:ExpandedRowCount", String.valueOf(this.matrix.getCoordY().size() - 1));
        tableEl.setAttribute("x:FullColumns", "1");
        tableEl.setAttribute("x:FullRows", "1");
        this.renderColumns(tableEl);
        this.renderRows(tableEl);
        this.renderWorksheetOptions(page, worksheetEl);
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        this.exportExcel(report, outputStream, (StiExcelXmlExportSettings)exportSettings);
    }

    public void exportExcel(StiReport report, OutputStream outputStream, StiExcelExportSettings settings) throws StiException {
        try {
            this.exportExcelException(report, outputStream, settings);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportExcelException(StiReport report, OutputStream outputStream, StiExcelExportSettings settings) throws ParserConfigurationException, IOException, TransformerException {
        StiLicenseKeyValidator.isValidOnJavaFramework(null);
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        StiPagesRange pageRange = settings.getPageRange();
        try {
            this.title = report.getReportAlias() == null || report.getReportAlias().trim().length() == 0 ? report.getReportName() : report.getReportAlias();
            StiPagesCollection pages = pageRange.getSelectedPages(report.getRenderedPages());
            this.matrix = new StiMatrix(pages, ExportOptions.ExcelXml.getDivideBigCells(), this);
            if (this.isStoped()) {
                return;
            }
            this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.document = docBuilder.newDocument();
            this.renderBeginDoc();
            this.renderStyles();
            pages.GetPage(pages.get(0));
            this.renderCells(pages.get(0));
            if (this.isStoped()) {
                return;
            }
            outputStream.write(StiXmlHelper.serialize((Document)this.document).getBytes("UTF-8"));
            this.closeProgress();
        }
        finally {
            outputStream.close();
            if (this.matrix != null) {
                this.matrix.clear();
                this.matrix = null;
            }
        }
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.ExcelXml;
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }
}

