/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2.builders;

import com.stimulsoft.base.data.ListExt;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiSparkline;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.engine.engineV2.builders.StiComponentV2Builder;
import com.stimulsoft.report.helpers.StiValueHelper;

public class StiSparklineV2Builder
extends StiComponentV2Builder {
    @Override
    public void Prepare(StiComponent masterComp) {
        super.Prepare(masterComp);
        if (masterComp.getHeight() > masterComp.getPage().getHeight() || masterComp.getHeight() > masterComp.getParent().getHeight()) {
            masterComp.setHeight(Math.min(masterComp.getPage().getHeight(), masterComp.getParent().getHeight()));
        }
    }

    @Override
    public StiComponent InternalRender(StiComponent masterComp) {
        StiSparkline masterSparkline = (StiSparkline)masterComp;
        StiSparkline childSparkline = (StiSparkline)masterSparkline.clone();
        childSparkline.values = StiSparklineV2Builder.getValuesFromValueDataColumn(masterSparkline, 0);
        return childSparkline;
    }

    public static double[] getValuesFromValueDataColumn(StiSparkline sparkline, int maxRows) {
        if (StiValidationUtil.isNullOrWhiteSpace((String)sparkline.getValueDataColumn())) {
            return null;
        }
        StiDataSource dataSource = sparkline.getDataSource();
        if (dataSource != null) {
            StiDataColumn dataColumn = StiDataColumn.getDataColumnFromColumnName(sparkline.getReport().getDictionary(), sparkline.getValueDataColumn(), false);
            if (dataColumn != null && dataColumn.isArray()) {
                return ListExt.toDecimalArray((Object)dataSource.get(dataColumn.getName()));
            }
            dataSource.saveState("SparklineRender_DataColumn");
            if (!StiValidationUtil.isNullOrWhiteSpace((String)sparkline.getDataRelationName())) {
                dataSource.SetDetails(sparkline.getDataRelationName());
            }
            double[] values = new double[dataSource.getCount()];
            dataSource.First();
            for (int posIndex = 0; posIndex < dataSource.getCount(); ++posIndex) {
                Object data = StiDataColumn.GetDataFromDataColumn(sparkline.getReport().getDictionary(), sparkline.getValueDataColumn());
                values[posIndex] = StiValueHelper.tryToDecimal(data);
                if (maxRows > 0 && posIndex > maxRows) break;
                dataSource.Next();
            }
            dataSource.RestoreState("SparklineRender_DataColumn");
            return values;
        }
        return null;
    }
}

