/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2.builders;

import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.bands.StiHierarchicalBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.engine.engineV2.builders.StiDataBandV2Builder;

public class StiHierarchicalBandV2Builder
extends StiDataBandV2Builder {
    @Override
    public StiComponent InternalRender(StiComponent masterComp) {
        StiHierarchicalBand masterHierarchical = (StiHierarchicalBand)(masterComp instanceof StiHierarchicalBand ? masterComp : null);
        if (this.IsCollapsed(masterHierarchical)) {
            return new StiContainer();
        }
        StiComponent tempVar = super.InternalRender(masterHierarchical);
        StiContainer container = (StiContainer)(tempVar instanceof StiContainer ? tempVar : null);
        if (container != null) {
            int level;
            if (!masterHierarchical.isDataSourceEmpty() && !masterHierarchical.getDataSource().getIsEmpty() && (level = masterHierarchical.getDataSource().GetLevel()) > 0) {
                StiHierarchicalBandV2Builder.CreateIndention(masterHierarchical, container, level);
            }
            if (!masterHierarchical.getIsBusinessObjectEmpty() && !masterHierarchical.getBusinessObject().getIsEmpty() && (level = masterHierarchical.getBusinessObject().getLevel()) > 0) {
                StiHierarchicalBandV2Builder.CreateIndention(masterHierarchical, container, level);
            }
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean IsCollapsed(StiHierarchicalBand band) {
        int resIndex = band.collapsingIndex;
        int resPosition = band.getPosition();
        int level = 0;
        if (!band.isDataSourceEmpty()) {
            level = band.getDataSource().GetLevel();
        }
        if (!band.getIsBusinessObjectEmpty()) {
            level = band.getBusinessObject().getLevel();
        }
        try {
            do {
                if (band.collapsingIndex == 0 || band.getPosition() == 0) {
                    boolean bl = false;
                    return bl;
                }
                --band.collapsingIndex;
                band.setPosition(band.getPosition() - 1);
            } while (!band.isDataSourceEmpty() && level <= band.getDataSource().GetLevel() || !band.getIsBusinessObjectEmpty() && level <= band.getBusinessObject().getLevel() || !StiHierarchicalBandV2Builder.IsCollapsed(band, false));
            boolean bl = true;
            return bl;
        }
        finally {
            band.collapsingIndex = resIndex;
            band.setPosition(resPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CreateIndention(StiHierarchicalBand masterHierarchical, StiContainer container, int level) {
        double dist = (double)level * masterHierarchical.getReport().getUnit().ConvertFromHInches(masterHierarchical.getIndent());
        StiComponentsCollection stiComponentsCollection = container.getComponents();
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : container.getComponents()) {
                if (comp.getLocked()) continue;
                comp.setLeft(comp.getLeft() + dist);
            }
        }
    }
}

