/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiPageFooterBand;
import com.stimulsoft.report.components.bands.StiPageHeaderBand;
import com.stimulsoft.report.components.bands.StiReportTitleBand;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import com.stimulsoft.report.engine.engineV2.StiPageHelper;

public class StiStaticBandsHelper {
    private boolean denyReportBands = false;
    private boolean denyPageBands = false;
    public StiEngine engine = null;
    private double reservedFreeSpace = 0.0;
    private double reservedCrossFreeSpace = 0.0;
    private double reservedPositionX = 0.0;
    private double reservedPositionY = 0.0;
    private double reservedPositionBottomY = 0.0;

    public final double getReservedFreeSpace() {
        return this.reservedFreeSpace;
    }

    public final double getReservedCrossFreeSpace() {
        return this.reservedCrossFreeSpace;
    }

    public final double getReservedPositionX() {
        return this.reservedPositionX;
    }

    public final double getReservedPositionY() {
        return this.reservedPositionY;
    }

    public final double getReservedPositionBottomY() {
        return this.reservedPositionBottomY;
    }

    public final void Render() {
        if (!this.engine.getThreads().IsActive && !this.engine.getDenyChangeThread()) {
            if (this.engine.getTemplatePage().getTitleBeforeHeader()) {
                this.RenderTitleBeforeHeader();
            } else {
                this.RenderHeaderBeforeTitle();
            }
            this.engine.setDenyRenderMasterComponentsInContainer(true);
            StiPageHelper.RenderSimpleComponents(this.engine.getTemplatePage(), this.engine.getContainerForRender());
            this.engine.setDenyRenderMasterComponentsInContainer(false);
        }
        if (this.engine.getPage() != null) {
            this.engine.getPage().getPageInfoV2().PositionFromTop = this.engine.getPositionY();
            this.engine.getPage().getPageInfoV2().PositionFromBottom = this.engine.getPositionBottomY();
        }
        StiRectangle rect = this.engine.getContainerForRender().getDockRegion(this.engine.getContainerForRender(), false);
        this.engine.setCrossFreeSpace(rect.width);
        this.engine.setFreeSpace(rect.height);
        if (this.engine.getColumnsOnPanel().getCount() > 1 && this.engine.getColumnsOnPanel().getRightToLeft() && !this.engine.getIsCrossBandsMode()) {
            this.engine.setPositionX(rect.getRight() - this.engine.getColumnsOnPanel().GetColumnWidth());
        } else {
            this.engine.setPositionX(rect.getLeft());
        }
        this.engine.setPositionY(rect.y);
        this.engine.setPositionBottomY(rect.getBottom());
        this.reservedCrossFreeSpace = this.engine.getCrossFreeSpace();
        this.reservedFreeSpace = this.engine.getFreeSpace();
        this.reservedPositionX = this.engine.getPositionX();
        this.reservedPositionY = this.engine.getPositionY();
        this.reservedPositionBottomY = this.engine.getPositionBottomY();
        if (!StiOptions.Engine.getForceNewPageForExtraColumns()) {
            this.engine.setPositionY(this.engine.offsetNewColumnY + this.reservedPositionY);
        }
    }

    private void RenderTitleBeforeHeader() {
        if (!this.denyReportBands) {
            boolean resDenyReportTitleBands = this.denyReportBands;
            boolean resdenyPageBands = this.denyPageBands;
            this.denyPageBands = true;
            this.denyReportBands = true;
            this.RenderReportTitleBands();
            this.denyPageBands = resdenyPageBands;
            this.denyReportBands = resDenyReportTitleBands;
        }
        if (!this.denyPageBands) {
            boolean resDenyPageBands = this.denyPageBands;
            boolean resDenyReportTitleBands = this.denyReportBands;
            this.denyPageBands = true;
            this.denyReportBands = true;
            this.RenderPageHeaderBands();
            this.RenderPageFooterBands();
            this.denyPageBands = resDenyPageBands;
            this.denyReportBands = resDenyReportTitleBands;
        }
    }

    private void RenderHeaderBeforeTitle() {
        if (!this.denyPageBands) {
            boolean resDenyPageBands = this.denyPageBands;
            boolean resDenyReportBands = this.denyReportBands;
            this.denyPageBands = true;
            this.RenderPageHeaderBands();
            this.RenderPageFooterBands();
            this.denyPageBands = resDenyPageBands;
        }
    }

    private void RenderReportTitleBands() {
        if (this.engine.getTemplatePage().getPageInfoV2().IsReportTitlesRendered) {
            return;
        }
        for (StiComponent component : this.engine.getTemplatePage().getComponents()) {
            StiReportTitleBand reportTitleBand = (StiReportTitleBand)(component instanceof StiReportTitleBand ? component : null);
            if (reportTitleBand == null) continue;
            reportTitleBand.parentBookmark = this.engine.getContainerForRender().getCurrentBookmark();
            reportTitleBand.doBookmark();
            reportTitleBand.parentPointer = this.engine.getContainerForRender().currentPointer;
            reportTitleBand.doPointer();
            this.engine.RenderBand(reportTitleBand);
        }
        this.engine.getTemplatePage().getPageInfoV2().IsReportTitlesRendered = true;
    }

    private void RenderPageHeaderBands() {
        StiComponentsCollection components = this.GetPageHeaders();
        for (StiComponent component : components) {
            StiPageHeaderBand pageHeaderBand = (StiPageHeaderBand)(component instanceof StiPageHeaderBand ? component : null);
            if (pageHeaderBand == null) continue;
            pageHeaderBand.parentBookmark = this.engine.getContainerForRender().getCurrentBookmark();
            pageHeaderBand.doBookmark();
            pageHeaderBand.parentPointer = this.engine.getContainerForRender().currentPointer;
            pageHeaderBand.doPointer();
            this.engine.RenderBand(pageHeaderBand);
        }
    }

    private void RenderPageFooterBands() {
        StiComponentsCollection components = this.GetPageFooters();
        for (StiComponent component : components) {
            StiPageFooterBand pageFooterBand = (StiPageFooterBand)(component instanceof StiPageFooterBand ? component : null);
            if (pageFooterBand == null) continue;
            pageFooterBand.parentBookmark = this.engine.getContainerForRender().getCurrentBookmark();
            pageFooterBand.doBookmark();
            pageFooterBand.parentPointer = this.engine.getContainerForRender().currentPointer;
            pageFooterBand.doPointer();
            this.engine.RenderBand(pageFooterBand);
        }
    }

    private StiComponentsCollection GetPageHeaders() {
        int indexCurrent;
        StiPage page;
        int indexPage;
        StiComponentsCollection comps = new StiComponentsCollection();
        for (indexPage = indexCurrent = this.engine.getReport().getPages().indexOf(this.engine.getTemplatePage()); indexPage >= 0 && (page = this.engine.getReport().getPages().get(indexPage)).getPrintHeadersFootersFromPreviousPage(); --indexPage) {
        }
        if (indexPage <= -1) {
            indexPage = 0;
        }
        for (int index = indexPage; index <= indexCurrent; ++index) {
            StiPage page2 = this.engine.getReport().getPages().get(index);
            comps.AddRange(this.GetPageHeadersFromPage(page2));
        }
        return comps;
    }

    private StiComponentsCollection GetPageFooters() {
        int indexCurrent;
        StiPage page;
        int indexPage;
        StiComponentsCollection comps = new StiComponentsCollection();
        for (indexPage = indexCurrent = this.engine.getReport().getPages().indexOf(this.engine.getTemplatePage()); indexPage >= 0 && (page = this.engine.getReport().getPages().get(indexPage)).getPrintHeadersFootersFromPreviousPage(); --indexPage) {
        }
        if (indexPage <= -1) {
            indexPage = 0;
        }
        for (int index = indexPage; index <= indexCurrent; ++index) {
            StiPage page2 = this.engine.getReport().getPages().get(index);
            comps.AddRange(this.GetPageFootersFromPage(page2));
        }
        return comps;
    }

    private StiComponentsCollection GetPageHeadersFromPage(StiPage page) {
        StiComponentsCollection comps = new StiComponentsCollection();
        for (StiComponent component : page.components) {
            StiPageHeaderBand pageHeaderBand = (StiPageHeaderBand)(component instanceof StiPageHeaderBand ? component : null);
            if (pageHeaderBand == null) continue;
            comps.add(pageHeaderBand);
        }
        return comps;
    }

    private StiComponentsCollection GetPageFootersFromPage(StiPage page) {
        StiComponentsCollection comps = new StiComponentsCollection();
        for (StiComponent component : page.components) {
            StiPageFooterBand pageFooterBand = (StiPageFooterBand)(component instanceof StiPageFooterBand ? component : null);
            if (pageFooterBand == null) continue;
            comps.add(pageFooterBand);
        }
        return comps;
    }

    public StiStaticBandsHelper(StiEngine engine) {
        this.engine = engine;
    }
}

