/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import com.stimulsoft.report.engine.engineV2.StiReportRenderingStopException;
import com.stimulsoft.report.enums.StiReportPass;

public class StiProgressHelper {
    public StiEngine engine = null;
    public boolean allowCachedPagesCache;

    public final void Process() {
        StiReport report = this.engine.getReport();
        if (!report.isShowProgress()) {
            return;
        }
        if (report.getCompiledReport() != null) {
            report = report.getCompiledReport();
        }
        int progressValue = -1;
        String pass = "";
        if (StiLocalization.getLocalization().getCultureName().equals("en")) {
            if (report.reportPass == StiReportPass.First) {
                pass = "First Pass";
            }
            if (report.reportPass == StiReportPass.Second) {
                pass = "Second Pass";
            }
        } else {
            if (report.reportPass == StiReportPass.First) {
                pass = StiLocalization.Get((String)"Report", (String)"FirstPass");
            }
            if (report.reportPass == StiReportPass.Second) {
                pass = StiLocalization.Get((String)"Report", (String)"SecondPass");
            }
        }
        if (StiOptions.Engine.getUsePercentageProgress()) {
            double count = 0.0;
            double value = 0.0;
            for (StiPage page : report.getPages()) {
                if (page.getSkip()) continue;
                StiComponentsCollection comps = page.GetComponents();
                for (StiComponent comp : comps) {
                    StiDataBand dataBand = (StiDataBand)(comp instanceof StiDataBand ? comp : null);
                    if (dataBand == null || dataBand.getMasterComponent() != null) continue;
                    count += (double)dataBand.getCount();
                    if (dataBand.getPosition() <= dataBand.getCount()) {
                        value += (double)dataBand.getPosition();
                        continue;
                    }
                    value += (double)dataBand.getCount();
                }
            }
            if (count > 0.0) {
                // empty if block
            }
            report.progressOfRendering = progressValue = (int)value;
        }
        if (StiLocalization.getLocalization().getCultureName().equals("en")) {
            report.setStatusString(String.format("Page - %1$s", report.getCurrentPrintPage() + 1));
        } else {
            report.setStatusString(String.format("%1$s - %2$s", StiLocalization.getValue((String)"Components", (String)"StiPage"), report.getCurrentPrintPage() + 1));
        }
        if (report.reportPass != StiReportPass.None) {
            report.setStatusString(String.format("%1$s: %2$s", pass, report.getStatusString()));
        }
        if (report.progress != null) {
            if (progressValue != -1) {
                report.progress.setIsMarquee(false);
                report.progress.update(report.getStatusString(), progressValue);
            } else {
                report.progress.update(report.getStatusString());
            }
            if (report.progress.getIsBreaked()) {
                report.isStopped = true;
                throw new StiReportRenderingStopException();
            }
        }
        if (report.parentReport != null && report.parentReport.progress != null) {
            report.parentReport.progress.update(report.parentReport.getStatusString());
            if (report.parentReport.progress.getIsBreaked()) {
                report.parentReport.isStopped = true;
                throw new StiReportRenderingStopException();
            }
        }
    }

    public StiProgressHelper(StiEngine engine) {
        this.engine = engine;
    }
}

