/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiEmptyBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.components.enums.StiEmptySizeMode;
import com.stimulsoft.report.components.interfaces.IStiOddEvenStyles;
import com.stimulsoft.report.components.simplecomponents.StiCrossLinePrimitive;
import com.stimulsoft.report.engine.StiOddEvenStylesHelper;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import java.util.ArrayList;

public class StiEmptyBandsV2Helper {
    public StiEngine engine = null;
    private StiEmptyBand emptyBand;

    public final void Register(ArrayList<? extends StiBand> emptyBands) {
        if (emptyBands != null && emptyBands.size() > 0) {
            this.emptyBand = (StiEmptyBand)(emptyBands.get(0) instanceof StiEmptyBand ? emptyBands.get(0) : null);
        }
    }

    public final void Clear() {
        this.emptyBand = null;
    }

    private StiContainer CreateEmptyBandContainer(StiContainer containerForRender) {
        this.engine.getReport().setLine(this.engine.getReport().getLine() + 1);
        ++this.engine.getReport().LineThrough;
        this.emptyBand.InvokeRendering();
        this.emptyBand.parentBookmark = containerForRender.getCurrentBookmark();
        this.emptyBand.parentPointer = containerForRender.currentPointer;
        StiComponent comp = this.emptyBand.render();
        if (comp == null) {
            return null;
        }
        StiOddEvenStylesHelper.applyOddEvenStyles(this.engine.getReport(), this.emptyBand instanceof IStiOddEvenStyles ? this.emptyBand : null, (StiContainer)(comp instanceof StiContainer ? comp : null));
        comp.setDockStyle(StiDockStyle.None);
        comp.setLeft(this.engine.getPositionX());
        comp.top = this.engine.getPositionY();
        return (StiContainer)(comp instanceof StiContainer ? comp : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Render(StiContainer containerForRender, StiContainer selectedContainer) {
        if (this.emptyBand == null) {
            return;
        }
        this.engine.setIsDynamicBookmarksMode(true);
        try {
            this.emptyBand.InvokeBeginRender();
            int startIndex = -1;
            if (containerForRender != null) {
                startIndex = containerForRender.getComponents().indexOf(selectedContainer);
            }
            if (startIndex == -1) {
                startIndex = containerForRender.getComponents().size();
            }
            StiContainer comp = null;
            StiComponent latestRenderedEmptyBand = null;
            while ((comp = this.CreateEmptyBandContainer(containerForRender)) != null) {
                if (comp.getHeight() == 0.0) {
                    comp.setHeight(this.engine.getReport().getUnit().ConvertFromHInches(10.0));
                }
                if (!(comp.getHeight() <= this.engine.getFreeSpace())) break;
                this.engine.setPositionY(this.engine.getPositionY() + comp.getHeight());
                this.engine.setFreeSpace(this.engine.getFreeSpace() - comp.getHeight());
                containerForRender.getComponents().add(startIndex, comp);
                ++startIndex;
                latestRenderedEmptyBand = comp;
                comp.doBookmark();
                comp.doPointer();
                if (!(this.engine.getFreeSpace() > 9.99999999E8)) continue;
            }
            if (this.emptyBand.getSizeMode() == StiEmptySizeMode.DecreaseLastRow) {
                comp.setHeight(this.engine.getFreeSpace());
                this.engine.setPositionY(this.engine.getPositionY() + comp.getHeight());
                this.engine.setFreeSpace(this.engine.getFreeSpace() - comp.getHeight());
                containerForRender.getComponents().add(startIndex, comp);
                comp.doBookmark();
                comp.doPointer();
            } else if (this.emptyBand.getSizeMode() == StiEmptySizeMode.IncreaseLastRow) {
                if (latestRenderedEmptyBand == null) {
                    if (this.engine.getFreeSpace() > 0.0) {
                        comp = this.CreateEmptyBandContainer(containerForRender);
                        comp.top = this.engine.getPositionY();
                        comp.setHeight(this.engine.getFreeSpace());
                    }
                } else {
                    latestRenderedEmptyBand.setHeight(latestRenderedEmptyBand.getHeight() + this.engine.getFreeSpace());
                }
            } else if (this.emptyBand.getSizeMode() == StiEmptySizeMode.AlignFooterToTop) {
                StiComponentsCollection stiComponentsCollection = containerForRender.getComponents();
                synchronized (stiComponentsCollection) {
                    for (StiComponent component : containerForRender.getComponents()) {
                        if (!(component.top > this.engine.getPositionY()) || component instanceof StiCrossLinePrimitive) continue;
                        component.top -= this.engine.getFreeSpace();
                    }
                }
            }
            this.emptyBand.InvokeEndRender();
        }
        finally {
            this.engine.setIsDynamicBookmarksMode(false);
        }
    }

    public StiEmptyBandsV2Helper(StiEngine engine) {
        this.engine = engine;
    }
}

