/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.base.StiRepositoryItems;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentDivider;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiTableOfContents;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.complexcomponents.StiContainerHelper;
import com.stimulsoft.report.components.complexcomponents.StiContainerInfoV2;
import com.stimulsoft.report.components.interfaces.IStiBreakable;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.engine.engineV2.StiEngine;

public class StiBreakableHelper {
    public StiEngine engine = null;

    public final boolean IsCanBreak(StiContainer container) {
        StiContainer breakable;
        StiContainer stiContainer = breakable = container.getContainerInfoV2().getParentBand() instanceof IStiBreakable ? container.getContainerInfoV2().getParentBand() : null;
        if (breakable != null && breakable.getCanBreak()) {
            return true;
        }
        StiContainer stiContainer2 = breakable = container instanceof IStiBreakable ? container : null;
        return breakable != null && breakable.getCanBreak();
    }

    public final boolean IsNeedBreak(StiContainer container) {
        StiPage currentPage;
        StiPage stiPage = currentPage = this.engine.getContainerForRender() instanceof StiPage ? (StiPage)this.engine.getContainerForRender() : null;
        if (currentPage != null && currentPage.getUnlimitedHeight() && !currentPage.getUnlimitedBreakable() && container.getContainerInfoV2() != null && container.getContainerInfoV2().getParentBand() != null) {
            boolean existCrosstab = false;
            for (StiComponent comp : container.getContainerInfoV2().getParentBand().getComponents()) {
                if (!(comp instanceof StiCrossTab)) continue;
                existCrosstab = true;
            }
            if (!existCrosstab) {
                return false;
            }
        }
        return container.getHeight() > this.engine.getFreeSpace() && this.IsCanBreak(container);
    }

    public final StiContainer Break(StiContainer originalContainer) {
        StiContainerInfoV2 info = originalContainer.getContainerInfoV2();
        double minTop = originalContainer.getHeight();
        for (StiComponent comp : originalContainer.getComponents()) {
            minTop = Math.min(minTop, comp.getTop());
        }
        int compsCountBeforeBreak = originalContainer.getComponents().size();
        StiRefObject haveBreaked = new StiRefObject((Object)false);
        StiContainer continuedContainer = StiComponentDivider.BreakContainer(this.engine.getFreeSpace(), originalContainer, (StiRefObject<Boolean>)haveBreaked);
        continuedContainer.getContainerInfoV2().IgnoreResetPageNumber = true;
        boolean suppressFirstContainer = minTop == 0.0 && compsCountBeforeBreak > 0 && originalContainer.getComponents().size() == 0;
        continuedContainer.setName(suppressFirstContainer && info != null && info.DataSourceRow != null ? "Continued_" + originalContainer.getName() : "Continued");
        continuedContainer.setHeight(continuedContainer.getHeight() - originalContainer.getHeight());
        originalContainer.setName(!suppressFirstContainer && info != null && info.DataSourceRow != null ? "Breaked_" + originalContainer.getName() : "Breaked");
        if (info.getParentBand() instanceof StiTableOfContents) {
            originalContainer.setName(info.getParentBand().getName());
        }
        originalContainer.setHeight(this.engine.getFreeSpace());
        if (!suppressFirstContainer) {
            this.engine.setFreeSpace(this.engine.getFreeSpace() + originalContainer.getHeight());
            this.engine.RenderContainer(originalContainer);
            this.engine.setFreeSpace(this.engine.getFreeSpace() - originalContainer.getHeight());
        }
        this.engine.NewDestination(!suppressFirstContainer);
        continuedContainer.canGrow = true;
        if (((Boolean)haveBreaked.argvalue).booleanValue()) {
            StiContainerHelper.checkSize(continuedContainer);
        }
        return continuedContainer;
    }

    public final void SetCanBreak(StiContainer container) {
        container.setCanBreak(true);
        for (int index = 0; index < container.components.size(); ++index) {
            StiContainer cont;
            StiComponent comp = (StiComponent)container.components.get(index);
            IStiBreakable breakable = (IStiBreakable)((Object)(comp instanceof IStiBreakable ? comp : null));
            if (breakable != null) {
                StiComponent tempComp;
                if (!breakable.getCanBreak() && this.engine != null && this.engine.getReport() != null && (tempComp = this.engine.getReport().GetComponentByName(comp.getName())) != null && tempComp.getProperties().equals((Object)comp.getProperties()) && comp.getProperties() != null) {
                    comp.setProperties((StiRepositoryItems)comp.getProperties().clone());
                }
                breakable.setCanBreak(true);
            }
            if ((cont = (StiContainer)(comp instanceof StiContainer ? comp : null)) == null) continue;
            this.SetCanBreak(cont);
        }
    }

    public final StiContainer ProcessBreakable(StiContainer container) {
        if (this.engine.getIsCrossBandsMode()) {
            return container;
        }
        boolean isAlreadySetCanBreak = false;
        while (this.IsNeedBreak(container)) {
            double heightBeforeBreak = container.getHeight();
            if (heightBeforeBreak != (container = this.Break(container)).getHeight()) continue;
            if (isAlreadySetCanBreak) break;
            this.SetCanBreak(container);
            isAlreadySetCanBreak = true;
        }
        return container;
    }

    public StiBreakableHelper(StiEngine engine) {
        this.engine = engine;
    }
}

