/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine;

import com.stimulsoft.base.context.chart.IStiContextPainter;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.series.StiSeriesGeom;
import com.stimulsoft.report.chart.geoms.series.pie.StiPieSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.IStiGeomInteraction;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.view.series.StiSeriesInteraction;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import com.stimulsoft.report.components.StiInteraction;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.painters.StiContextPainter;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;

public final class StiChartInteractionHelper {
    private static StiRectangle cachedChartRect = StiRectangle.empty();
    private static StiChart cachedChart = null;
    private static StiCellGeom cachedChartGeom = null;

    public static void ProcessChart(StiChart masterChart, StiChart childChart) {
        if (StiOptions.Engine.getAllowInteractionInChartWithComponents()) {
            boolean interactionPresent = false;
            for (IStiSeries series : childChart.getSeries()) {
                if (!(series.getHyperlinks() != null && series.getHyperlinks().length > 0 || series.getTags() != null && series.getTags().length > 0 || series.getToolTips() != null && series.getToolTips().length > 0) && (series.getCore().getInteraction() == null || !((StiSeriesInteraction)series.getCore().getInteraction()).getDrillDownEnabled())) continue;
                interactionPresent = true;
                break;
            }
            if (interactionPresent) {
                BufferedImage bmp = new BufferedImage(10, 10, 1);
                StiGraphics gg = new StiGraphics((Graphics)bmp.createGraphics());
                StiContextPainter painter = new StiContextPainter(gg, 1.0, 1.0);
                StiContext context = new StiContext((IStiContextPainter)painter, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), 1.0);
                StiRectangle rect = masterChart.getReport().getUnit().ConvertToHInches(masterChart.getClientRectangle());
                StiCellGeom chartGeom = childChart.getCore().Render(context, new StiRectangle(0.0, 0.0, rect.width, rect.height), true);
                ArrayList<StiCellGeom> seriesGeomItems = chartGeom.GetSeriesGeoms();
                if (seriesGeomItems.size() != 0) {
                    ArrayList<StiText> interactiveComps = new ArrayList<StiText>();
                    for (StiCellGeom seriesGeomItem : seriesGeomItems) {
                        StiSeriesGeom seriesGeom;
                        StiSeriesElementGeom seriesElementGeom;
                        IStiSeries series = null;
                        StiSeriesElementGeom stiSeriesElementGeom = seriesElementGeom = seriesGeomItem instanceof StiSeriesElementGeom ? (StiSeriesElementGeom)seriesGeomItem : null;
                        if (seriesElementGeom != null) {
                            series = seriesElementGeom.getSeries();
                        }
                        if (series != null && seriesElementGeom != null && seriesElementGeom.getInteraction() != null) {
                            StiRectangle rectF = chartGeom.GetRect(seriesGeomItem);
                            if (seriesElementGeom instanceof StiPieSeriesElementGeom) {
                                StiPieSeriesElementGeom pieSegment = seriesElementGeom instanceof StiPieSeriesElementGeom ? (StiPieSeriesElementGeom)seriesElementGeom : null;
                                float angleRad = (float)(Math.PI * pieSegment.getEndAngle() / 180.0);
                                StiPoint pieCenter = new StiPoint(rectF.x + rectF.width / 2.0, rectF.y + rectF.height / 2.0);
                                StiPoint centerPoint2 = new StiPoint(pieCenter.x + (double)((float)Math.cos(angleRad)) * pieSegment.getRadius() / 2.0, pieCenter.y + (double)((float)Math.sin(angleRad)) * pieSegment.getRadius() / 2.0);
                                rectF = new StiRectangle(centerPoint2.x - pieSegment.getRadius() / 4.0, centerPoint2.y - pieSegment.getRadius() / 4.0, pieSegment.getRadius() / 2.0, pieSegment.getRadius() / 2.0);
                            }
                            StiRectangle rectD = new StiRectangle(rectF.x, rectF.y, rectF.width, rectF.height);
                            rectD = masterChart.getReport().getUnit().ConvertFromHInches(rectD);
                            StiText text = StiChartInteractionHelper.createInteractionText(masterChart, childChart, series.getCore(), seriesElementGeom.getInteraction(), rectD);
                            interactiveComps.add(text);
                        }
                        StiSeriesGeom stiSeriesGeom = seriesGeom = seriesGeomItem instanceof StiSeriesGeom ? (StiSeriesGeom)seriesGeomItem : null;
                        if (seriesGeom != null) {
                            series = seriesGeom.getSeries();
                        }
                        if (series == null || seriesGeom == null || seriesGeom.getInteractions() == null) continue;
                        double step = seriesGeom.getInteractions().get((int)(seriesGeom.getInteractions().size() - 1)).getPoint().x - seriesGeom.getInteractions().get((int)0).getPoint().x;
                        step = Math.min(step, 30.0);
                        StiPoint startPoint = StiPoint.getEmpty();
                        if (seriesGeom.getAreaGeom() != null) {
                            startPoint = chartGeom.GetRect(seriesGeom.getAreaGeom()).getLocation();
                        }
                        for (StiSeriesInteractionData data : seriesGeom.getInteractions()) {
                            StiRectangle rectD = new StiRectangle(startPoint.x + data.getPoint().x - step / 2.0, startPoint.y + data.getPoint().y - step / 2.0, step, step);
                            rectD = masterChart.getReport().getUnit().ConvertFromHInches(rectD);
                            StiText text = StiChartInteractionHelper.createInteractionText(masterChart, childChart, series.getCore(), data, rectD);
                            interactiveComps.add(text);
                        }
                    }
                    if (interactiveComps.size() > 0) {
                        childChart.getChartInfoV2().interactiveComps = interactiveComps;
                    }
                }
            }
        }
    }

    private static StiText createInteractionText(StiChart masterChart, StiChart childChart, StiSeriesCoreXF series, StiSeriesInteractionData interactionData, StiRectangle rectD) {
        StiText text = new StiText(rectD);
        text.setName(childChart.getName() + "Interaction");
        text.setToolTipValue(interactionData.getTooltip());
        text.setHyperlinkValue(interactionData.getHyperlink());
        text.setTagValue(interactionData.getTag() != null ? interactionData.getTag().toString() : null);
        if (series.getInteraction() != null && ((StiSeriesInteraction)series.getInteraction()).getDrillDownEnabled()) {
            text.setPage(masterChart.getPage());
            text.setInteraction(new StiInteraction());
            text.getInteraction().setDrillDownEnabled(((StiSeriesInteraction)series.getInteraction()).getDrillDownEnabled());
            text.getInteraction().setDrillDownPageGuid(((StiSeriesInteraction)series.getInteraction()).getDrillDownPageGuid());
            text.getInteraction().setDrillDownReport(((StiSeriesInteraction)series.getInteraction()).getDrillDownReport());
            text.setDrillDownParameters(new HashMap<String, Object>());
            text.getDrillDownParameters().put("Series", series);
            text.getDrillDownParameters().put("SeriesIndex", series.getSeries().getChart().getSeries().indexOf(series.getSeries()));
            text.getDrillDownParameters().put("SeriesArgument", interactionData.getArgument());
            text.getDrillDownParameters().put("SeriesValue", interactionData.getValue());
            text.getDrillDownParameters().put("SeriesPointIndex", interactionData.getPointIndex());
            text.getDrillDownParameters().put("SeriesTag", interactionData.getTag());
            text.getDrillDownParameters().put("SeriesHyperlink", interactionData.getHyperlink());
            text.getDrillDownParameters().put("SeriesTooltip", interactionData.getTooltip());
        }
        return text;
    }

    private static StiCellGeom GetGeomAt(StiChart chart, StiRectangle chartRect, float x, float y, StiRefObject<StiCellGeom> chartGeom, float zoom) {
        chartGeom.argvalue = null;
        x -= (float)chartRect.x;
        y -= (float)chartRect.y;
        if (cachedChart == chart && cachedChartGeom != null && cachedChartRect.equals(chartRect)) {
            chartGeom.argvalue = cachedChartGeom;
        } else {
            StiContextPainter painter = new StiContextPainter(StiReport.getGlobalMeasureGraphics(), zoom, 1.0);
            StiContext context = new StiContext((IStiContextPainter)painter, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), (double)zoom);
            chartGeom.argvalue = chart.getCore().Render(context, new StiRectangle(0.0, 0.0, chartRect.getWidth(), chartRect.getHeight()), true);
            cachedChart = chart;
            cachedChartGeom = (StiCellGeom)chartGeom.argvalue;
            cachedChartRect = chartRect;
        }
        return ((StiCellGeom)chartGeom.argvalue).GetGeomAt((StiCellGeom)chartGeom.argvalue, x, y);
    }

    public static IStiGeomInteraction GetInteraction(StiChart chart, StiRectangle chartRect, float x, float y, StiRefObject<StiCellGeom> chartGeom, float zoom) {
        StiCellGeom geom = StiChartInteractionHelper.GetGeomAt(chart, chartRect, x, y, chartGeom, zoom);
        if (geom instanceof IStiGeomInteraction) {
            return geom instanceof IStiGeomInteraction ? geom : null;
        }
        return null;
    }

    public static void ResetChartGeomCache() {
        cachedChart = null;
    }
}

