/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.databases;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.io.StiCloseUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataParameter;
import com.stimulsoft.report.dictionary.StiDatabaseInformation;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariableAsParameterHelper;
import com.stimulsoft.report.dictionary.adapters.StiAbstractAdapter;
import com.stimulsoft.report.dictionary.adapters.StiJDBCParameters;
import com.stimulsoft.report.dictionary.adapters.StiJdbcAdapter;
import com.stimulsoft.report.dictionary.adapters.StiOracleAdapter;
import com.stimulsoft.report.dictionary.adapters.StiPostgreSqlAdapter;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataStoreSource;
import com.stimulsoft.report.dictionary.dataSources.StiOracleSource;
import com.stimulsoft.report.dictionary.dataSources.StiSqlSource;
import com.stimulsoft.report.dictionary.databases.QueryParameter;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import com.stimulsoft.report.dictionary.databases.StiEncryptionConnectionString;
import com.stimulsoft.report.dictionary.databases.StiNamedParameterStatement;
import com.stimulsoft.report.dictionary.databases.StiPostgreSQLDatabase;
import com.stimulsoft.report.dictionary.enums.StiSqlSourceType;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.utils.data.StiDataColumnsUtil;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StiJDBCDatabase
extends StiDatabase {
    private static final Logger LOG = Logger.getLogger(StiJDBCDatabase.class.getName());
    private static final String patternStr = "[^@]@([A-z0-9])+";
    private static final Pattern pattern = Pattern.compile("[^@]@([A-z0-9])+");
    private String connectionString;
    private boolean promptUserNameAndPassword = false;
    private String url;
    private String user;
    private String password;
    private Connection con;
    private StiDataStoreSource source;
    private String driver;
    private Map<String, String> other;
    private List<Connection> connections = new ArrayList<Connection>();

    public StiJDBCDatabase() {
    }

    public Connection getConnection() {
        return this.con;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public StiJDBCDatabase(String name, String url, String driver, String user, String password) {
        this(name, name, url, driver, user, password);
    }

    public StiJDBCDatabase(String name, String alias, String url, String driver, String user, String password) {
        super(name, alias);
        this.url = url;
        this.driver = driver;
        this.user = user;
        this.password = password;
    }

    public StiJDBCDatabase(String name, String alias, Connection con) {
        super(name, alias);
        this.con = con;
    }

    protected StiJDBCDatabase(String name, String connectionString) {
        super(name, name);
        this.setConnectionString(connectionString);
    }

    protected StiJDBCDatabase(String name, String alias, String connectionString) {
        super(name, alias);
        this.setConnectionString(connectionString);
    }

    public void setUser(String user) {
        this.user = user;
    }

    @StiSerializable
    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @StiSerializable
    public String getPassword() {
        return this.password;
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getPromptUserNameAndPassword() {
        return this.promptUserNameAndPassword;
    }

    public final void setPromptUserNameAndPassword(boolean value) {
        this.promptUserNameAndPassword = value;
    }

    @StiSerializable(deprecated=true)
    public final String getConnectionString() {
        return this.connectionString;
    }

    public final void setConnectionString(String value) {
        this.connectionString = value;
        if (!"OverrideConnectionString".equals(value) && StiValidationUtil.isNotNullOrEmpty((String)value)) {
            StiJDBCParameters param = this.getAdapter(this.connectionString).getJdbcParameters();
            this.url = param.getConnectionURL();
            this.user = param.getUser();
            this.password = param.getPassword();
            this.driver = param.getDriverName();
            this.other = param.getOther();
        }
    }

    @StiSerializable
    public final String getConnectionStringEncrypted() throws NoSuchAlgorithmException {
        return new StiEncryptionConnectionString().encrypt(this.connectionString, "8pTP5X15uKADcSw7");
    }

    public final void setConnectionStringEncrypted(String value) throws NoSuchAlgorithmException {
        this.setConnectionString(new StiEncryptionConnectionString().decrypt(value, "8pTP5X15uKADcSw7").trim());
    }

    protected StiAbstractAdapter getAdapter(String connectionString) {
        return new StiJdbcAdapter(connectionString);
    }

    @Override
    public String getServiceName() {
        return "JDBC";
    }

    @Override
    public void connect(StiDataStoreSource source, StiReport report) throws StiException {
        this.connect(source, true, report);
    }

    @Override
    public void connect(StiDataStoreSource source, Boolean fillTable, StiReport report) throws StiException {
        try {
            source.getVariableParameters().clear();
            List<StiVariable> variables = StiVariableAsParameterHelper.fetchAll(source.getQuery(), source.getParameters(), source.getDictionary().getReport());
            if (variables != null && variables.size() > 0) {
                for (StiVariable variable : variables) {
                    try {
                        Object value = source.getDictionary().getReport().get(variable.getName());
                        if (value == null) {
                            value = variable.eval(source.getDictionary().getReport());
                        }
                        StiDataParameter param = new StiDataParameter(variable.getName(), 0, 0);
                        param.setParameterValue(value);
                        source.getVariableParameters().add(param);
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel < 10) continue;
                        e.printStackTrace();
                    }
                }
            }
            if (StiValidationUtil.isNotNullOrEmpty((String)this.driver)) {
                Class.forName(this.driver);
            }
            if (this.con != null) {
                this.connections.add(this.con);
            }
            if (!(StiValidationUtil.isNullOrEmpty((String)this.url) && StiValidationUtil.isNullOrEmpty((String)this.user) && StiValidationUtil.isNullOrEmpty((String)this.password))) {
                if (StiOptions.Engine.logLevel >= 5) {
                    LOG.info("Connection: " + this.con);
                    LOG.info("Try to connect url: " + this.url + " user: " + this.user + " password: " + this.password + " driver: " + this.driver);
                }
                Properties info = new Properties();
                info.setProperty("user", this.user);
                info.setProperty("password", this.password);
                if (!this.url.contains("Encoding") && !this.url.contains("encoding") || this.other.containsKey("characterEncoding")) {
                    info.setProperty("useUnicode", "true");
                    info.setProperty("characterEncoding", "UTF-8");
                }
                info.putAll(this.other);
                this.con = DriverManager.getConnection(this.url, info);
            }
            if (StiOptions.Engine.logLevel >= 5) {
                LOG.info("Open connection: " + this.con);
                LOG.info("Fill table: " + fillTable);
            }
            if (this.con == null) {
                throw new StiException("Could not connect " + this);
            }
            if (fillTable.booleanValue()) {
                this.fillTable(source);
            }
        }
        catch (Exception e) {
            throw new StiException(e.getMessage() + "\n" + this.toString(), (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void fillTable(StiDataStoreSource source) {
        block13: {
            block14: {
                block12: {
                    this.source = source;
                    table = source.createNewTable();
                    pstmt = null;
                    query = source.getQuery();
                    res = this.getPreparedStatement(query, source);
                    pstmt = (PreparedStatement)res.get("pstmt");
                    if (StiOptions.Engine.logLevel >= 10) {
                        StiJDBCDatabase.LOG.log(Level.SEVERE, "PreparedStatement=" + pstmt);
                    }
                    try {
                        if (StiOptions.Dictionary.getQueryTimeout() > 0) {
                            pstmt.setQueryTimeout(StiOptions.Dictionary.getQueryTimeout());
                        } else {
                            pstmt.setQueryTimeout(((StiSqlSource)source).getCommandTimeout());
                        }
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel < 10) break block12;
                        e.printStackTrace();
                    }
                }
                if (!(source instanceof StiOracleSource) || ((StiOracleSource)source).getType() != StiSqlSourceType.StoredProcedure) ** GOTO lbl41
                pstmt.executeUpdate();
                refCursorIndex = (Integer)res.get("refCursorIndex");
                outParameters = (ArrayList)res.get("outParameters");
                if (refCursorIndex < 0) break block14;
                rs = (ResultSet)DataRow.getValue("getObject", refCursorIndex, pstmt);
                ** GOTO lbl42
            }
            if (outParameters.size() <= 0) break block13;
            dataRow = table.createNewRow();
            for (columnIndex = 1; columnIndex < outParameters.size() + 1; ++columnIndex) {
                column = source.getColumns().get(((QueryParameter)outParameters.get((int)(columnIndex - 1))).name.substring(1));
                dataRow.addSqlCell(column.getName(), ((QueryParameter)outParameters.get((int)(columnIndex - 1))).index, StiDataColumnsUtil.getSqlType(column.getType()), pstmt, source.getDictionary().getReport().getConvertNulls());
            }
            source.setDataTable(table);
            StiCloseUtil.close((Statement)pstmt);
            return;
        }
        try {
            throw new StiException("Output parameters not defined: " + query);
lbl41:
            // 1 sources

            rs = pstmt.executeQuery();
lbl42:
            // 2 sources

            this.getData(table, rs, source.getDictionary().getReport().getConvertNulls());
        }
        catch (Exception e) {
            try {
                if (source != null && source.getDictionary() != null && source.getDictionary().getReport() != null) {
                    source.getDictionary().getReport().WriteToReportRenderingMessages("PreparedStatement=" + pstmt + " " + (e.getMessage() != null ? e.getMessage() : e.getStackTrace()[0].toString()));
                }
                StiJDBCDatabase.LOG.log(Level.SEVERE, "PreparedStatement=" + pstmt);
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable var12_14) {
                StiCloseUtil.close(pstmt);
                throw var12_14;
            }
        }
        StiCloseUtil.close((Statement)pstmt);
        source.setDataTable(table);
    }

    public DataTable getData(DataTable dataTable, ResultSet rs) throws SQLException {
        return this.getData(dataTable, rs, true);
    }

    public DataTable getData(DataTable dataTable, ResultSet rs, Boolean convertNull) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        int emptyNameIndex = 0;
        while (rs.next()) {
            DataRow dataRow = dataTable.createNewRow();
            for (int columnIndex = 1; columnIndex < columnCount + 1; ++columnIndex) {
                String columnName = rsmd.getColumnLabel(columnIndex);
                columnName = !"".equals(columnName) ? columnName : StiLocalization.Get((String)"PropertyMain", (String)"Column") + (++emptyNameIndex == 1 ? "" : Integer.valueOf(emptyNameIndex));
                dataRow.addSqlCell(columnName, columnIndex, rsmd.getColumnType(columnIndex), rsmd.getColumnTypeName(columnIndex), rs, convertNull);
            }
        }
        return dataTable;
    }

    @Override
    public void disconnect() {
        if (StiOptions.Dictionary.autoCloseConnection) {
            try {
                if (this.con != null && !this.con.isClosed()) {
                    StiCloseUtil.close((Connection)this.con);
                }
                for (Connection conn : this.connections) {
                    if (conn.isClosed()) continue;
                    StiCloseUtil.close((Connection)conn);
                }
            }
            catch (Exception e) {
                StiLoggingUtil.showWarning((String)("Error close connection: " + this.con), (Exception)e);
                LOG.warning(e.getMessage());
            }
        }
    }

    private Map<String, Object> getPreparedStatement(String query, StiDataStoreSource source) throws SQLException, StiException {
        PreparedStatement pstmt;
        HashMap<String, Object> result = new HashMap<String, Object>();
        StiText tempText = new StiText();
        tempText.setName("**DataSourceSqlCommand**");
        tempText.setPage(source.getDictionary().getReport().getPages().get(0));
        List<Object> parsedQuery = StiJDBCDatabase.getQueryParameter(query, this.con, source);
        ArrayList queryParameters = (ArrayList)parsedQuery.get(0);
        query = (String)parsedQuery.get(1);
        if (source instanceof StiOracleSource && ((StiOracleSource)source).getType() == StiSqlSourceType.StoredProcedure) {
            String parsedValue = (String)StiParser.ParseTextValue(query, (StiComponent)tempText);
            pstmt = parsedValue.startsWith("?") ? this.con.prepareCall("{" + parsedValue + "}") : this.con.prepareCall(parsedValue);
            int refCursorIndex = -1;
            ArrayList<QueryParameter> outParameters = new ArrayList<QueryParameter>();
            for (QueryParameter queryParameter : queryParameters) {
                if (queryParameter.name.toLowerCase().indexOf("refcursor") >= 0) {
                    refCursorIndex = queryParameter.index;
                    StiJDBCDatabase.registerOutParameterOracle(pstmt, refCursorIndex, -10);
                    continue;
                }
                StiDataParameter reportParameter = source.getParameters().getByName(queryParameter.name.substring(1));
                if (reportParameter == null) {
                    reportParameter = source.getVariableParameterByName(queryParameter.name.substring(1));
                }
                if (reportParameter != null) {
                    pstmt.setObject(queryParameter.index, reportParameter.getParameterValueByDatabace());
                    continue;
                }
                StiDataColumn column = source.getColumns().get(queryParameter.name.substring(1));
                if (column == null) {
                    throw new StiException("Parameter " + queryParameter.name.substring(1) + " not found. DataSource: " + this.getName() + " table: " + (source != null ? source.getName() : ""));
                }
                StiJDBCDatabase.registerOutParameterOracle(pstmt, queryParameter.index, StiDataColumnsUtil.getSqlType(column.getType()));
                outParameters.add(queryParameter);
            }
            result.put("refCursorIndex", refCursorIndex);
            result.put("outParameters", outParameters);
        } else if ((queryParameters == null || queryParameters.size() == 0) && source.getParameters().size() > 0) {
            StiNamedParameterStatement namedPstmt = new StiNamedParameterStatement(this.con, (String)StiParser.ParseTextValue(query, (StiComponent)tempText));
            for (StiDataParameter param : source.getParameters()) {
                namedPstmt.setObject(param.getName(), param.getParameterValueByDatabace());
            }
            pstmt = namedPstmt.getStatement();
        } else {
            pstmt = this.con.prepareStatement((String)StiParser.ParseTextValue(query, (StiComponent)tempText));
            for (QueryParameter queryParameter : queryParameters) {
                StiDataParameter reportParameter = source.getParameters().getByName(queryParameter.name.substring(1));
                if (reportParameter == null) {
                    reportParameter = source.getVariableParameterByName(queryParameter.name.substring(1));
                }
                if (reportParameter == null) {
                    throw new StiException("Parameter " + queryParameter.name.substring(1) + " not found. DataSource: " + this.getName() + " table: " + (source != null ? source.getName() : ""));
                }
                pstmt.setObject(queryParameter.index, reportParameter.getParameterValueByDatabace());
            }
        }
        result.put("pstmt", pstmt);
        return result;
    }

    public static void registerOutParameterOracle(Object pstmt, int index, int sqlType) {
        try {
            Class<?> cl = Class.forName("oracle.jdbc.OracleCallableStatement");
            cl.getMethod("registerOutParameter", Integer.TYPE, Integer.TYPE).invoke(pstmt, index, sqlType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<QuoteFinder> extractTexts(String text) {
        ArrayList<QuoteFinder> result = new ArrayList<QuoteFinder>();
        boolean qOpen = false;
        QuoteFinder quote = null;
        String txt = "";
        for (int i = 0; i < text.length(); ++i) {
            if (qOpen && text.charAt(i) != '\'') {
                txt = txt + text.charAt(i);
                continue;
            }
            if (qOpen && text.charAt(i) == '\'') {
                quote.text = txt;
                quote.end = i;
                result.add(quote);
                qOpen = false;
                continue;
            }
            if (qOpen || text.charAt(i) != '\'') continue;
            qOpen = true;
            txt = "";
            quote = new QuoteFinder();
            quote.start = i;
        }
        return result;
    }

    public static List<Object> getQueryParameter(String query, Connection con, StiDataSource source) throws SQLException {
        int i;
        ArrayList<QueryParameter> result = new ArrayList<QueryParameter>();
        Matcher matcher = pattern.matcher(query);
        int index = 0;
        HashMap<Integer, Integer> replacedParams = new HashMap<Integer, Integer>();
        List<QuoteFinder> texts = StiJDBCDatabase.extractTexts(query);
        while (matcher.find()) {
            String paramStr = matcher.group().substring(1);
            boolean inQuote = false;
            for (QuoteFinder text : texts) {
                if (matcher.start() < text.start || matcher.end() > text.end) continue;
                inQuote = true;
            }
            if (inQuote) continue;
            StiText tempText = new StiText();
            tempText.setName("**DataSourceSqlCommand**");
            tempText.setPage(source.getDictionary().getReport().getPages().get(0));
            String tQuery = new StringBuilder(query).replace(matcher.start() + 1, matcher.end(), "?").toString();
            if (con.getMetaData().getDatabaseProductName().toLowerCase().indexOf("postgre") == -1 && con.getMetaData().getDatabaseProductName().toLowerCase().indexOf("oracle") == -1 && con.getMetaData().getDatabaseProductName().toLowerCase().indexOf("microsoft") == -1) {
                String parsedValue = (String)StiParser.ParseTextValue(tQuery, (StiComponent)tempText);
                try {
                    PreparedStatement pstmt = con.prepareStatement(parsedValue);
                    if (pstmt.getParameterMetaData().getParameterCount() != 1) continue;
                    result.add(new QueryParameter(++index, paramStr));
                    replacedParams.put(matcher.start() + 1, matcher.end());
                    continue;
                }
                catch (Exception e) {
                    if (source != null && source.getDictionary() != null && source.getDictionary().getReport() != null) {
                        source.getDictionary().getReport().WriteToReportRenderingMessages("Original query: " + query + " Param: " + paramStr + ", # " + index + ", SQL statement: " + parsedValue + " " + (e.getMessage() != null ? e.getMessage() : e.getStackTrace()[0].toString()));
                    }
                    LOG.severe("Original query: " + query);
                    LOG.severe("Param: " + paramStr + ", # " + index + ", SQL statement: " + parsedValue);
                    throw new RuntimeException(e);
                }
            }
            result.add(new QueryParameter(++index, paramStr));
            replacedParams.put(matcher.start() + 1, matcher.end());
        }
        ArrayList sortedKeys = new ArrayList(replacedParams.keySet());
        Collections.sort(sortedKeys);
        StringBuilder queryResult = new StringBuilder(query);
        for (i = sortedKeys.size() - 1; i >= 0; --i) {
            queryResult.replace((Integer)sortedKeys.get(i), (Integer)replacedParams.get(sortedKeys.get(i)), "?");
        }
        i = queryResult.indexOf("@@");
        while (i != -1) {
            queryResult.replace(i, i + 2, "@");
            ++i;
            i = queryResult.indexOf("@@", i);
        }
        ArrayList<Object> res = new ArrayList<Object>();
        res.add(result);
        res.add(queryResult.toString());
        return res;
    }

    public void testConnection(Connection con, StiAbstractAdapter adapter) throws SQLException {
        if (adapter instanceof StiOracleAdapter) {
            Statement statement = con.createStatement();
            statement.executeQuery("select t.owner from dba_tables t, DBA_TAB_COLUMNS");
            statement.close();
        } else {
            con.getMetaData().getTables(null, null, "%", null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public StiDatabaseInformation getDatabaseInformation(Connection con, StiAbstractAdapter adapter, StiReport report) {
        String db;
        StiDatabaseInformation information;
        block28: {
            Hashtable<String, DataTable> tableHash;
            block27: {
                information = new StiDatabaseInformation();
                tableHash = new Hashtable<String, DataTable>();
                db = adapter.getLeastOne(adapter.getDatabaseName(), adapter.getParsedParameters().getOriginalKeyValue());
                if (adapter instanceof StiOracleAdapter) {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            DataTable table = null;
                            Statement statement = con.createStatement();
                            String query = i == 0 ? "select t.owner, t.table_name, c.column_name, c.data_type from dba_tables t, DBA_TAB_COLUMNS c where t.owner=c.owner and t.table_name = c.table_name and t.owner != 'SYS' and t.owner != 'SYSTEM' and t.owner != 'MDSYS' and t.owner != 'XDB' order by t.owner, t.table_name, c.column_name" : (i == 1 ? "select col.owner , col.table_name, col.column_name, col.data_type from sys.all_tab_columns col inner join sys.all_views v on col.owner = v.owner and col.table_name = v.view_name where v.owner != 'SYS' and v.owner != 'SYSTEM' and v.owner != 'MDSYS' and v.owner != 'XDB' order by col.owner, col.table_name, col.column_id" : "SELECT owner, object_name FROM ALL_PROCEDURES WHERE OBJECT_TYPE='PROCEDURE' order by owner, object_name");
                            ResultSet resultSet = statement.executeQuery(query);
                            while (resultSet.next()) {
                                String tableName = String.format("%s.%s", resultSet.getString("owner"), i == 2 ? resultSet.getString("object_name") : resultSet.getString("table_name"));
                                if (table == null || !tableName.equals(table.getName())) {
                                    table = new DataTable(tableName);
                                    tableHash.put(table.getTableName(), table);
                                    if (i == 0) {
                                        information.getTables().add(table);
                                    } else if (i == 1) {
                                        information.getViews().add(table);
                                    } else {
                                        information.getStoredProcedures().add(table);
                                    }
                                }
                                if (i > 1) continue;
                                table.getColumns().add(new StiDataColumn(resultSet.getString("column_name"), resultSet.getString("column_name"), StiDataColumnsUtil.getOracleSystemType(resultSet.getString("data_type"))));
                            }
                            statement.close();
                            continue;
                        }
                        catch (Exception e) {
                            if (StiOptions.Engine.logLevel < 10) continue;
                            e.printStackTrace();
                        }
                    }
                    return information;
                }
                try {
                    ResultSet tablesSet = con.getMetaData().getTables(db, null, "%", null);
                    while (tablesSet.next()) {
                        try {
                            if (StiValidationUtil.isNotNullOrEmpty((String)tablesSet.getString("TABLE_SCHEM")) && "sys".equals(tablesSet.getString("TABLE_SCHEM").toLowerCase())) continue;
                            DataTable table = null;
                            if (!"dbo".equals(tablesSet.getString("TABLE_SCHEM")) && tablesSet.getString("TABLE_SCHEM") != null) {
                                table = adapter instanceof StiOracleAdapter ? new DataTable(String.format("%s.%s", tablesSet.getString("TABLE_SCHEM"), tablesSet.getString("TABLE_NAME"))) : new DataTable(String.format("%s (%s)", tablesSet.getString("TABLE_NAME"), tablesSet.getString("TABLE_SCHEM")));
                            } else if (adapter instanceof StiPostgreSqlAdapter) {
                                String schem = tablesSet.getString("TABLE_SCHEM") != null ? tablesSet.getString("TABLE_SCHEM") : "public";
                                table = new DataTable(tablesSet.getString("TABLE_NAME"), String.format("select * from %s.%s", this.getDatabaseSpecificName(schem), this.getDatabaseSpecificName(tablesSet.getString("TABLE_NAME"))));
                            } else {
                                table = new DataTable(tablesSet.getString("TABLE_NAME"));
                            }
                            if (tablesSet.getString("TABLE_TYPE") == null) continue;
                            if (tablesSet.getString("TABLE_TYPE").toLowerCase().indexOf("view") >= 0 && !information.containsView(table.getTableName())) {
                                tableHash.put(table.getTableName(), table);
                                information.getViews().add(table);
                            }
                            if (tablesSet.getString("TABLE_TYPE").toLowerCase().indexOf("table") < 0 || information.containsTable(table.getTableName())) continue;
                            tableHash.put(table.getTableName(), table);
                            information.getTables().add(table);
                        }
                        catch (Exception e) {
                            if (StiOptions.Engine.logLevel < 10) continue;
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block27;
                    e.printStackTrace();
                }
            }
            try {
                ResultSet columnsSet = con.getMetaData().getColumns(db, null, null, null);
                while (columnsSet.next()) {
                    if (StiValidationUtil.isNotNullOrEmpty((String)columnsSet.getString("TABLE_SCHEM")) && "sys".equals(columnsSet.getString("TABLE_SCHEM").toLowerCase())) continue;
                    String columnName = columnsSet.getString("COLUMN_NAME");
                    String tableName = columnsSet.getString("TABLE_SCHEM") != null && !"sys".equals(columnsSet.getString("TABLE_SCHEM")) && !"dbo".equals(columnsSet.getString("TABLE_SCHEM")) ? (adapter instanceof StiOracleAdapter ? String.format("%s.%s", columnsSet.getString("TABLE_SCHEM"), columnsSet.getString("TABLE_NAME")) : String.format("%s (%s)", columnsSet.getString("TABLE_NAME"), columnsSet.getString("TABLE_SCHEM"))) : columnsSet.getString("TABLE_NAME");
                    StiSystemType columnType = StiDataColumnsUtil.getSystemType(columnsSet.getInt("DATA_TYPE"));
                    StiDataColumn column = new StiDataColumn(columnName, columnName, columnType);
                    if (!tableHash.containsKey(tableName)) continue;
                    ((DataTable)tableHash.get(tableName)).getColumns().add(column);
                }
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block28;
                e.printStackTrace();
            }
        }
        Hashtable<String, DataTable> procedureHash = new Hashtable<String, DataTable>();
        try {
            ResultSet proceduresSet = con.getMetaData().getProcedures(db, null, null);
            while (proceduresSet.next()) {
                if (StiValidationUtil.isNotNullOrEmpty((String)proceduresSet.getString("PROCEDURE_SCHEM")) && "sys".equals(proceduresSet.getString("PROCEDURE_SCHEM").toLowerCase())) continue;
                String procName = proceduresSet.getString("PROCEDURE_SCHEM") != null && !"dbo".equals(proceduresSet.getString("PROCEDURE_SCHEM")) ? String.format("[%s].[%s]", proceduresSet.getString("PROCEDURE_SCHEM"), proceduresSet.getString("PROCEDURE_SCHEM")) : proceduresSet.getString("SPECIFIC_NAME");
                DataTable procedure = new DataTable(procName);
                procedureHash.put(procedure.getTableName(), procedure);
                information.getStoredProcedures().add(procedure);
                ResultSet pColumns = con.getMetaData().getProcedureColumns(db, null, proceduresSet.getString("PROCEDURE_NAME"), null);
                while (pColumns.next()) {
                    if (pColumns.getInt("COLUMN_TYPE") != 1 && pColumns.getInt("COLUMN_TYPE") != 4) continue;
                    StiSystemType columnType = StiDataColumnsUtil.getSystemType(pColumns.getInt("DATA_TYPE"));
                    StiDataColumn column = new StiDataColumn(pColumns.getString("COLUMN_NAME"), pColumns.getString("COLUMN_NAME"), columnType);
                    column.setCaption(pColumns.getInt("COLUMN_TYPE") == 1 ? "Parameters" : "Columns");
                    procedure.getColumns().add(column);
                }
            }
            return information;
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel < 10) return information;
            e.printStackTrace();
        }
        return information;
    }

    @Override
    public void applyDatabaseInformation(StiDatabaseInformation information, StiReport report, StiDatabaseInformation informationAll) {
        StiDataColumn column;
        StiDataColumn dataColumn;
        String table;
        StiSqlSource source;
        for (DataTable dataTable : information.getTables()) {
            source = new StiSqlSource(this.getName(), StiNameCreation.createName(report, dataTable.getTableName(), false, false, true));
            table = dataTable.getTableName();
            String columnsSelect = "";
            if (table.trim().contains(" ") && !(this instanceof StiPostgreSQLDatabase)) {
                table = String.format("[%s]", table);
            }
            Iterator iterator = dataTable.getColumns().iterator();
            while (iterator.hasNext()) {
                dataColumn = (StiDataColumn)iterator.next();
                column = new StiDataColumn(dataColumn.getName(), dataColumn.getName(), dataColumn.getSystemType());
                column.setDataSource(source);
                source.getColumns().add(column);
                columnsSelect = columnsSelect + dataColumn.getName() + ",";
            }
            columnsSelect = informationAll != null && dataTable.getColumns().size() != informationAll.getTables().get(information.getTables().indexOf(dataTable)).getColumns().size() ? columnsSelect.substring(0, columnsSelect.length() - 1) : "*";
            int indexScheme = table.indexOf(" (");
            if (indexScheme != -1) {
                String nameDataBase = table.substring(0, indexScheme);
                String scheme = table.substring(indexScheme + 2, table.indexOf(")"));
                if (!(this instanceof StiPostgreSQLDatabase)) {
                    source.setSqlCommand(String.format("select * from [%s].[%s]", scheme, nameDataBase.startsWith("[") ? nameDataBase.substring(1) : nameDataBase));
                } else {
                    source.setSqlCommand(String.format("select * from \"%s\".\"%s\"", scheme, nameDataBase));
                }
            } else {
                source.setSqlCommand(StiValidationUtil.isNullOrEmpty((String)dataTable.getQuery()) ? "select " + columnsSelect + " from " + table : dataTable.getQuery());
            }
            report.getDictionary().getDataSources().add(source);
            source.setDictionary(report.getDictionary());
        }
        for (DataTable dataTable : information.getViews()) {
            Object nameDataBase;
            int indexScheme;
            source = new StiSqlSource(this.getName(), StiNameCreation.createName(report, dataTable.getTableName(), false, false, true));
            table = dataTable.getTableName();
            if (table.trim().contains(" ")) {
                table = String.format("[%s]", table);
            }
            if ((indexScheme = table.indexOf(" (")) != -1) {
                nameDataBase = table.substring(1, indexScheme - 1);
                String scheme = table.substring(indexScheme + 2, table.length() - ((String)nameDataBase).length() + indexScheme - 4);
                if (!(this instanceof StiPostgreSQLDatabase)) {
                    source.setSqlCommand(String.format("select * from [%s].[%s]", scheme, nameDataBase));
                } else {
                    source.setSqlCommand(String.format("select * from %s.%s", scheme, nameDataBase));
                }
            } else {
                source.setSqlCommand("select * from " + table);
            }
            nameDataBase = dataTable.getColumns().iterator();
            while (nameDataBase.hasNext()) {
                dataColumn = (StiDataColumn)nameDataBase.next();
                column = new StiDataColumn(dataColumn.getName(), dataColumn.getName(), dataColumn.getSystemType());
                column.setDataSource(source);
                source.getColumns().add(column);
            }
            report.getDictionary().getDataSources().add(source);
            source.setDictionary(report.getDictionary());
        }
        for (DataTable dataTable : information.getStoredProcedures()) {
            source = new StiSqlSource(this.getName(), StiNameCreation.createName(report, dataTable.getTableName(), false, false, true));
            String procName = dataTable.getTableName();
            if (!procName.trim().contains("[") && !(this instanceof StiPostgreSQLDatabase)) {
                procName = String.format("[%s]", procName);
            }
            source.setSqlCommand("execute " + String.format("%s", procName));
            Iterator iterator = dataTable.getColumns().iterator();
            while (iterator.hasNext()) {
                StiDataColumn dataColumn2 = (StiDataColumn)iterator.next();
                if ("Columns".equals(dataColumn2.getCaption())) {
                    StiDataColumn procedureColumn = new StiDataColumn(dataColumn2.getName(), dataColumn2.getName(), dataColumn2.getSystemType());
                    procedureColumn.setDataSource(source);
                    procedureColumn.setName(dataColumn2.getName());
                    source.getColumns().add(procedureColumn);
                    continue;
                }
                StiDataParameter procedureParameter = new StiDataParameter();
                procedureParameter.setDataSource(source);
                procedureParameter.setName(dataColumn2.getName());
                source.getParameters().add(procedureParameter);
            }
            if (source.getParameters().size() > 0) {
                source.setSqlCommand(dataTable.getTableName());
                source.setType(StiSqlSourceType.StoredProcedure);
            }
            report.getDictionary().getDataSources().add(source);
            source.setDictionary(report.getDictionary());
        }
    }

    @Override
    public String toString() {
        return "StiJDBCDatabase [promptUserNameAndPassword=" + this.promptUserNameAndPassword + ", url=" + this.url + ", user=" + this.user + ", password=****, driver=" + this.driver + ", other=" + this.other + "]";
    }

    public void setConnection(Connection con) {
        this.con = con;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDatabaseSpecificName(String name) {
        return name;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("User")) {
                this.user = (String)property.Value;
                continue;
            }
            if (property.Name.equals("ConnectionStringEncrypted")) {
                try {
                    this.setConnectionStringEncrypted((String)property.Value);
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (property.Name.equals("Password")) {
                this.setPassword((String)property.Value);
                continue;
            }
            if (property.Name.equals("Driver")) {
                this.setDriver((String)property.Value);
                continue;
            }
            if (!property.Name.equals("PromptUserNameAndPassword")) continue;
            this.setPromptUserNameAndPassword((Boolean)property.Value);
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("User", this.getUser());
        jObject.AddPropertyStringNullOfEmpty("Password", this.getPassword());
        jObject.AddPropertyStringNullOfEmpty("Driver", this.getDriver());
        try {
            jObject.AddPropertyStringNullOfEmpty("ConnectionStringEncrypted", this.getConnectionStringEncrypted());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        jObject.AddPropertyBool("PromptUserNameAndPassword", this.getPromptUserNameAndPassword(), false);
        return jObject;
    }

    public StiJDBCDatabase createSqlConnector() {
        return this;
    }

    public String getSampleConnectionString() {
        return "url=myUrl;user=myUserName;password=myPassword;driver=myDriver";
    }

    private static class QuoteFinder {
        String text;
        int start;
        int end;

        private QuoteFinder() {
        }
    }
}

