/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.dataSources;

import com.stimulsoft.base.system.StiDictionaryEntry;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.view.series.StiSeries;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiDataHelper;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.conditions.StiBaseCondition;
import com.stimulsoft.report.components.conditions.StiCondition;
import com.stimulsoft.report.components.conditions.StiFilter;
import com.stimulsoft.report.components.conditions.StiMultiCondition;
import com.stimulsoft.report.components.enums.StiFilterMode;
import com.stimulsoft.report.components.interfaces.IStiConditions;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiSimpleText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.simplecomponents.StiZipCode;
import com.stimulsoft.report.crossTab.StiCrossCell;
import com.stimulsoft.report.crossTab.StiCrossHeader;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.enums.StiItemsInitializationType;
import com.stimulsoft.report.dictionary.enums.StiVariableInitBy;
import com.stimulsoft.report.engine.parser.StiAsmCommand;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.engine.parser.enums.StiAsmCommandType;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class StiDataSourceHelper {
    public static void checkExpression(String expression, StiComponent component, Hashtable<String, Hashtable<String, String>> datasourcesNames) {
        block3: {
            try {
                boolean storeToPrint = false;
                Object result = StiParser.ParseTextValue(expression, component, storeToPrint, false, true, false);
                if (result == null || !(result instanceof List)) {
                    return;
                }
                StiDataSourceHelper.checkAsmCommandList((List)result, component, datasourcesNames);
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block3;
                e.printStackTrace();
            }
        }
    }

    private static void checkAsmCommandList(List<StiAsmCommand> list, StiComponent component, Hashtable<String, Hashtable<String, String>> datasourcesNames) {
        block7: {
            try {
                for (StiAsmCommand asmCommand : list) {
                    if (asmCommand.Type == StiAsmCommandType.PushValue && asmCommand.Parameter1 instanceof List) {
                        StiDataSourceHelper.checkAsmCommandList((List)asmCommand.Parameter1, component, datasourcesNames);
                        continue;
                    }
                    if (asmCommand.Type != StiAsmCommandType.PushDataSourceField || asmCommand.Type != StiAsmCommandType.PushDataSourceField) continue;
                    String[] parts = ((String)asmCommand.Parameter1).split("\\.");
                    StiDataSource ds = component.getReport().getDictionary().getDataSources().get(parts[0]);
                    StiDataSourceHelper.addDataSourceName(datasourcesNames, ds.getName());
                    if (parts.length <= 2) continue;
                    String nameInSource = parts[1];
                    StiDataRelation relation = null;
                    for (StiDataRelation rel : ds.GetParentRelations()) {
                        if (!StiValidationUtil.equals((Object)rel.getNameInSource(), (Object)nameInSource) || relation != null) continue;
                        relation = rel;
                    }
                    StiDataSourceHelper.addRelation(datasourcesNames, relation);
                    ds = ds.GetParentDataSource(nameInSource);
                    StiDataSourceHelper.addDataSourceName(datasourcesNames, ds.getName());
                    for (int indexPart = 2; indexPart < parts.length - 1; ++indexPart) {
                        nameInSource = parts[indexPart];
                        StiDataRelation relation2 = null;
                        for (StiDataRelation rel : ds.GetParentRelations()) {
                            if (!StiValidationUtil.equals((Object)rel.getNameInSource(), (Object)nameInSource) || relation2 != null) continue;
                            relation2 = rel;
                        }
                        StiDataSourceHelper.addRelation(datasourcesNames, relation2);
                        ds = ds.GetParentDataSource(nameInSource);
                        StiDataSourceHelper.addDataSourceName(datasourcesNames, ds.getName());
                    }
                }
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block7;
                e.printStackTrace();
            }
        }
    }

    private static void addDataSourceName(Hashtable<String, Hashtable<String, String>> hashtable, String dataSourceName) {
        if (!hashtable.containsKey(dataSourceName)) {
            hashtable.put(dataSourceName, new Hashtable());
        }
    }

    private static void addDataSourceColumn(Hashtable<String, Hashtable<String, String>> hashtable, String dataSourceName, String columnName) {
        Hashtable<String, String> hash = hashtable.get(dataSourceName);
        if (hash == null) {
            hash = new Hashtable();
            hashtable.put(dataSourceName, hash);
        }
        hash.put(columnName, columnName);
    }

    private static void addRelation(Hashtable<String, Hashtable<String, String>> hashtable, StiDataRelation relation) {
        if (relation != null) {
            if (relation.getChildSource() != null) {
                StiDataSourceHelper.addDataSourceName(hashtable, relation.getChildSource().getName());
                for (String st : relation.getChildColumns()) {
                    StiDataSourceHelper.addDataSourceColumn(hashtable, relation.getChildSource().getName(), st);
                }
            }
            if (relation.getParentSource() != null) {
                StiDataSourceHelper.addDataSourceName(hashtable, relation.getParentSource().getName());
                for (String st : relation.getParentColumns()) {
                    StiDataSourceHelper.addDataSourceColumn(hashtable, relation.getParentSource().getName(), st);
                }
            }
        }
    }

    public static Hashtable<String, Hashtable<String, String>> getDataSourcesUsedInRequestFromUsersVariables(StiReport report) {
        Hashtable<String, Hashtable<String, String>> datasourcesNames = new Hashtable<String, Hashtable<String, String>>();
        StiText comp = new StiText();
        comp.setName("*RequestFromUserVariable*");
        comp.setPage(new StiPage(report));
        Iterator iterator = report.getDictionary().getVariables().iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            if (!variable.getRequestFromUser()) continue;
            if (variable.getDialogInfo().getItemsInitializationType() == StiItemsInitializationType.Columns) {
                StiDataSourceHelper.checkExpression("{" + variable.getDialogInfo().getKeysColumn() + "}", comp, datasourcesNames);
            }
            if (variable.getInitBy() != StiVariableInitBy.Expression) continue;
            StiDataSourceHelper.checkExpression("{" + variable.getValue() + "}", comp, datasourcesNames);
            if (!variable.getSystemType().isRange()) continue;
            StiDataSourceHelper.checkExpression("{" + variable.getInitByExpressionFrom() + "}", comp, datasourcesNames);
            StiDataSourceHelper.checkExpression("{" + variable.getInitByExpressionTo() + "}", comp, datasourcesNames);
        }
        return datasourcesNames;
    }

    private static void addSort(Hashtable<String, Hashtable<String, String>> hashtable, StiComponent tempComp, ArrayList<String> sortArray, String dataSourceName) {
        for (int index = 1; index < sortArray.size(); index += 2) {
            String st2 = sortArray.get(index);
            if (st2.startsWith("{")) {
                StiDataSourceHelper.checkExpression(st2, tempComp, hashtable);
                continue;
            }
            StiDataSourceHelper.addDataSourceColumn(hashtable, dataSourceName, st2);
        }
    }

    public static Hashtable<String, Hashtable<String, String>> getUsedDataSourcesNames(StiReport report) {
        Hashtable<String, Hashtable<String, String>> datasourcesNames = new Hashtable<String, Hashtable<String, String>>();
        StiPage tempPage = report.getRenderedPages().size() > 0 ? report.getRenderedPages().get(0) : new StiPage(report);
        StiText tempComp = new StiText();
        tempComp.setPage(tempPage);
        tempComp.setName("*GetUsedDataSourcesNames*");
        StiComponentsCollection comps = report.GetComponents();
        for (int indexComp = 0; indexComp < comps.size(); ++indexComp) {
            StiComponent component = (StiComponent)comps.get(indexComp);
            try {
                StiComponent icondition;
                StiPage page;
                StiChart chart;
                StiCheckBox checkbox;
                StiZipCode zipcode;
                StiBarCode barcode;
                StiImage stiImage;
                StiRichText richText;
                StiText stiText;
                StiSimpleText stiSimpleText;
                StiCrossHeader crossHeader;
                StiCrossCell crossCell;
                StiGroupHeaderBand groupHeaderBand;
                StiCrossTab crosstab;
                StiDataBand dataBand;
                StiDataBand stiDataBand = dataBand = component instanceof StiDataBand ? (StiDataBand)component : null;
                if (dataBand != null && StiValidationUtil.isNotNullOrEmpty((String)dataBand.getDataSourceName())) {
                    StiDataSourceHelper.addDataSourceName(datasourcesNames, dataBand.getDataSourceName());
                    StiDataSourceHelper.addRelation(datasourcesNames, dataBand.getDataRelation());
                    StiDataSourceHelper.addSort(datasourcesNames, tempComp, dataBand.getSort(), dataBand.getDataSourceName());
                }
                StiCrossTab stiCrossTab = crosstab = component instanceof StiCrossTab ? (StiCrossTab)component : null;
                if (crosstab != null && StiValidationUtil.isNotNullOrEmpty((String)crosstab.getDataSourceName())) {
                    StiDataSourceHelper.addDataSourceName(datasourcesNames, crosstab.getDataSourceName());
                    StiDataSourceHelper.addSort(datasourcesNames, tempComp, crosstab.getSort(), crosstab.getDataSourceName());
                }
                StiGroupHeaderBand stiGroupHeaderBand = groupHeaderBand = component instanceof StiGroupHeaderBand ? (StiGroupHeaderBand)component : null;
                if (groupHeaderBand != null) {
                    StiDataSourceHelper.checkExpression(groupHeaderBand.getCondition().getValue(), component, datasourcesNames);
                }
                StiCrossCell stiCrossCell = crossCell = component instanceof StiCrossCell ? (StiCrossCell)component : null;
                if (crossCell != null) {
                    StiDataSourceHelper.checkExpression(crossCell.getValue().getValue(), component, datasourcesNames);
                }
                StiCrossHeader stiCrossHeader = crossHeader = component instanceof StiCrossHeader ? (StiCrossHeader)component : null;
                if (crossHeader != null) {
                    StiDataSourceHelper.checkExpression(crossHeader.getDisplayValue().getValue(), component, datasourcesNames);
                }
                StiSimpleText stiSimpleText2 = stiSimpleText = component instanceof StiSimpleText ? (StiSimpleText)component : null;
                if (stiSimpleText != null) {
                    StiDataSourceHelper.checkExpression(stiSimpleText.getText().getValue(), component, datasourcesNames);
                }
                StiText stiText2 = stiText = component instanceof StiText ? (StiText)component : null;
                if (stiText != null) {
                    StiDataSourceHelper.checkExpression(stiText.getExcelValue().getValue(), component, datasourcesNames);
                }
                StiRichText stiRichText = richText = component instanceof StiRichText ? (StiRichText)component : null;
                if (richText != null) {
                    // empty if block
                }
                StiImage stiImage2 = stiImage = component instanceof StiImage ? (StiImage)component : null;
                if (stiImage != null) {
                    StiDataSourceHelper.checkExpression(stiImage.getImageData().getValue(), component, datasourcesNames);
                    StiDataSourceHelper.checkExpression("{" + stiImage.getDataColumn() + "}", component, datasourcesNames);
                }
                StiBarCode stiBarCode = barcode = component instanceof StiBarCode ? (StiBarCode)component : null;
                if (barcode != null) {
                    StiDataSourceHelper.checkExpression(barcode.getCode().getValue(), component, datasourcesNames);
                }
                StiZipCode stiZipCode = zipcode = component instanceof StiZipCode ? (StiZipCode)component : null;
                if (zipcode != null) {
                    StiDataSourceHelper.checkExpression(zipcode.getCode().getValue(), component, datasourcesNames);
                }
                StiCheckBox stiCheckBox = checkbox = component instanceof StiCheckBox ? (StiCheckBox)component : null;
                if (checkbox != null) {
                    StiDataSourceHelper.checkExpression(checkbox.getChecked().getValue(), component, datasourcesNames);
                }
                StiChart stiChart = chart = component instanceof StiChart ? (StiChart)component : null;
                if (chart != null) {
                    if (!StiValidationUtil.isNullOrEmpty((String)chart.getDataSourceName())) {
                        StiDataSourceHelper.addDataSourceName(datasourcesNames, chart.getDataSourceName());
                    }
                    for (IStiSeries ser : chart.getSeries()) {
                        StiSeries series = (StiSeries)ser;
                        StiDataSourceHelper.checkExpression(series.getArgument().getValue(), component, datasourcesNames);
                        StiDataSourceHelper.checkExpression("{" + series.getArgumentDataColumn() + "}", component, datasourcesNames);
                    }
                }
                StiPage stiPage = page = component instanceof StiPage ? (StiPage)component : null;
                if (page != null) {
                    StiDataSourceHelper.checkExpression(page.getExcelSheet().getValue(), component, datasourcesNames);
                }
                StiComponent stiComponent = icondition = component instanceof IStiConditions ? component : null;
                if (icondition == null || icondition.getConditions().size() <= 0) continue;
                ArrayList<StiDictionaryEntry> conditionList = new ArrayList<StiDictionaryEntry>();
                for (StiBaseCondition cond : icondition.getConditions()) {
                    StiCondition condition = cond instanceof StiCondition ? (StiCondition)cond : null;
                    String expression = null;
                    if (cond instanceof StiMultiCondition) {
                        StiMultiCondition multiCondition = (StiMultiCondition)cond;
                        if (!multiCondition.getFilterOn() || multiCondition.getFilters().size() <= 0) continue;
                        StringBuilder conditionExpression = new StringBuilder("{");
                        for (int index = 0; index < multiCondition.getFilters().size(); ++index) {
                            StiFilter filter = (StiFilter)multiCondition.getFilters().get(index);
                            conditionExpression.append("(");
                            conditionExpression.append(StiDataHelper.GetFilterExpression(filter, filter.getColumn()));
                            conditionExpression.append(")");
                            if (index >= multiCondition.getFilters().size() - 1) continue;
                            conditionExpression.append(multiCondition.getFilterMode() == StiFilterMode.And ? " && " : " || ");
                        }
                        conditionExpression.append("}");
                        StiDictionaryEntry de = new StiDictionaryEntry((Object)multiCondition, (Object)conditionExpression.toString());
                        conditionList.add(de);
                        continue;
                    }
                    if (condition == null) continue;
                    expression = "{" + StiDataHelper.GetFilterExpression(condition, condition.getColumn()) + "}";
                    StiDictionaryEntry de = new StiDictionaryEntry((Object)condition, (Object)expression);
                    conditionList.add(de);
                }
                if (conditionList.size() <= 0) continue;
                for (StiDictionaryEntry de : conditionList) {
                    StiDataSourceHelper.checkExpression((String)de.Value, component, datasourcesNames);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String[] stringArray = report.getDictionary().getVariables().iterator();
        while (stringArray.hasNext()) {
            StiVariable vr = (StiVariable)stringArray.next();
            if (vr.getInitBy() == StiVariableInitBy.Expression) {
                StiDataSourceHelper.checkExpression("{" + vr.getValue() + "}", tempComp, datasourcesNames);
                if (vr.getType().getSystemType().isRange()) {
                    StiDataSourceHelper.checkExpression("{" + vr.getInitByExpressionFrom() + "}", tempComp, datasourcesNames);
                    StiDataSourceHelper.checkExpression("{" + vr.getInitByExpressionTo() + "}", tempComp, datasourcesNames);
                }
            }
            if (!vr.getRequestFromUser() || vr.getDialogInfo().getItemsInitializationType() != StiItemsInitializationType.Columns) continue;
            StiDataSourceHelper.checkExpression("{" + vr.getDialogInfo().getKeysColumn() + "}", tempComp, datasourcesNames);
        }
        if (report.getListOfUsedData() != null) {
            for (String st : report.getListOfUsedData()) {
                StiDataSourceHelper.addDataSourceName(datasourcesNames, st);
            }
        }
        return datasourcesNames;
    }
}

