/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.data;

import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumnsCollection;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataRowCollection;
import java.util.Iterator;

public class DataTable
implements IStiName,
Cloneable {
    private String name;
    private StiDataColumnsCollection columns;
    private String caption;
    private String query;
    private DataRowCollection rows = new DataRowCollection();

    public DataTable() {
        this("", new StiDataColumnsCollection());
    }

    public DataTable(String name) {
        this.name = name;
        this.columns = new StiDataColumnsCollection();
    }

    public DataTable(String name, String query) {
        this(name);
        this.query = query;
    }

    public DataTable(String name, StiDataColumnsCollection columns) {
        this.name = name;
        this.columns = columns;
    }

    public DataRowCollection getRows() {
        return this.rows;
    }

    public DataRow getRows(int index) {
        return (DataRow)this.rows.get(index);
    }

    public StiDataColumnsCollection getColumns() {
        return this.columns;
    }

    public void setColumns(StiDataColumnsCollection columns) {
        this.columns = columns;
    }

    public DataRow NewRow() {
        return DataRow.create(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTableName() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getDataSet() {
        return null;
    }

    public void setRows(DataRowCollection rows) {
        this.rows = rows;
    }

    public void addRow(DataRow dataRow) {
        this.rows.add(dataRow);
    }

    public void setTableName(String name) {
        this.setName(name);
    }

    public DataRow createNewRow() {
        DataRow newRow = new DataRow(this);
        this.addRow(newRow);
        return newRow;
    }

    public int getColumnIndex(String columnName) {
        return this.getColumns().getIndexByName(columnName, false);
    }

    public StiDataColumn getColumn(String columnName) {
        return this.getColumns().get(columnName);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String toString() {
        String separator = "-";
        StringBuilder builder = new StringBuilder(this.rows.size()).append(separator + this.name + separator + "\n");
        builder.append("[");
        Iterator iterator = this.columns.iterator();
        while (iterator.hasNext()) {
            StiDataColumn col = (StiDataColumn)iterator.next();
            builder.append(col);
        }
        builder.append("]");
        for (DataRow row : this.rows) {
            builder.append(row + "\n");
        }
        builder.append(separator + separator);
        return builder.toString();
    }

    public boolean existColumn(String columnName) {
        return this.columns.contains(columnName);
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }
}

