/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.businessObjects;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.enums.StiSortOrder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;

public class StiBusinessObjectsCollection
extends ArrayList<StiBusinessObject>
implements Comparator<StiBusinessObject>,
IStiJsonReportObject {
    private static final long serialVersionUID = -2373429800117245491L;
    private int directionFactor = 1;
    public Hashtable<String, StiBusinessObject> cachedBusinessObjects;
    public StiDictionary dictionary;
    public StiBusinessObject parentBusinessObject;

    public StiBusinessObjectsCollection(StiDictionary dictionary, StiBusinessObject parentBusinessObject) {
        this.dictionary = dictionary;
        this.parentBusinessObject = parentBusinessObject;
    }

    public StiBusinessObjectsCollection(List<StiBusinessObject> content) {
        super(content);
    }

    public StiBusinessObjectsCollection() {
    }

    @Override
    public StiBusinessObject set(int index, StiBusinessObject newValue) {
        StiBusinessObject businessObject;
        StiBusinessObject oldValue = super.set(index, newValue);
        StiBusinessObject stiBusinessObject = businessObject = newValue instanceof StiBusinessObject ? newValue : null;
        if (this.dictionary != null) {
            businessObject.setDictionary(this.dictionary);
        }
        if (this.parentBusinessObject != null) {
            businessObject.setParentBusinessObject(this.parentBusinessObject);
        }
        return oldValue;
    }

    public final Hashtable<String, StiBusinessObject> getCachedBusinessObjects() {
        if (this.cachedBusinessObjects == null) {
            this.cachedBusinessObjects = new Hashtable();
        }
        return this.cachedBusinessObjects;
    }

    public final StiBusinessObject getItem(String name) {
        name = name.toLowerCase();
        StiBusinessObject searchedSource = this.getCachedBusinessObjects().get(name);
        if (searchedSource != null) {
            return searchedSource;
        }
        for (StiBusinessObject source : this) {
            if (source.getName().toLowerCase().equals(name)) {
                this.getCachedBusinessObjects().put(name, source);
                return source;
            }
            if (StiNameValidator.CorrectName(source.getName().toLowerCase()) != StiNameValidator.CorrectName(name)) continue;
            this.cachedBusinessObjects.put(name, source);
            return source;
        }
        return null;
    }

    public final void setItem(String name, StiBusinessObject value) {
        name = name.toLowerCase();
        for (int index = 0; index < this.size(); ++index) {
            StiBusinessObject source;
            StiBusinessObject stiBusinessObject = source = this.get(index) instanceof StiBusinessObject ? (StiBusinessObject)((Object)this.get(index)) : null;
            if (!source.getName().toLowerCase().equals(name)) continue;
            this.set(index, value);
            return;
        }
        this.add(value);
    }

    public final void Sort() {
        this.Sort(StiSortOrder.Asc);
    }

    public final void Sort(StiSortOrder order) {
        this.Sort(order, true);
    }

    public final void Sort(StiSortOrder order, boolean sortColumns) {
        this.directionFactor = order == StiSortOrder.Asc ? 1 : -1;
    }

    public final void Connect() {
        for (StiBusinessObject businessObject : this) {
            businessObject.Connect();
        }
    }

    public final void Disconnect() {
        for (StiBusinessObject businessObject : this) {
            businessObject.Disconnect();
        }
    }

    @Override
    public int compare(StiBusinessObject o1, StiBusinessObject o2) {
        StiBusinessObject source2;
        StiBusinessObject source1 = o1 instanceof StiBusinessObject ? o1 : null;
        StiBusinessObject stiBusinessObject = source2 = o2 instanceof StiBusinessObject ? o2 : null;
        if (StiOptions.Designer.isSortDictionaryByAliases()) {
            return source1.getAlias().compareTo(source2.getAlias()) * this.directionFactor;
        }
        return source1.getName().compareTo(source2.getName()) * this.directionFactor;
    }

    @Override
    public final Object clone() {
        ArrayList clone = (ArrayList)super.clone();
        StiBusinessObjectsCollection sources = new StiBusinessObjectsCollection(this.dictionary, this.parentBusinessObject);
        sources.addAll(clone);
        return sources;
    }

    public StiBusinessObject get(String string) {
        return null;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        for (StiBusinessObject businessObject : this) {
            jObject.AddPropertyJObject(index.toString(), businessObject.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            StiBusinessObject businessObject = new StiBusinessObject();
            businessObject.setDictionary(this.dictionary);
            businessObject.LoadFromJsonObject((JSONObject)property.Value);
            this.add(businessObject);
        }
    }
}

