/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import java.util.Date;

public class StiMaxTimeFunctionService
extends StiAggregateFunctionService {
    private Date maximum = new Date();
    private boolean valueProcessed = false;

    public StiMaxTimeFunctionService() {
    }

    public StiMaxTimeFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    @Override
    public void CalcItem(Object value) {
        if (value instanceof Date) {
            Date timeValue = (Date)value;
            if (this.valueProcessed) {
                if (this.maximum.after(timeValue)) {
                    this.maximum = timeValue;
                }
            } else {
                this.maximum = timeValue;
                this.valueProcessed = true;
            }
        }
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    @Override
    public Class GetResultType() {
        return Date.class;
    }

    public String getServiceName() {
        return "MaxTime";
    }

    @Override
    public Object GetValue() {
        return this.maximum;
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.valueProcessed = false;
        }
    }

    @Override
    public void SetValue(Object value) {
        this.maximum = (Date)value;
    }
}

