/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.StiValueCollection;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.utils.StiCollectionsUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.enums.StiSortOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class StiVariablesCollection
extends StiValueCollection<StiVariable> {
    private static final long serialVersionUID = -8109782982172087329L;
    private final int directionFactor = 1;

    public JSONObject SaveToJsonObjectEx(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            jObject.AddPropertyJObject(index.toString(), variable.SaveToJsonObjectEx());
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObjectEx(JSONObject jObject, StiReport report) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            StiVariable variable = new StiVariable();
            variable.LoadFromJsonObjectEx((JSONObject)property.Value, report);
            this.add(variable);
        }
    }

    public final void add(String name, Object value) {
        if (name.length() > 0 && this.contains(name)) {
            this.remove(name);
        }
        this.add(new StiVariable(name, value));
    }

    public final void add(String category, String name, Object value) {
        if (name.length() > 0 && this.contains(name)) {
            this.remove(name);
        }
        this.add(new StiVariable(category, name, value));
    }

    public final void add(String category, String name, String alias, Object value) {
        if (name.length() > 0 && this.contains(name)) {
            this.remove(name);
        }
        this.add(new StiVariable(category, name, alias, value));
    }

    public final void add(String category, String name, String alias, Object value, boolean readOnly) {
        if (name.length() > 0 && this.contains(name)) {
            this.remove(name);
        }
        this.add(new StiVariable(category, name, alias, value, readOnly));
    }

    public final void add(String category, String name, String alias, StiSystemType type, String value, boolean readOnly) {
        if (name.length() > 0 && this.contains(name)) {
            this.remove(name);
        }
        this.add(new StiVariable(category, name, alias, type, value, readOnly));
    }

    public final void add(String category) {
        this.add(new StiVariable(category));
    }

    public final void add(String category, String name, StiSystemType type, String value, boolean readOnly) {
        if (name.length() > 0 && this.contains(name)) {
            this.remove(name);
        }
        this.add(new StiVariable(category, name, type, value, readOnly));
    }

    public final void add(String category, String name, StiSystemTypeEnum type) {
        if (name.length() > 0 && this.contains(name)) {
            this.remove(name);
        }
        this.add(new StiVariable(category, name, type));
    }

    public final void add(String name, StiSystemTypeEnum type) {
        if (name.length() > 0 && this.contains(name)) {
            this.remove(name);
        }
        this.add(new StiVariable(name, type));
    }

    public boolean contains(String variableName) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StiVariable var = (StiVariable)iterator.next();
            if (!StiValidationUtil.equals((Object)var.getName(), (Object)variableName) && (var.getName() == null || !var.getName().equalsIgnoreCase(variableName))) continue;
            return true;
        }
        return false;
    }

    public StiVariable remove(String variableName) {
        for (int i = 0; i < this.size(); ++i) {
            if (!StiValidationUtil.equals((Object)((StiVariable)this.get(i)).getName(), (Object)variableName)) continue;
            return (StiVariable)this.remove(i);
        }
        return null;
    }

    public boolean containsCategory(String name) {
        name = name.toLowerCase();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            if (variable.getCategory() == null || !variable.getCategory().toLowerCase().equals(name)) continue;
            return true;
        }
        return false;
    }

    public final boolean add(StiVariable variable) {
        if (variable.getName().length() > 0 && this.contains(variable.getName())) {
            this.remove(variable.getName());
        }
        return super.add((Object)variable);
    }

    public void Sort(StiSortOrder order) {
        if (order == StiSortOrder.Asc) {
            Collections.sort(this);
        } else {
            Collections.sort(this, Collections.reverseOrder());
        }
    }

    public StiVariable get(String variableName) {
        return (StiVariable)StiCollectionsUtil.getElement((ArrayList)((Object)this), (String)variableName, StiVariable.class, (boolean)true);
    }

    public void removeCategory(String category) {
        int pos = 0;
        while (pos < this.size()) {
            if (StiValidationUtil.equals((Object)((StiVariable)this.get(pos)).getCategory(), (Object)category)) {
                this.remove(pos);
                continue;
            }
            ++pos;
        }
    }

    public int getFirstCategoryIndex(String category) {
        int index = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            if (StiValidationUtil.equals((Object)category, (Object)variable.getCategory())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getLastCategoryIndex(String category) {
        int selectedIndex = -1;
        int index = 0;
        boolean find = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            if (StiValidationUtil.equals((Object)category, (Object)variable.getCategory())) {
                selectedIndex = index;
                find = true;
            } else if (find) break;
            ++index;
        }
        return selectedIndex;
    }

    public void moveCategoryTo(String fromCategory, String toCategory) {
        int toIndex;
        if (fromCategory == toCategory) {
            return;
        }
        int fromIndex = this.getFirstCategoryIndex(fromCategory);
        if (fromIndex == (toIndex = this.getFirstCategoryIndex(toCategory))) {
            return;
        }
        ArrayList<StiVariable> fromVariables = new ArrayList<StiVariable>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            if (!StiValidationUtil.equals((Object)variable.getCategory(), (Object)fromCategory)) continue;
            fromVariables.add(variable);
        }
        this.removeCategory(fromCategory);
        int index = fromIndex > toIndex ? this.getFirstCategoryIndex(toCategory) : this.getLastCategoryIndex(toCategory) + 1;
        for (StiVariable variable : fromVariables) {
            this.add(index, variable);
            ++index;
        }
    }
}

